/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.datatypes;

public class Complex {
    private double _r;
    private double _j;

    public Complex() {
        this._r = 0.0;
        this._j = 0.0;
    }

    public Complex(Complex c) {
        this._r = c._r;
        this._j = c._j;
    }

    public Complex(double r, double j) {
        this._r = r;
        this._j = j;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this._r);
        if (this._j > 0.0) {
            sb.append('+');
        }
        return sb.append(this._j).append('j').toString();
    }

    public double getReal() {
        return this._r;
    }

    public double getImag() {
        return this._j;
    }

    public void setReal(double r) {
        this._r = r;
    }

    public void setImag(double j) {
        this._j = j;
    }

    public void addReal(double r) {
        this._r += r;
    }

    public void addImag(double j) {
        this._j += j;
    }

    public void mulReal(double s) {
        this._r *= s;
    }

    public void mulImag(double s) {
        this._j *= s;
    }

    public double getMag() {
        return Math.sqrt(this._r * this._r + this._j * this._j);
    }

    public double getPhi() {
        if (this._r == 0.0 && this._j == 0.0) {
            return 0.0;
        }
        double phi = Math.toDegrees(Math.atan(Math.abs(this._j / this._r)));
        if (this._r >= 0.0 && this._j >= 0.0) {
            return phi;
        }
        if (this._r <= 0.0 && this._j >= 0.0) {
            return 180.0 - phi;
        }
        if (this._r <= 0.0 && this._j <= 0.0) {
            return phi + 180.0;
        }
        if (this._r >= 0.0 && this._j <= 0.0) {
            return 360.0 - phi;
        }
        return Math.toDegrees(Math.atan(Math.abs(this._j / this._r)));
    }

    public double[] toArr() {
        double[] arr = new double[]{this._r, this._j};
        return arr;
    }

    public Complex conjugate() {
        return new Complex(this._r, -this._j);
    }

    public Complex add(Complex c) {
        return new Complex(this._r + c._r, this._j + c._j);
    }

    public Complex sub(Complex c) {
        return new Complex(this._r - c._r, this._j - c._j);
    }

    public Complex mul(Complex c) {
        return new Complex(this._r * c._r - this._j * c._j, this._r * c._j + this._j * c._r);
    }

    public Complex mul(double s) {
        return new Complex(this._r * s, this._j * s);
    }

    public Complex div(Complex c) {
        return this.mul(c.conjugate()).div(c._r * c._r + c._j * c._j);
    }

    public Complex div(double s) {
        return this.mul(1.0 / s);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._j);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._r);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex other = (Complex)obj;
        if (Double.doubleToLongBits(this._j) != Double.doubleToLongBits(other._j)) {
            return false;
        }
        return Double.doubleToLongBits(this._r) == Double.doubleToLongBits(other._r);
    }

    public void show() {
        if (this._j < 0.0) {
            System.out.println(this.getReal() + " - j" + Math.abs(this.getImag()));
        } else {
            System.out.println(this.getReal() + " + j" + this.getImag());
        }
    }

    public void show(String ident) {
        if (this._j < 0.0) {
            System.out.println(ident + ": " + this.getReal() + " - j" + Math.abs(this.getImag()));
        } else {
            System.out.println(ident + ": " + this.getReal() + " + j" + this.getImag());
        }
    }

    public void showMag() {
        System.out.println(this.getMag());
    }

    public void showPhi() {
        System.out.println(this.getPhi());
    }
}

