/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.tools;

import org.esa.nest.math.exceptions.JWaveError;
import org.esa.nest.math.exceptions.JWaveException;
import org.esa.nest.math.exceptions.JWaveFailure;

public class MathToolKit {
    public int[] decompose(int number) throws JWaveException {
        if (number < 1) {
            throw new JWaveFailure("the supported number for decomposition is smaller than one");
        }
        int power = this.getExponent(number);
        int[] tmpArr = new int[power + 1];
        int pos = 0;
        double current = number;
        while (current >= 1.0) {
            tmpArr[pos] = power = this.getExponent(current);
            current -= this.scalb(1.0, power);
            ++pos;
        }
        int[] ancientEgyptianMultipliers = new int[pos];
        for (int c = 0; c < pos; ++c) {
            ancientEgyptianMultipliers[c] = tmpArr[c];
        }
        return ancientEgyptianMultipliers;
    }

    public int[] decompose(int number, int blockSize) throws JWaveException {
        int[] blockedAncientEgyptianMultipliers = null;
        if (!this.isBinary(blockSize)) {
            throw new JWaveFailure("given block size is not 2^p|p={1,2,3,4,..}. block size shold be e. g.: 4, 8, 16, 32, ..");
        }
        if (number < blockSize) {
            throw new JWaveFailure("Given blockSize is greater than the given number to be split by it");
        }
        int noOfBlocks = number % blockSize;
        int rest = number - noOfBlocks * blockSize;
        int[] ancientEgyptianMultipliers = this.decompose(rest);
        int blockedAncientEgyptianMultipliersSize = ancientEgyptianMultipliers.length + noOfBlocks;
        blockedAncientEgyptianMultipliers = new int[blockedAncientEgyptianMultipliersSize];
        int j = 0;
        for (int i = 0; i < blockedAncientEgyptianMultipliersSize; ++i) {
            if (i < noOfBlocks) {
                blockedAncientEgyptianMultipliers[i] = blockSize;
                continue;
            }
            blockedAncientEgyptianMultipliers[i] = ancientEgyptianMultipliers[j];
            ++j;
        }
        return blockedAncientEgyptianMultipliers;
    }

    public int compose(int[] ancientEgyptianMultipliers) throws JWaveException {
        if (ancientEgyptianMultipliers == null) {
            throw new JWaveError("given array is null");
        }
        int number = 0;
        for (int ancientEgyptianMultiplier : ancientEgyptianMultipliers) {
            number += (int)this.scalb(1.0, ancientEgyptianMultiplier);
        }
        return number;
    }

    public boolean isBinary(int number) {
        boolean isBinary = false;
        int power = (int)(Math.log(number) / Math.log(2.0));
        double result = 1.0 * Math.pow(2.0, power);
        if (result == (double)number) {
            isBinary = true;
        }
        return isBinary;
    }

    public int getExponent(double f) {
        int exp = (int)(Math.log(f) / Math.log(2.0));
        return exp;
    }

    public double scalb(double f, int scaleFactor) {
        double res = f * Math.pow(2.0, scaleFactor);
        return res;
    }
}

