/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.transforms;

import org.esa.nest.math.datatypes.Complex;
import org.esa.nest.math.exceptions.JWaveError;
import org.esa.nest.math.exceptions.JWaveException;
import org.esa.nest.math.tools.MathToolKit;

public abstract class BasicTransform {
    protected MathToolKit _mathToolKit = new MathToolKit();

    public abstract double[] forward(double[] var1);

    public abstract double[] reverse(double[] var1);

    public double[][] decompose(double[] arrTime) throws JWaveException {
        throw new JWaveError("method is not working for this transform type!");
    }

    public double[] recompose(double[][] matDeComp) throws JWaveException {
        throw new JWaveError("method is not working for this transform type!");
    }

    public Complex[] forward(Complex[] arrTime) {
        double[] arrTimeBulk = new double[2 * arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            int k = i * 2;
            arrTimeBulk[k] = arrTime[i].getReal();
            arrTimeBulk[k + 1] = arrTime[i].getImag();
        }
        double[] arrHilbBulk = this.forward(arrTimeBulk);
        Complex[] arrHilb = new Complex[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            int k = i * 2;
            arrHilb[i] = new Complex(arrHilbBulk[k], arrHilbBulk[k + 1]);
        }
        return arrHilb;
    }

    public Complex[] reverse(Complex[] arrHilb) {
        double[] arrHilbBulk = new double[2 * arrHilb.length];
        for (int i = 0; i < arrHilb.length; ++i) {
            int k = i * 2;
            arrHilbBulk[k] = arrHilb[i].getReal();
            arrHilbBulk[k + 1] = arrHilb[i].getImag();
        }
        double[] arrTimeBulk = this.reverse(arrHilbBulk);
        Complex[] arrTime = new Complex[arrHilb.length];
        for (int i = 0; i < arrTime.length; ++i) {
            int k = i * 2;
            arrTime[i] = new Complex(arrTimeBulk[k], arrTimeBulk[k + 1]);
        }
        return arrTime;
    }

    public double[][] forward(double[][] matTime) {
        double[] arrHilb;
        double[] arrTime;
        int noOfRows = matTime.length;
        int noOfCols = matTime[0].length;
        double[][] matHilb = new double[noOfRows][noOfCols];
        for (int i = 0; i < noOfRows; ++i) {
            arrTime = new double[noOfCols];
            for (int j = 0; j < noOfCols; ++j) {
                arrTime[j] = matTime[i][j];
            }
            arrHilb = this.forward(arrTime);
            for (int j = 0; j < noOfCols; ++j) {
                matHilb[i][j] = arrHilb[j];
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            arrTime = new double[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                arrTime[i] = matHilb[i][j];
            }
            arrHilb = this.forward(arrTime);
            for (int i = 0; i < noOfRows; ++i) {
                matHilb[i][j] = arrHilb[i];
            }
        }
        return matHilb;
    }

    public double[][] reverse(double[][] matFreq) {
        double[] arrTime;
        double[] arrFreq;
        int noOfRows = matFreq.length;
        int noOfCols = matFreq[0].length;
        double[][] matTime = new double[noOfRows][noOfCols];
        for (int j = 0; j < noOfCols; ++j) {
            arrFreq = new double[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                arrFreq[i] = matFreq[i][j];
            }
            arrTime = this.reverse(arrFreq);
            for (int i = 0; i < noOfRows; ++i) {
                matTime[i][j] = arrTime[i];
            }
        }
        for (int i = 0; i < noOfRows; ++i) {
            arrFreq = new double[noOfCols];
            for (int j = 0; j < noOfCols; ++j) {
                arrFreq[j] = matTime[i][j];
            }
            arrTime = this.reverse(arrFreq);
            for (int j = 0; j < noOfCols; ++j) {
                matTime[i][j] = arrTime[j];
            }
        }
        return matTime;
    }

    public double[][][] forward(double[][][] spcTime) {
        int noOfRows = spcTime.length;
        int noOfCols = spcTime[0].length;
        int noOfHigh = spcTime[0][0].length;
        double[][][] spcHilb = new double[noOfRows][noOfCols][noOfHigh];
        for (int i = 0; i < noOfRows; ++i) {
            double[][] matTime = new double[noOfCols][noOfHigh];
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    matTime[j][k] = spcTime[i][j][k];
                }
            }
            double[][] matHilb = this.forward(matTime);
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    spcHilb[i][j][k] = matHilb[j][k];
                }
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            for (int k = 0; k < noOfHigh; ++k) {
                double[] arrTime = new double[noOfRows];
                for (int i = 0; i < noOfRows; ++i) {
                    arrTime[i] = spcHilb[i][j][k];
                }
                double[] arrHilb = this.forward(arrTime);
                for (int i = 0; i < noOfRows; ++i) {
                    spcHilb[i][j][k] = arrHilb[i];
                }
            }
        }
        return spcHilb;
    }

    public double[][][] reverse(double[][][] spcHilb) {
        int noOfRows = spcHilb.length;
        int noOfCols = spcHilb[0].length;
        int noOfHigh = spcHilb[0][0].length;
        double[][][] spcTime = new double[noOfRows][noOfCols][noOfHigh];
        for (int i = 0; i < noOfRows; ++i) {
            double[][] matHilb = new double[noOfCols][noOfHigh];
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    matHilb[j][k] = spcHilb[i][j][k];
                }
            }
            double[][] matTime = this.reverse(matHilb);
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    spcTime[i][j][k] = matTime[j][k];
                }
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            for (int k = 0; k < noOfHigh; ++k) {
                double[] arrHilb = new double[noOfRows];
                for (int i = 0; i < noOfRows; ++i) {
                    arrHilb[i] = spcTime[i][j][k];
                }
                double[] arrTime = this.reverse(arrHilb);
                for (int i = 0; i < noOfRows; ++i) {
                    spcTime[i][j][k] = arrTime[i];
                }
            }
        }
        return spcTime;
    }
}

