/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.transforms;

import org.esa.nest.math.exceptions.JWaveFailure;
import org.esa.nest.math.transforms.WaveletTransform;
import org.esa.nest.math.transforms.wavelets.Wavelet;

public class FastWaveletTransform
extends WaveletTransform {
    public FastWaveletTransform(Wavelet wavelet) throws JWaveFailure {
        super(wavelet);
    }

    @Override
    public double[] forward(double[] arrTime) {
        double[] arrHilb = new double[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            arrHilb[i] = arrTime[i];
        }
        int transformWavelength = this._wavelet.getTransformWavelength();
        for (int h = arrHilb.length; h >= transformWavelength; h >>= 1) {
            double[] arrTempPart = this._wavelet.forward(arrHilb, h);
            for (int i = 0; i < h; ++i) {
                arrHilb[i] = arrTempPart[i];
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) {
        int transformWavelength;
        double[] arrTime = new double[arrHilb.length];
        for (int i = 0; i < arrHilb.length; ++i) {
            arrTime[i] = arrHilb[i];
        }
        for (int h = transformWavelength = this._wavelet.getTransformWavelength(); h <= arrTime.length && h >= transformWavelength; h <<= 1) {
            double[] arrTempPart = this._wavelet.reverse(arrTime, h);
            for (int i = 0; i < h; ++i) {
                arrTime[i] = arrTempPart[i];
            }
        }
        return arrTime;
    }

    @Override
    public double[][] decompose(double[] arrTime) {
        int levels = this._mathToolKit.getExponent(arrTime.length);
        double[][] matDeComp = new double[levels + 1][arrTime.length];
        double[] arrHilb = new double[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            arrHilb[i] = arrTime[i];
            matDeComp[0][i] = arrTime[i];
        }
        int l = 1;
        int h = arrHilb.length;
        int transformWavelength = this._wavelet.getTransformWavelength();
        while (h >= transformWavelength) {
            int i;
            double[] arrTempPart = this._wavelet.forward(arrHilb, h);
            for (i = 0; i < h; ++i) {
                arrHilb[i] = arrTempPart[i];
            }
            for (i = 0; i < arrTime.length; ++i) {
                matDeComp[l][i] = i < h ? arrHilb[i] : 0.0;
            }
            h >>= 1;
            ++l;
        }
        return matDeComp;
    }

    @Override
    public double[] recompose(double[][] matDeComp) {
        int transformWavelength;
        int length = matDeComp[0].length;
        int levels = matDeComp.length;
        double[] arrTime = new double[length];
        for (int l = 1; l < levels; ++l) {
            int steps = (int)this._mathToolKit.scalb(l, 1);
            for (int i = 0; i < length; ++i) {
                if (i >= steps) continue;
                arrTime[i] = matDeComp[l][i];
            }
        }
        for (int h = transformWavelength = this._wavelet.getTransformWavelength(); h <= arrTime.length && h >= transformWavelength; h <<= 1) {
            double[] arrTempPart = this._wavelet.reverse(arrTime, h);
            for (int i = 0; i < h; ++i) {
                arrTime[i] = arrTempPart[i];
            }
        }
        return arrTime;
    }
}

