/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.transforms;

import org.esa.nest.math.exceptions.JWaveFailure;
import org.esa.nest.math.transforms.WaveletTransform;
import org.esa.nest.math.transforms.wavelets.Wavelet;

public class WaveletPacketTransform
extends WaveletTransform {
    public WaveletPacketTransform(Wavelet wavelet) throws JWaveFailure {
        super(wavelet);
    }

    @Override
    public double[] forward(double[] arrTime) {
        double[] arrHilb = new double[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            arrHilb[i] = arrTime[i];
        }
        int k = arrTime.length;
        int h = arrTime.length;
        int transformWavelength = this._wavelet.getTransformWavelength();
        if (h >= transformWavelength) {
            while (h >= transformWavelength) {
                int g = k / h;
                for (int p = 0; p < g; ++p) {
                    double[] iBuf = new double[h];
                    for (int i = 0; i < h; ++i) {
                        iBuf[i] = arrHilb[i + p * h];
                    }
                    double[] oBuf = this._wavelet.forward(iBuf, h);
                    for (int i = 0; i < h; ++i) {
                        arrHilb[i + p * h] = oBuf[i];
                    }
                }
                h >>= 1;
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) {
        double[] arrTime = new double[arrHilb.length];
        for (int i = 0; i < arrHilb.length; ++i) {
            arrTime[i] = arrHilb[i];
        }
        int transformWavelength = this._wavelet.getTransformWavelength();
        int k = arrTime.length;
        if (arrHilb.length >= transformWavelength) {
            for (int h = transformWavelength; h <= arrTime.length && h >= transformWavelength; h <<= 1) {
                int g = k / h;
                for (int p = 0; p < g; ++p) {
                    double[] iBuf = new double[h];
                    for (int i = 0; i < h; ++i) {
                        iBuf[i] = arrTime[i + p * h];
                    }
                    double[] oBuf = this._wavelet.reverse(iBuf, h);
                    for (int i = 0; i < h; ++i) {
                        arrTime[i + p * h] = oBuf[i];
                    }
                }
            }
        }
        return arrTime;
    }
}

