/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.transforms.wavelets;

import org.esa.nest.math.transforms.wavelets.WaveletInterface;

public abstract class Wavelet
implements WaveletInterface {
    protected String _name = null;
    protected int _motherWavelength = 0;
    protected int _transformWavelength = 0;
    protected double[] _scalingDeCom = null;
    protected double[] _waveletDeCom = null;
    protected double[] _scalingReCon = null;
    protected double[] _waveletReCon = null;

    protected void _buildOrthonormalSpace() {
        int i;
        this._waveletDeCom = new double[this._motherWavelength];
        for (i = 0; i < this._motherWavelength; ++i) {
            this._waveletDeCom[i] = i % 2 == 0 ? this._scalingDeCom[this._motherWavelength - 1 - i] : -this._scalingDeCom[this._motherWavelength - 1 - i];
        }
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (i = 0; i < this._motherWavelength; ++i) {
            this._scalingReCon[i] = this._scalingDeCom[i];
            this._waveletReCon[i] = this._waveletDeCom[i];
        }
    }

    protected void _buildBiOrthonormalSpace() {
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (int i = 0; i < this._motherWavelength; ++i) {
            if (i % 2 == 0) {
                this._scalingReCon[i] = this._waveletDeCom[this._motherWavelength - 1 - i];
                this._waveletReCon[i] = this._scalingDeCom[this._motherWavelength - 1 - i];
                continue;
            }
            this._scalingReCon[i] = -this._waveletDeCom[this._motherWavelength - 1 - i];
            this._waveletReCon[i] = -this._scalingDeCom[this._motherWavelength - 1 - i];
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public double[] forward(double[] arrTime, int arrTimeLength) {
        double[] arrHilb = new double[arrTimeLength];
        int h = arrHilb.length >> 1;
        for (int i = 0; i < h; ++i) {
            arrHilb[i + h] = 0.0;
            arrHilb[i] = 0.0;
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = i * 2 + j; k >= arrHilb.length; k -= arrHilb.length) {
                }
                int n = i;
                arrHilb[n] = arrHilb[n] + arrTime[k] * this._scalingDeCom[j];
                int n2 = i + h;
                arrHilb[n2] = arrHilb[n2] + arrTime[k] * this._waveletDeCom[j];
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb, int arrHilbLength) {
        double[] arrTime = new double[arrHilbLength];
        for (int i = 0; i < arrTime.length; ++i) {
            arrTime[i] = 0.0;
        }
        int h = arrTime.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = i * 2 + j; k >= arrTime.length; k -= arrTime.length) {
                }
                int n = k;
                arrTime[n] = arrTime[n] + (arrHilb[i] * this._scalingReCon[j] + arrHilb[i + h] * this._waveletReCon[j]);
            }
        }
        return arrTime;
    }

    @Override
    public int getMotherWavelength() {
        return this._motherWavelength;
    }

    @Override
    public int getTransformWavelength() {
        return this._transformWavelength;
    }

    @Override
    public double[] getScalingDeComposition() {
        double[] scalingDeCom = new double[this._scalingDeCom.length];
        for (int i = 0; i < this._scalingDeCom.length; ++i) {
            scalingDeCom[i] = this._scalingDeCom[i];
        }
        return scalingDeCom;
    }

    @Override
    public double[] getWaveletDeComposition() {
        double[] waveletDeCom = new double[this._waveletDeCom.length];
        for (int i = 0; i < this._waveletDeCom.length; ++i) {
            waveletDeCom[i] = this._waveletDeCom[i];
        }
        return waveletDeCom;
    }

    @Override
    public double[] getScalingReConstruction() {
        double[] scalingReCon = new double[this._scalingReCon.length];
        for (int i = 0; i < this._scalingReCon.length; ++i) {
            scalingReCon[i] = this._scalingReCon[i];
        }
        return scalingReCon;
    }

    @Override
    public double[] getWaveletReConstruction() {
        double[] waveletReCon = new double[this._waveletReCon.length];
        for (int i = 0; i < this._waveletReCon.length; ++i) {
            waveletReCon[i] = this._waveletReCon[i];
        }
        return waveletReCon;
    }
}

