/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.wizards.MosaicWizard;

import java.awt.BorderLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.wizards.MosaicWizard.MosaicWizardMosaicPanel;
import org.esa.nest.dat.wizards.WizardPanel;
import org.esa.snap.dat.dialogs.BatchGraphDialog;

public class MosaicWizardBatchPanel
extends WizardPanel {
    private static final File graphFile = new File(wizardGraphPath, "Cal_ML_TC.xml");
    private BatchGraphDialog batchDlg;

    public MosaicWizardBatchPanel(File[] productFileList, File targetFolder) {
        super("Batch Process Terrain Correction");
        this.createPanel();
        this.batchProcess(productFileList, targetFolder, graphFile);
    }

    public void returnFromLaterStep() {
    }

    public boolean canRedisplayNextPanel() {
        return false;
    }

    public boolean hasNextPanel() {
        if (this.batchDlg != null) {
            return !this.batchDlg.isProcessing();
        }
        return true;
    }

    public boolean canFinish() {
        return false;
    }

    public WizardPanel getNextPanel() {
        return new MosaicWizardMosaicPanel(this.getTargetFileList());
    }

    public boolean validateInput() {
        if (this.getTargetFileList().length == 0) {
            this.batchDlg.onApply();
            this.getOwner().updateState();
        }
        return this.getTargetFileList().length != 0;
    }

    private void createPanel() {
        JPanel textPanel = MosaicWizardBatchPanel.createTextPanel((String)"Instructions", (String)"The Batch Processing dialog will now load the Cal_ML_TCGraph.xml\nand apply Calibration, Multilooking and Terrain Correction to your input products.\nAt the end of the processing, press Next to mosaic them together.");
        this.add(textPanel, "North");
        this.batchDlg = new BatchGraphDialog((AppContext)VisatApp.getApp(), "Batch Processing", "batchProcessing", false);
        JPanel batchPanel = new JPanel(new BorderLayout());
        batchPanel.add(this.batchDlg.getContent(), "Center");
        batchPanel.setBorder(BorderFactory.createTitledBorder("Batch Processing"));
        this.add(batchPanel, "Center");
    }

    private void batchProcess(File[] fileList, File targetFolder, File graphFile) {
        this.batchDlg.setInputFiles(fileList);
        this.batchDlg.setTargetFolder(targetFolder);
        this.batchDlg.addListener((BatchGraphDialog.BatchProcessListener)new WizardPanel.MyBatchProcessListener((WizardPanel)this));
        if (graphFile != null) {
            this.batchDlg.LoadGraphFile(graphFile);
        }
    }
}

