/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ReaderUtils;

@OperatorMetadata(alias="DeburstWSS", category="SAR Processing", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Debursts an ASAR WSS product")
public final class DeburstWSSOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"SS1", "SS2", "SS3", "SS4", "SS5"}, defaultValue="SS1", label="Sub Swath:")
    private String subSwath = "SS1";
    @Parameter(defaultValue="false", label="Produce Intensities Only")
    private boolean produceIntensitiesOnly = false;
    @Parameter(defaultValue="false", label="Mean Average Intensities")
    private boolean average = false;
    private final Vector<Integer> startLine = new Vector(5);
    private static final double zeroThreshold = 1000.0;
    private static final double zeroThresholdSmall = 500.0;
    private LineTime[] lineTimes = null;
    private boolean lineTimesSorted = false;
    private int margin = 50;
    private double nodatavalue = 0.0;
    private double lineTimeInterval = 0.0;
    private final Map<Band, ComplexBand> bandMap = new HashMap<Band, ComplexBand>(5);
    private static final String SS1 = "SS1";
    private static final String SS2 = "SS2";
    private static final String SS3 = "SS3";
    private static final String SS4 = "SS4";
    private static final String SS5 = "SS5";
    private int subSwathNum;
    private int targetWidth;
    private int targetHeight;

    public void initialize() throws OperatorException {
        try {
            if (!this.sourceProduct.getProductType().equals("ASA_WSS_1P")) {
                throw new OperatorException("Source product is not an ASA_WSS_1P");
            }
            int subSwathBandNum = DeburstWSSOp.getRealBandNumFromSubSwath(this.subSwath);
            this.subSwathNum = DeburstWSSOp.getSubSwathNumber(this.subSwath);
            this.getSourceMetadata();
            this.targetProduct = new Product(this.sourceProduct.getName() + "_" + this.subSwath, this.sourceProduct.getProductType(), this.targetWidth, this.targetHeight);
            this.targetProduct.setPreferredTileSize(this.targetWidth, 50);
            Band[] sourceBands = this.sourceProduct.getBands();
            if (this.produceIntensitiesOnly) {
                Band tgtBand = this.targetProduct.addBand("Intensity_" + this.subSwath, 30);
                tgtBand.setUnit("intensity");
                tgtBand.setNoDataValueUsed(true);
                tgtBand.setNoDataValue(this.nodatavalue);
                this.bandMap.put(tgtBand, new ComplexBand(sourceBands[subSwathBandNum], sourceBands[subSwathBandNum + 1]));
            } else {
                Band trgI = this.targetProduct.addBand("i_" + this.subSwath, sourceBands[subSwathBandNum].getDataType());
                trgI.setUnit("real");
                trgI.setNoDataValueUsed(true);
                trgI.setNoDataValue(this.nodatavalue);
                Band trgQ = this.targetProduct.addBand("q_" + this.subSwath, sourceBands[subSwathBandNum + 1].getDataType());
                trgQ.setUnit("imaginary");
                trgQ.setNoDataValueUsed(true);
                trgQ.setNoDataValue(this.nodatavalue);
                this.bandMap.put(trgI, new ComplexBand(sourceBands[subSwathBandNum], sourceBands[subSwathBandNum + 1]));
                ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)trgI, (Band)trgQ, (String)('_' + this.subSwath));
            }
            DeburstWSSOp.copyMetaData(this.sourceProduct.getMetadataRoot(), this.targetProduct.getMetadataRoot());
            ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
            this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
            this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
            this.targetProduct.setDescription(this.sourceProduct.getDescription());
            this.createTiePointGrids();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getSourceMetadata() {
        MetadataElement origRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
        MetadataElement mppRootElem = origRoot.getElement("MAIN_PROCESSING_PARAMS_ADS");
        MetadataElement mpp = mppRootElem.getElementAt(this.subSwathNum);
        this.targetHeight = mpp.getAttributeInt("num_output_lines") / 3;
        this.targetWidth = mpp.getAttributeInt("num_samples_per_line");
        if (!DeburstWSSOp.isBandReady(this.sourceProduct, this.subSwathNum)) {
            throw new OperatorException("Time codes for " + this.subSwath + " not ready yet. Please try again.");
        }
    }

    private static boolean isBandReady(Product srcProduct, int subSwathNum) {
        MetadataElement imgRecElem = srcProduct.getMetadataRoot().getElement("Image Record");
        if (imgRecElem == null) {
            return false;
        }
        MetadataElement bandElem = imgRecElem.getElement(srcProduct.getBandAt(subSwathNum * 2).getName());
        if (bandElem == null) {
            return false;
        }
        MetadataAttribute attrib = bandElem.getAttribute("t");
        return attrib != null;
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetWidth);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"SWATH", (String)this.subSwath);
        if (this.produceIntensitiesOnly) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"SAMPLE_TYPE", (String)"DETECTED");
        }
        MetadataElement srcOrigRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
        MetadataElement srcMPPRootElem = srcOrigRoot.getElement("MAIN_PROCESSING_PARAMS_ADS");
        MetadataElement srcMPP = srcMPPRootElem.getElementAt(this.subSwathNum);
        ProductData.UTC startTime = srcMPP.getAttributeUTC("first_zero_doppler_time", AbstractMetadata.NO_METADATA_UTC);
        ProductData.UTC endTime = srcMPP.getAttributeUTC("last_zero_doppler_time", AbstractMetadata.NO_METADATA_UTC);
        absTgt.setAttributeUTC("first_line_time", startTime);
        absTgt.setAttributeUTC("last_line_time", endTime);
        this.lineTimeInterval = srcMPP.getAttributeDouble("line_time_interval");
        absTgt.setAttributeDouble("line_time_interval", this.lineTimeInterval);
        MetadataElement tgtOrigRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        MetadataElement tgtMppRootElem = tgtOrigRoot.getElement("MAIN_PROCESSING_PARAMS_ADS");
        tgtOrigRoot.removeElement(tgtMppRootElem);
        MetadataElement tgtmds1RootElem = tgtOrigRoot.getElement("MDS1_SQ_ADS");
        tgtOrigRoot.removeElement(tgtmds1RootElem);
        MetadataElement srcMDS1RootElem = srcOrigRoot.getElement("MAIN_PROCESSING_PARAMS_ADS");
        MetadataElement srcMDS1 = srcMDS1RootElem.getElementAt(this.subSwathNum);
        MetadataElement tgtMPP = srcMDS1.createDeepClone();
        tgtMPP.setName("MAIN_PROCESSING_PARAMS_ADS");
        tgtOrigRoot.addElement(tgtMPP);
        MetadataElement tgtMDS1 = srcMPP.createDeepClone();
        tgtMDS1.setName("MDS1_SQ_ADS");
        tgtOrigRoot.addElement(tgtMDS1);
        this.targetProduct.setStartTime(startTime);
        this.targetProduct.setEndTime(endTime);
        DeburstWSSOp.updateOrbitStateVectors(absTgt, this.subSwathNum);
    }

    private static void updateOrbitStateVectors(MetadataElement absTgt, int subSwathNum) {
        MetadataElement orbVectorsElem = absTgt.getElement("Orbit_State_Vectors");
        if (subSwathNum == 0) {
            int[] nums = new int[]{1, 2, 3, 4, 5};
            DeburstWSSOp.removeAndRenameOrbitStateVectors(orbVectorsElem, nums);
        } else if (subSwathNum == 1) {
            int[] nums = new int[]{6, 7, 8, 9, 10};
            DeburstWSSOp.removeAndRenameOrbitStateVectors(orbVectorsElem, nums);
        } else if (subSwathNum == 2) {
            int[] nums = new int[]{11, 12, 13, 14, 15};
            DeburstWSSOp.removeAndRenameOrbitStateVectors(orbVectorsElem, nums);
        } else if (subSwathNum == 3) {
            int[] nums = new int[]{16, 17, 18, 19, 20};
            DeburstWSSOp.removeAndRenameOrbitStateVectors(orbVectorsElem, nums);
        } else if (subSwathNum == 4) {
            int[] nums = new int[]{21, 22, 23, 24, 25};
            DeburstWSSOp.removeAndRenameOrbitStateVectors(orbVectorsElem, nums);
        }
    }

    private static void removeAndRenameOrbitStateVectors(MetadataElement orbVectorsElem, int[] nums) {
        int i = 1;
        for (int n = 1; n <= 25; ++n) {
            MetadataElement orbElem = orbVectorsElem.getElement("orbit_vector" + n);
            if (!DeburstWSSOp.contains(nums, n)) {
                orbVectorsElem.removeElement(orbElem);
                continue;
            }
            orbElem.setName("orbit_vector" + i);
            ++i;
        }
    }

    private static boolean contains(int[] nums, int n) {
        for (int i : nums) {
            if (i != n) continue;
            return true;
        }
        return false;
    }

    private void createTiePointGrids() {
        MetadataElement origRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
        MetadataElement geolocRootElem = origRoot.getElement("GEOLOCATION_GRID_ADS");
        MetadataElement[] geolocElems = geolocRootElem.getElements();
        MetadataElement mainProcRootElem = origRoot.getElement("MAIN_PROCESSING_PARAMS_ADS");
        MetadataElement[] mainProcElems = mainProcRootElem.getElements();
        Double lineTimeInterval = 0.0;
        for (MetadataElement mainProcElem : mainProcElems) {
            String swathStr = mainProcElem.getAttributeString("swath_num");
            if (!swathStr.equalsIgnoreCase(this.subSwath)) continue;
            lineTimeInterval = mainProcElem.getAttribute("line_time_interval").getData().getElemDouble();
            break;
        }
        int subSamplingX = 1;
        ArrayList<Double> time = new ArrayList<Double>(13);
        ArrayList<Float> lats = new ArrayList<Float>(143);
        ArrayList<Float> lons = new ArrayList<Float>(143);
        ArrayList<Float> slant = new ArrayList<Float>(143);
        ArrayList<Float> incidence = new ArrayList<Float>(143);
        for (MetadataElement geolocElem : geolocElems) {
            String swathStr = geolocElem.getAttributeString("swath_number");
            if (!swathStr.equalsIgnoreCase(this.subSwath)) continue;
            subSamplingX = geolocElem.getAttribute("ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.samp_numbers").getData().getElemIntAt(1) - 1;
            MetadataAttribute attrib = geolocElem.getAttribute("first_zero_doppler_time");
            if (attrib != null) {
                String timeStr = attrib.getData().getElemString();
                double timeMJD = 0.0;
                try {
                    timeMJD = ProductData.UTC.parse((String)timeStr).getMJD();
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Unable to parse metadata attribute " + timeStr);
                }
                time.add(timeMJD * 24.0 * 3600.0);
            }
            DeburstWSSOp.addTiePoints(geolocElem, "ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.lats", lats);
            DeburstWSSOp.addTiePoints(geolocElem, "ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.longs", lons);
            DeburstWSSOp.addTiePoints(geolocElem, "ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.slant_range_times", slant);
            DeburstWSSOp.addTiePoints(geolocElem, "ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.angles", incidence);
        }
        int subSamplingY = (int)(((Double)time.get(1) - (Double)time.get(0)) / lineTimeInterval + 0.5);
        int length = lats.size();
        float[] latList = new float[length];
        float[] lonList = new float[length];
        float[] slantList = new float[length];
        float[] incList = new float[length];
        for (int i = 0; i < length; ++i) {
            latList[i] = ((Float)lats.get(i)).floatValue() / 1000000.0f;
            lonList[i] = ((Float)lons.get(i)).floatValue() / 1000000.0f;
            slantList[i] = ((Float)slant.get(i)).floatValue();
            incList[i] = ((Float)incidence.get(i)).floatValue();
        }
        int gridWidth = 11;
        int gridHeight = length / 11;
        TiePointGrid latGrid = new TiePointGrid("latitude", 11, gridHeight, 0.0f, 0.0f, (float)subSamplingX, (float)subSamplingY, latList);
        latGrid.setUnit("deg");
        TiePointGrid lonGrid = new TiePointGrid("longitude", 11, gridHeight, 0.0f, 0.0f, (float)subSamplingX, (float)subSamplingY, lonList, TiePointGrid.DISCONT_AT_180);
        lonGrid.setUnit("deg");
        TiePointGrid slantGrid = new TiePointGrid("slant_range_time", 11, gridHeight, 0.0f, 0.0f, (float)subSamplingX, (float)subSamplingY, slantList);
        slantGrid.setUnit("ns");
        TiePointGrid incGrid = new TiePointGrid("incident_angle", 11, gridHeight, 0.0f, 0.0f, (float)subSamplingX, (float)subSamplingY, incList);
        incGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(latGrid);
        this.targetProduct.addTiePointGrid(lonGrid);
        this.targetProduct.addTiePointGrid(slantGrid);
        this.targetProduct.addTiePointGrid(incGrid);
        this.targetProduct.setGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84));
    }

    private static void addTiePoints(MetadataElement elem, String tag, List<Float> array) {
        block4: {
            MetadataAttribute attrib = elem.getAttribute(tag);
            if (attrib == null) break block4;
            if (attrib.getDataType() == 30) {
                float[] fList;
                for (float f : fList = (float[])attrib.getData().getElems()) {
                    array.add(Float.valueOf(f));
                }
            } else {
                int[] iList;
                for (int i : iList = (int[])attrib.getData().getElems()) {
                    array.add(Float.valueOf(i));
                }
            }
        }
    }

    private static int getSubSwathNumber(String subSwath) {
        if (subSwath.equals(SS1)) {
            return 0;
        }
        if (subSwath.equals(SS2)) {
            return 1;
        }
        if (subSwath.equals(SS3)) {
            return 2;
        }
        if (subSwath.equals(SS4)) {
            return 3;
        }
        return 4;
    }

    private static int getRealBandNumFromSubSwath(String subSwath) {
        if (subSwath.equals(SS1)) {
            return 0;
        }
        if (subSwath.equals(SS2)) {
            return 2;
        }
        if (subSwath.equals(SS3)) {
            return 4;
        }
        if (subSwath.equals(SS4)) {
            return 6;
        }
        return 8;
    }

    private static void copyMetaData(MetadataElement source, MetadataElement target) {
        for (MetadataElement metadataElement : source.getElements()) {
            if (metadataElement.getName().equals("Image Record")) continue;
            target.addElement(metadataElement.createDeepClone());
        }
        for (MetadataElement metadataElement : source.getAttributes()) {
            target.addAttribute(metadataElement.createDeepClone());
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        Tile targetTileI = null;
        Tile targetTileQ = null;
        Tile targetTileIntensity = null;
        try {
            ComplexBand cBand;
            if (this.produceIntensitiesOnly) {
                Band tgtBand = this.targetProduct.getBandAt(0);
                targetTileIntensity = targetTiles.get(tgtBand);
                cBand = this.bandMap.get(tgtBand);
            } else {
                Band tgtBandI = this.targetProduct.getBandAt(0);
                Band tgtBandQ = this.targetProduct.getBandAt(1);
                targetTileI = targetTiles.get(tgtBandI);
                targetTileQ = targetTiles.get(tgtBandQ);
                cBand = this.bandMap.get(tgtBandI);
            }
            if (!this.lineTimesSorted) {
                this.sortLineTimes(this.sourceProduct, cBand.i);
            }
            int maxY = targetRectangle.y + targetRectangle.height;
            int maxX = targetRectangle.x + targetRectangle.width;
            double threshold = 1.35E-7;
            double start = this.targetProduct.getStartTime().getMJD();
            double end = this.targetProduct.getEndTime().getMJD();
            double interval = (end - start) / (double)this.targetHeight;
            Vector<Integer> burstLines = new Vector<Integer>(4);
            for (int y = targetRectangle.y; y < maxY; ++y) {
                boolean ok;
                double startTime = start + (double)y * interval;
                burstLines.clear();
                double min1 = 3.4028234663852886E38;
                double min2 = 3.4028234663852886E38;
                double min3 = 3.4028234663852886E38;
                int i1 = 0;
                int i2 = 0;
                int i3 = 0;
                for (int i = 0; i < this.lineTimes.length; ++i) {
                    if (this.lineTimes[i].visited || this.lineTimes[i].time < 1.0) continue;
                    double t = this.lineTimes[i].time;
                    double diff = Math.abs(t - startTime);
                    if (diff < min1) {
                        if (min1 < min2) {
                            if (min2 < min3) {
                                min3 = min2;
                                i3 = i2;
                            }
                            min2 = min1;
                            i2 = i1;
                        }
                        min1 = diff;
                        i1 = i;
                        continue;
                    }
                    if (diff < min2) {
                        if (min2 < min3) {
                            min3 = min2;
                            i3 = i2;
                        }
                        min2 = diff;
                        i2 = i;
                        continue;
                    }
                    if (!(diff < min3)) continue;
                    min3 = diff;
                    i3 = i;
                }
                burstLines.add(this.lineTimes[i1].line);
                this.setVisited(i1);
                burstLines.add(this.lineTimes[i2].line);
                this.setVisited(i2);
                burstLines.add(this.lineTimes[i3].line);
                this.setVisited(i3);
                if (burstLines.isEmpty() || (ok = this.deburstTile(burstLines, y, targetRectangle.x, maxX, cBand.i, cBand.q, targetTileI, targetTileQ, targetTileIntensity))) continue;
                System.out.println("not ok " + y);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void setVisited(int i) {
        this.lineTimes[i].visited = true;
    }

    private synchronized void sortLineTimes(Product srcProduct, Band srcBand) {
        if (this.lineTimesSorted) {
            return;
        }
        MetadataElement imgRecElem = srcProduct.getMetadataRoot().getElement("Image Record");
        MetadataElement bandElem = imgRecElem.getElement(srcBand.getName());
        MetadataAttribute attrib = bandElem.getAttribute("t");
        double[] timeData = (double[])attrib.getData().getElems();
        this.lineTimes = new LineTime[timeData.length];
        for (int y = 0; y < timeData.length; ++y) {
            this.lineTimes[y] = new LineTime(y, timeData[y]);
        }
        Arrays.sort(this.lineTimes, new LineTimeComparator());
        this.lineTimesSorted = true;
    }

    private boolean deburstTile(Vector<Integer> burstLines, int targetLine, int startX, int endX, Band srcBandI, Band srcBandQ, Tile targetTileI, Tile targetTileQ, Tile targetTileIntensity) {
        Integer[] burstLineList = new Integer[burstLines.size()];
        burstLines.toArray(burstLineList);
        int rowLength = endX - startX;
        double[] peakLine = new double[rowLength];
        double[] peakLineI = new double[rowLength];
        double[] peakLineQ = new double[rowLength];
        double[] sumLine = new double[rowLength];
        int[] avgTotals = new int[rowLength];
        Arrays.fill(peakLine, -3.4028234663852886E38);
        Arrays.fill(sumLine, 0.0);
        Arrays.fill(avgTotals, 0);
        Vector<short[]> srcDataListI = new Vector<short[]>(3);
        Vector<short[]> srcDataListQ = new Vector<short[]>(3);
        int widthMargin = this.targetWidth - this.margin;
        try {
            this.getBurstLines(burstLineList, srcBandI, srcBandQ, startX, endX, srcDataListI, srcDataListQ);
            if (srcDataListI.isEmpty()) {
                return false;
            }
            int dataListSize = srcDataListI.size();
            int x = startX;
            int i = 0;
            while (x < endX) {
                for (int j = 0; j < dataListSize; ++j) {
                    short[] srcDataQ;
                    double Qval;
                    short[] srcDataI = srcDataListI.get(j);
                    double Ival = srcDataI[i];
                    double intensity = Ival * Ival + (Qval = (double)(srcDataQ = srcDataListQ.get(j))[i]) * Qval;
                    if (intensity > peakLine[i]) {
                        peakLine[i] = intensity;
                        peakLineI[i] = Ival;
                        peakLineQ[i] = Qval;
                    }
                    if (!this.average || DeburstWSSOp.isInvalid(Ival, Qval, 500.0)) continue;
                    int n = i;
                    sumLine[n] = sumLine[n] + intensity;
                    int n2 = i;
                    avgTotals[n2] = avgTotals[n2] + 1;
                }
                if (this.average && avgTotals[i] > 1) {
                    int n = i;
                    sumLine[n] = sumLine[n] / (double)avgTotals[i];
                }
                ++x;
                ++i;
            }
            if (this.produceIntensitiesOnly) {
                int i2;
                int x2;
                ProductData data = targetTileIntensity.getDataBuffer();
                if (this.average) {
                    x2 = startX;
                    i2 = 0;
                    while (x2 < endX) {
                        if (x2 < this.margin || x2 > widthMargin) {
                            data.setElemDoubleAt(targetTileIntensity.getDataBufferIndex(x2, targetLine), this.nodatavalue);
                        } else {
                            data.setElemDoubleAt(targetTileIntensity.getDataBufferIndex(x2, targetLine), sumLine[i2]);
                        }
                        ++x2;
                        ++i2;
                    }
                } else {
                    x2 = startX;
                    i2 = 0;
                    while (x2 < endX) {
                        if (peakLine[i2] == -3.4028234663852886E38) {
                            peakLine[i2] = 0.0;
                        }
                        if (x2 < this.margin || x2 > widthMargin) {
                            data.setElemDoubleAt(targetTileIntensity.getDataBufferIndex(x2, targetLine), this.nodatavalue);
                        } else {
                            data.setElemDoubleAt(targetTileIntensity.getDataBufferIndex(x2, targetLine), peakLine[i2]);
                        }
                        ++x2;
                        ++i2;
                    }
                }
            } else {
                ProductData dataI = targetTileI.getDataBuffer();
                ProductData dataQ = targetTileQ.getDataBuffer();
                int x3 = startX;
                int i3 = 0;
                while (x3 < endX) {
                    if (peakLine[i3] == -3.4028234663852886E38) {
                        peakLineI[i3] = 0.0;
                        peakLineQ[i3] = 0.0;
                        System.out.println("uninitPeak " + i3 + " at " + targetLine);
                    }
                    int index = targetTileI.getDataBufferIndex(x3, targetLine);
                    if (x3 < this.margin || x3 > widthMargin) {
                        dataI.setElemDoubleAt(index, this.nodatavalue);
                        dataQ.setElemDoubleAt(index, this.nodatavalue);
                    } else {
                        dataI.setElemDoubleAt(index, peakLineI[i3]);
                        dataQ.setElemDoubleAt(index, peakLineQ[i3]);
                    }
                    ++x3;
                    ++i3;
                }
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("deburstTile " + e.toString());
            return false;
        }
    }

    private void getBurstLines(Integer[] burstLineList, Band srcBandI, Band srcBandQ, int startX, int endX, Vector<short[]> srcDataListI, Vector<short[]> srcDataListQ) {
        int srcBandHeight = srcBandI.getRasterHeight() - 1;
        int srcBandWidth = srcBandI.getRasterWidth() - 1;
        for (Integer y : burstLineList) {
            if (y > srcBandHeight) continue;
            Rectangle sourceRectangle = new Rectangle(startX, y, endX, 1);
            Tile sourceRasterI = this.getSourceTile((RasterDataNode)srcBandI, sourceRectangle);
            short[] srcDataI = (short[])sourceRasterI.getRawSamples().getElems();
            Tile sourceRasterQ = this.getSourceTile((RasterDataNode)srcBandQ, sourceRectangle);
            short[] srcDataQ = (short[])sourceRasterQ.getRawSamples().getElems();
            int invalidCount = 0;
            int total = 0;
            int max = Math.min(srcBandWidth, srcDataI.length);
            for (int i = 500; i < max; i += 50) {
                if (DeburstWSSOp.isInvalid(srcDataI[i], srcDataQ[i], 1000.0)) {
                    ++invalidCount;
                }
                ++total;
            }
            if ((double)((float)invalidCount / (float)total) > 0.4) continue;
            srcDataListI.add(srcDataI);
            srcDataListQ.add(srcDataQ);
        }
    }

    private static void addToAverage(int i, double Ival, double Qval, double[] sumLine, int[] avgTotals) {
        if (!DeburstWSSOp.isInvalid(Ival, Qval, 500.0)) {
            int n = i;
            sumLine[n] = sumLine[n] + (Ival * Ival + Qval * Qval);
            int n2 = i;
            avgTotals[n2] = avgTotals[n2] + 1;
        }
    }

    private static boolean isInvalid(double i, double q, double threshold) {
        return i > -threshold && i < threshold && q > -threshold && q < threshold;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DeburstWSSOp.class);
        }
    }

    private static final class ComplexBand {
        final Band i;
        final Band q;

        public ComplexBand(Band iBand, Band qBand) {
            this.i = iBand;
            this.q = qBand;
        }
    }

    private static final class LineTimeComparator
    implements Comparator<LineTime> {
        private LineTimeComparator() {
        }

        @Override
        public int compare(LineTime a, LineTime b) {
            if (a.time < b.time) {
                return -1;
            }
            if (a.time > b.time) {
                return 1;
            }
            return 0;
        }
    }

    private static final class LineTime {
        boolean visited = false;
        final int line;
        final double time;

        LineTime(int y, double utc) {
            this.line = y;
            this.time = utc;
        }
    }
}

