/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.Unit;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileIndex;

@OperatorMetadata(alias="Multilook", category="SAR Processing", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Averages the power across a number of lines in both the azimuth and range directions")
public final class MultilookOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(description="The user defined number of range looks", interval="[1, *)", defaultValue="1", label="Number of Range Looks")
    private int nRgLooks = 1;
    @Parameter(description="The user defined number of azimuth looks", interval="[1, *)", defaultValue="1", label="Number of Azimuth Looks")
    private int nAzLooks = 1;
    @Parameter(description="For complex product output intensity or i and q", defaultValue="true", label="Output Intensity")
    private Boolean outputIntensity = true;
    @Parameter(description="Use ground square pixel", defaultValue="true", label="GR Square Pixel")
    private Boolean grSquarePixel = true;
    @Parameter(defaultValue="Currently, detection for complex data is performed without any resampling", label="Note")
    String note;
    private MetadataElement absRoot = null;
    private double azimuthLooks;
    private double rangeLooks;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private int targetImageWidth;
    private int targetImageHeight;
    private double rangeSpacing;
    private double azimuthSpacing;
    private boolean isPolsar = false;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap();

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected();
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.isPolsar = this.absRoot.getAttributeInt("polsar_data", 0) == 1;
            this.getRangeAzimuthSpacing();
            this.getRangeAzimuthLooks();
            this.getSourceImageDimension();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int tx0 = targetTileRectangle.x;
        int ty0 = targetTileRectangle.y;
        int tw = targetTileRectangle.width;
        int th = targetTileRectangle.height;
        int x0 = tx0 * this.nRgLooks;
        int y0 = ty0 * this.nAzLooks;
        int w = tw * this.nRgLooks;
        int h = th * this.nAzLooks;
        Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
        try {
            Tile sourceRaster1;
            Band sourceBand1;
            Tile sourceRaster2 = null;
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, sourceTileRectangle);
                if (sourceRaster1 == null) {
                    throw new OperatorException("Cannot get source tile");
                }
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, sourceTileRectangle);
                sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, sourceTileRectangle);
                if (sourceRaster1 == null || sourceRaster2 == null) {
                    throw new OperatorException("Cannot get source tile");
                }
            }
            ProductData trgData = targetTile.getDataBuffer();
            ProductData srcData1 = sourceRaster1.getDataBuffer();
            ProductData srcData2 = sourceRaster2 != null ? sourceRaster2.getDataBuffer() : null;
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceRaster1);
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand1);
            boolean isdB = bandUnit == Unit.UnitType.INTENSITY_DB || bandUnit == Unit.UnitType.AMPLITUDE_DB;
            boolean isComplex = this.outputIntensity != false && (bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            if (this.nRgLooks == 1 && this.nAzLooks == 1) {
                if (!isComplex && targetTile.getDataBuffer().getType() == sourceRaster1.getDataBuffer().getType()) {
                    targetTile.setRawSamples(sourceRaster1.getRawSamples());
                } else {
                    for (int ty = ty0; ty < maxy; ++ty) {
                        trgIndex.calculateStride(ty);
                        srcIndex.calculateStride(ty);
                        for (int tx = tx0; tx < maxx; ++tx) {
                            int index = srcIndex.getIndex(tx);
                            double i = srcData1.getElemDoubleAt(index);
                            if (srcData2 != null) {
                                double q = srcData2.getElemDoubleAt(index);
                                trgData.setElemDoubleAt(trgIndex.getIndex(tx), i * i + q * q);
                                continue;
                            }
                            trgData.setElemDoubleAt(trgIndex.getIndex(tx), i);
                        }
                    }
                }
            } else {
                for (int ty = ty0; ty < maxy; ++ty) {
                    trgIndex.calculateStride(ty);
                    for (int tx = tx0; tx < maxx; ++tx) {
                        double meanValue = MultilookOp.getMeanValue(tx, ty, srcData1, srcData2, srcIndex, this.nRgLooks, this.nAzLooks, isdB, isComplex, this.isPolsar);
                        trgData.setElemDoubleAt(trgIndex.getIndex(tx), meanValue);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private void getRangeAzimuthSpacing() {
        this.rangeSpacing = this.absRoot.getAttributeDouble("range_spacing", 1.0);
        this.azimuthSpacing = this.absRoot.getAttributeDouble("azimuth_spacing", 1.0);
    }

    private void getRangeAzimuthLooks() {
        this.azimuthLooks = this.absRoot.getAttributeDouble("azimuth_looks", 1.0);
        this.rangeLooks = this.absRoot.getAttributeDouble("range_looks", 1.0);
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() {
        this.targetImageWidth = this.sourceImageWidth / this.nRgLooks;
        this.targetImageHeight = this.sourceImageHeight / this.nAzLooks;
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.targetImageWidth, this.targetImageHeight);
        OperatorUtils.addSelectedBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (Product)this.targetProduct, this.targetBandNameToSourceBandName, (boolean)this.outputIntensity, (boolean)false);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyIndexCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        this.targetProduct.setDescription(this.sourceProduct.getDescription());
        this.addGeoCoding();
        this.updateTargetProductMetadata();
    }

    private void addGeoCoding() {
        TiePointGrid lat = OperatorUtils.getLatitude((Product)this.sourceProduct);
        TiePointGrid lon = OperatorUtils.getLongitude((Product)this.sourceProduct);
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        TiePointGrid slantRgTime = OperatorUtils.getSlantRangeTime((Product)this.sourceProduct);
        if (lat == null || lon == null || incidenceAngle == null || slantRgTime == null) {
            ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
            return;
        }
        int gridWidth = 11;
        int gridHeight = 11;
        float subSamplingX = (float)this.targetImageWidth / 10.0f;
        float subSamplingY = (float)this.targetImageHeight / 10.0f;
        PixelPos[] newTiePointPos = new PixelPos[121];
        int k = 0;
        for (int j = 0; j < 11; ++j) {
            float y = (float)((this.nAzLooks - 1) / 2) + Math.min((float)j * subSamplingY, (float)(this.targetImageHeight - 1)) * (float)this.nAzLooks;
            for (int i = 0; i < 11; ++i) {
                float x = (float)((this.nRgLooks - 1) / 2) + Math.min((float)i * subSamplingX, (float)(this.targetImageWidth - 1)) * (float)this.nRgLooks;
                newTiePointPos[k] = new PixelPos();
                newTiePointPos[k].x = x;
                newTiePointPos[k].y = y;
                ++k;
            }
        }
        OperatorUtils.createNewTiePointGridsAndGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct, (int)11, (int)11, (float)subSamplingX, (float)subSamplingY, (PixelPos[])newTiePointPos);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"multilook_flag", (int)1);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"azimuth_looks", (double)(this.azimuthLooks * (double)this.nAzLooks));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"range_looks", (double)(this.rangeLooks * (double)this.nRgLooks));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"azimuth_spacing", (double)(this.azimuthSpacing * (double)this.nAzLooks));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"range_spacing", (double)(this.rangeSpacing * (double)this.nRgLooks));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetImageHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetImageWidth);
        float oldLineTimeInterval = (float)absTgt.getAttributeDouble("line_time_interval");
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"line_time_interval", (double)(oldLineTimeInterval * (float)this.nAzLooks));
        double oldNearEdgeSlantRange = absTgt.getAttributeDouble("slant_range_to_first_pixel");
        double newNearEdgeSlantRange = oldNearEdgeSlantRange + this.rangeSpacing * (double)(this.nRgLooks - 1) / 2.0;
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"slant_range_to_first_pixel", (double)newNearEdgeSlantRange);
        double oldFirstLineUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("first_line_time")).getMJD();
        double newFirstLineUTC = oldFirstLineUTC + (double)oldLineTimeInterval * ((double)(this.nAzLooks - 1) / 2.0) / 86400.0;
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_line_time", (ProductData.UTC)new ProductData.UTC(newFirstLineUTC));
    }

    private static double getMeanValue(int tx, int ty, ProductData srcData1, ProductData srcData2, TileIndex srcIndex, int nRgLooks, int nAzLooks, boolean isdB, boolean isComplex, boolean isPolsar) {
        int xStart = tx * nRgLooks;
        int yStart = ty * nAzLooks;
        int xEnd = xStart + nRgLooks;
        int yEnd = yStart + nAzLooks;
        double meanValue = 0.0;
        if (isdB) {
            for (int y = yStart; y < yEnd; ++y) {
                int offset = srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    meanValue += Math.pow(10.0, srcData1.getElemDoubleAt(x - offset) / 10.0);
                }
            }
            return 10.0 * Math.log10(meanValue /= (double)(nRgLooks * nAzLooks));
        }
        if (isComplex && !isPolsar) {
            for (int y = yStart; y < yEnd; ++y) {
                int offset = srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    int index = x - offset;
                    double i = srcData1.getElemDoubleAt(index);
                    double q = srcData2.getElemDoubleAt(index);
                    meanValue += i * i + q * q;
                }
            }
        } else {
            for (int y = yStart; y < yEnd; ++y) {
                int offset = srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    meanValue += srcData1.getElemDoubleAt(x - offset);
                }
            }
        }
        return meanValue / (double)(nRgLooks * nAzLooks);
    }

    public static void getDerivedParameters(Product srcProduct, DerivedParams param) throws Exception {
        TiePointGrid incidenceAngle;
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        double rangeSpacing = abs.getAttributeDouble("range_spacing", 1.0);
        double azimuthSpacing = abs.getAttributeDouble("azimuth_spacing", 1.0);
        double groundRangeSpacing = rangeSpacing;
        if (rangeSpacing == 99999.0) {
            azimuthSpacing = 1.0;
            groundRangeSpacing = 1.0;
        } else if (!srgrFlag && (incidenceAngle = OperatorUtils.getIncidenceAngle((Product)srcProduct)) != null) {
            double incidenceAngleAtCentreRangePixel = MultilookOp.getIncidenceAngleAtCentreRangePixel(srcProduct, incidenceAngle);
            groundRangeSpacing /= Math.sin(incidenceAngleAtCentreRangePixel * (Math.PI / 180));
        }
        double nAzLooks = (double)param.nRgLooks * groundRangeSpacing / azimuthSpacing;
        if (nAzLooks < 1.0) {
            param.nAzLooks = 1;
            param.nRgLooks = (int)Math.round(azimuthSpacing / groundRangeSpacing);
        } else {
            param.nAzLooks = (int)Math.round(nAzLooks);
        }
        param.meanGRSqaurePixel = (float)(((double)param.nRgLooks * groundRangeSpacing + (double)param.nAzLooks * azimuthSpacing) * 0.5);
    }

    private static double getIncidenceAngleAtCentreRangePixel(Product srcProduct, TiePointGrid incidenceAngle) throws OperatorException {
        int sourceImageWidth = srcProduct.getSceneRasterWidth();
        int sourceImageHeight = srcProduct.getSceneRasterHeight();
        int x = sourceImageWidth / 2;
        int y = sourceImageHeight / 2;
        return incidenceAngle.getPixelFloat((float)x, (float)y);
    }

    public void setNumRangeLooks(int numRangelooks) {
        this.nRgLooks = numRangelooks;
    }

    public void setNumAzimuthLooks(int numAzimuthlooks) {
        this.nAzLooks = numAzimuthlooks;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MultilookOp.class);
        }
    }

    static class DerivedParams {
        int nAzLooks = 0;
        int nRgLooks = 0;
        float meanGRSqaurePixel = 0.0f;

        DerivedParams() {
        }
    }
}

