/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.esa.beam.framework.ui.AppContext;
import org.esa.nest.gpf.MultilookOp;
import org.esa.snap.gpf.OperatorUIUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class MultilookOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JTextField nRgLooks = new JTextField("");
    private final JTextField nAzLooks = new JTextField("");
    private final JTextField meanGRSqaurePixel = new JTextField("");
    private final JCheckBox grSquarePixelCheckBox = new JCheckBox("GR Square Pixel");
    private final JCheckBox independentLooksCheckBox = new JCheckBox("Independent Looks");
    private final JCheckBox outputIntensityCheckBox = new JCheckBox("Output Intensity");
    private Boolean outputIntensity = true;
    private Boolean grSquarePixel = true;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.outputIntensityCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultilookOpUI.this.outputIntensity = e.getStateChange() == 1;
            }
        });
        this.grSquarePixelCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultilookOpUI.this.grSquarePixel = e.getStateChange() == 1;
                MultilookOpUI.this.independentLooksCheckBox.setSelected(MultilookOpUI.this.grSquarePixel == false);
                if (MultilookOpUI.this.grSquarePixel.booleanValue()) {
                    MultilookOpUI.this.nAzLooks.setText("");
                    MultilookOpUI.this.nAzLooks.setEditable(false);
                }
                MultilookOpUI.this.setAzimuthLooks();
            }
        });
        this.independentLooksCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultilookOpUI.this.grSquarePixel = e.getStateChange() != 1;
                MultilookOpUI.this.grSquarePixelCheckBox.setSelected(MultilookOpUI.this.grSquarePixel);
                if (!MultilookOpUI.this.grSquarePixel.booleanValue()) {
                    MultilookOpUI.this.nAzLooks.setEditable(true);
                }
                MultilookOpUI.this.setAzimuthLooks();
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        this.nRgLooks.setText(String.valueOf(this.paramMap.get("nRgLooks")));
        this.nAzLooks.setText(String.valueOf(this.paramMap.get("nAzLooks")));
        this.outputIntensity = (Boolean)this.paramMap.get("outputIntensity");
        if (this.outputIntensity != null) {
            this.outputIntensityCheckBox.setSelected(this.outputIntensity);
        }
        this.outputIntensityCheckBox.setVisible(this.isComplexSrcProduct());
        this.grSquarePixel = (Boolean)this.paramMap.get("grSquarePixel");
        if (this.grSquarePixel != null) {
            this.grSquarePixelCheckBox.setSelected(this.grSquarePixel);
            this.independentLooksCheckBox.setSelected(this.grSquarePixel == false);
            if (this.grSquarePixel.booleanValue()) {
                this.nAzLooks.setText("");
                this.nAzLooks.setEditable(false);
            } else {
                this.nAzLooks.setEditable(true);
            }
        }
        this.setAzimuthLooks();
    }

    private void setAzimuthLooks() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                if (this.grSquarePixelCheckBox.isSelected()) {
                    MultilookOp.DerivedParams param = new MultilookOp.DerivedParams();
                    param.nRgLooks = Integer.parseInt(this.nRgLooks.getText());
                    MultilookOp.getDerivedParameters(this.sourceProducts[0], param);
                    this.nAzLooks.setText(String.valueOf(param.nAzLooks));
                    this.nRgLooks.setText(String.valueOf(param.nRgLooks));
                    float meanSqaurePixel = param.meanGRSqaurePixel;
                    this.meanGRSqaurePixel.setText(String.valueOf(meanSqaurePixel));
                } else {
                    this.meanGRSqaurePixel.setText("");
                }
            }
            catch (Exception e) {
                this.meanGRSqaurePixel.setText("");
            }
        }
    }

    public UIValidation validateParameters() {
        if (this.sourceProducts != null && !this.isComplexSrcProduct() && !this.outputIntensity.booleanValue()) {
            return new UIValidation(UIValidation.State.ERROR, "Cannot output in complex, please select output intensity");
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        String nRgLooksStr = this.nRgLooks.getText();
        String nAzLooksStr = this.nAzLooks.getText();
        if (nRgLooksStr != null && !nRgLooksStr.isEmpty()) {
            this.paramMap.put("nRgLooks", Integer.parseInt(nRgLooksStr));
        }
        if (nAzLooksStr != null && !nAzLooksStr.isEmpty()) {
            this.paramMap.put("nAzLooks", Integer.parseInt(nAzLooksStr));
        }
        this.paramMap.put("outputIntensity", this.outputIntensity);
        this.paramMap.put("grSquarePixel", this.grSquarePixel);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.grSquarePixelCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.independentLooksCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Number of Range Looks:", (JComponent)this.nRgLooks);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Number of Azimuth Looks:", (JComponent)this.nAzLooks);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Mean GR Square Pixel:", (JComponent)this.meanGRSqaurePixel);
        this.nAzLooks.setEditable(false);
        this.meanGRSqaurePixel.setEditable(false);
        this.nRgLooks.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                MultilookOpUI.this.setAzimuthLooks();
            }
        });
        this.nRgLooks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultilookOpUI.this.setAzimuthLooks();
            }
        });
        ++gbc.gridy;
        contentPane.add((Component)this.outputIntensityCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"", (JComponent)new JTextArea("Note: Detection for complex data\nis done without resampling."));
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

