/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.filtering;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.gpf.OperatorUtils;

@OperatorMetadata(alias="Multi-Temporal-Speckle-Filter", category="SAR Processing/Speckle Filtering", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Speckle Reduction using Multitemporal Filtering")
public class MultiTemporalSpeckleFilterOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct = null;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"3x3", "5x5", "7x7", "9x9", "11x11"}, defaultValue="3x3", label="Window Size")
    private String windowSize = "3x3";
    private int halfWindowWidth = 0;
    private int halfWindowHeight = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private static final String WINDOW_SIZE_3x3 = "3x3";
    private static final String WINDOW_SIZE_5x5 = "5x5";
    private static final String WINDOW_SIZE_7x7 = "7x7";
    private static final String WINDOW_SIZE_9x9 = "9x9";
    private static final String WINDOW_SIZE_11x11 = "11x11";

    public void initialize() throws OperatorException {
        try {
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.addSelectedBands();
            int windowWidth = 0;
            int windowHeight = 0;
            if (this.windowSize.equals(WINDOW_SIZE_3x3)) {
                windowWidth = 3;
                windowHeight = 3;
            } else if (this.windowSize.equals(WINDOW_SIZE_5x5)) {
                windowWidth = 5;
                windowHeight = 5;
            } else if (this.windowSize.equals(WINDOW_SIZE_7x7)) {
                windowWidth = 7;
                windowHeight = 7;
            } else if (this.windowSize.equals(WINDOW_SIZE_9x9)) {
                windowWidth = 9;
                windowHeight = 9;
            } else if (this.windowSize.equals(WINDOW_SIZE_11x11)) {
                windowWidth = 11;
                windowHeight = 11;
            } else {
                throw new OperatorException("Unknown filter size: " + this.windowSize);
            }
            this.halfWindowWidth = windowWidth / 2;
            this.halfWindowHeight = windowHeight / 2;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void addSelectedBands() {
        Band[] sourceBands;
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0 && OperatorUtils.isComplex((Product)this.sourceProduct)) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (!band.getUnit().contains("intensity")) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        if ((sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames)).length <= 1) {
            throw new OperatorException("Multitemporal filtering cannot be applied with one source band. Select more bands.");
        }
        for (Band srcBand : sourceBands) {
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            if (unit.contains("phase") || unit.contains("imaginary") || unit.contains("real")) {
                throw new OperatorException("Please select amplitude or intensity bands.");
            }
            Band targetBand = new Band(srcBand.getName(), 30, this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            targetBand.setUnit(unit);
            this.targetProduct.addBand(targetBand);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        Band[] targetBands = this.targetProduct.getBands();
        int numBands = targetBands.length;
        ProductData[] targetData = new ProductData[numBands];
        for (int i = 0; i < numBands; ++i) {
            Tile targetTile = targetTiles.get(targetBands[i]);
            targetData[i] = targetTile.getDataBuffer();
        }
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        Tile[] sourceTile = new Tile[numBands];
        ProductData[] sourceData = new ProductData[numBands];
        double[] bandNoDataValues = new double[numBands];
        for (int i = 0; i < numBands; ++i) {
            Band srcBand = this.sourceProduct.getBand(targetBands[i].getName());
            sourceTile[i] = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle);
            sourceData[i] = sourceTile[i].getDataBuffer();
            bandNoDataValues[i] = srcBand.getNoDataValue();
        }
        double[] localMeans = new double[numBands];
        double srcDataValue = 0.0;
        int yMax = y0 + h;
        for (int y = y0; y < yMax; ++y) {
            int xMax = x0 + w;
            for (int x = x0; x < xMax; ++x) {
                int sourceIndex = sourceTile[0].getDataBufferIndex(x, y);
                double sum = 0.0;
                int n = 0;
                for (int i = 0; i < numBands; ++i) {
                    srcDataValue = sourceData[i].getElemDoubleAt(sourceIndex);
                    if (srcDataValue == bandNoDataValues[i]) {
                        localMeans[i] = bandNoDataValues[i];
                        continue;
                    }
                    localMeans[i] = this.computeLocalMean(x, y, sourceTile[i], sourceData[i], bandNoDataValues[i]);
                    if (localMeans[i] != 0.0) {
                        sum += sourceData[i].getElemDoubleAt(sourceIndex) / localMeans[i];
                    }
                    ++n;
                }
                if (n > 0) {
                    sum /= (double)n;
                }
                int targetIndex = targetTiles.get(targetBands[0]).getDataBufferIndex(x, y);
                for (int i = 0; i < numBands; ++i) {
                    if (localMeans[i] != bandNoDataValues[i]) {
                        targetData[i].setElemDoubleAt(targetIndex, sum * localMeans[i]);
                        continue;
                    }
                    targetData[i].setElemDoubleAt(targetIndex, bandNoDataValues[i]);
                }
            }
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowWidth);
        int y0 = Math.max(0, ty0 - this.halfWindowHeight);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowWidth, this.sourceImageWidth);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowHeight, this.sourceImageHeight);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    private double computeLocalMean(int xc, int yc, Tile srcTile, ProductData srcData, double noDataValue) {
        int x0 = Math.max(0, xc - this.halfWindowWidth);
        int y0 = Math.max(0, yc - this.halfWindowHeight);
        int xMax = Math.min(xc + this.halfWindowWidth, this.sourceImageWidth - 1);
        int yMax = Math.min(yc + this.halfWindowHeight, this.sourceImageHeight - 1);
        double mean = 0.0;
        double value = 0.0;
        int n = 0;
        for (int y = y0; y < yMax; ++y) {
            for (int x = x0; x < xMax; ++x) {
                int index = srcTile.getDataBufferIndex(x, y);
                value = srcData.getElemDoubleAt(index);
                if (value == noDataValue) continue;
                mean += value;
                ++n;
            }
        }
        return mean / (double)n;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MultiTemporalSpeckleFilterOp.class);
        }
    }
}

