/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.filtering;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.Unit;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileIndex;

@OperatorMetadata(alias="Speckle-Filter", category="SAR Processing/Speckle Filtering", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Speckle Reduction")
public class SpeckleFilterOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct = null;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"Mean", "Median", "Frost", "Gamma Map", "Lee", "Refined Lee"}, defaultValue="Refined Lee", label="Filter")
    private String filter;
    @Parameter(description="The kernel x dimension", interval="(1, 100]", defaultValue="3", label="Size X")
    private int filterSizeX = 3;
    @Parameter(description="The kernel y dimension", interval="(1, 100]", defaultValue="3", label="Size Y")
    private int filterSizeY = 3;
    @Parameter(description="The damping factor (Frost filter only)", interval="(0, 100]", defaultValue="2", label="Frost Damping Factor")
    private int dampingFactor = 2;
    @Parameter(description="The edge threshold (Refined Lee filter only)", interval="(0, *)", defaultValue="5000", label="Edge detection threshold")
    private double edgeThreshold = 5000.0;
    @Parameter(defaultValue="false", label="Estimate Eqivalent Number of Looks")
    private boolean estimateENL = true;
    @Parameter(description="The number of looks", interval="(0, *)", defaultValue="1.0", label="Number of looks")
    private double enl = 1.0;
    static final String MEAN_SPECKLE_FILTER = "Mean";
    static final String MEDIAN_SPECKLE_FILTER = "Median";
    static final String FROST_SPECKLE_FILTER = "Frost";
    static final String GAMMA_MAP_SPECKLE_FILTER = "Gamma Map";
    static final String LEE_SPECKLE_FILTER = "Lee";
    static final String LEE_REFINED_FILTER = "Refined Lee";
    private final Map<String, String[]> targetBandNameToSourceBandName = new HashMap<String, String[]>();
    private int halfSizeX;
    private int halfSizeY;
    private int sourceImageWidth;
    private int sourceImageHeight;

    public void SetFilter(String s) {
        if (!(s.equals(MEAN_SPECKLE_FILTER) || s.equals(MEDIAN_SPECKLE_FILTER) || s.equals(FROST_SPECKLE_FILTER) || s.equals(GAMMA_MAP_SPECKLE_FILTER) || s.equals(LEE_SPECKLE_FILTER) || s.equals(LEE_REFINED_FILTER))) {
            throw new OperatorException(s + " is an invalid filter name.");
        }
        this.filter = s;
    }

    public void initialize() throws OperatorException {
        try {
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            if (this.filter.equals(LEE_REFINED_FILTER)) {
                this.filterSizeX = 7;
                this.filterSizeY = 7;
            }
            this.halfSizeX = this.filterSizeX / 2;
            this.halfSizeY = this.filterSizeY / 2;
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() throws Exception {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        OperatorUtils.addSelectedBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (Product)this.targetProduct, this.targetBandNameToSourceBandName, (boolean)true, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Band sourceBand1;
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            Rectangle sourceTileRectangle = this.getSourceTileRectangle(tx0, ty0, tw, th);
            Tile sourceTile1 = null;
            Tile sourceTile2 = null;
            ProductData sourceData1 = null;
            ProductData sourceData2 = null;
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceTile1 = this.getSourceTile((RasterDataNode)sourceBand1, sourceTileRectangle);
                sourceData1 = sourceTile1.getDataBuffer();
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceTile1 = this.getSourceTile((RasterDataNode)sourceBand1, sourceTileRectangle);
                sourceTile2 = this.getSourceTile((RasterDataNode)sourceBand2, sourceTileRectangle);
                sourceData1 = sourceTile1.getDataBuffer();
                sourceData2 = sourceTile2.getDataBuffer();
            }
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand1);
            double noDataValue = sourceBand1.getNoDataValue();
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceTile1);
            double[] neighborValues = new double[this.filterSizeX * this.filterSizeY];
            switch (this.filter) {
                case "Mean": {
                    this.computeMean(sourceData1, sourceData2, trgData, noDataValue, bandUnit, neighborValues, srcIndex, trgIndex, tx0, ty0, tw, th);
                    return;
                }
                case "Median": {
                    this.computeMedian(sourceData1, sourceData2, trgData, noDataValue, bandUnit, neighborValues, srcIndex, trgIndex, tx0, ty0, tw, th);
                    return;
                }
                case "Frost": {
                    this.computeFrost(sourceData1, sourceData2, trgData, noDataValue, bandUnit, neighborValues, srcIndex, trgIndex, tx0, ty0, tw, th);
                    return;
                }
                case "Gamma Map": {
                    double n = this.estimateENL ? this.computeEquivalentNumberOfLooks(sourceData1, sourceData2, noDataValue, bandUnit, srcIndex, tx0, ty0, tw, th) : this.enl;
                    double cu = 1.0 / Math.sqrt(n);
                    double cu2 = cu * cu;
                    this.computeGammaMap(sourceData1, sourceData2, trgData, noDataValue, bandUnit, neighborValues, srcIndex, trgIndex, tx0, ty0, tw, th, cu, cu2, n);
                    return;
                }
                case "Lee": {
                    double n = this.estimateENL ? this.computeEquivalentNumberOfLooks(sourceData1, sourceData2, noDataValue, bandUnit, srcIndex, tx0, ty0, tw, th) : this.enl;
                    double cu = 1.0 / Math.sqrt(n);
                    double cu2 = cu * cu;
                    this.computeLee(sourceData1, sourceData2, trgData, noDataValue, bandUnit, neighborValues, srcIndex, trgIndex, tx0, ty0, tw, th, cu, cu2);
                    return;
                }
                case "Refined Lee": {
                    this.computeRefinedLee(sourceData1, sourceData2, trgData, noDataValue, bandUnit, srcIndex, trgIndex, tx0, ty0, tw, th, sourceTileRectangle);
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            return;
        }
        finally {
            pm.done();
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfSizeX) {
            sx0 -= this.halfSizeX;
            sw += this.halfSizeX;
        }
        if (y0 >= this.halfSizeY) {
            sy0 -= this.halfSizeY;
            sh += this.halfSizeY;
        }
        if (x0 + w + this.halfSizeX <= this.sourceImageWidth) {
            sw += this.halfSizeX;
        }
        if (y0 + h + this.halfSizeY <= this.sourceImageHeight) {
            sh += this.halfSizeY;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private void computeMean(ProductData srcData1, ProductData srcData2, ProductData trgData, double noDataValue, Unit.UnitType unit, double[] neighborValues, TileIndex srcIndex, TileIndex trgIndex, int tx0, int ty0, int tw, int th) {
        int maxY = ty0 + th;
        int maxX = tx0 + tw;
        for (int y = ty0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = tx0; x < maxX; ++x) {
                int idx = trgIndex.getIndex(x);
                int numSamples = this.getNeighborValues(x, y, srcData1, srcData2, srcIndex, noDataValue, unit, neighborValues);
                if (numSamples > 0) {
                    trgData.setElemDoubleAt(idx, SpeckleFilterOp.getMeanValue(neighborValues, numSamples, noDataValue));
                    continue;
                }
                trgData.setElemDoubleAt(idx, noDataValue);
            }
        }
    }

    private void computeMedian(ProductData srcData1, ProductData srcData2, ProductData trgData, double noDataValue, Unit.UnitType unit, double[] neighborValues, TileIndex srcIndex, TileIndex trgIndex, int x0, int y0, int w, int h) {
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int idx = trgIndex.getIndex(x);
                int numSamples = this.getNeighborValues(x, y, srcData1, srcData2, srcIndex, noDataValue, unit, neighborValues);
                if (numSamples > 0) {
                    trgData.setElemDoubleAt(idx, SpeckleFilterOp.getMedianValue(neighborValues, numSamples, noDataValue));
                    continue;
                }
                trgData.setElemDoubleAt(idx, noDataValue);
            }
        }
    }

    private void computeFrost(ProductData srcData1, ProductData srcData2, ProductData trgData, double noDataValue, Unit.UnitType unit, double[] neighborValues, TileIndex srcIndex, TileIndex trgIndex, int x0, int y0, int w, int h) {
        double[] mask = new double[this.filterSizeX * this.filterSizeY];
        this.getFrostMask(mask);
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int idx = trgIndex.getIndex(x);
                int numSamples = this.getNeighborValues(x, y, srcData1, srcData2, srcIndex, noDataValue, unit, neighborValues);
                if (numSamples > 0) {
                    trgData.setElemDoubleAt(idx, this.getFrostValue(neighborValues, numSamples, noDataValue, mask));
                    continue;
                }
                trgData.setElemDoubleAt(idx, noDataValue);
            }
        }
    }

    private void computeGammaMap(ProductData srcData1, ProductData srcData2, ProductData trgData, double noDataValue, Unit.UnitType unit, double[] neighborValues, TileIndex srcIndex, TileIndex trgIndex, int x0, int y0, int w, int h, double cu, double cu2, double enl) {
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int idx = trgIndex.getIndex(x);
                int numSamples = this.getNeighborValues(x, y, srcData1, srcData2, srcIndex, noDataValue, unit, neighborValues);
                if (numSamples > 0) {
                    trgData.setElemDoubleAt(idx, this.getGammaMapValue(neighborValues, numSamples, noDataValue, cu, cu2, enl));
                    continue;
                }
                trgData.setElemDoubleAt(idx, noDataValue);
            }
        }
    }

    private void computeLee(ProductData srcData1, ProductData srcData2, ProductData trgData, double noDataValue, Unit.UnitType unit, double[] neighborValues, TileIndex srcIndex, TileIndex trgIndex, int x0, int y0, int w, int h, double cu, double cu2) {
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int idx = trgIndex.getIndex(x);
                int numSamples = this.getNeighborValues(x, y, srcData1, srcData2, srcIndex, noDataValue, unit, neighborValues);
                if (numSamples > 0) {
                    trgData.setElemDoubleAt(idx, this.getLeeValue(neighborValues, numSamples, noDataValue, cu, cu2));
                    continue;
                }
                trgData.setElemDoubleAt(idx, noDataValue);
            }
        }
    }

    private int getNeighborValues(int tx, int ty, ProductData srcData1, ProductData srcData2, TileIndex srcIndex, double noDataValue, Unit.UnitType bandUnit, double[] neighborValues) {
        int numValidSamples = 0;
        int k = 0;
        if (bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            for (int y = ty - this.halfSizeY; y <= ty + this.halfSizeY; ++y) {
                int x;
                if (y < 0 || y > this.sourceImageHeight - 1) {
                    for (x = tx - this.halfSizeX; x <= tx + this.halfSizeX; ++x) {
                        neighborValues[k++] = noDataValue;
                    }
                    continue;
                }
                srcIndex.calculateStride(y);
                for (x = tx - this.halfSizeX; x <= tx + this.halfSizeX; ++x) {
                    if (x < 0 || x > this.sourceImageWidth - 1) {
                        neighborValues[k++] = noDataValue;
                        continue;
                    }
                    int idx = srcIndex.getIndex(x);
                    double I = srcData1.getElemDoubleAt(idx);
                    double Q = srcData2.getElemDoubleAt(idx);
                    if (I != noDataValue && Q != noDataValue) {
                        neighborValues[k++] = I * I + Q * Q;
                        ++numValidSamples;
                        continue;
                    }
                    neighborValues[k++] = noDataValue;
                }
            }
        } else {
            for (int y = ty - this.halfSizeY; y <= ty + this.halfSizeY; ++y) {
                int x;
                if (y < 0 || y > this.sourceImageHeight - 1) {
                    for (x = tx - this.halfSizeX; x <= tx + this.halfSizeX; ++x) {
                        neighborValues[k++] = noDataValue;
                    }
                    continue;
                }
                srcIndex.calculateStride(y);
                for (x = tx - this.halfSizeX; x <= tx + this.halfSizeX; ++x) {
                    if (x < 0 || x > this.sourceImageWidth - 1) {
                        neighborValues[k++] = noDataValue;
                        continue;
                    }
                    int idx = srcIndex.getIndex(x);
                    double v = srcData1.getElemDoubleAt(idx);
                    if (v != noDataValue) {
                        neighborValues[k++] = v;
                        ++numValidSamples;
                        continue;
                    }
                    neighborValues[k++] = noDataValue;
                }
            }
        }
        return numValidSamples;
    }

    private static double getMeanValue(double[] neighborValues, int numSamples, double noDataValue) {
        double mean = 0.0;
        for (double v : neighborValues) {
            if (v == noDataValue) continue;
            mean += v;
        }
        return mean /= (double)numSamples;
    }

    private static double getVarianceValue(double[] neighborValues, int numSamples, double mean, double noDataValue) {
        double var = 0.0;
        if (numSamples > 1) {
            for (double v : neighborValues) {
                if (v == noDataValue) continue;
                double diff = v - mean;
                var += diff * diff;
            }
            var /= (double)(numSamples - 1);
        }
        return var;
    }

    private static double getMedianValue(double[] neighborValues, int numSamples, double noDataValue) {
        double[] tmp = new double[numSamples];
        int k = 0;
        for (double v : neighborValues) {
            if (v == noDataValue) continue;
            tmp[k++] = v;
        }
        Arrays.sort(tmp);
        return tmp[numSamples / 2];
    }

    private void getFrostMask(double[] mask) {
        for (int i = 0; i < this.filterSizeX; ++i) {
            int s = i * this.filterSizeY;
            int dr = Math.abs(i - this.halfSizeX);
            for (int j = 0; j < this.filterSizeY; ++j) {
                mask[j + s] = Math.max(dr, Math.abs(j - this.halfSizeY));
            }
        }
    }

    private double getFrostValue(double[] neighborValues, int numSamples, double noDataValue, double[] mask) {
        double mean = SpeckleFilterOp.getMeanValue(neighborValues, numSamples, noDataValue);
        if (mean <= Double.MIN_VALUE) {
            return mean;
        }
        double var = SpeckleFilterOp.getVarianceValue(neighborValues, numSamples, mean, noDataValue);
        if (var <= Double.MIN_VALUE) {
            return mean;
        }
        double k = (double)this.dampingFactor * var / (mean * mean);
        double sum = 0.0;
        double totalWeight = 0.0;
        for (int i = 0; i < neighborValues.length; ++i) {
            if (neighborValues[i] == noDataValue) continue;
            double weight = FastMath.exp((double)(-k * mask[i]));
            sum += weight * neighborValues[i];
            totalWeight += weight;
        }
        return sum / totalWeight;
    }

    private double getGammaMapValue(double[] neighborValues, int numSamples, double noDataValue, double cu, double cu2, double enl) {
        double cmax;
        double mean = SpeckleFilterOp.getMeanValue(neighborValues, numSamples, noDataValue);
        if (mean <= Double.MIN_VALUE) {
            return mean;
        }
        double var = SpeckleFilterOp.getVarianceValue(neighborValues, numSamples, mean, noDataValue);
        if (var <= Double.MIN_VALUE) {
            return mean;
        }
        double ci = Math.sqrt(var) / mean;
        if (ci <= cu) {
            return mean;
        }
        double cp = neighborValues[neighborValues.length / 2];
        if (cu < ci && ci < (cmax = Math.sqrt(2.0) * cu)) {
            double alpha = (1.0 + cu2) / (ci * ci - cu2);
            double b = alpha - enl - 1.0;
            double d = mean * mean * b * b + 4.0 * alpha * enl * mean * cp;
            return (b * mean + Math.sqrt(d)) / (2.0 * alpha);
        }
        return cp;
    }

    private double getLeeValue(double[] neighborValues, int numSamples, double noDataValue, double cu, double cu2) {
        double mean = SpeckleFilterOp.getMeanValue(neighborValues, numSamples, noDataValue);
        if (Double.compare(mean, Double.MIN_VALUE) <= 0) {
            return mean;
        }
        double var = SpeckleFilterOp.getVarianceValue(neighborValues, numSamples, mean, noDataValue);
        if (Double.compare(var, Double.MIN_VALUE) <= 0) {
            return mean;
        }
        double ci = Math.sqrt(var) / mean;
        if (ci < cu) {
            return mean;
        }
        double cp = neighborValues[neighborValues.length / 2];
        double w = 1.0 - cu2 / (ci * ci);
        return cp * w + mean * (1.0 - w);
    }

    private double computeEquivalentNumberOfLooks(ProductData srcData1, ProductData srcData2, double noDataValue, Unit.UnitType bandUnit, TileIndex srcIndex, int x0, int y0, int w, int h) {
        double enl = 1.0;
        double sum = 0.0;
        double sum2 = 0.0;
        double sum4 = 0.0;
        int numSamples = 0;
        if (bandUnit != null && (bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY)) {
            for (int y = y0; y < y0 + h; ++y) {
                srcIndex.calculateStride(y);
                for (int x = x0; x < x0 + w; ++x) {
                    int idx = srcIndex.getIndex(x);
                    double i = srcData1.getElemDoubleAt(idx);
                    double q = srcData2.getElemDoubleAt(idx);
                    if (i == noDataValue || q == noDataValue) continue;
                    double v = i * i + q * q;
                    sum += v;
                    sum2 += v * v;
                    ++numSamples;
                }
            }
            if (sum != 0.0 && sum2 > 0.0) {
                double m = sum / (double)numSamples;
                double m2 = sum2 / (double)numSamples;
                double mm = m * m;
                enl = mm / (m2 - mm);
            }
        } else if (bandUnit != null && bandUnit == Unit.UnitType.INTENSITY) {
            for (int y = y0; y < y0 + h; ++y) {
                srcIndex.calculateStride(y);
                for (int x = x0; x < x0 + w; ++x) {
                    int idx = srcIndex.getIndex(x);
                    double v = srcData1.getElemDoubleAt(idx);
                    if (v == noDataValue) continue;
                    sum += v;
                    sum2 += v * v;
                    ++numSamples;
                }
            }
            if (sum != 0.0 && sum2 > 0.0) {
                double m = sum / (double)numSamples;
                double m2 = sum2 / (double)numSamples;
                double mm = m * m;
                enl = mm / (m2 - mm);
            }
        } else {
            for (int y = y0; y < y0 + h; ++y) {
                srcIndex.calculateStride(y);
                for (int x = x0; x < x0 + w; ++x) {
                    int idx = srcIndex.getIndex(x);
                    double v = srcData1.getElemDoubleAt(idx);
                    if (v == noDataValue) continue;
                    double v2 = v * v;
                    sum2 += v2;
                    sum4 += v2 * v2;
                    ++numSamples;
                }
            }
            if (sum2 > 0.0 && sum4 > 0.0) {
                double m2 = sum2 / (double)numSamples;
                double m4 = sum4 / (double)numSamples;
                double m2m2 = m2 * m2;
                enl = m2m2 / (m4 - m2m2);
            }
        }
        return enl;
    }

    private void computeRefinedLee(ProductData srcData1, ProductData srcData2, ProductData trgData, double noDataValue, Unit.UnitType unit, TileIndex srcIndex, TileIndex trgIndex, int x0, int y0, int w, int h, Rectangle sourceTileRectangle) {
        double[][] neighborPixelValues = new double[this.filterSizeY][this.filterSizeX];
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int idx = trgIndex.getIndex(x);
                int numSamples = this.getNeighborValuesWithoutBorderExt(x, y, srcData1, srcData2, srcIndex, noDataValue, unit, sourceTileRectangle, neighborPixelValues);
                if (numSamples > 0) {
                    trgData.setElemDoubleAt(idx, this.getRefinedLeeValue(numSamples, noDataValue, neighborPixelValues));
                    continue;
                }
                trgData.setElemDoubleAt(idx, noDataValue);
            }
        }
    }

    private int getNeighborValuesWithoutBorderExt(int x, int y, ProductData srcData1, ProductData srcData2, TileIndex srcIndex, double noDataValue, Unit.UnitType bandUnit, Rectangle sourceTileRectangle, double[][] neighborPixelValues) {
        int sx0 = sourceTileRectangle.x;
        int sy0 = sourceTileRectangle.y;
        int sw = sourceTileRectangle.width;
        int sh = sourceTileRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        int numSamples = 0;
        if (bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            for (int j = 0; j < this.filterSizeY; ++j) {
                int i;
                int yj = y - this.halfSizeY + j;
                if (yj < sy0 || yj >= maxY) {
                    for (i = 0; i < this.filterSizeX; ++i) {
                        neighborPixelValues[j][i] = noDataValue;
                    }
                    continue;
                }
                srcIndex.calculateStride(yj);
                for (i = 0; i < this.filterSizeX; ++i) {
                    int xi = x - this.halfSizeX + i;
                    if (xi < sx0 || xi >= maxX) {
                        neighborPixelValues[j][i] = noDataValue;
                        continue;
                    }
                    int idx = srcIndex.getIndex(xi);
                    double I = srcData1.getElemDoubleAt(idx);
                    double Q = srcData2.getElemDoubleAt(idx);
                    if (I != noDataValue && Q != noDataValue) {
                        neighborPixelValues[j][i] = I * I + Q * Q;
                        ++numSamples;
                        continue;
                    }
                    neighborPixelValues[j][i] = noDataValue;
                }
            }
        } else {
            for (int j = 0; j < this.filterSizeY; ++j) {
                int i;
                int yj = y - this.halfSizeY + j;
                if (yj < sy0 || yj >= maxY) {
                    for (i = 0; i < this.filterSizeX; ++i) {
                        neighborPixelValues[j][i] = noDataValue;
                    }
                    continue;
                }
                srcIndex.calculateStride(yj);
                for (i = 0; i < this.filterSizeX; ++i) {
                    int xi = x - this.halfSizeX + i;
                    if (xi < sx0 || xi >= maxX) {
                        neighborPixelValues[j][i] = noDataValue;
                        continue;
                    }
                    int idx = srcIndex.getIndex(xi);
                    double v = srcData1.getElemDoubleAt(idx);
                    if (v != noDataValue) {
                        neighborPixelValues[j][i] = v;
                        ++numSamples;
                        continue;
                    }
                    neighborPixelValues[j][i] = noDataValue;
                }
            }
        }
        return numSamples;
    }

    private double getRefinedLeeValue(int numSamples, double noDataValue, double[][] neighborPixelValues) {
        if (numSamples < this.filterSizeX * this.filterSizeY) {
            return this.computePixelValueUsingLocalStatistics(neighborPixelValues, noDataValue);
        }
        double var = this.getLocalVarianceValue(this.getLocalMeanValue(neighborPixelValues, noDataValue), neighborPixelValues, noDataValue);
        if (var < this.edgeThreshold) {
            return this.computePixelValueUsingLocalStatistics(neighborPixelValues, noDataValue);
        }
        return SpeckleFilterOp.computePixelValueUsingEdgeDetection(neighborPixelValues, noDataValue);
    }

    private double computePixelValueUsingLocalStatistics(double[][] neighborPixelValues, double noDataValue) {
        if (neighborPixelValues[this.halfSizeY][this.halfSizeX] == noDataValue) {
            return noDataValue;
        }
        double meanY = this.getLocalMeanValue(neighborPixelValues, noDataValue);
        if (meanY == noDataValue) {
            return noDataValue;
        }
        double varY = this.getLocalVarianceValue(meanY, neighborPixelValues, noDataValue);
        if (varY == 0.0) {
            return meanY;
        }
        if (varY == noDataValue) {
            return noDataValue;
        }
        double sigmaV = SpeckleFilterOp.getLocalNoiseVarianceValue(neighborPixelValues, noDataValue);
        double varX = (varY - meanY * meanY * sigmaV) / (1.0 + sigmaV);
        if (varX < 0.0) {
            varX = 0.0;
        }
        double b = varX / varY;
        return meanY + b * (neighborPixelValues[3][3] - meanY);
    }

    private static double computePixelValueUsingEdgeDetection(double[][] neighborPixelValues, double noDataValue) {
        double[][] subAreaMeans = new double[3][3];
        SpeckleFilterOp.computeSubAreaMeans(neighborPixelValues, subAreaMeans);
        double gradient0 = Math.abs(subAreaMeans[1][0] - subAreaMeans[1][2]);
        double gradient1 = Math.abs(subAreaMeans[0][2] - subAreaMeans[2][0]);
        double gradient2 = Math.abs(subAreaMeans[0][1] - subAreaMeans[2][1]);
        double gradient3 = Math.abs(subAreaMeans[0][0] - subAreaMeans[2][2]);
        int direction = 0;
        double maxGradient = gradient0;
        if (gradient1 > maxGradient) {
            maxGradient = gradient1;
            direction = 1;
        }
        if (gradient2 > maxGradient) {
            maxGradient = gradient2;
            direction = 2;
        }
        if (gradient3 > maxGradient) {
            maxGradient = gradient3;
            direction = 3;
        }
        int d = 0;
        if (direction == 0) {
            d = Math.abs(subAreaMeans[1][0] - subAreaMeans[1][1]) < Math.abs(subAreaMeans[1][1] - subAreaMeans[1][2]) ? 4 : 0;
        } else if (direction == 1) {
            d = Math.abs(subAreaMeans[0][2] - subAreaMeans[1][1]) < Math.abs(subAreaMeans[1][1] - subAreaMeans[2][0]) ? 1 : 5;
        } else if (direction == 2) {
            d = Math.abs(subAreaMeans[0][1] - subAreaMeans[1][1]) < Math.abs(subAreaMeans[1][1] - subAreaMeans[2][1]) ? 2 : 6;
        } else if (direction == 3) {
            d = Math.abs(subAreaMeans[0][0] - subAreaMeans[1][1]) < Math.abs(subAreaMeans[1][1] - subAreaMeans[2][2]) ? 3 : 7;
        }
        double[] pixels = new double[28];
        SpeckleFilterOp.getNonEdgeAreaPixelValues(neighborPixelValues, d, pixels);
        double meanY = SpeckleFilterOp.getMeanValue(pixels, pixels.length, noDataValue);
        double varY = SpeckleFilterOp.getVarianceValue(pixels, pixels.length, meanY, noDataValue);
        if (varY == 0.0) {
            return 0.0;
        }
        double sigmaV = SpeckleFilterOp.getLocalNoiseVarianceValue(neighborPixelValues, noDataValue);
        double varX = (varY - meanY * meanY * sigmaV) / (1.0 + sigmaV);
        if (varX < 0.0) {
            varX = 0.0;
        }
        double b = varX / varY;
        return meanY + b * (neighborPixelValues[3][3] - meanY);
    }

    private double getLocalMeanValue(double[][] neighborPixelValues, double noDataValue) {
        int k = 0;
        double mean = 0.0;
        for (int j = 0; j < this.filterSizeY; ++j) {
            for (int i = 0; i < this.filterSizeX; ++i) {
                if (neighborPixelValues[j][i] == noDataValue) continue;
                mean += neighborPixelValues[j][i];
                ++k;
            }
        }
        if (k > 0) {
            return mean / (double)k;
        }
        return noDataValue;
    }

    private double getLocalVarianceValue(double mean, double[][] neighborPixelValues, double noDataValue) {
        int k = 0;
        double var = 0.0;
        for (int j = 0; j < this.filterSizeY; ++j) {
            for (int i = 0; i < this.filterSizeX; ++i) {
                if (neighborPixelValues[j][i] == noDataValue) continue;
                double diff = neighborPixelValues[j][i] - mean;
                var += diff * diff;
                ++k;
            }
        }
        if (k > 1) {
            return var / (double)(k - 1);
        }
        return noDataValue;
    }

    private static double getLocalNoiseVarianceValue(double[][] neighborPixelValues, double noDataValue) {
        double[] subAreaVariances = new double[9];
        double[] subArea = new double[9];
        int numSubArea = 0;
        for (int j = 0; j < 3; ++j) {
            int y0 = 2 * j;
            for (int i = 0; i < 3; ++i) {
                int x0 = 2 * i;
                int k = 0;
                for (int y = y0; y < y0 + 3; ++y) {
                    int yy = (y - y0) * 3;
                    for (int x = x0; x < x0 + 3; ++x) {
                        if (neighborPixelValues[y][x] == noDataValue) continue;
                        subArea[yy + (x - x0)] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                if (k != 9) continue;
                double subAreaMean = SpeckleFilterOp.getMeanValue(subArea, k, noDataValue);
                subAreaVariances[numSubArea] = subAreaMean > 0.0 ? SpeckleFilterOp.getVarianceValue(subArea, k, subAreaMean, noDataValue) / (subAreaMean * subAreaMean) : 0.0;
                ++numSubArea;
            }
        }
        if (numSubArea < 1) {
            return 0.0;
        }
        Arrays.sort(subAreaVariances, 0, numSubArea - 1);
        int numSubAreaForAvg = Math.min(5, numSubArea);
        double avg = 0.0;
        for (int n = 0; n < numSubAreaForAvg; ++n) {
            avg += subAreaVariances[n];
        }
        return avg / (double)numSubAreaForAvg;
    }

    private static void computeSubAreaMeans(double[][] neighborPixelValues, double[][] subAreaMeans) {
        for (int j = 0; j < 3; ++j) {
            int y0 = 2 * j;
            for (int i = 0; i < 3; ++i) {
                int x0 = 2 * i;
                int k = 0;
                double mean = 0.0;
                for (int y = y0; y < y0 + 3; ++y) {
                    for (int x = x0; x < x0 + 3; ++x) {
                        mean += neighborPixelValues[y][x];
                        ++k;
                    }
                }
                subAreaMeans[j][i] = mean / (double)k;
            }
        }
    }

    private static void getNonEdgeAreaPixelValues(double[][] neighborPixelValues, int d, double[] pixels) {
        switch (d) {
            case 0: {
                int k = 0;
                for (int y = 0; y < 7; ++y) {
                    for (int x = 3; x < 7; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 1: {
                int k = 0;
                for (int y = 0; y < 7; ++y) {
                    for (int x = y; x < 7; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 2: {
                int k = 0;
                for (int y = 0; y < 4; ++y) {
                    for (int x = 0; x < 7; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 3: {
                int k = 0;
                for (int y = 0; y < 7; ++y) {
                    for (int x = 0; x < 7 - y; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 4: {
                int k = 0;
                for (int y = 0; y < 7; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 5: {
                int k = 0;
                for (int y = 0; y < 7; ++y) {
                    for (int x = 0; x < y + 1; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 6: {
                int k = 0;
                for (int y = 3; y < 7; ++y) {
                    for (int x = 0; x < 7; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 7: {
                int k = 0;
                for (int y = 0; y < 7; ++y) {
                    for (int x = 6 - y; x < 7; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpeckleFilterOp.class);
        }
    }
}

