/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.filtering;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.ui.AppContext;
import org.esa.snap.gpf.OperatorUIUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class SpeckleFilterOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox filter = new JComboBox<String>(new String[]{"Mean", "Median", "Frost", "Gamma Map", "Lee", "Refined Lee"});
    private final JLabel dampingFactorLabel = new JLabel("Damping Factor:");
    private final JLabel edgeThresholdLabel = new JLabel("Edge Threshold:");
    private final JLabel filterSizeXLabel = new JLabel("Filter Size X:   ");
    private final JLabel filterSizeYLabel = new JLabel("Filter Size Y:   ");
    private final JTextField filterSizeX = new JTextField("");
    private final JTextField filterSizeY = new JTextField("");
    private final JTextField dampingFactor = new JTextField("");
    private final JTextField edgeThreshold = new JTextField("");
    private final JLabel estimateENLCheckBoxLabel = new JLabel("Estimate Equivalent Number of Looks");
    private final JCheckBox estimateENLCheckBox = new JCheckBox("");
    private final JLabel enlLabel = new JLabel("Number of Looks:   ");
    private final JTextField enl = new JTextField("");
    private Boolean estimateENL = true;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.estimateENLCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SpeckleFilterOpUI.this.estimateENL = e.getStateChange() == 1;
                if (SpeckleFilterOpUI.this.estimateENL.booleanValue()) {
                    SpeckleFilterOpUI.this.enl.setEnabled(false);
                } else {
                    SpeckleFilterOpUI.this.enl.setEnabled(true);
                }
            }
        });
        return panel;
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        this.filter.setSelectedItem(this.paramMap.get("filter"));
        this.filterSizeX.setText(String.valueOf(this.paramMap.get("filterSizeX")));
        this.filterSizeY.setText(String.valueOf(this.paramMap.get("filterSizeY")));
        this.dampingFactor.setText(String.valueOf(this.paramMap.get("dampingFactor")));
        this.edgeThreshold.setText(String.valueOf(this.paramMap.get("edgeThreshold")));
        this.estimateENLCheckBox.setSelected(true);
        this.estimateENL = true;
        this.enl.setEnabled(false);
        this.enl.setText(String.valueOf(this.paramMap.get("enl")));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("filter", this.filter.getSelectedItem());
        this.paramMap.put("filterSizeX", Integer.parseInt(this.filterSizeX.getText()));
        this.paramMap.put("filterSizeY", Integer.parseInt(this.filterSizeY.getText()));
        this.paramMap.put("dampingFactor", Integer.parseInt(this.dampingFactor.getText()));
        this.paramMap.put("edgeThreshold", Double.parseDouble(this.edgeThreshold.getText()));
        this.paramMap.put("estimateENL", this.estimateENL);
        this.paramMap.put("enl", Double.parseDouble(this.enl.getText()));
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Source Bands:", (JComponent)new JScrollPane(this.bandList));
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Filter:", (JComponent)this.filter);
        this.filter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SpeckleFilterOpUI.this.updateFilterSelection();
            }
        });
        ++gbc.gridy;
        int savedY = gbc.gridy++;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.filterSizeXLabel, (JComponent)this.filterSizeX);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.filterSizeYLabel, (JComponent)this.filterSizeY);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.dampingFactorLabel, (JComponent)this.dampingFactor);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.enlLabel, (JComponent)this.enl);
        gbc.gridy = savedY;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.edgeThresholdLabel, (JComponent)this.edgeThreshold);
        gbc.weightx = 1.0;
        contentPane.add((Component)new JPanel(), gbc);
        DialogUtils.enableComponents((JComponent)this.filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)true);
        DialogUtils.enableComponents((JComponent)this.filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)true);
        DialogUtils.enableComponents((JComponent)this.dampingFactorLabel, (JComponent)this.dampingFactor, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.enlLabel, (JComponent)this.enl, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.edgeThresholdLabel, (JComponent)this.edgeThreshold, (boolean)false);
        return contentPane;
    }

    private void updateFilterSelection() {
        String item = (String)this.filter.getSelectedItem();
        if (item.equals("Frost")) {
            DialogUtils.enableComponents((JComponent)this.dampingFactorLabel, (JComponent)this.dampingFactor, (boolean)true);
        } else {
            DialogUtils.enableComponents((JComponent)this.dampingFactorLabel, (JComponent)this.dampingFactor, (boolean)false);
        }
        if (item.equals("Refined Lee")) {
            DialogUtils.enableComponents((JComponent)this.edgeThresholdLabel, (JComponent)this.edgeThreshold, (boolean)true);
            DialogUtils.enableComponents((JComponent)this.filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)false);
            DialogUtils.enableComponents((JComponent)this.filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)false);
        } else {
            DialogUtils.enableComponents((JComponent)this.edgeThresholdLabel, (JComponent)this.edgeThreshold, (boolean)false);
            DialogUtils.enableComponents((JComponent)this.filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)true);
            DialogUtils.enableComponents((JComponent)this.filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)true);
        }
        if (item.equals("Gamma Map") || item.equals("Lee")) {
            DialogUtils.enableComponents((JComponent)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox, (boolean)true);
            DialogUtils.enableComponents((JComponent)this.enlLabel, (JComponent)this.enl, (boolean)true);
            this.estimateENLCheckBox.setSelected(true);
            this.enl.setEnabled(false);
        } else {
            DialogUtils.enableComponents((JComponent)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox, (boolean)false);
            DialogUtils.enableComponents((JComponent)this.enlLabel, (JComponent)this.enl, (boolean)false);
        }
    }
}

