/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.nest.gpf.geometric.SARUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.datamodel.PosVector;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileIndex;
import org.esa.snap.util.Maths;

@OperatorMetadata(alias="ALOS-Deskewing", category="SAR Processing/Geometric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Deskewing ALOS product")
public class ALOSDeskewingOp
extends Operator {
    public static final String PRODUCT_SUFFIX = "_DS";
    @SourceProduct(alias="source")
    Product sourceProduct;
    @TargetProduct
    Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    boolean useMapreadyShiftOnly = false;
    boolean useFAQShiftOnly = false;
    boolean useBoth = false;
    boolean useHybrid = true;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double absShift = 0.0;
    private double fracShift = 0.0;
    private OrbitStateVector[] orbitStateVectors = null;
    private double firstLineTime = 0.0;
    private double lineTimeInterval = 0.0;
    private double lastLineTime = 0.0;
    private AbstractMetadata.DopplerCentroidCoefficientList[] dopplerCentroidCoefficientLists = null;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private double slantRangeToFirstPixel = 0.0;
    private double radarWaveLength = 0.0;
    private SARGeocoding.Orbit orbit = null;
    private int polyDegree = 2;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap();
    private static final double AngularVelocity = ALOSDeskewingOp.getAngularVelocity();

    public void initialize() throws OperatorException {
        try {
            if (!(this.useMapreadyShiftOnly || this.useFAQShiftOnly || this.useBoth || this.useHybrid)) {
                throw new OperatorException("No method was selected for shift calculation");
            }
            this.getMetadata();
            this.computeSensorPositionsAndVelocities();
            this.createTargetProduct();
            this.computeShift();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMetadata() throws Exception {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        String mission = absRoot.getAttributeString("MISSION");
        if (!mission.equals("ALOS")) {
            throw new OperatorException("The deskewing operator is for ALOS PALSAR products only");
        }
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)absRoot);
        if (this.orbitStateVectors == null) {
            throw new OperatorException("Invalid Obit State Vectors");
        }
        if (this.orbitStateVectors.length < 2) {
            throw new OperatorException("Not enough orbit state vectors");
        }
        this.firstLineTime = absRoot.getAttributeUTC("first_line_time").getMJD();
        this.lastLineTime = absRoot.getAttributeUTC("last_line_time").getMJD();
        this.lineTimeInterval = absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        this.dopplerCentroidCoefficientLists = AbstractMetadata.getDopplerCentroidCoefficients((MetadataElement)absRoot);
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
        this.slantRangeToFirstPixel = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"slant_range_to_first_pixel");
        this.radarWaveLength = SARUtils.getRadarFrequency((MetadataElement)absRoot);
    }

    private void computeSensorPositionsAndVelocities() {
        this.orbit = new SARGeocoding.Orbit(this.orbitStateVectors, this.polyDegree, this.firstLineTime, this.lineTimeInterval, this.sourceImageHeight);
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        OperatorUtils.addSelectedBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (Product)this.targetProduct, this.targetBandNameToSourceBandName, (boolean)false, (boolean)false);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (Band srcBand : this.sourceProduct.getBands()) {
            if (!(srcBand instanceof VirtualBand)) continue;
            OperatorUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcBand), (String)srcBand.getName());
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        double fd = this.getDopplerFrequency(0);
        stateVector v = this.getOrbitStateVector(this.firstLineTime);
        double vel = Math.sqrt(v.xVel * v.xVel + v.yVel * v.yVel + v.zVel * v.zVel);
        double newSlantRangeToFirstPixel = FastMath.cos((double)FastMath.asin((double)(fd * this.radarWaveLength / (2.0 * vel)))) * this.slantRangeToFirstPixel;
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"slant_range_to_first_pixel", (double)newSlantRangeToFirstPixel);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            int tyMax = ty0 + th;
            int txMax = tx0 + tw;
            int maxShift = (int)this.computeMaxShift(txMax, ty0);
            Rectangle sourceRectangle = this.getSourceRectangle(tx0, ty0, tw, th, maxShift);
            int sx0 = sourceRectangle.x;
            int sy0 = sourceRectangle.y;
            int sw = sourceRectangle.width;
            int sh = sourceRectangle.height;
            int syMax = sy0 + sh;
            int sxMax = sx0 + sw;
            Set<Band> keySet = targetTiles.keySet();
            for (Band targetBand : keySet) {
                Tile targetTile = targetTiles.get(targetBand);
                String srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName())[0];
                Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(srcBandName), sourceRectangle);
                ProductData trgDataBuffer = targetTile.getDataBuffer();
                ProductData srcDataBuffer = sourceTile.getDataBuffer();
                TileIndex srcIndex = new TileIndex(sourceTile);
                for (int y = sy0; y < syMax; ++y) {
                    srcIndex.calculateStride(y);
                    stateVector v = this.getOrbitStateVector(this.firstLineTime + (double)y * this.lineTimeInterval);
                    for (int x = sx0; x < sxMax; ++x) {
                        double totalShift;
                        if (this.useMapreadyShiftOnly) {
                            totalShift = FastMath.round((double)(this.fracShift * (double)x));
                        } else if (this.useFAQShiftOnly) {
                            totalShift = this.computeFAQShift(v, x);
                        } else if (this.useBoth) {
                            totalShift = this.computeFAQShift(v, x) + (double)FastMath.round((double)(this.fracShift * (double)x));
                        } else if (this.useHybrid) {
                            totalShift = this.absShift + (double)FastMath.round((double)(this.fracShift * (double)x));
                        } else {
                            throw new OperatorException("No method was selected for shift calculation");
                        }
                        int newy = y + (int)totalShift;
                        if (newy < ty0 || newy >= tyMax) continue;
                        int trgIdx = targetTile.getDataBufferIndex(x, newy);
                        trgDataBuffer.setElemFloatAt(trgIdx, srcDataBuffer.getElemFloatAt(srcIndex.getIndex(x)));
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private double computeMaxShift(int txMax, int ty0) throws Exception {
        if (this.useMapreadyShiftOnly) {
            return FastMath.round((double)((double)txMax * this.fracShift));
        }
        if (this.useFAQShiftOnly) {
            stateVector v = this.getOrbitStateVector(this.firstLineTime + (double)ty0 * this.lineTimeInterval);
            return this.computeFAQShift(v, txMax) + (double)FastMath.round((double)((double)txMax * this.fracShift));
        }
        return this.absShift + (double)FastMath.round((double)((double)txMax * this.fracShift));
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th, int maxShift) {
        int syMax;
        int sy0;
        int sx0 = tx0;
        int sw = tw;
        if (maxShift > 0) {
            sy0 = Math.max(ty0 - maxShift, 0);
            syMax = ty0 + th - 1;
        } else if (maxShift < 0) {
            sy0 = ty0;
            syMax = Math.min(ty0 + th - 1 - maxShift, this.sourceImageHeight - 1);
        } else {
            sy0 = ty0;
            syMax = ty0 + th - 1;
        }
        int sh = syMax - sy0 + 1;
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private double computeFAQShift(stateVector v, int x) throws Exception {
        double slr = this.slantRangeToFirstPixel + (double)x * this.rangeSpacing;
        double fd = this.getDopplerFrequency(x);
        double vel = Math.sqrt(v.xVel * v.xVel + v.yVel * v.yVel + v.zVel * v.zVel);
        return slr * fd * this.radarWaveLength / (2.0 * vel * this.azimuthSpacing);
    }

    private void computeShift() throws Exception {
        if (this.useFAQShiftOnly) {
            return;
        }
        stateVector v = this.getOrbitStateVector(this.firstLineTime);
        double slr = this.slantRangeToFirstPixel + 0.0 * this.rangeSpacing;
        double fd = this.getDopplerFrequency(0);
        double[] lookYaw = new double[2];
        this.computeLookYawAngles(v, slr, fd, lookYaw);
        this.fracShift = FastMath.sin((double)lookYaw[0]) * FastMath.sin((double)lookYaw[1]);
        if (this.useMapreadyShiftOnly) {
            return;
        }
        String demName = "SRTM 3Sec";
        String demResamplingMethod = "BILINEAR_INTERPOLATION";
        DEMFactory.validateDEM((String)"SRTM 3Sec", (Product)this.sourceProduct);
        ElevationModel dem = DEMFactory.createElevationModel((String)"SRTM 3Sec", (String)"BILINEAR_INTERPOLATION");
        float demNoDataValue = dem.getDescriptor().getNoDataValue();
        GeoPos geoPos = new GeoPos();
        for (int y = 0; y < this.sourceImageHeight; ++y) {
            double alt;
            this.sourceProduct.getGeoCoding().getGeoPos(new PixelPos(0.5f, (float)y + 0.5f), geoPos);
            double lat = geoPos.lat;
            double lon = geoPos.lon;
            if (lon >= 180.0) {
                lon -= 360.0;
            }
            if ((alt = dem.getElevation(new GeoPos((float)lat, (float)lon))) == (double)demNoDataValue) continue;
            double[] earthPoint = new double[3];
            double[] sensorPos = new double[3];
            GeoUtils.geo2xyzWGS84((double)geoPos.getLat(), (double)geoPos.getLon(), (double)alt, (double[])earthPoint);
            double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTime((double)this.firstLineTime, (double)this.lineTimeInterval, (double)this.radarWaveLength, (double[])earthPoint, (double[][])this.orbit.sensorPosition, (double[][])this.orbit.sensorVelocity);
            if (zeroDopplerTime == -99999.0) continue;
            double slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos);
            double zeroDopplerTimeWithoutBias = zeroDopplerTime + slantRange / 2.59020683712E13;
            this.absShift = (zeroDopplerTimeWithoutBias - this.firstLineTime) / this.lineTimeInterval - (double)y;
            return;
        }
        this.absShift = this.computeFAQShift(v, 0);
    }

    private stateVector getOrbitStateVector(double time) {
        PosVector pos = new PosVector();
        PosVector vel = new PosVector();
        double[] position = new double[3];
        double[] velocity = new double[3];
        this.orbit.getPositionVelocity(time, position, velocity);
        pos.x = position[0];
        pos.y = position[1];
        pos.z = position[2];
        vel.x = velocity[0];
        vel.y = velocity[1];
        vel.z = velocity[2];
        return new stateVector(time, pos.x, pos.y, pos.z, vel.x, vel.y, vel.z);
    }

    private static stateVector vectorInterpolation(OrbitStateVector v1, OrbitStateVector v2, double time) {
        double[] pos1 = new double[]{v1.x_pos, v1.y_pos, v1.z_pos};
        double[] vel1 = new double[]{v1.x_vel, v1.y_vel, v1.z_vel};
        double[] pos2 = new double[]{v2.x_pos, v2.y_pos, v2.z_pos};
        double[] vel2 = new double[]{v2.x_vel, v2.y_vel, v2.z_vel};
        double t = time;
        double t1 = v1.time.getMJD();
        double t2 = v2.time.getMJD();
        double dt = t2 - t1;
        double alpha = (t - t1) / dt;
        double alpha2 = alpha * alpha;
        double alpha3 = alpha2 * alpha;
        double[] pos = new double[3];
        double[] vel = new double[3];
        for (int i = 0; i < 3; ++i) {
            double a0 = pos1[i];
            double a1 = vel1[i] * dt;
            double a2 = -3.0 * pos1[i] + 3.0 * pos2[i] - 2.0 * vel1[i] * dt - vel2[i] * dt;
            double a3 = 2.0 * pos1[i] - 2.0 * pos2[i] + vel1[i] * dt + vel2[i] * dt;
            pos[i] = a0 + a1 * alpha + a2 * alpha2 + a3 * alpha3;
            vel[i] = (a1 + 2.0 * a2 * alpha + 3.0 * a3 * alpha2) / dt;
        }
        return new stateVector(time, pos[0], pos[1], pos[2], vel[0], vel[1], vel[2]);
    }

    private double getDopplerFrequency(int x) {
        return this.dopplerCentroidCoefficientLists[0].coefficients[0] + this.dopplerCentroidCoefficientLists[0].coefficients[1] * (double)x + this.dopplerCentroidCoefficientLists[0].coefficients[2] * (double)x * (double)x;
    }

    private void computeLookYawAngles(stateVector v, double slant, double dopp, double[] lookYaw) {
        boolean succeed;
        int iterations = 0;
        int max_iter = 10000;
        double yaw = 0.0;
        double[] look = new double[]{0.0};
        double prevDeltaDop = -9999999.0;
        double[] vRel = new double[3];
        double lambda = this.radarWaveLength;
        while (succeed = this.getLook(v, slant, yaw, look)) {
            double dopGuess = ALOSDeskewingOp.getDoppler(v, look[0], yaw, vRel, this.radarWaveLength);
            double deltaDop = dopp - dopGuess;
            double relativeVelocity = Math.sqrt(vRel[0] * vRel[0] + vRel[1] * vRel[1] + vRel[2] * vRel[2]);
            double deltaAz = deltaDop * (lambda / (2.0 * relativeVelocity));
            if (Math.abs(deltaDop + prevDeltaDop) < 1.0E-6) {
                deltaAz /= 2.0;
            }
            if (Math.abs(deltaAz * slant) < 0.1) break;
            yaw += deltaAz;
            if (++iterations > max_iter) break;
            prevDeltaDop = deltaDop;
        }
        lookYaw[0] = look[0];
        lookYaw[1] = yaw;
    }

    private boolean getLook(stateVector v, double slant, double yaw, double[] plook) {
        GeoCoding geoCoding = this.sourceProduct.getGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("GeoCoding is null");
        }
        GeoPos geoPos = geoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
        double earthRadius = ALOSDeskewingOp.computeEarthRadius(geoPos);
        double ht = Math.sqrt(v.xPos * v.xPos + v.yPos * v.yPos + v.zPos * v.zPos);
        double look = FastMath.acos((double)((ht * ht + slant * slant - earthRadius * earthRadius) / (2.0 * slant * ht)));
        for (int iter = 0; iter < 100; ++iter) {
            double delta_range = slant - ALOSDeskewingOp.calcRange(v, look, yaw);
            if (Math.abs(delta_range) < 0.1) {
                plook[0] = look;
                return true;
            }
            double sininc = ht / earthRadius * FastMath.sin((double)look);
            double taninc = sininc / Math.sqrt(1.0 - sininc * sininc);
            look += delta_range / (slant * taninc);
        }
        return false;
    }

    private static double calcRange(stateVector v, double look, double yaw) {
        double[][] rM = new double[3][3];
        ALOSDeskewingOp.getRotationMatrix(v, rM);
        double cosyaw = FastMath.cos((double)yaw);
        double x = FastMath.sin((double)yaw);
        double y = -FastMath.sin((double)look) * cosyaw;
        double z = -FastMath.cos((double)look) * cosyaw;
        double rx = rM[0][0] * x + rM[1][0] * y + rM[2][0] * z;
        double ry = rM[0][1] * x + rM[1][1] * y + rM[2][1] * z;
        double rz = rM[0][2] * x + rM[1][2] * y + rM[2][2] * z;
        double re = 6378137.0;
        double rp = 6378135.99663591;
        double re2 = 4.0680631590769E13;
        double rp2 = 4.068061879158276E13;
        double a = (rx * rx + ry * ry) / 4.0680631590769E13 + rz * rz / 4.068061879158276E13;
        double b = 2.0 * ((v.xPos * rx + v.yPos * ry) / 4.0680631590769E13 + v.zPos * rz / 4.068061879158276E13);
        double c = (v.xPos * v.xPos + v.yPos * v.yPos) / 4.0680631590769E13 + v.zPos * v.zPos / 4.068061879158276E13 - 1.0;
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return -1.0;
        }
        double sqrtD = Math.sqrt(d);
        double ans1 = (-b + sqrtD) / (2.0 * a);
        double ans2 = (-b - sqrtD) / (2.0 * a);
        return Math.min(ans1, ans2);
    }

    private static void getRotationMatrix(stateVector v, double[][] rM) {
        double[] ax = new double[3];
        double[] ay = new double[3];
        double[] az = new double[]{v.xPos, v.yPos, v.zPos};
        double[] vl = new double[]{v.xVel, v.yVel, v.zVel};
        Maths.normalizeVector((double[])az);
        Maths.normalizeVector((double[])vl);
        ALOSDeskewingOp.crossProduct(az, vl, ay);
        ALOSDeskewingOp.crossProduct(ay, az, ax);
        for (int i = 0; i < 3; ++i) {
            rM[0][i] = ax[i];
            rM[1][i] = ay[i];
            rM[2][i] = az[i];
        }
    }

    private static void crossProduct(double[] a, double[] b, double[] c) {
        c[0] = a[1] * b[2] - a[2] * b[1];
        c[1] = a[2] * b[0] - a[0] * b[2];
        c[2] = a[0] * b[1] - a[1] * b[0];
    }

    private static double getDoppler(stateVector v, double look, double yaw, double[] relVel, double lambda) {
        double spx = v.xPos;
        double spy = v.yPos;
        double spz = v.zPos;
        double svx = v.xVel;
        double svy = v.yVel;
        double svz = v.zVel;
        double x = FastMath.sin((double)yaw);
        double y = -FastMath.sin((double)look) * FastMath.cos((double)yaw);
        double z = -FastMath.cos((double)look) * FastMath.cos((double)yaw);
        double[][] rM = new double[3][3];
        ALOSDeskewingOp.getRotationMatrix(v, rM);
        double rpx = rM[0][0] * x + rM[1][0] * y + rM[2][0] * z;
        double rpy = rM[0][1] * x + rM[1][1] * y + rM[2][1] * z;
        double rpz = rM[0][2] * x + rM[1][2] * y + rM[2][2] * z;
        double range = ALOSDeskewingOp.calcRange(v, look, yaw);
        double tpx = (rpx *= range) + spx;
        double tpy = (rpy *= range) + spy;
        double tpz = (rpz *= range) + spz;
        double tvx = -AngularVelocity * tpy;
        double tvy = AngularVelocity * tpx;
        double tvz = 0.0;
        double rvx = tvx - svx;
        double rvy = tvy - svy;
        double rvz = 0.0 - svz;
        relVel[0] = rvx;
        relVel[1] = rvy;
        relVel[2] = rvz;
        return -2.0 / (lambda * range) * (rpx * rvx + rpy * rvy + rpz * rvz);
    }

    private static double getAngularVelocity() {
        double dayLength = 86400.0;
        return 7.292116792292688E-5;
    }

    private static double computeEarthRadius(GeoPos geoPos) {
        double lat = geoPos.lat;
        double re = 6378137.0;
        double rp = 6356752.314245179;
        return 4.0544237135322805E13 / Math.sqrt(4.0408299984661445E13 * FastMath.cos((double)lat) * FastMath.cos((double)lat) + 4.0680631590769E13 * FastMath.sin((double)lat) * FastMath.sin((double)lat));
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ALOSDeskewingOp.class);
        }
    }

    public static class stateVector {
        public double xPos;
        public double yPos;
        public double zPos;
        public double xVel;
        public double yVel;
        public double zVel;
        public double time;

        public stateVector(double time, double xPos, double yPos, double zPos, double xVel, double yVel, double zVel) {
            this.time = time;
            this.xPos = xPos;
            this.yPos = yPos;
            this.zPos = zPos;
            this.xVel = xVel;
            this.yVel = yVel;
            this.zVel = zVel;
        }
    }
}

