/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import java.awt.geom.Rectangle2D;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.nest.gpf.geometric.MapProjectionHandler;
import org.esa.snap.gpf.OperatorUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSGeoCodingHandler {
    private final CoordinateReferenceSystem targetCRS;
    private final CrsGeoCoding geoCoding;
    private final int targetWidth;
    private final int targetHeight;
    private final OperatorUtils.ImageGeoBoundary srcImageBoundary;

    public CRSGeoCodingHandler(Product sourceProduct, String mapProjection, double pixelSpacingInDegree, double pixelSpacingInMeter) throws Exception {
        this.targetCRS = MapProjectionHandler.getCRS(mapProjection);
        this.srcImageBoundary = OperatorUtils.computeImageGeoBoundary((Product)sourceProduct);
        double pixelSizeX = pixelSpacingInMeter;
        double pixelSizeY = pixelSpacingInMeter;
        if (this.targetCRS.getName().getCode().equals("WGS84(DD)")) {
            pixelSizeX = pixelSpacingInDegree;
            pixelSizeY = pixelSpacingInDegree;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        double lonMin = this.srcImageBoundary.lonMin;
        double lonMax = this.srcImageBoundary.lonMax;
        bounds.setFrameFromDiagonal(lonMin, this.srcImageBoundary.latMin, lonMax, this.srcImageBoundary.latMax);
        ReferencedEnvelope boundsEnvelope = new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope targetEnvelope = boundsEnvelope.transform(this.targetCRS, true, 200);
        this.targetWidth = (int)Math.floor(targetEnvelope.getSpan(0) / pixelSizeX);
        this.targetHeight = (int)Math.floor(targetEnvelope.getSpan(1) / pixelSizeY);
        this.geoCoding = new CrsGeoCoding(this.targetCRS, this.targetWidth, this.targetHeight, targetEnvelope.getMinimum(0), targetEnvelope.getMaximum(1), pixelSizeX, pixelSizeY);
    }

    public int getTargetWidth() {
        return this.targetWidth;
    }

    public int getTargetHeight() {
        return this.targetHeight;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public CrsGeoCoding getCrsGeoCoding() {
        return this.geoCoding;
    }
}

