/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.gpf.geometric.CRSGeoCodingHandler;
import org.esa.nest.gpf.geometric.RangeDopplerGeocodingOp;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ReaderUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="Ellipsoid-Correction-GG", category="SAR Processing/Geometric/Ellipsoid Correction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="GG method for orthorectification")
public final class GeolocationGridGeocodingOp
extends Operator {
    public static final String PRODUCT_SUFFIX = "_EC";
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="BILINEAR_INTERPOLATION", label="Image Resampling Method")
    private String imgResamplingMethod = "BILINEAR_INTERPOLATION";
    @Parameter(description="The coordinate reference system in well known text format")
    private String mapProjection;
    private boolean srgrFlag = false;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private TiePointGrid slantRangeTime = null;
    private TiePointGrid latitude = null;
    private TiePointGrid longitude = null;
    private GeoCoding targetGeoCoding = null;
    private double rangeSpacing = 0.0;
    private double firstLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private CoordinateReferenceSystem targetCRS;
    private double delLat = 0.0;
    private double delLon = 0.0;
    private AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;
    private final Map<String, String[]> targetBandNameToSourceBandName = new HashMap<String, String[]>(10);
    private Resampling imgResampling = null;
    private boolean nearRangeOnLeft = true;
    private boolean unBiasedZeroDoppler = false;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected();
            validator.checkIfTOPSARBurstProduct(false);
            this.getSourceImageDimension();
            this.getMetadata();
            this.imgResampling = ResamplingFactory.createResampling((String)this.imgResamplingMethod);
            this.getTiePointGrids();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMetadata() throws Exception {
        TiePointGrid incidenceAngle;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        String mission = RangeDopplerGeocodingOp.getMissionType(absRoot);
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)absRoot, (String)"srgr_flag");
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
        this.firstLineUTC = AbstractMetadata.parseUTC((String)absRoot.getAttributeString("first_line_time")).getMJD();
        this.lineTimeInterval = absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        if (this.srgrFlag) {
            this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)absRoot);
        }
        if (mission.contains("CSKS") || mission.contains("TSX") || mission.equals("RS2")) {
            this.unBiasedZeroDoppler = true;
        }
        if ((incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct)) != null) {
            this.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft((TiePointGrid)incidenceAngle, (int)this.sourceImageWidth);
        }
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() throws OperatorException {
        try {
            block4: {
                double pixelSpacingInDegree;
                double pixelSpacingInMeter = Math.max(SARGeocoding.getAzimuthPixelSpacing((Product)this.sourceProduct), SARGeocoding.getRangePixelSpacing((Product)this.sourceProduct));
                this.delLat = pixelSpacingInDegree = SARGeocoding.getPixelSpacingInDegree((double)pixelSpacingInMeter);
                this.delLon = pixelSpacingInDegree;
                CRSGeoCodingHandler crsHandler = new CRSGeoCodingHandler(this.sourceProduct, this.mapProjection, pixelSpacingInDegree, pixelSpacingInMeter);
                this.targetCRS = crsHandler.getTargetCRS();
                this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), crsHandler.getTargetWidth(), crsHandler.getTargetHeight());
                this.targetProduct.setGeoCoding((GeoCoding)crsHandler.getCrsGeoCoding());
                OperatorUtils.addSelectedBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (Product)this.targetProduct, this.targetBandNameToSourceBandName, (boolean)true, (boolean)true);
                this.targetGeoCoding = this.targetProduct.getGeoCoding();
                ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
                ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
                ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
                this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
                this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
                this.targetProduct.setDescription(this.sourceProduct.getDescription());
                try {
                    ProductUtils.copyIndexCodings((Product)this.sourceProduct, (Product)this.targetProduct);
                }
                catch (Exception e) {
                    if (this.imgResampling.equals(Resampling.NEAREST_NEIGHBOUR)) break block4;
                    throw new OperatorException("Use Nearest Neighbour with Classifications: " + e.getMessage());
                }
            }
            this.updateTargetProductMetadata();
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void updateTargetProductMetadata() throws OperatorException {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"srgr_flag", (int)1);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"map_projection", (String)this.targetCRS.getName().getCode());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetProduct.getSceneRasterHeight());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetProduct.getSceneRasterWidth());
        GeoPos geoPosFirstNear = this.targetGeoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
        GeoPos geoPosFirstFar = this.targetGeoCoding.getGeoPos(new PixelPos((float)(this.targetProduct.getSceneRasterWidth() - 1), 0.0f), null);
        GeoPos geoPosLastNear = this.targetGeoCoding.getGeoPos(new PixelPos(0.0f, (float)(this.targetProduct.getSceneRasterHeight() - 1)), null);
        GeoPos geoPosLastFar = this.targetGeoCoding.getGeoPos(new PixelPos((float)(this.targetProduct.getSceneRasterWidth() - 1), (float)(this.targetProduct.getSceneRasterHeight() - 1)), null);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_lat", (double)geoPosFirstNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_lat", (double)geoPosFirstFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_lat", (double)geoPosLastNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_lat", (double)geoPosLastFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_long", (double)geoPosFirstNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_long", (double)geoPosFirstFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_long", (double)geoPosLastNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_long", (double)geoPosLastFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)this.targetProduct));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"is_terrain_corrected", (int)0);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"geo_ref_system", (String)this.targetCRS.getName().getCode());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"lat_pixel_res", (double)this.delLat);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"lon_pixel_res", (double)this.delLon);
        MetadataElement lookDirectionListElem = new MetadataElement("Look_Direction_List");
        int numOfDirections = 5;
        for (int i = 1; i <= 5; ++i) {
            SARGeocoding.addLookDirection((String)"look_direction", (MetadataElement)lookDirectionListElem, (int)i, (int)5, (int)this.sourceImageWidth, (int)this.sourceImageHeight, (double)this.firstLineUTC, (double)this.lineTimeInterval, (boolean)this.nearRangeOnLeft, (TiePointGrid)this.latitude, (TiePointGrid)this.longitude);
        }
        absTgt.addElement(lookDirectionListElem);
    }

    private void getTiePointGrids() {
        this.slantRangeTime = OperatorUtils.getSlantRangeTime((Product)this.sourceProduct);
        if (this.slantRangeTime == null) {
            throw new OperatorException("Product without slant range time tie point grid");
        }
        this.latitude = OperatorUtils.getLatitude((Product)this.sourceProduct);
        if (this.latitude == null) {
            throw new OperatorException("Product without latitude tie point grid");
        }
        this.longitude = OperatorUtils.getLongitude((Product)this.sourceProduct);
        if (this.longitude == null) {
            throw new OperatorException("Product without longitude tie point grid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
        Band sourceBand1 = null;
        Band sourceBand2 = null;
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
        }
        double srcBandNoDataValue = sourceBand1.getNoDataValue();
        double oneBillionthHalfSpeedLight = 0.149896229;
        TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0, y0, w, h);
        GeoCoding srcGeocoding = sourceBand1.getGeoCoding();
        try {
            ProductData trgData = targetTile.getDataBuffer();
            int srcMaxRange = this.sourceImageWidth - 1;
            int srcMaxAzimuth = this.sourceImageHeight - 1;
            GeoPos geoPos = new GeoPos();
            PixelPos pixPos = new PixelPos();
            for (int y = y0; y < y0 + h; ++y) {
                for (int x = x0; x < x0 + w; ++x) {
                    int index = targetTile.getDataBufferIndex(x, y);
                    tileGeoRef.getGeoPos(x, y, geoPos);
                    float lat = geoPos.lat;
                    float lon = geoPos.lon;
                    if ((double)lon >= 180.0) {
                        lon = (float)((double)lon - 360.0);
                    }
                    geoPos.setLocation(lat, lon);
                    srcGeocoding.getPixelPos(geoPos, pixPos);
                    if (Float.isNaN(pixPos.x) || Float.isNaN(pixPos.y) || (double)pixPos.x < 0.0 || pixPos.x >= (float)srcMaxRange || (double)pixPos.y < 0.0 || pixPos.y >= (float)srcMaxAzimuth) {
                        trgData.setElemDoubleAt(index, srcBandNoDataValue);
                        continue;
                    }
                    double slantRange = (double)this.slantRangeTime.getPixelFloat(pixPos.x, pixPos.y) * 0.149896229;
                    double zeroDopplerTime = this.computeZeroDopplerTime(pixPos);
                    double azimuthIndex = 0.0;
                    double rangeIndex = 0.0;
                    if (this.unBiasedZeroDoppler) {
                        azimuthIndex = (zeroDopplerTime - this.firstLineUTC) / this.lineTimeInterval;
                        rangeIndex = this.computeRangeIndex(zeroDopplerTime, slantRange);
                    } else {
                        double zeroDopplerTimeWithoutBias = zeroDopplerTime + slantRange / 1.49896229E8 / 86400.0;
                        azimuthIndex = (zeroDopplerTimeWithoutBias - this.firstLineUTC) / this.lineTimeInterval;
                        rangeIndex = this.computeRangeIndex(zeroDopplerTimeWithoutBias, slantRange);
                    }
                    if (rangeIndex < 0.0 || rangeIndex >= (double)srcMaxRange || azimuthIndex < 0.0 || azimuthIndex >= (double)srcMaxAzimuth) {
                        trgData.setElemDoubleAt(index, srcBandNoDataValue);
                        continue;
                    }
                    trgData.setElemDoubleAt(index, this.getPixelValue(azimuthIndex, rangeIndex, sourceBand1, sourceBand2));
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private double computeZeroDopplerTime(PixelPos pixPos) {
        int j0 = (int)pixPos.y;
        double t0 = this.firstLineUTC + (double)j0 * this.lineTimeInterval;
        double t1 = this.firstLineUTC + (double)(j0 + 1) * this.lineTimeInterval;
        return t0 + (double)(pixPos.y - (float)j0) * (t1 - t0);
    }

    private double computeRangeIndex(double zeroDopplerTime, double slantRange) throws Exception {
        double rangeIndex = 0.0;
        if (this.srgrFlag) {
            if (this.srgrConvParams.length == 0) {
                throw new Exception("SRGR coefficients not found in product");
            }
            int idx = 0;
            int i = 0;
            while (i < this.srgrConvParams.length && zeroDopplerTime >= this.srgrConvParams[i].timeMJD) {
                idx = i++;
            }
            double groundRange = SARGeocoding.computeGroundRange((int)this.sourceImageWidth, (double)this.rangeSpacing, (double)slantRange, (double[])this.srgrConvParams[idx].coefficients, (double)this.srgrConvParams[idx].ground_range_origin);
            if (groundRange < 0.0) {
                return -1.0;
            }
            rangeIndex = (groundRange - this.srgrConvParams[idx].ground_range_origin) / this.rangeSpacing;
        } else {
            int azimuthIndex = (int)((zeroDopplerTime - this.firstLineUTC) / this.lineTimeInterval);
            double r0 = this.nearRangeOnLeft ? this.slantRangeTime.getPixelDouble(0, azimuthIndex) / 1.0E9 * 1.49896229E8 : this.slantRangeTime.getPixelDouble(this.sourceImageWidth - 1, azimuthIndex) / 1.0E9 * 1.49896229E8;
            rangeIndex = (slantRange - r0) / this.rangeSpacing;
        }
        if (!this.nearRangeOnLeft) {
            rangeIndex = (double)(this.sourceImageWidth - 1) - rangeIndex;
        }
        return rangeIndex;
    }

    private double getPixelValue(double azimuthIndex, double rangeIndex, Band sourceBand1, Band sourceBand2) {
        try {
            int x0 = (int)(rangeIndex + 0.5);
            int y0 = (int)(azimuthIndex + 0.5);
            Rectangle srcRect = null;
            Tile sourceTileQ = null;
            if (this.imgResampling.equals(Resampling.NEAREST_NEIGHBOUR)) {
                srcRect = new Rectangle(x0, y0, 1, 1);
            } else if (this.imgResampling.equals(Resampling.BILINEAR_INTERPOLATION)) {
                srcRect = new Rectangle(Math.max(0, x0 - 1), Math.max(0, y0 - 1), 3, 3);
            } else if (this.imgResampling.equals(Resampling.CUBIC_CONVOLUTION)) {
                srcRect = new Rectangle(Math.max(0, x0 - 2), Math.max(0, y0 - 2), 5, 5);
            } else if (this.imgResampling.equals(Resampling.BISINC_5_POINT_INTERPOLATION)) {
                srcRect = new Rectangle(Math.max(0, x0 - 3), Math.max(0, y0 - 3), 6, 6);
            } else if (this.imgResampling == Resampling.BISINC_11_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 6), Math.max(0, y0 - 6), 12, 12);
            } else if (this.imgResampling == Resampling.BISINC_21_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 11), Math.max(0, y0 - 11), 22, 22);
            } else if (this.imgResampling.equals(Resampling.BICUBIC_INTERPOLATION)) {
                srcRect = new Rectangle(Math.max(0, x0 - 2), Math.max(0, y0 - 2), 5, 5);
            } else {
                throw new OperatorException("Unhandled interpolation method");
            }
            Tile sourceTileI = this.getSourceTile((RasterDataNode)sourceBand1, srcRect);
            if (sourceBand2 != null) {
                sourceTileQ = this.getSourceTile((RasterDataNode)sourceBand2, srcRect);
            }
            ResamplingRaster imgResamplingRaster = new ResamplingRaster(sourceTileI, sourceTileQ);
            Resampling resampling = this.imgResampling;
            Resampling.Index imgResamplingIndex = resampling.createIndex();
            resampling.computeIndex(rangeIndex + 0.5, azimuthIndex + 0.5, this.sourceImageWidth, this.sourceImageHeight, imgResamplingIndex);
            return resampling.resample((Resampling.Raster)imgResamplingRaster, imgResamplingIndex);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            return 0.0;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GeolocationGridGeocodingOp.class);
        }
    }

    public static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile sourceTileI;
        private final Tile sourceTileQ;
        private final double noDataValue;
        private final ProductData dataBufferI;
        private final ProductData dataBufferQ;

        public ResamplingRaster(Tile sourceTileI, Tile sourceTileQ) {
            this.sourceTileI = sourceTileI;
            this.sourceTileQ = sourceTileQ;
            this.dataBufferI = sourceTileI.getDataBuffer();
            this.dataBufferQ = sourceTileQ != null ? sourceTileQ.getDataBuffer() : null;
            this.noDataValue = sourceTileI.getRasterDataNode().getNoDataValue();
        }

        public final int getWidth() {
            return this.sourceTileI.getWidth();
        }

        public final int getHeight() {
            return this.sourceTileI.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) {
            boolean allValid = true;
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    double v = this.dataBufferI.getElemDoubleAt(this.sourceTileI.getDataBufferIndex(x[j], y[i]));
                    if (this.noDataValue != 0.0 && v == this.noDataValue) {
                        samples[i][j] = this.noDataValue;
                        allValid = false;
                        continue;
                    }
                    samples[i][j] = (float)v;
                    if (this.dataBufferQ == null) continue;
                    double vq = this.dataBufferQ.getElemDoubleAt(this.sourceTileQ.getDataBufferIndex(x[j], y[i]));
                    if (this.noDataValue != 0.0 && vq == this.noDataValue) {
                        samples[i][j] = this.noDataValue;
                        allValid = false;
                        continue;
                    }
                    samples[i][j] = v * v + vq * vq;
                }
            }
            return allValid;
        }
    }
}

