/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.crs.CrsForm;
import org.esa.beam.framework.ui.crs.CrsSelectionPanel;
import org.esa.beam.framework.ui.crs.CustomCrsForm;
import org.esa.beam.framework.ui.crs.PredefinedCrsForm;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.visat.VisatApp;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapProjectionHandler {
    private final CrsSelectionPanel crsSelectionPanel = MapProjectionHandler.createCRSPanel();
    private CoordinateReferenceSystem crs;

    private static CrsSelectionPanel createCRSPanel() {
        VisatApp visatApp = VisatApp.getApp();
        CustomCrsForm customCrsForm = new CustomCrsForm((AppContext)visatApp);
        PredefinedCrsForm predefinedCrsForm = new PredefinedCrsForm((AppContext)visatApp);
        return new CrsSelectionPanel(new CrsForm[]{customCrsForm, predefinedCrsForm});
    }

    public void initParameters(String mapProjection, Product[] sourceProducts) {
        this.crs = this.getCRS(mapProjection, sourceProducts);
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public String getCRSName() {
        if (this.crs != null) {
            return this.crs.getName().getCode();
        }
        return "";
    }

    private CoordinateReferenceSystem getCRS(String mapProjection, Product[] sourceProducts) {
        CoordinateReferenceSystem theCRS = MapProjectionHandler.parseCRS(mapProjection);
        if (theCRS == null) {
            return this.getCRSFromDialog(sourceProducts);
        }
        return theCRS;
    }

    static CoordinateReferenceSystem parseCRS(String mapProjection) {
        try {
            if (mapProjection != null && !mapProjection.isEmpty()) {
                return CRS.parseWKT((String)mapProjection);
            }
        }
        catch (Exception e) {
            try {
                return CRS.decode((String)mapProjection, (boolean)true);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        return null;
    }

    private CoordinateReferenceSystem getCRSFromDialog(Product[] sourceProducts) {
        try {
            if (sourceProducts == null || sourceProducts[0] == null) {
                return this.crsSelectionPanel.getCrs(new GeoPos(0.0f, 0.0f));
            }
            return this.crsSelectionPanel.getCrs(ProductUtils.getCenterGeoPos((Product)sourceProducts[0]));
        }
        catch (Exception e) {
            VisatApp.getApp().showErrorDialog("Unable to create coodinate reference system");
            return null;
        }
    }

    public void promptForFeatureCrs(Product[] sourceProducts) {
        ModalDialog dialog = new ModalDialog(VisatApp.getApp().getApplicationWindow(), "Map Projection", 161, "mapProjection");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setCellPadding(0, 0, new Insets(4, 10, 4, 4));
        JPanel contentPanel = new JPanel((LayoutManager)tableLayout);
        contentPanel.add((Component)this.crsSelectionPanel);
        dialog.setContent((Component)contentPanel);
        if (dialog.show() == 1) {
            this.crs = this.getCRSFromDialog(sourceProducts);
        }
    }

    public static CoordinateReferenceSystem getCRS(String mapProjection) throws Exception {
        try {
            if (mapProjection == null || mapProjection.isEmpty() || mapProjection.equals("WGS84(DD)")) {
                return DefaultGeographicCRS.WGS84;
            }
            return CRS.parseWKT((String)mapProjection);
        }
        catch (Exception e) {
            return CRS.decode((String)mapProjection, (boolean)true);
        }
    }
}

