/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.MathUtils;
import org.esa.nest.gpf.geometric.MapProjectionHandler;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.esa.snap.gpf.TileIndex;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="SAR-Mosaic", category="SAR Processing/Geometric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Mosaics two or more products based on their geo-codings.")
public class MosaicOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="NEAREST_NEIGHBOUR", description="The method to be used when resampling the slave grid onto the master grid.", label="Resampling Type")
    private String resamplingMethod = "NEAREST_NEIGHBOUR";
    @Parameter(defaultValue="true", description="Average the overlapping areas", label="Average Overlap")
    private boolean average = true;
    @Parameter(defaultValue="true", description="Normalize by Mean", label="Normalize by Mean")
    private boolean normalizeByMean = true;
    @Parameter(defaultValue="false", description="Gradient Domain Mosaic", label="Gradient Domain Mosaic")
    private boolean gradientDomainMosaic = false;
    @Parameter(defaultValue="0", description="Pixel Size (m)", label="Pixel Size (m)")
    private double pixelSize = 0.0;
    @Parameter(defaultValue="0", description="Target width", label="Scene Width (pixels)")
    private int sceneWidth = 0;
    @Parameter(defaultValue="0", description="Target height", label="Scene Height (pixels)")
    private int sceneHeight = 0;
    @Parameter(defaultValue="20", description="Feather amount around source image", label="Feature (pixels)")
    private int feather = 0;
    @Parameter(defaultValue="5000", description="Maximum number of iterations", label="Maximum Iterations")
    private int maxIterations = 5000;
    @Parameter(defaultValue="1e-4", description="Convergence threshold for Relaxed Gauss-Seidel method", label="Convergence Threshold")
    private double convergenceThreshold = 1.0E-4;
    private final OperatorUtils.SceneProperties scnProp = new OperatorUtils.SceneProperties();
    private final Map<Integer, Band> bandIndexSet = new HashMap<Integer, Band>(20);
    private final Map<Product, Rectangle> srcRectMap = new HashMap<Product, Rectangle>(10);
    private Product[] selectedProducts = null;
    private boolean outputGradientBand = false;

    public void initialize() throws OperatorException {
        try {
            block13: {
                if (this.gradientDomainMosaic && this.resamplingMethod.contains("NEAREST_NEIGHBOUR")) {
                    throw new OperatorException("Nearest neighbour resampling method produces poor result with gradient domain mosaic, please select other method");
                }
                GeoCoding srcGeocoding = null;
                for (Product prod : this.sourceProduct) {
                    if (prod.getGeoCoding() == null) {
                        throw new OperatorException(MessageFormat.format("Product ''{0}'' has no geo-coding.", prod.getName()));
                    }
                    if (srcGeocoding != null) continue;
                    srcGeocoding = prod.getGeoCoding();
                }
                this.getSourceBands();
                OperatorUtils.computeImageGeoBoundary((Product[])this.selectedProducts, (OperatorUtils.SceneProperties)this.scnProp);
                if (this.sceneWidth == 0 || this.sceneHeight == 0) {
                    MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[0]);
                    if (this.pixelSize == 0.0 && absRoot != null) {
                        double d = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
                        double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
                        this.pixelSize = Math.min(d, azimuthSpacing);
                    }
                    OperatorUtils.getSceneDimensions((double)this.pixelSize, (OperatorUtils.SceneProperties)this.scnProp);
                    this.sceneWidth = this.scnProp.sceneWidth;
                    this.sceneHeight = this.scnProp.sceneHeight;
                    double d = (double)this.sceneWidth / (double)this.sceneHeight;
                    long dim = (long)this.sceneWidth * (long)this.sceneHeight;
                    while (this.sceneWidth > 0 && this.sceneHeight > 0 && dim > Integer.MAX_VALUE) {
                        this.sceneWidth -= 1000;
                        this.sceneHeight = (int)((double)this.sceneWidth / d);
                        dim = (long)this.sceneWidth * (long)this.sceneHeight;
                    }
                }
                this.targetProduct = new Product("mosaic", "mosaic", this.sceneWidth, this.sceneHeight);
                this.targetProduct.setGeoCoding((GeoCoding)this.createCRSGeoCoding(srcGeocoding));
                for (Map.Entry entry : this.bandIndexSet.entrySet()) {
                    Band srcBand = (Band)entry.getValue();
                    int targetBandDataType = this.gradientDomainMosaic ? 30 : srcBand.getDataType();
                    Band targetBand = new Band(srcBand.getName(), targetBandDataType, this.sceneWidth, this.sceneHeight);
                    targetBand.setUnit(srcBand.getUnit());
                    targetBand.setDescription(srcBand.getDescription());
                    targetBand.setNoDataValue(srcBand.getNoDataValue());
                    targetBand.setNoDataValueUsed(true);
                    this.targetProduct.addBand(targetBand);
                    if (!this.gradientDomainMosaic || !this.outputGradientBand) continue;
                    String targetBandName = srcBand.getName() + "_gradient";
                    Band gradientBand = new Band(targetBandName, 30, this.sceneWidth, this.sceneHeight);
                    this.targetProduct.addBand(gradientBand);
                }
                if (this.sourceProduct[0].getIndexCodingGroup().getNodeCount() > 0 && this.sourceProduct[0].getIndexCodingGroup().get(0) != null) {
                    try {
                        ProductUtils.copyIndexCodings((Product)this.sourceProduct[0], (Product)this.targetProduct);
                    }
                    catch (Exception e) {
                        if (this.resamplingMethod.equals(Resampling.NEAREST_NEIGHBOUR)) break block13;
                        throw new OperatorException("Use Nearest Neighbour with Classificaitons: " + e.getMessage());
                    }
                }
            }
            for (Product srcProduct : this.selectedProducts) {
                Rectangle srcRect = MosaicOp.getSrcRect(this.targetProduct.getGeoCoding(), (double[])this.scnProp.srcCornerLatitudeMap.get(srcProduct), (double[])this.scnProp.srcCornerLongitudeMap.get(srcProduct));
                this.srcRectMap.put(srcProduct, srcRect);
            }
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private CrsGeoCoding createCRSGeoCoding(GeoCoding srcGeocoding) throws Exception {
        CoordinateReferenceSystem srcCRS = srcGeocoding.getMapCRS();
        CoordinateReferenceSystem targetCRS = MapProjectionHandler.getCRS(srcCRS.toWKT());
        double pixelSpacingInDegree = this.pixelSize / 6378137.0 * 57.29577951308232;
        double pixelSizeX = this.pixelSize;
        double pixelSizeY = this.pixelSize;
        if (targetCRS.getName().getCode().equals("WGS84(DD)")) {
            pixelSizeX = pixelSpacingInDegree;
            pixelSizeY = pixelSpacingInDegree;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        bounds.setFrameFromDiagonal(this.scnProp.lonMin, this.scnProp.latMin, this.scnProp.lonMax, this.scnProp.latMax);
        ReferencedEnvelope boundsEnvelope = new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope targetEnvelope = boundsEnvelope.transform(targetCRS, true);
        return new CrsGeoCoding(targetCRS, this.sceneWidth, this.sceneHeight, targetEnvelope.getMinimum(0), targetEnvelope.getMaximum(1), pixelSizeX, pixelSizeY);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absRoot == null) {
            absRoot = AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)this.targetProduct.getMetadataRoot());
        }
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"range_spacing", (double)this.pixelSize);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"azimuth_spacing", (double)this.pixelSize);
    }

    private Band[] getSourceBands() throws OperatorException {
        ArrayList<Band> bandList = new ArrayList<Band>(20);
        HashSet<Product> selectedProductSet = new HashSet<Product>(this.sourceProduct.length);
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            for (Product srcProduct : this.sourceProduct) {
                for (Band band : srcProduct.getBands()) {
                    if (band instanceof VirtualBand) continue;
                    bandList.add(band);
                    this.bandIndexSet.put(srcProduct.getBandIndex(band.getName()), band);
                }
                selectedProductSet.add(srcProduct);
            }
        } else {
            for (String name : this.sourceBandNames) {
                String bandName = MosaicOp.getBandName(name);
                String productName = MosaicOp.getProductName(name, this.sourceProduct[0].getName());
                Product srcProduct = this.getProduct(productName);
                Band band = srcProduct.getBand(bandName);
                String bandUnit = band.getUnit();
                if (bandUnit != null && (bandUnit.contains("imaginary") || bandUnit.contains("real"))) {
                    throw new OperatorException("Real and imaginary bands not handled");
                }
                bandList.add(band);
                this.bandIndexSet.put(srcProduct.getBandIndex(band.getName()), band);
                selectedProductSet.add(srcProduct);
            }
        }
        this.selectedProducts = selectedProductSet.toArray(new Product[selectedProductSet.size()]);
        return bandList.toArray(new Band[bandList.size()]);
    }

    private Product getProduct(String productName) {
        for (Product prod : this.sourceProduct) {
            if (!prod.getName().equals(productName)) continue;
            return prod;
        }
        return null;
    }

    private static String getBandName(String name) {
        if (name.contains("::")) {
            return name.substring(0, name.indexOf("::"));
        }
        return name;
    }

    private static String getProductName(String name, String defaultName) {
        if (name.contains("::")) {
            return name.substring(name.indexOf("::") + 2, name.length());
        }
        return defaultName;
    }

    private static Rectangle getSrcRect(GeoCoding destGeoCoding, double[] lats, double[] lons) {
        double srcLatMin = 90.0;
        double srcLatMax = -90.0;
        double srcLonMin = 180.0;
        double srcLonMax = -180.0;
        for (double lat : lats) {
            if (lat < srcLatMin) {
                srcLatMin = lat;
            }
            if (!(lat > srcLatMax)) continue;
            srcLatMax = lat;
        }
        for (double lon : lons) {
            if (lon < srcLonMin) {
                srcLonMin = lon;
            }
            if (!(lon > srcLonMax)) continue;
            srcLonMax = lon;
        }
        GeoPos geoPos = new GeoPos();
        PixelPos[] pixelPos = new PixelPos[4];
        geoPos.setLocation((float)srcLatMin, (float)srcLonMin);
        pixelPos[0] = destGeoCoding.getPixelPos(geoPos, null);
        geoPos.setLocation((float)srcLatMin, (float)srcLonMax);
        pixelPos[1] = destGeoCoding.getPixelPos(geoPos, null);
        geoPos.setLocation((float)srcLatMax, (float)srcLonMax);
        pixelPos[2] = destGeoCoding.getPixelPos(geoPos, null);
        geoPos.setLocation((float)srcLatMax, (float)srcLonMin);
        pixelPos[3] = destGeoCoding.getPixelPos(geoPos, null);
        return MosaicOp.getBoundingBox(pixelPos, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, 4);
    }

    private static Rectangle getBoundingBox(PixelPos[] pixelPositions, int minOffsetX, int minOffsetY, int maxWidth, int maxHeight, int margin) {
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        for (PixelPos pixelsPos : pixelPositions) {
            if (pixelsPos == null) continue;
            int x = (int)Math.floor(pixelsPos.getX());
            int y = (int)Math.floor(pixelsPos.getY());
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        if (minX > maxX || minY > maxY) {
            return null;
        }
        minX = Math.max(minX - margin, minOffsetX);
        maxX = Math.min(maxX + margin, maxWidth - 1);
        minY = Math.max(minY - margin, minOffsetY);
        maxY = Math.min(maxY + margin, maxHeight - 1);
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            ArrayList<Product> validProducts = new ArrayList<Product>(this.sourceProduct.length);
            for (Product srcProduct : this.selectedProducts) {
                Rectangle srcRect = this.srcRectMap.get(srcProduct);
                if (srcRect == null || !srcRect.intersects(targetRectangle)) continue;
                validProducts.add(srcProduct);
            }
            if (validProducts.isEmpty()) {
                return;
            }
            GeoPos geoPos = new GeoPos();
            PixelPos pixelPos = new PixelPos();
            int minX = targetRectangle.x;
            int minY = targetRectangle.y;
            int maxX = targetRectangle.x + targetRectangle.width - 1;
            int maxY = targetRectangle.y + targetRectangle.height - 1;
            TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, minX, minY, maxX - minX + 1, maxY - minY + 1);
            ArrayList<PixelPos[]> srcPixelCoords = new ArrayList<PixelPos[]>(validProducts.size());
            int numPixelPos = targetRectangle.width * targetRectangle.height;
            for (Product validProduct : validProducts) {
                srcPixelCoords.add(new PixelPos[numPixelPos]);
            }
            int coordIndex = 0;
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    tileGeoRef.getGeoPos(x, y, geoPos);
                    int prodIndex = 0;
                    for (Product product : validProducts) {
                        product.getGeoCoding().getPixelPos(geoPos, pixelPos);
                        ((PixelPos[])srcPixelCoords.get((int)prodIndex))[coordIndex] = pixelPos.x >= (float)this.feather && pixelPos.y >= (float)this.feather && pixelPos.x < (float)(product.getSceneRasterWidth() - this.feather) && pixelPos.y < (float)(product.getSceneRasterHeight() - this.feather) ? new PixelPos(pixelPos.x, pixelPos.y) : null;
                        ++prodIndex;
                    }
                    ++coordIndex;
                }
            }
            Resampling resampling = ResamplingFactory.createResampling((String)this.resamplingMethod);
            if (this.gradientDomainMosaic) {
                this.performGradientDomainMosaic(targetTiles, targetRectangle, srcPixelCoords, validProducts, resampling, pm);
                return;
            }
            ArrayList<SourceData> validSourceData = new ArrayList<SourceData>(validProducts.size());
            for (Map.Entry entry : targetTiles.entrySet()) {
                String trgBandName = ((Band)entry.getKey()).getName();
                validSourceData.clear();
                int prodIndex = 0;
                for (Product srcProduct : validProducts) {
                    Band srcBand = srcProduct.getBand(trgBandName);
                    if (srcBand == null) continue;
                    PixelPos[] pixPos = (PixelPos[])srcPixelCoords.get(prodIndex);
                    Rectangle sourceRectangle = MosaicOp.getBoundingBox(pixPos, this.feather, this.feather, srcProduct.getSceneRasterWidth() - this.feather, srcProduct.getSceneRasterHeight() - this.feather, 4);
                    if (sourceRectangle != null) {
                        Tile srcTile;
                        double min = 0.0;
                        double max = 0.0;
                        double mean = 0.0;
                        double std = 0.0;
                        if (this.normalizeByMean) {
                            try {
                                Stx stats = srcBand.getStx(true, ProgressMonitor.NULL);
                                mean = stats.getMean();
                                min = stats.getMinimum();
                                max = stats.getMaximum();
                                std = stats.getStandardDeviation();
                            }
                            catch (Throwable e) {
                                this.normalizeByMean = false;
                            }
                        }
                        if ((srcTile = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle)) != null) {
                            validSourceData.add(new SourceData(srcTile, pixPos, resampling, min, max, mean, std));
                        }
                    }
                    ++prodIndex;
                }
                if (validSourceData.isEmpty()) continue;
                this.collocateSourceBand(validSourceData, resampling, (Tile)entry.getValue());
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private void collocateSourceBand(List<SourceData> validSourceData, Resampling resampling, Tile targetTile) throws OperatorException {
        try {
            Rectangle targetRectangle = targetTile.getRectangle();
            ProductData trgBuffer = targetTile.getDataBuffer();
            int maxY = targetRectangle.y + targetRectangle.height;
            int maxX = targetRectangle.x + targetRectangle.width;
            TileIndex trgIndex = new TileIndex(targetTile);
            double[] sampleList = new double[validSourceData.size()];
            int[] sampleDistanceList = new int[validSourceData.size()];
            int index = 0;
            for (int y = targetRectangle.y; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                int x = targetRectangle.x;
                while (x < maxX) {
                    double targetVal = 0.0;
                    int numSamples = 0;
                    for (SourceData srcDat : validSourceData) {
                        PixelPos sourcePixelPos = srcDat.srcPixPos[index];
                        if (sourcePixelPos == null) continue;
                        resampling.computeIndex((double)sourcePixelPos.x, (double)sourcePixelPos.y, srcDat.srcRasterWidth - this.feather, srcDat.srcRasterHeight - this.feather, srcDat.resamplingIndex);
                        double sample = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                        if (Double.isNaN(sample) || sample == srcDat.nodataValue || MathUtils.equalValues((double)sample, (double)0.0, (double)1.0E-4f)) continue;
                        if (this.normalizeByMean) {
                            sample -= srcDat.srcMean;
                            sample /= srcDat.srcStd;
                        }
                        targetVal = sample;
                        if (!this.average) continue;
                        sampleList[numSamples] = sample;
                        sampleDistanceList[numSamples] = (int)(Math.min(sourcePixelPos.x + 1.0f, (float)srcDat.srcRasterWidth - sourcePixelPos.x) * Math.min(sourcePixelPos.y + 1.0f, (float)srcDat.srcRasterHeight - sourcePixelPos.y));
                        ++numSamples;
                    }
                    if (targetVal != 0.0) {
                        if (this.average && numSamples > 1) {
                            double sum = 0.0;
                            int totalWeight = 0;
                            for (int i = 0; i < numSamples; ++i) {
                                sum += sampleList[i] * (double)sampleDistanceList[i];
                                totalWeight += sampleDistanceList[i];
                            }
                            targetVal = sum / (double)totalWeight;
                        }
                        trgBuffer.setElemDoubleAt(trgIndex.getIndex(x), targetVal);
                    }
                    ++x;
                    ++index;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void performGradientDomainMosaic(Map<Band, Tile> targetTiles, Rectangle targetRectangle, List<PixelPos[]> srcPixelCoords, List<Product> validProducts, Resampling resampling, ProgressMonitor pm) throws OperatorException {
        try {
            int minX = targetRectangle.x;
            int minY = targetRectangle.y;
            int maxX = targetRectangle.x + targetRectangle.width - 1;
            int maxY = targetRectangle.y + targetRectangle.height - 1;
            double[][] mosaicedTile = new double[targetRectangle.height][targetRectangle.width];
            double[][] gradientTile = new double[targetRectangle.height][targetRectangle.width];
            byte[][] mask = new byte[targetRectangle.height][targetRectangle.width];
            ArrayList<SourceData> validSourceData = new ArrayList<SourceData>(validProducts.size());
            for (Map.Entry<Band, Tile> bandTileEntry : targetTiles.entrySet()) {
                String trgBandName = bandTileEntry.getKey().getName();
                if (trgBandName.contains("_gradient")) continue;
                Tile trgTile = bandTileEntry.getValue();
                ProductData trgBuffer = trgTile.getDataBuffer();
                this.getValidSourceData(validProducts, trgBandName, srcPixelCoords, resampling, validSourceData, pm);
                for (int i = 0; i < validSourceData.size(); ++i) {
                    if (i == 0) {
                        this.readFirstProduct(minX, maxX, minY, maxY, (SourceData)validSourceData.get(i), resampling, mosaicedTile, mask);
                        continue;
                    }
                    this.readNextProduct(minX, maxX, minY, maxY, (SourceData)validSourceData.get(i), resampling, mosaicedTile, mask, gradientTile);
                    this.performMosaic(mask, gradientTile, mosaicedTile);
                    MosaicOp.cleanUpMask(mask);
                }
                TileIndex trgIndex = new TileIndex(trgTile);
                for (int y = minY; y <= maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = minX; x <= maxX; ++x) {
                        trgBuffer.setElemDoubleAt(trgIndex.getIndex(x), mosaicedTile[y - minY][x - minX]);
                    }
                }
                if (!this.outputGradientBand) continue;
                Band gradientBand = this.targetProduct.getBand(trgBandName + "_gradient");
                ProductData gradientBuffer = targetTiles.get(gradientBand).getDataBuffer();
                for (int y = minY; y <= maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = minX; x <= maxX; ++x) {
                        gradientBuffer.setElemDoubleAt(trgIndex.getIndex(x), gradientTile[y - minY][x - minX]);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getValidSourceData(List<Product> validProducts, String trgBandName, List<PixelPos[]> srcPixelCoords, Resampling resampling, List<SourceData> validSourceData, ProgressMonitor pm) {
        try {
            validSourceData.clear();
            int prodIndex = 0;
            for (Product srcProduct : validProducts) {
                Band srcBand = srcProduct.getBand(trgBandName);
                if (srcBand == null) continue;
                PixelPos[] pixPos = srcPixelCoords.get(prodIndex);
                Rectangle sourceRectangle = MosaicOp.getBoundingBox(pixPos, 0, 0, srcProduct.getSceneRasterWidth(), srcProduct.getSceneRasterHeight(), this.feather);
                if (sourceRectangle != null) {
                    Tile srcTile;
                    double mean = 0.0;
                    double min = 0.0;
                    double max = 0.0;
                    double std = 0.0;
                    if (this.normalizeByMean) {
                        try {
                            Stx stats = srcBand.getStx(true, pm);
                            mean = stats.getMean();
                            min = stats.getMinimum();
                            max = stats.getMaximum();
                            std = stats.getStandardDeviation();
                        }
                        catch (Throwable e) {
                            this.normalizeByMean = false;
                        }
                    }
                    if ((srcTile = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle)) != null) {
                        validSourceData.add(new SourceData(srcTile, pixPos, resampling, min, max, mean, std));
                    }
                }
                ++prodIndex;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void readFirstProduct(int minX, int maxX, int minY, int maxY, SourceData srcDat, Resampling resampling, double[][] mosaicedTile, byte[][] mask) throws OperatorException {
        try {
            int index = 0;
            for (int y = minY; y <= maxY; ++y) {
                int yy = y - minY;
                int x = minX;
                while (x <= maxX) {
                    int xx = x - minX;
                    PixelPos sourcePixelPos = srcDat.srcPixPos[index];
                    if (sourcePixelPos == null) {
                        mosaicedTile[yy][xx] = srcDat.nodataValue;
                        mask[yy][xx] = -1;
                    } else {
                        resampling.computeIndex((double)sourcePixelPos.x, (double)sourcePixelPos.y, srcDat.srcRasterWidth, srcDat.srcRasterHeight, srcDat.resamplingIndex);
                        double sample = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                        if (MosaicOp.isValidSample(sample, srcDat.nodataValue)) {
                            if (this.normalizeByMean) {
                                sample -= srcDat.srcMean;
                                sample /= srcDat.srcStd;
                            }
                            mosaicedTile[yy][xx] = sample;
                            mask[yy][xx] = 0;
                        } else {
                            mosaicedTile[yy][xx] = srcDat.nodataValue;
                            mask[yy][xx] = -1;
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void readNextProduct(int minX, int maxX, int minY, int maxY, SourceData srcDat, Resampling resampling, double[][] mosaicedTile, byte[][] mask, double[][] gradientTile) throws OperatorException {
        try {
            int targetTileWidth = mosaicedTile[0].length;
            int targetTileHeight = mosaicedTile.length;
            double[] adjacentPixels = new double[4];
            int index = 0;
            for (int y = minY; y <= maxY; ++y) {
                int yy = y - minY;
                int x = minX;
                while (x <= maxX) {
                    int xx = x - minX;
                    PixelPos sourcePixelPos = srcDat.srcPixPos[index];
                    if (sourcePixelPos != null) {
                        resampling.computeIndex((double)sourcePixelPos.x, (double)sourcePixelPos.y, srcDat.srcRasterWidth, srcDat.srcRasterHeight, srcDat.resamplingIndex);
                        double sample = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                        if (MosaicOp.isValidSample(sample, srcDat.nodataValue)) {
                            if (this.normalizeByMean) {
                                sample -= srcDat.srcMean;
                                sample /= srcDat.srcStd;
                            }
                            if (mask[yy][xx] == -1) {
                                mosaicedTile[yy][xx] = sample;
                                mask[yy][xx] = 1;
                            } else if (mask[yy][xx] == 0 && this.isInnerPoint(index, targetTileWidth, targetTileHeight, srcDat, resampling, adjacentPixels)) {
                                if (MosaicOp.isInnerPoint(xx, yy, mask)) {
                                    mask[yy][xx] = 2;
                                    mosaicedTile[yy][xx] = sample;
                                    gradientTile[yy][xx] = adjacentPixels[0] + adjacentPixels[1] + adjacentPixels[2] + adjacentPixels[3] - 4.0 * sample;
                                } else {
                                    mosaicedTile[yy][xx] = sample;
                                }
                            }
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private boolean isInnerPoint(int index, int targetTileWidth, int targetTileHeight, SourceData srcDat, Resampling resampling, double[] adjacentPixels) {
        try {
            int indexUp = index - targetTileWidth;
            int indexDown = index + targetTileWidth;
            int indexLeft = index - 1;
            int indexRight = index + 1;
            if (indexUp >= 0 && indexDown < targetTileWidth * targetTileHeight && index % targetTileWidth != 0 && (index + 1) % targetTileWidth != 0 && srcDat.srcPixPos[indexUp] != null && srcDat.srcPixPos[indexDown] != null && srcDat.srcPixPos[indexLeft] != null && srcDat.srcPixPos[indexRight] != null) {
                resampling.computeIndex((double)srcDat.srcPixPos[indexUp].x, (double)srcDat.srcPixPos[indexUp].y, srcDat.srcRasterWidth, srcDat.srcRasterHeight, srcDat.resamplingIndex);
                double s1 = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                resampling.computeIndex((double)srcDat.srcPixPos[indexDown].x, (double)srcDat.srcPixPos[indexDown].y, srcDat.srcRasterWidth, srcDat.srcRasterHeight, srcDat.resamplingIndex);
                double s2 = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                resampling.computeIndex((double)srcDat.srcPixPos[indexLeft].x, (double)srcDat.srcPixPos[indexLeft].y, srcDat.srcRasterWidth, srcDat.srcRasterHeight, srcDat.resamplingIndex);
                double s3 = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                resampling.computeIndex((double)srcDat.srcPixPos[indexRight].x, (double)srcDat.srcPixPos[indexRight].y, srcDat.srcRasterWidth, srcDat.srcRasterHeight, srcDat.resamplingIndex);
                double s4 = resampling.resample((Resampling.Raster)srcDat.resamplingRaster, srcDat.resamplingIndex);
                if (MosaicOp.isValidSample((float)s1, srcDat.nodataValue) && MosaicOp.isValidSample((float)s2, srcDat.nodataValue) && MosaicOp.isValidSample((float)s3, srcDat.nodataValue) && MosaicOp.isValidSample((float)s4, srcDat.nodataValue)) {
                    if (this.normalizeByMean) {
                        adjacentPixels[0] = (s1 - srcDat.srcMean) / srcDat.srcStd;
                        adjacentPixels[1] = (s2 - srcDat.srcMean) / srcDat.srcStd;
                        adjacentPixels[2] = (s3 - srcDat.srcMean) / srcDat.srcStd;
                        adjacentPixels[3] = (s4 - srcDat.srcMean) / srcDat.srcStd;
                    } else {
                        adjacentPixels[0] = s1;
                        adjacentPixels[1] = s2;
                        adjacentPixels[2] = s3;
                        adjacentPixels[3] = s4;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            return false;
        }
    }

    private static boolean isInnerPoint(int xx, int yy, byte[][] mask) {
        if (xx == 0 || yy == 0 || xx == mask[0].length - 1 || yy == mask.length - 1) {
            return false;
        }
        return !(mask[yy - 1][xx] != 0 && mask[yy - 1][xx] != 2 || mask[yy + 1][xx] != 0 && mask[yy + 1][xx] != 2 || mask[yy][xx - 1] != 0 && mask[yy][xx - 1] != 2 || mask[yy][xx + 1] != 0 && mask[yy][xx + 1] != 2);
    }

    private static boolean isValidSample(double sample, double noDataValue) {
        return !Double.isNaN(sample) && sample != noDataValue && !MathUtils.equalValues((double)sample, (double)0.0, (double)1.0E-4f);
    }

    private double computeGradient(int xx, int yy, double[][] mosaicedTile, double s0, double[] adjacentPixels) {
        double g2 = adjacentPixels[0] + adjacentPixels[1] + adjacentPixels[2] + adjacentPixels[3] - 4.0 * s0;
        return g2;
    }

    private void performMosaic(byte[][] mask, double[][] gradientTile, double[][] mosaicedTile) {
        double w = 1.5;
        int rows = mask.length;
        int cols = mask[0].length;
        double error = 0.0;
        for (int it = 0; it < this.maxIterations; ++it) {
            error = 0.0;
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    if (mask[r][c] != 2) continue;
                    double sigma = gradientTile[r][c] - mosaicedTile[r - 1][c] - mosaicedTile[r + 1][c] - mosaicedTile[r][c - 1] - mosaicedTile[r][c + 1];
                    double update = -0.5 * mosaicedTile[r][c] - 1.5 * sigma / 4.0;
                    error = Math.max(error, Math.abs(mosaicedTile[r][c] - update));
                    mosaicedTile[r][c] = update;
                }
            }
            if (error < this.convergenceThreshold) break;
        }
    }

    private static void cleanUpMask(byte[][] mask) {
        int rows = mask.length;
        int cols = mask[0].length;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                if (mask[r][c] <= 0) continue;
                mask[r][c] = 0;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MosaicOp.class);
        }
    }

    private static class SourceData {
        final Tile srcTile;
        final ResamplingRaster resamplingRaster;
        final Resampling.Index resamplingIndex;
        final double nodataValue;
        final PixelPos[] srcPixPos;
        final int srcRasterHeight;
        final int srcRasterWidth;
        final double srcMean;
        final double srcMax;
        final double srcMin;
        final double srcStd;

        public SourceData(Tile tile, PixelPos[] pixPos, Resampling resampling, double min, double max, double mean, double std) {
            this.srcTile = tile;
            this.resamplingRaster = new ResamplingRaster(this.srcTile);
            this.resamplingIndex = resampling.createIndex();
            this.nodataValue = tile.getRasterDataNode().getNoDataValue();
            this.srcPixPos = pixPos;
            Product srcProduct = tile.getRasterDataNode().getProduct();
            this.srcRasterHeight = srcProduct.getSceneRasterHeight();
            this.srcRasterWidth = srcProduct.getSceneRasterWidth();
            this.srcMin = min;
            this.srcMax = max;
            this.srcMean = mean;
            this.srcStd = std;
        }
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;
        private final boolean usesNoData;
        private final boolean scalingApplied;
        private final double noDataValue;
        private final double geophysicalNoDataValue;
        private final ProductData dataBuffer;
        private final int minX;
        private final int minY;
        private final int maxX;
        private final int maxY;

        public ResamplingRaster(Tile tile) {
            this.tile = tile;
            this.minX = tile.getMinX();
            this.minY = tile.getMinY();
            this.maxX = tile.getMaxX();
            this.maxY = tile.getMaxY();
            this.dataBuffer = tile.getDataBuffer();
            RasterDataNode rasterDataNode = tile.getRasterDataNode();
            this.usesNoData = rasterDataNode.isNoDataValueUsed();
            this.noDataValue = rasterDataNode.getNoDataValue();
            this.geophysicalNoDataValue = rasterDataNode.getGeophysicalNoDataValue();
            this.scalingApplied = rasterDataNode.isScalingApplied();
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
            boolean allValid = true;
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    if (x[j] < this.minX || y[i] < this.minY || x[j] > this.maxX || y[i] > this.maxY) {
                        samples[i][j] = Double.NaN;
                        allValid = false;
                    }
                    try {
                        samples[i][j] = this.dataBuffer.getElemDoubleAt(this.tile.getDataBufferIndex(x[j], y[i]));
                    }
                    catch (Exception e) {
                        samples[i][j] = Double.NaN;
                        allValid = false;
                    }
                    if (!this.usesNoData || (!this.scalingApplied || this.geophysicalNoDataValue != samples[i][j]) && this.noDataValue != samples[i][j]) continue;
                    samples[i][j] = Double.NaN;
                    allValid = false;
                }
            }
            return allValid;
        }
    }
}

