/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.util.SystemUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUIUtils;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class MosaicOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox<String> resamplingMethod = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JTextField pixelSize = new JTextField("");
    private final JTextField sceneWidth = new JTextField("");
    private final JTextField sceneHeight = new JTextField("");
    private final JTextField feather = new JTextField("");
    private final JTextField maxIterations = new JTextField("");
    private final JTextField convergenceThreshold = new JTextField("");
    private final JLabel maxIterationsLabel = new JLabel("Maximum Iterations");
    private final JLabel convergenceThresholdLabel = new JLabel("Convergence Threshold");
    private final JCheckBox averageCheckBox = new JCheckBox("Weighted Average of Overlap");
    private final JCheckBox normalizeByMeanCheckBox = new JCheckBox("Normalize");
    private final JCheckBox gradientDomainMosaicCheckBox = new JCheckBox("Gradient Domain Mosaic");
    private boolean changedByUser = false;
    private boolean average = false;
    private boolean normalizeByMean = false;
    private boolean gradientDomainMosaic = false;
    private double widthHeightRatio = 1.0;
    private double pixelSizeHeightRatio = 1.0;
    private final OperatorUtils.SceneProperties scnProp = new OperatorUtils.SceneProperties();
    private static final String useGradientDomainStr = System.getProperty(SystemUtils.getApplicationContextId() + ".mosaic.allow.gradient.domain");
    private static final boolean useGradientDomain = useGradientDomainStr != null && useGradientDomainStr.equals("true");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.averageCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MosaicOpUI.this.average = e.getStateChange() == 1;
                if (MosaicOpUI.this.average) {
                    MosaicOpUI.this.gradientDomainMosaic = false;
                    MosaicOpUI.this.gradientDomainMosaicCheckBox.getModel().setSelected(MosaicOpUI.this.gradientDomainMosaic);
                    MosaicOpUI.this.maxIterations.setVisible(false);
                    MosaicOpUI.this.convergenceThreshold.setVisible(false);
                    MosaicOpUI.this.maxIterationsLabel.setVisible(false);
                    MosaicOpUI.this.convergenceThresholdLabel.setVisible(false);
                }
            }
        });
        this.normalizeByMeanCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MosaicOpUI.this.normalizeByMean = e.getStateChange() == 1;
                if (MosaicOpUI.this.normalizeByMean) {
                    MosaicOpUI.this.maxIterations.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                    MosaicOpUI.this.convergenceThreshold.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                    MosaicOpUI.this.maxIterationsLabel.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                    MosaicOpUI.this.convergenceThresholdLabel.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                }
            }
        });
        this.gradientDomainMosaicCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MosaicOpUI.this.gradientDomainMosaic = e.getStateChange() == 1;
                if (MosaicOpUI.this.gradientDomainMosaic) {
                    MosaicOpUI.this.average = false;
                    MosaicOpUI.this.averageCheckBox.getModel().setSelected(MosaicOpUI.this.average);
                }
                MosaicOpUI.this.maxIterations.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                MosaicOpUI.this.convergenceThreshold.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                MosaicOpUI.this.maxIterationsLabel.setVisible(MosaicOpUI.this.gradientDomainMosaic);
                MosaicOpUI.this.convergenceThresholdLabel.setVisible(MosaicOpUI.this.gradientDomainMosaic);
            }
        });
        this.pixelSize.addKeyListener(new TextAreaKeyListener());
        this.sceneWidth.addKeyListener(new TextAreaKeyListener());
        this.sceneHeight.addKeyListener(new TextAreaKeyListener());
        return new JScrollPane(panel);
    }

    public void initParameters() {
        Double convergenceThresholdVal;
        Integer maxIterationsVal;
        Integer featherVal;
        Integer height;
        Integer width;
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        this.resamplingMethod.setSelectedItem(this.paramMap.get("resamplingMethod"));
        Double pixSize = (Double)this.paramMap.get("pixelSize");
        if (pixSize == null) {
            pixSize = 0.0;
        }
        if ((width = (Integer)this.paramMap.get("sceneWidth")) == null) {
            width = 0;
        }
        if ((height = (Integer)this.paramMap.get("sceneHeight")) == null) {
            height = 0;
        }
        if ((featherVal = (Integer)this.paramMap.get("feather")) == null) {
            featherVal = 0;
        }
        if ((maxIterationsVal = (Integer)this.paramMap.get("maxIterations")) == null) {
            maxIterationsVal = 0;
        }
        if ((convergenceThresholdVal = (Double)this.paramMap.get("convergenceThreshold")) == null) {
            convergenceThresholdVal = 0.0;
        }
        if (!this.changedByUser && this.sourceProducts != null) {
            try {
                OperatorUtils.computeImageGeoBoundary((Product[])this.sourceProducts, (OperatorUtils.SceneProperties)this.scnProp);
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
                double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
                double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
                double minSpacing = Math.min(rangeSpacing, azimuthSpacing);
                pixSize = minSpacing;
                OperatorUtils.getSceneDimensions((double)minSpacing, (OperatorUtils.SceneProperties)this.scnProp);
                width = this.scnProp.sceneWidth;
                height = this.scnProp.sceneHeight;
                this.widthHeightRatio = (double)width.intValue() / (double)height.intValue();
                this.pixelSizeHeightRatio = pixSize / (double)height.intValue();
                long dim = width * height;
                while (dim > Integer.MAX_VALUE) {
                    width = width - 1000;
                    height = (int)((double)width.intValue() / this.widthHeightRatio);
                    dim = width * height;
                }
            }
            catch (Exception e) {
                width = 0;
                height = 0;
            }
        }
        this.pixelSize.setText(String.valueOf(pixSize));
        this.sceneWidth.setText(String.valueOf(width));
        this.sceneHeight.setText(String.valueOf(height));
        this.feather.setText(String.valueOf(featherVal));
        this.maxIterations.setText(String.valueOf(maxIterationsVal));
        this.convergenceThreshold.setText(String.valueOf(convergenceThresholdVal));
        this.average = (Boolean)this.paramMap.get("average");
        this.averageCheckBox.getModel().setSelected(this.average);
        this.normalizeByMean = (Boolean)this.paramMap.get("normalizeByMean");
        this.normalizeByMeanCheckBox.getModel().setSelected(this.normalizeByMean);
        this.gradientDomainMosaic = (Boolean)this.paramMap.get("gradientDomainMosaic");
        this.gradientDomainMosaicCheckBox.getModel().setSelected(this.gradientDomainMosaic);
        this.maxIterations.setVisible(this.gradientDomainMosaic);
        this.convergenceThreshold.setVisible(this.gradientDomainMosaic);
        this.maxIterationsLabel.setVisible(this.gradientDomainMosaic);
        this.convergenceThresholdLabel.setVisible(this.gradientDomainMosaic);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("resamplingMethod", this.resamplingMethod.getSelectedItem());
        this.paramMap.put("pixelSize", Double.parseDouble(this.pixelSize.getText()));
        this.paramMap.put("sceneWidth", Integer.parseInt(this.sceneWidth.getText()));
        this.paramMap.put("sceneHeight", Integer.parseInt(this.sceneHeight.getText()));
        this.paramMap.put("feather", Integer.parseInt(this.feather.getText()));
        this.paramMap.put("maxIterations", Integer.parseInt(this.maxIterations.getText()));
        this.paramMap.put("convergenceThreshold", Double.parseDouble(this.convergenceThreshold.getText()));
        this.paramMap.put("average", this.average);
        this.paramMap.put("normalizeByMean", this.normalizeByMean);
        this.paramMap.put("gradientDomainMosaic", this.gradientDomainMosaic);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Method:", this.resamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Pixel Size (m):", (JComponent)this.pixelSize);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Scene Width (pixels)", (JComponent)this.sceneWidth);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Scene Height (pixels)", (JComponent)this.sceneHeight);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Feather (pixels)", (JComponent)this.feather);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.maxIterationsLabel, (JComponent)this.maxIterations);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.convergenceThresholdLabel, (JComponent)this.convergenceThreshold);
        ++gbc.gridy;
        contentPane.add((Component)this.averageCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.normalizeByMeanCheckBox, gbc);
        ++gbc.gridy;
        if (useGradientDomain) {
            contentPane.add((Component)this.gradientDomainMosaicCheckBox, gbc);
        }
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private class TextAreaKeyListener
    implements KeyListener {
        private TextAreaKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            try {
                MosaicOpUI.this.changedByUser = true;
                if (e.getComponent() == MosaicOpUI.this.pixelSize) {
                    double pixSize = Double.parseDouble(MosaicOpUI.this.pixelSize.getText());
                    OperatorUtils.getSceneDimensions((double)pixSize, (OperatorUtils.SceneProperties)MosaicOpUI.this.scnProp);
                    MosaicOpUI.this.sceneWidth.setText(String.valueOf(((MosaicOpUI)MosaicOpUI.this).scnProp.sceneWidth));
                    MosaicOpUI.this.sceneHeight.setText(String.valueOf(((MosaicOpUI)MosaicOpUI.this).scnProp.sceneHeight));
                } else if (e.getComponent() == MosaicOpUI.this.sceneWidth) {
                    int height = (int)((double)Integer.parseInt(MosaicOpUI.this.sceneWidth.getText()) / MosaicOpUI.this.widthHeightRatio);
                    MosaicOpUI.this.sceneHeight.setText(String.valueOf(height));
                    MosaicOpUI.this.pixelSize.setText(String.valueOf((double)height * MosaicOpUI.this.pixelSizeHeightRatio));
                } else if (e.getComponent() == MosaicOpUI.this.sceneHeight) {
                    int width = (int)((double)Integer.parseInt(MosaicOpUI.this.sceneHeight.getText()) / MosaicOpUI.this.widthHeightRatio);
                    MosaicOpUI.this.sceneWidth.setText(String.valueOf(width));
                    MosaicOpUI.this.pixelSize.setText(String.valueOf((double)width * MosaicOpUI.this.pixelSizeHeightRatio));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

