/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.EarthGravitationalModel96;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.FileElevationModel;
import org.esa.nest.datamodel.CalibrationFactory;
import org.esa.nest.datamodel.Calibrator;
import org.esa.nest.gpf.Sentinel1Calibrator;
import org.esa.nest.gpf.geometric.CRSGeoCodingHandler;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.nest.gpf.geometric.SARUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.datamodel.Unit;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.eo.LocalGeometry;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ReaderUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="Terrain-Correction", category="SAR Processing/Geometric/Terrain Correction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="RD method for orthorectification")
public class RangeDopplerGeocodingOp
extends Operator {
    public static final String PRODUCT_SUFFIX = "_TC";
    @SourceProduct(alias="source")
    Product sourceProduct;
    @TargetProduct
    Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(valueSet={"ACE", "GETASSE30", "SRTM 3Sec", "ASTER 1sec GDEM"}, description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="BILINEAR_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BILINEAR_INTERPOLATION";
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="BILINEAR_INTERPOLATION", label="Image Resampling Method")
    private String imgResamplingMethod = "BILINEAR_INTERPOLATION";
    @Parameter(description="The pixel spacing in meters", defaultValue="0", label="Pixel Spacing (m)")
    private double pixelSpacingInMeter = 0.0;
    @Parameter(description="The pixel spacing in degrees", defaultValue="0", label="Pixel Spacing (deg)")
    private double pixelSpacingInDegree = 0.0;
    @Parameter(description="The coordinate reference system in well known text format", defaultValue="WGS84(DD)")
    private String mapProjection = "WGS84(DD)";
    @Parameter(defaultValue="true", label="Mask out areas with no elevation", description="Mask the sea with no data value (faster)")
    private boolean nodataValueAtSea = true;
    @Parameter(defaultValue="false", label="Save DEM as band")
    private boolean saveDEM = false;
    @Parameter(defaultValue="false", label="Save latitude and longitude as band")
    private boolean saveLatLon = false;
    @Parameter(defaultValue="false", label="Save incidence angle from ellipsoid as band")
    private boolean saveIncidenceAngleFromEllipsoid = false;
    @Parameter(defaultValue="false", label="Save local incidence angle as band")
    private boolean saveLocalIncidenceAngle = false;
    @Parameter(defaultValue="false", label="Save projected local incidence angle as band")
    private boolean saveProjectedLocalIncidenceAngle = false;
    @Parameter(defaultValue="true", label="Save selected source band")
    private boolean saveSelectedSourceBand = true;
    @Parameter(defaultValue="false", label="Apply radiometric normalization")
    private boolean applyRadiometricNormalization = false;
    @Parameter(defaultValue="false", label="Save Sigma0 as a band")
    private boolean saveSigmaNought = false;
    @Parameter(defaultValue="false", label="Save Gamma0 as a band")
    private boolean saveGammaNought = false;
    @Parameter(defaultValue="false", label="Save Beta0 as a band")
    private boolean saveBetaNought = false;
    @Parameter(valueSet={"Use incidence angle from Ellipsoid", "Use local incidence angle from DEM", "Use projected local incidence angle from DEM"}, defaultValue="Use projected local incidence angle from DEM", label="")
    private String incidenceAngleForSigma0 = "Use projected local incidence angle from DEM";
    @Parameter(valueSet={"Use incidence angle from Ellipsoid", "Use local incidence angle from DEM", "Use projected local incidence angle from DEM"}, defaultValue="Use projected local incidence angle from DEM", label="")
    private String incidenceAngleForGamma0 = "Use projected local incidence angle from DEM";
    @Parameter(valueSet={"Latest Auxiliary File", "Product Auxiliary File", "External Auxiliary File"}, description="The auxiliary file", defaultValue="Latest Auxiliary File", label="Auxiliary File")
    private String auxFile = "Latest Auxiliary File";
    @Parameter(description="The antenne elevation pattern gain auxiliary data file.", label="External Aux File")
    private File externalAuxFile = null;
    private MetadataElement absRoot = null;
    private ElevationModel dem = null;
    private Band elevationBand = null;
    private float demNoDataValue = 0.0f;
    private GeoCoding targetGeoCoding = null;
    private boolean srgrFlag = false;
    private boolean isElevationModelAvailable = false;
    private boolean usePreCalibrationOp = false;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int targetImageWidth = 0;
    private int targetImageHeight = 0;
    private double avgSceneHeight = 0.0;
    private double wavelength = 0.0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private double firstLineUTC = 0.0;
    private double lastLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private double nearEdgeSlantRange = 0.0;
    private CoordinateReferenceSystem targetCRS;
    private double delLat = 0.0;
    private double delLon = 0.0;
    private int polyDegree = 2;
    private SARGeocoding.Orbit orbit = null;
    private AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;
    private OrbitStateVector[] orbitStateVectors = null;
    private final HashMap<String, Band[]> targetBandNameToSourceBand = new HashMap();
    private final Map<String, Boolean> targetBandApplyRadiometricNormalizationFlag = new HashMap<String, Boolean>();
    private final Map<String, Boolean> targetBandApplyRetroCalibrationFlag = new HashMap<String, Boolean>();
    private TiePointGrid incidenceAngle = null;
    private TiePointGrid latitude = null;
    private TiePointGrid longitude = null;
    private static final int INVALID_SUB_SWATH_INDEX = -1;
    private Resampling imgResampling = null;
    boolean useAvgSceneHeight = false;
    private Calibrator calibrator = null;
    private boolean orthoDataProduced = false;
    private boolean processingStarted = false;
    private boolean isPolsar = false;
    private boolean nearRangeOnLeft = true;
    private String mission = null;
    private boolean skipBistaticCorrection = false;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected();
            validator.checkIfTOPSARBurstProduct(false);
            this.checkUserInput();
            this.getSourceImageDimension();
            this.getMetadata();
            this.getTiePointGrid();
            if (this.useAvgSceneHeight) {
                this.saveSigmaNought = false;
                this.saveBetaNought = false;
                this.saveGammaNought = false;
                this.saveDEM = false;
                this.saveLocalIncidenceAngle = false;
                this.saveProjectedLocalIncidenceAngle = false;
            }
            this.imgResampling = ResamplingFactory.createResampling((String)this.imgResamplingMethod);
            this.createTargetProduct();
            this.computeSensorPositionsAndVelocities();
            if (this.saveSigmaNought) {
                this.calibrator = CalibrationFactory.createCalibrator((Product)this.sourceProduct);
                if (this.calibrator instanceof Sentinel1Calibrator) {
                    Band[] sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames);
                    HashSet<String> polList = new HashSet<String>();
                    for (Band band : sourceBands) {
                        polList.add(OperatorUtils.getBandPolarization((String)band.getName(), (MetadataElement)this.absRoot));
                    }
                    String[] selectedPolarisations = polList.toArray(new String[polList.size()]);
                    Sentinel1Calibrator cal = (Sentinel1Calibrator)this.calibrator;
                    cal.setUserSelections(this.sourceProduct, selectedPolarisations, this.saveSigmaNought, this.saveGammaNought, this.saveBetaNought, false);
                }
                this.calibrator.setAuxFileFlag(this.auxFile);
                this.calibrator.setExternalAuxFile(this.externalAuxFile);
                this.calibrator.initialize((Operator)this, this.sourceProduct, this.targetProduct, true, true);
                this.calibrator.setIncidenceAngleForSigma0(this.incidenceAngleForSigma0);
            }
            this.updateTargetProductMetadata();
            if (this.externalDEMFile == null && !this.useAvgSceneHeight) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            if (!this.useAvgSceneHeight) {
                DEMFactory.validateDEM((String)this.demName, (Product)this.sourceProduct);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public void dispose() throws OperatorException {
        if (this.dem != null) {
            this.dem.dispose();
        }
        if (!this.orthoDataProduced && this.processingStarted) {
            String errMsg = this.getId() + " error: no valid output was produced. Please verify the DEM";
            System.out.println(errMsg);
            if (VisatApp.getApp() != null) {
                VisatApp.getApp().setStatusBarMessage(errMsg);
            }
        }
    }

    private void checkUserInput() {
        if (!this.saveSelectedSourceBand && !this.applyRadiometricNormalization) {
            throw new OperatorException("Please select output band for terrain corrected image");
        }
        if (!this.applyRadiometricNormalization) {
            this.saveSigmaNought = false;
            this.saveGammaNought = false;
            this.saveBetaNought = false;
        }
        if (this.saveBetaNought || this.saveGammaNought || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use incidence angle from Ellipsoid") || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use local incidence angle from DEM")) {
            this.saveSigmaNought = true;
            this.saveProjectedLocalIncidenceAngle = true;
        }
        if (this.saveGammaNought && this.incidenceAngleForGamma0.contains("Use incidence angle from Ellipsoid") || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use incidence angle from Ellipsoid")) {
            this.saveIncidenceAngleFromEllipsoid = true;
        }
        if (this.saveGammaNought && this.incidenceAngleForGamma0.contains("Use local incidence angle from DEM") || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use local incidence angle from DEM")) {
            this.saveLocalIncidenceAngle = true;
        }
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
    }

    private void getTiePointGrid() {
        this.latitude = OperatorUtils.getLatitude((Product)this.sourceProduct);
        if (this.latitude == null) {
            throw new OperatorException("Product without latitude tie point grid");
        }
        this.longitude = OperatorUtils.getLongitude((Product)this.sourceProduct);
        if (this.longitude == null) {
            throw new OperatorException("Product without longitude tie point grid");
        }
    }

    private void getMetadata() throws Exception {
        this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        this.mission = RangeDopplerGeocodingOp.getMissionType(this.absRoot);
        if (this.mission.contains("CSKS") || this.mission.contains("TSX") || this.mission.equals("RS2") || this.mission.contains("SENTINEL")) {
            this.skipBistaticCorrection = true;
        }
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"srgr_flag");
        this.wavelength = SARUtils.getRadarFrequency((MetadataElement)this.absRoot);
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        if (this.rangeSpacing <= 0.0) {
            throw new OperatorException("Invalid input for range pixel spacing: " + this.rangeSpacing);
        }
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
        if (this.azimuthSpacing <= 0.0) {
            throw new OperatorException("Invalid input for azimuth pixel spacing: " + this.azimuthSpacing);
        }
        this.firstLineUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("first_line_time")).getMJD();
        this.lastLineUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("last_line_time")).getMJD();
        this.lineTimeInterval = (this.lastLineUTC - this.firstLineUTC) / (double)(this.sourceImageHeight - 1);
        if (this.lastLineUTC == 0.0) {
            throw new OperatorException("Invalid input for Line Time Interval: " + this.lineTimeInterval);
        }
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)this.absRoot);
        if (this.orbitStateVectors == null || this.orbitStateVectors.length == 0) {
            throw new OperatorException("Invalid Obit State Vectors");
        }
        if (this.srgrFlag) {
            this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)this.absRoot);
            if (this.srgrConvParams == null || this.srgrConvParams.length == 0) {
                throw new OperatorException("Invalid SRGR Coefficients");
            }
        } else {
            this.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"slant_range_to_first_pixel");
        }
        this.avgSceneHeight = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"avg_scene_height");
        MetadataAttribute attribute = this.absRoot.getAttribute("retro-calibration performed flag");
        if (attribute != null) {
            this.usePreCalibrationOp = true;
            if (!this.applyRadiometricNormalization) {
                throw new OperatorException("Apply radiometric normalization must be selected.");
            }
        } else {
            boolean multilookFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"multilook_flag");
            if (this.applyRadiometricNormalization && (this.mission.equals("ERS1") || this.mission.equals("ERS2")) && !multilookFlag) {
                throw new OperatorException("For radiometric normalization of ERS product, please first use\n  'Remove Antenna Pattern' operator to remove calibration factors applied and apply ADC,\n  then apply 'Range-Doppler Terrain Correction' operator; or use one of the following\n  user graphs: 'RemoveAntPat_Orthorectify' or 'RemoveAntPat_Multilook_Orthorectify'.");
            }
        }
        this.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft((TiePointGrid)this.incidenceAngle, (int)this.sourceImageWidth);
        this.isPolsar = this.absRoot.getAttributeInt("polsar_data", 0) == 1;
    }

    public static String getMissionType(MetadataElement absRoot) {
        String productType;
        String mission = absRoot.getAttributeString("MISSION");
        if (mission.equals("ALOS") && !(productType = absRoot.getAttributeString("PRODUCT_TYPE").toUpperCase()).contains("1.1")) {
            throw new OperatorException("Detected ALOS PALSAR products are currently not supported");
        }
        if (mission.equals("RS1")) {
            // empty if block
        }
        return mission;
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        if (this.externalDEMFile != null) {
            this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Float.valueOf((float)this.externalDEMNoDataValue));
            this.demNoDataValue = (float)this.externalDEMNoDataValue;
            this.demName = this.externalDEMFile.getName();
        } else {
            this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
            this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
        }
        if (this.elevationBand != null) {
            this.elevationBand.setNoDataValue((double)this.demNoDataValue);
            this.elevationBand.setNoDataValueUsed(true);
        }
        this.isElevationModelAvailable = true;
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() {
        try {
            if (this.pixelSpacingInMeter <= 0.0) {
                this.pixelSpacingInMeter = Math.max(SARGeocoding.getAzimuthPixelSpacing((Product)this.sourceProduct), SARGeocoding.getRangePixelSpacing((Product)this.sourceProduct));
                this.pixelSpacingInDegree = SARGeocoding.getPixelSpacingInDegree((double)this.pixelSpacingInMeter);
            }
            this.delLat = this.pixelSpacingInDegree;
            this.delLon = this.pixelSpacingInDegree;
            CRSGeoCodingHandler crsHandler = new CRSGeoCodingHandler(this.sourceProduct, this.mapProjection, this.pixelSpacingInDegree, this.pixelSpacingInMeter);
            this.targetCRS = crsHandler.getTargetCRS();
            this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), crsHandler.getTargetWidth(), crsHandler.getTargetHeight());
            this.targetProduct.setGeoCoding((GeoCoding)crsHandler.getCrsGeoCoding());
            this.targetImageWidth = this.targetProduct.getSceneRasterWidth();
            this.targetImageHeight = this.targetProduct.getSceneRasterHeight();
            this.addSelectedBands();
            this.targetGeoCoding = this.targetProduct.getGeoCoding();
            ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
            this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
            this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
            this.targetProduct.setDescription(this.sourceProduct.getDescription());
            try {
                ProductUtils.copyIndexCodings((Product)this.sourceProduct, (Product)this.targetProduct);
            }
            catch (Exception e) {
                if (!this.imgResampling.equals(Resampling.NEAREST_NEIGHBOUR)) {
                    throw new OperatorException("Use Nearest Neighbour with Classifications: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void computeSensorPositionsAndVelocities() {
        this.orbit = new SARGeocoding.Orbit(this.orbitStateVectors, this.polyDegree, this.firstLineUTC, this.lineTimeInterval, this.sourceImageHeight);
    }

    void addSelectedBands() throws OperatorException {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames);
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit != null && !this.isPolsar && (unit.equals("real") || unit.equals("imaginary"))) {
                if (i == sourceBands.length - 1) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (!(nextUnit != null && (unit.equals("real") && nextUnit.equals("imaginary") || unit.equals("imaginary") && nextUnit.equals("real")))) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                Band[] srcBands = new Band[]{srcBand, sourceBands[i + 1]};
                String pol = OperatorUtils.getBandPolarization((String)srcBand.getName(), (MetadataElement)this.absRoot);
                String suffix = OperatorUtils.getSuffixFromBandName((String)srcBand.getName());
                if (this.saveSigmaNought) {
                    targetBandName = suffix != null && !suffix.isEmpty() && !this.isPolsar ? (!(pol == null || pol.isEmpty() || suffix.contains(pol) || suffix.contains(pol.toUpperCase())) ? "Sigma0_" + suffix + '_' + pol.toUpperCase() : "Sigma0_" + suffix) : "Sigma0";
                    if (this.addTargetBand(targetBandName, "intensity", srcBand) != null) {
                        this.targetBandNameToSourceBand.put(targetBandName, srcBands);
                        this.targetBandApplyRadiometricNormalizationFlag.put(targetBandName, true);
                        if (this.usePreCalibrationOp) {
                            this.targetBandApplyRetroCalibrationFlag.put(targetBandName, false);
                        } else {
                            this.targetBandApplyRetroCalibrationFlag.put(targetBandName, true);
                        }
                    }
                }
                if (this.saveSelectedSourceBand) {
                    targetBandName = suffix != null && !suffix.isEmpty() && !this.isPolsar ? (!(pol == null || pol.isEmpty() || suffix.contains(pol) || suffix.contains(pol.toUpperCase())) ? "Intensity_" + suffix + '_' + pol.toUpperCase() : "Intensity_" + suffix) : "Intensity";
                    if (this.addTargetBand(targetBandName, "intensity", srcBand) != null) {
                        this.targetBandNameToSourceBand.put(targetBandName, srcBands);
                        this.targetBandApplyRadiometricNormalizationFlag.put(targetBandName, false);
                        this.targetBandApplyRetroCalibrationFlag.put(targetBandName, false);
                    }
                }
                ++i;
                continue;
            }
            Band[] srcBands = new Band[]{srcBand};
            String pol = OperatorUtils.getBandPolarization((String)srcBand.getName(), (MetadataElement)this.absRoot);
            String suffix = OperatorUtils.getSuffixFromBandName((String)srcBand.getName());
            if (this.saveSigmaNought) {
                targetBandName = "Sigma0";
                if (suffix != null && !suffix.isEmpty() && !this.isPolsar) {
                    targetBandName = pol != null && !pol.isEmpty() && !suffix.contains(pol) && !suffix.contains(pol.toUpperCase()) ? targetBandName + '_' + suffix + '_' + pol.toUpperCase() : targetBandName + '_' + suffix;
                }
                if (this.addTargetBand(targetBandName, "intensity", srcBand) != null) {
                    this.targetBandNameToSourceBand.put(targetBandName, srcBands);
                    this.targetBandApplyRadiometricNormalizationFlag.put(targetBandName, true);
                    if (this.usePreCalibrationOp) {
                        this.targetBandApplyRetroCalibrationFlag.put(targetBandName, false);
                    } else {
                        this.targetBandApplyRetroCalibrationFlag.put(targetBandName, true);
                    }
                }
            }
            if (!this.saveSelectedSourceBand) continue;
            targetBandName = srcBand.getName();
            if (!(pol == null || pol.isEmpty() || this.isPolsar || srcBand.getName().toLowerCase().contains(pol))) {
                targetBandName = targetBandName + '_' + pol.toUpperCase();
            }
            int dataType = 30;
            if (this.imgResampling.equals(Resampling.NEAREST_NEIGHBOUR)) {
                dataType = srcBand.getDataType();
            }
            if (RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, targetBandName, unit, srcBand, dataType) == null) continue;
            this.targetBandNameToSourceBand.put(targetBandName, srcBands);
            this.targetBandApplyRadiometricNormalizationFlag.put(targetBandName, false);
            this.targetBandApplyRetroCalibrationFlag.put(targetBandName, false);
        }
        if (this.saveDEM) {
            this.elevationBand = this.addTargetBand("elevation", "meters", null);
        }
        if (this.saveLatLon) {
            this.addTargetBand("latitude", "deg", null);
            this.addTargetBand("longitude", "deg", null);
        }
        if (this.saveLocalIncidenceAngle) {
            this.addTargetBand("localIncidenceAngle", "deg", null);
        }
        if (this.saveProjectedLocalIncidenceAngle) {
            this.addTargetBand("projectedLocalIncidenceAngle", "deg", null);
        }
        if (this.saveIncidenceAngleFromEllipsoid) {
            this.addTargetBand("incidenceAngleFromEllipsoid", "deg", null);
        }
        if (this.saveSigmaNought && !this.incidenceAngleForSigma0.contains("Use projected local incidence angle from DEM")) {
            CalibrationFactory.createSigmaNoughtVirtualBand((Product)this.targetProduct, (String)this.incidenceAngleForSigma0);
        }
        if (this.saveGammaNought) {
            CalibrationFactory.createGammaNoughtVirtualBand((Product)this.targetProduct, (String)this.incidenceAngleForGamma0);
        }
        if (this.saveBetaNought) {
            CalibrationFactory.createBetaNoughtVirtualBand((Product)this.targetProduct);
        }
    }

    private Band addTargetBand(String bandName, String bandUnit, Band sourceBand) {
        return RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, bandName, bandUnit, sourceBand, 30);
    }

    public static Band addTargetBand(Product targetProduct, int targetImageWidth, int targetImageHeight, String bandName, String bandUnit, Band sourceBand, int dataType) {
        if (targetProduct.getBand(bandName) == null) {
            Band targetBand = new Band(bandName, dataType, targetImageWidth, targetImageHeight);
            targetBand.setUnit(bandUnit);
            if (sourceBand != null) {
                targetBand.setDescription(sourceBand.getDescription());
                targetBand.setNoDataValue(sourceBand.getNoDataValue());
            }
            targetBand.setNoDataValueUsed(true);
            targetProduct.addBand(targetBand);
            return targetBand;
        }
        return null;
    }

    private void updateTargetProductMetadata() throws Exception {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"srgr_flag", (int)1);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetImageHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetImageWidth);
        GeoPos geoPosFirstNear = this.targetGeoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
        GeoPos geoPosFirstFar = this.targetGeoCoding.getGeoPos(new PixelPos((float)(this.targetImageWidth - 1), 0.0f), null);
        GeoPos geoPosLastNear = this.targetGeoCoding.getGeoPos(new PixelPos(0.0f, (float)(this.targetImageHeight - 1)), null);
        GeoPos geoPosLastFar = this.targetGeoCoding.getGeoPos(new PixelPos((float)(this.targetImageWidth - 1), (float)(this.targetImageHeight - 1)), null);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_lat", (double)geoPosFirstNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_lat", (double)geoPosFirstFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_lat", (double)geoPosLastNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_lat", (double)geoPosLastFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_long", (double)geoPosFirstNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_long", (double)geoPosFirstFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_long", (double)geoPosLastNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_long", (double)geoPosLastFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)this.targetProduct));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"map_projection", (String)this.targetCRS.getName().getCode());
        if (!this.useAvgSceneHeight) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"is_terrain_corrected", (int)1);
            if (this.externalDEMFile != null) {
                AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.externalDEMFile.getPath());
            } else {
                AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.demName);
            }
        }
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"geo_ref_system", (String)"WGS84");
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"lat_pixel_res", (double)this.delLat);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"lon_pixel_res", (double)this.delLon);
        if (this.pixelSpacingInMeter > 0.0 && Double.compare(this.pixelSpacingInMeter, SARGeocoding.getPixelSpacing((Product)this.sourceProduct)) != 0) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"range_spacing", (double)this.pixelSpacingInMeter);
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"azimuth_spacing", (double)this.pixelSpacingInMeter);
        }
        MetadataElement lookDirectionListElem = new MetadataElement("Look_Direction_List");
        int numOfDirections = 5;
        for (int i = 1; i <= 5; ++i) {
            SARGeocoding.addLookDirection((String)"look_direction", (MetadataElement)lookDirectionListElem, (int)i, (int)5, (int)this.sourceImageWidth, (int)this.sourceImageHeight, (double)this.firstLineUTC, (double)this.lineTimeInterval, (boolean)this.nearRangeOnLeft, (TiePointGrid)this.latitude, (TiePointGrid)this.longitude);
        }
        absTgt.addElement(lookDirectionListElem);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            this.processingStarted = true;
            try {
                if (!this.isElevationModelAvailable) {
                    this.getElevationModel();
                }
            }
            catch (Exception e) {
                throw new OperatorException((Throwable)e);
            }
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0 - 1, y0 - 1, w + 2, h + 2);
            double[][] localDEM = new double[h + 2][w + 2];
            if (this.useAvgSceneHeight) {
                DEMFactory.fillDEM((double[][])localDEM, (float)((float)this.avgSceneHeight));
            } else {
                boolean valid = DEMFactory.getLocalDEM((ElevationModel)this.dem, (float)this.demNoDataValue, (String)this.demResamplingMethod, (TileGeoreferencing)tileGeoRef, (int)x0, (int)y0, (int)w, (int)h, (Product)this.sourceProduct, (boolean)this.nodataValueAtSea, (double[][])localDEM);
                if (!valid && this.nodataValueAtSea) {
                    return;
                }
            }
            GeoPos geoPos = new GeoPos();
            double[] earthPoint = new double[3];
            double[] sensorPos = new double[3];
            int srcMaxRange = this.sourceImageWidth - 1;
            int srcMaxAzimuth = this.sourceImageHeight - 1;
            ProductData demBuffer = null;
            ProductData latBuffer = null;
            ProductData lonBuffer = null;
            ProductData localIncidenceAngleBuffer = null;
            ProductData projectedLocalIncidenceAngleBuffer = null;
            ProductData incidenceAngleFromEllipsoidBuffer = null;
            ArrayList<TileData> trgTileList = new ArrayList<TileData>();
            Set<Band> keySet = targetTiles.keySet();
            for (Band targetBand : keySet) {
                if (targetBand.getName().equals("elevation")) {
                    demBuffer = targetTiles.get(targetBand).getDataBuffer();
                    continue;
                }
                if (targetBand.getName().equals("latitude")) {
                    latBuffer = targetTiles.get(targetBand).getDataBuffer();
                    continue;
                }
                if (targetBand.getName().equals("longitude")) {
                    lonBuffer = targetTiles.get(targetBand).getDataBuffer();
                    continue;
                }
                if (targetBand.getName().equals("localIncidenceAngle")) {
                    localIncidenceAngleBuffer = targetTiles.get(targetBand).getDataBuffer();
                    continue;
                }
                if (targetBand.getName().equals("projectedLocalIncidenceAngle")) {
                    projectedLocalIncidenceAngleBuffer = targetTiles.get(targetBand).getDataBuffer();
                    continue;
                }
                if (targetBand.getName().equals("incidenceAngleFromEllipsoid")) {
                    incidenceAngleFromEllipsoidBuffer = targetTiles.get(targetBand).getDataBuffer();
                    continue;
                }
                Band[] srcBands = this.targetBandNameToSourceBand.get(targetBand.getName());
                TileData td = new TileData(targetTiles.get(targetBand), srcBands, this.isPolsar, targetBand.getName(), this.getBandUnit(targetBand.getName()), this.absRoot, this.calibrator, this.imgResampling);
                td.applyRadiometricNormalization = this.targetBandApplyRadiometricNormalizationFlag.get(targetBand.getName());
                td.applyRetroCalibration = this.targetBandApplyRetroCalibrationFlag.get(targetBand.getName());
                trgTileList.add(td);
            }
            int maxY = y0 + h;
            int maxX = x0 + w;
            TileData[] trgTiles = trgTileList.toArray(new TileData[trgTileList.size()]);
            for (int y = y0; y < maxY; ++y) {
                int yy = y - y0 + 1;
                for (int x = x0; x < maxX; ++x) {
                    int index = trgTiles[0].targetTile.getDataBufferIndex(x, y);
                    double alt = localDEM[yy][x - x0 + 1];
                    if (this.saveDEM) {
                        demBuffer.setElemDoubleAt(index, alt);
                    }
                    if (alt == (double)this.demNoDataValue && !this.useAvgSceneHeight && this.nodataValueAtSea) continue;
                    tileGeoRef.getGeoPos(x, y, geoPos);
                    double lat = geoPos.lat;
                    double lon = geoPos.lon;
                    if (lon >= 180.0) {
                        lon -= 360.0;
                    }
                    if (this.saveLatLon) {
                        latBuffer.setElemDoubleAt(index, lat);
                        lonBuffer.setElemDoubleAt(index, lon);
                    }
                    if (alt == (double)this.demNoDataValue && !this.nodataValueAtSea) {
                        alt = EarthGravitationalModel96.instance().getEGM(lat, lon);
                    }
                    GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)alt, (double[])earthPoint);
                    double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTime((double)this.firstLineUTC, (double)this.lineTimeInterval, (double)this.wavelength, (double[])earthPoint, (double[][])this.orbit.sensorPosition, (double[][])this.orbit.sensorVelocity);
                    if (Double.compare(zeroDopplerTime, -99999.0) == 0) continue;
                    double slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos);
                    double azimuthIndex = 0.0;
                    double rangeIndex = 0.0;
                    double zeroDoppler = zeroDopplerTime;
                    if (!this.skipBistaticCorrection) {
                        zeroDoppler = zeroDopplerTime + slantRange / 2.59020683712E13;
                    }
                    if ((rangeIndex = SARGeocoding.computeRangeIndex((boolean)this.srgrFlag, (int)this.sourceImageWidth, (double)this.firstLineUTC, (double)this.lastLineUTC, (double)this.rangeSpacing, (double)zeroDoppler, (double)(slantRange = SARGeocoding.computeSlantRange((double)zeroDoppler, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos)), (double)this.nearEdgeSlantRange, (AbstractMetadata.SRGRCoefficientList[])this.srgrConvParams)) == -1.0) continue;
                    if (!this.nearRangeOnLeft) {
                        rangeIndex = (double)srcMaxRange - rangeIndex;
                    }
                    if (!SARGeocoding.isValidCell((double)rangeIndex, (double)(azimuthIndex = (zeroDoppler - this.firstLineUTC) / this.lineTimeInterval), (double)lat, (double)lon, (TileGeoreferencing)tileGeoRef, (int)srcMaxRange, (int)srcMaxAzimuth, (double[])sensorPos)) continue;
                    double[] localIncidenceAngles = new double[]{-99999.0, -99999.0};
                    if (this.saveLocalIncidenceAngle || this.saveProjectedLocalIncidenceAngle || this.saveSigmaNought) {
                        LocalGeometry localGeometry = new LocalGeometry(x, y, tileGeoRef, earthPoint, sensorPos);
                        SARGeocoding.computeLocalIncidenceAngle((LocalGeometry)localGeometry, (float)this.demNoDataValue, (boolean)this.saveLocalIncidenceAngle, (boolean)this.saveProjectedLocalIncidenceAngle, (boolean)this.saveSigmaNought, (int)x0, (int)y0, (int)x, (int)y, (double[][])localDEM, (double[])localIncidenceAngles);
                        if (this.saveLocalIncidenceAngle && localIncidenceAngles[0] != -99999.0) {
                            localIncidenceAngleBuffer.setElemDoubleAt(index, localIncidenceAngles[0]);
                        }
                        if (this.saveProjectedLocalIncidenceAngle && localIncidenceAngles[1] != -99999.0) {
                            projectedLocalIncidenceAngleBuffer.setElemDoubleAt(index, localIncidenceAngles[1]);
                        }
                    }
                    if (this.saveIncidenceAngleFromEllipsoid && this.incidenceAngle != null) {
                        incidenceAngleFromEllipsoidBuffer.setElemDoubleAt(index, (double)this.incidenceAngle.getPixelFloat((float)rangeIndex, (float)azimuthIndex));
                    }
                    double satelliteHeight = 0.0;
                    double sceneToEarthCentre = 0.0;
                    if (this.saveSigmaNought) {
                        satelliteHeight = Math.sqrt(sensorPos[0] * sensorPos[0] + sensorPos[1] * sensorPos[1] + sensorPos[2] * sensorPos[2]);
                        sceneToEarthCentre = Math.sqrt(earthPoint[0] * earthPoint[0] + earthPoint[1] * earthPoint[1] + earthPoint[2] * earthPoint[2]);
                    }
                    for (TileData tileData : trgTiles) {
                        int[] subSwathIndex = new int[]{-1};
                        double v = this.getPixelValue(azimuthIndex, rangeIndex, tileData, subSwathIndex);
                        if (v != tileData.noDataValue && tileData.applyRadiometricNormalization) {
                            v = localIncidenceAngles[1] != -99999.0 ? this.calibrator.applyCalibration(v, rangeIndex, azimuthIndex, slantRange, satelliteHeight, sceneToEarthCentre, localIncidenceAngles[1], tileData.bandPolar, tileData.bandUnit, subSwathIndex) : tileData.noDataValue;
                        }
                        tileData.tileDataBuffer.setElemDoubleAt(index, v);
                    }
                    this.orthoDataProduced = true;
                }
            }
            localDEM = null;
        }
        catch (Throwable e) {
            this.orthoDataProduced = true;
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private Unit.UnitType getBandUnit(String bandName) {
        Band[] srcBands = this.targetBandNameToSourceBand.get(bandName);
        return Unit.getUnitType((Band)srcBands[0]);
    }

    private double getPixelValue(double azimuthIndex, double rangeIndex, TileData tileData, int[] subSwathIndex) {
        try {
            Rectangle srcRect;
            int x0 = (int)(rangeIndex + 0.5);
            int y0 = (int)(azimuthIndex + 0.5);
            if (this.imgResampling == Resampling.BILINEAR_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 1), Math.max(0, y0 - 1), 3, 3);
            } else if (this.imgResampling == Resampling.NEAREST_NEIGHBOUR) {
                srcRect = new Rectangle(x0, y0, 1, 1);
            } else if (this.imgResampling == Resampling.CUBIC_CONVOLUTION) {
                srcRect = new Rectangle(Math.max(0, x0 - 2), Math.max(0, y0 - 2), 5, 5);
            } else if (this.imgResampling == Resampling.BISINC_5_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 3), Math.max(0, y0 - 3), 6, 6);
            } else if (this.imgResampling == Resampling.BISINC_11_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 6), Math.max(0, y0 - 6), 12, 12);
            } else if (this.imgResampling == Resampling.BISINC_21_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 11), Math.max(0, y0 - 11), 22, 22);
            } else if (this.imgResampling == Resampling.BICUBIC_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 2), Math.max(0, y0 - 2), 5, 5);
            } else {
                throw new OperatorException("Unhandled interpolation method");
            }
            Band[] srcBands = this.targetBandNameToSourceBand.get(tileData.bandName);
            tileData.imgResamplingRaster.set(rangeIndex, azimuthIndex, this.getSourceTile((RasterDataNode)srcBands[0], srcRect), srcBands.length > 1 ? this.getSourceTile((RasterDataNode)srcBands[1], srcRect) : null);
            this.imgResampling.computeIndex(rangeIndex + 0.5, azimuthIndex + 0.5, this.sourceImageWidth, this.sourceImageHeight, tileData.imgResamplingIndex);
            double v = this.imgResampling.resample((Resampling.Raster)tileData.imgResamplingRaster, tileData.imgResamplingIndex);
            subSwathIndex[0] = tileData.imgResamplingRaster.getSubSwathIndex();
            return v;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            return 0.0;
        }
    }

    void setApplyRadiometricCalibration(boolean flag) {
        this.saveSelectedSourceBand = !flag;
        this.applyRadiometricNormalization = flag;
        this.saveSigmaNought = flag;
    }

    void setSourceBandNames(String[] names) {
        this.sourceBandNames = names;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(RangeDopplerGeocodingOp.class);
        }
    }

    public static class ResamplingRaster
    implements Resampling.Raster {
        private double rangeIndex;
        private double azimuthIndex;
        private final TileData tileData;
        private Tile sourceTileI;
        private ProductData dataBufferI;
        private ProductData dataBufferQ;
        private int subSwathIndex;

        public ResamplingRaster(TileData tileData) {
            this.tileData = tileData;
        }

        public void set(double rangeIndex, double azimuthIndex, Tile sourceTileI, Tile sourceTileQ) {
            this.rangeIndex = rangeIndex;
            this.azimuthIndex = azimuthIndex;
            this.sourceTileI = sourceTileI;
            this.dataBufferI = sourceTileI.getDataBuffer();
            this.dataBufferQ = sourceTileQ != null ? sourceTileQ.getDataBuffer() : null;
        }

        public final int getWidth() {
            return this.sourceTileI.getWidth();
        }

        public final int getHeight() {
            return this.sourceTileI.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) {
            int[][] subSwathIndices = new int[y.length][x.length];
            boolean allPixelsFromSameSubSwath = true;
            boolean allValid = true;
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    int index = this.sourceTileI.getDataBufferIndex(x[j], y[i]);
                    double v = this.dataBufferI.getElemDoubleAt(index);
                    if (this.tileData.noDataValue != 0.0 && v == this.tileData.noDataValue) {
                        samples[i][j] = this.tileData.noDataValue;
                        allValid = false;
                        continue;
                    }
                    samples[i][j] = v;
                    if (this.tileData.computeIntensity) {
                        double vq = this.dataBufferQ.getElemDoubleAt(index);
                        if (this.tileData.noDataValue != 0.0 && vq == this.tileData.noDataValue) {
                            samples[i][j] = this.tileData.noDataValue;
                            allValid = false;
                            continue;
                        }
                        samples[i][j] = v * v + vq * vq;
                    }
                    int[] subSwathIndex = new int[]{-1};
                    if (!this.tileData.applyRetroCalibration) continue;
                    samples[i][j] = this.tileData.calibrator.applyRetroCalibration(x[j], y[i], samples[i][j], this.tileData.bandPolar, this.tileData.bandUnit, subSwathIndex);
                    subSwathIndices[i][j] = subSwathIndex[0];
                    if (subSwathIndex[0] == subSwathIndices[0][0]) continue;
                    allPixelsFromSameSubSwath = false;
                }
            }
            if (allPixelsFromSameSubSwath) {
                this.subSwathIndex = subSwathIndices[0][0];
            } else {
                int xIdx = -1;
                int yIdx = -1;
                for (int i = 0; i < y.length; ++i) {
                    if (!(Math.abs(this.azimuthIndex - (double)y[i]) <= 0.5)) continue;
                    yIdx = i;
                    break;
                }
                for (int j = 0; j < x.length; ++j) {
                    if (!(Math.abs(this.rangeIndex - (double)x[j]) <= 0.5)) continue;
                    xIdx = j;
                    break;
                }
                if (xIdx != -1 && yIdx != -1) {
                    this.subSwathIndex = subSwathIndices[yIdx][xIdx];
                    double sample = samples[yIdx][xIdx];
                    for (int i = 0; i < y.length; ++i) {
                        for (int j = 0; j < x.length; ++j) {
                            samples[i][j] = sample;
                        }
                    }
                } else {
                    throw new OperatorException("Invalid x and y input for getSamples");
                }
            }
            return allValid;
        }

        public int getSubSwathIndex() {
            return this.subSwathIndex;
        }
    }

    public static class TileData {
        final Tile targetTile;
        final ProductData tileDataBuffer;
        final String bandName;
        final String bandPolar;
        final Unit.UnitType bandUnit;
        final double noDataValue;
        final Band[] srcBands;
        final boolean isPolsar;
        private final Calibrator calibrator;
        boolean applyRadiometricNormalization = false;
        boolean applyRetroCalibration = false;
        final boolean computeIntensity;
        final ResamplingRaster imgResamplingRaster;
        final Resampling.Index imgResamplingIndex;

        public TileData(Tile tile, Band[] srcBands, boolean isPolsar, String name, Unit.UnitType unit, MetadataElement absRoot, Calibrator calibrator, Resampling imgResampling) {
            this.targetTile = tile;
            this.tileDataBuffer = tile.getDataBuffer();
            this.bandName = name;
            this.srcBands = srcBands;
            this.isPolsar = isPolsar;
            this.noDataValue = srcBands[0].getNoDataValue();
            this.bandPolar = OperatorUtils.getBandPolarization((String)srcBands[0].getName(), (MetadataElement)absRoot);
            this.bandUnit = unit;
            this.calibrator = calibrator;
            this.computeIntensity = !isPolsar && (this.bandUnit == Unit.UnitType.REAL || this.bandUnit == Unit.UnitType.IMAGINARY);
            this.imgResamplingRaster = new ResamplingRaster(this);
            this.imgResamplingIndex = imgResampling.createIndex();
        }
    }
}

