/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BitmaskDef;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.AutoCloseOptionPane;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModelRegistry;
import org.esa.nest.dataio.dem.FileElevationModel;
import org.esa.nest.datamodel.CalibrationFactory;
import org.esa.nest.datamodel.Calibrator;
import org.esa.nest.gpf.GCPManager;
import org.esa.nest.gpf.WarpOp;
import org.esa.nest.gpf.geometric.CRSGeoCodingHandler;
import org.esa.nest.gpf.geometric.RangeDopplerGeocodingOp;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.nest.gpf.geometric.SARUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.datamodel.Unit;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.eo.LocalGeometry;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ReaderUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.esa.snap.util.ResourceUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="SARSim-Terrain-Correction", category="SAR Processing/Geometric/Terrain Correction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Orthorectification with SAR simulation")
public class SARSimTerrainCorrectionOp
extends Operator {
    public static final String PRODUCT_SUFFIX = "_SimTC";
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The RMS threshold for eliminating invalid GCPs", interval="(0, *)", defaultValue="1.0", label="RMS Threshold")
    private float rmsThreshold = 1.0f;
    @Parameter(description="The order of WARP polynomial function", valueSet={"1", "2", "3"}, defaultValue="1", label="Warp Polynomial Order")
    private int warpPolynomialOrder = 1;
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="BILINEAR_INTERPOLATION", label="Image Resampling Method")
    private String imgResamplingMethod = "BILINEAR_INTERPOLATION";
    @Parameter(description="The pixel spacing in meters", defaultValue="0", label="Pixel Spacing (m)")
    private double pixelSpacingInMeter = 0.0;
    @Parameter(description="The pixel spacing in degrees", defaultValue="0", label="Pixel Spacing (deg)")
    private double pixelSpacingInDegree = 0.0;
    @Parameter(description="The coordinate reference system in well known text format")
    private String mapProjection;
    @Parameter(defaultValue="false", label="Save DEM as band")
    private boolean saveDEM = false;
    @Parameter(defaultValue="false", label="Save latitude and longitude as band")
    private boolean saveLatLon = false;
    @Parameter(defaultValue="false", label="Save local incidence angle as band")
    private boolean saveLocalIncidenceAngle = false;
    @Parameter(defaultValue="false", label="Save projected local incidence angle as band")
    private boolean saveProjectedLocalIncidenceAngle = false;
    @Parameter(defaultValue="true", label="Save selected source band")
    private boolean saveSelectedSourceBand = true;
    @Parameter(defaultValue="false", label="Apply radiometric normalization")
    private boolean applyRadiometricNormalization = false;
    @Parameter(defaultValue="false", label="Save Sigma0 as a band")
    private boolean saveSigmaNought = false;
    @Parameter(defaultValue="false", label="Save Gamma0 as a band")
    private boolean saveGammaNought = false;
    @Parameter(defaultValue="false", label="Save Beta0 as a band")
    private boolean saveBetaNought = false;
    @Parameter(valueSet={"Use incidence angle from Ellipsoid", "Use projected local incidence angle from DEM", "Use local incidence angle from DEM"}, defaultValue="Use projected local incidence angle from DEM", label="")
    private String incidenceAngleForSigma0 = "Use projected local incidence angle from DEM";
    @Parameter(valueSet={"Use incidence angle from Ellipsoid", "Use projected local incidence angle from DEM", "Use local incidence angle from DEM"}, defaultValue="Use projected local incidence angle from DEM", label="")
    private String incidenceAngleForGamma0 = "Use projected local incidence angle from DEM";
    @Parameter(valueSet={"Latest Auxiliary File", "Product Auxiliary File", "External Auxiliary File"}, description="The auxiliary file", defaultValue="Latest Auxiliary File", label="Auxiliary File")
    private String auxFile = "Latest Auxiliary File";
    @Parameter(description="The antenne elevation pattern gain auxiliary data file.", label="External Aux File")
    private File externalAuxFile = null;
    @Parameter(description="Show range and azimuth shifts file in a text viewer", defaultValue="false", label="Show Range and Azimuth Shifts")
    private boolean openShiftsFile = false;
    @Parameter(description="Show the Residuals file in a text viewer", defaultValue="false", label="Show Residuals")
    private boolean openResidualsFile = false;
    private ProductNodeGroup<Placemark> masterGCPGroup = null;
    private MetadataElement absRoot = null;
    private ElevationModel dem = null;
    private String demResamplingMethod;
    private boolean srgrFlag = false;
    private boolean saveLayoverShadowMask = false;
    private boolean saveIncidenceAngleFromEllipsoid = false;
    private boolean isElevationModelAvailable = false;
    private boolean usePreCalibrationOp = false;
    private boolean warpDataAvailable = false;
    private boolean fileOutput = false;
    private String demName = null;
    private Band elevationBand = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int targetImageWidth = 0;
    private int targetImageHeight = 0;
    private double avgSceneHeight = 0.0;
    private double wavelength = 0.0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private double firstLineUTC = 0.0;
    private double lastLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private double nearEdgeSlantRange = 0.0;
    private float demNoDataValue = 0.0f;
    private double delLat = 0.0;
    private double delLon = 0.0;
    private SARGeocoding.Orbit orbit = null;
    private int polyDegree = 2;
    private AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;
    private OrbitStateVector[] orbitStateVectors = null;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap();
    private final Map<String, Boolean> targetBandapplyRadiometricNormalizationFlag = new HashMap<String, Boolean>();
    private final Map<String, Boolean> targetBandApplyRetroCalibrationFlag = new HashMap<String, Boolean>();
    private final Map<Band, WarpOp.WarpData> warpDataMap = new HashMap<Band, WarpOp.WarpData>(10);
    private String processedSlaveBand;
    private TiePointGrid incidenceAngle = null;
    private TiePointGrid latitude = null;
    private TiePointGrid longitude = null;
    private static final double NonValidZeroDopplerTime = -99999.0;
    private static final int INVALID_SUB_SWATH_INDEX = -1;
    private Resampling imgResampling = null;
    private CoordinateReferenceSystem targetCRS;
    private boolean useAvgSceneHeight = false;
    private Calibrator calibrator = null;
    private Band maskBand = null;
    private boolean skipBistaticCorrection = false;
    private boolean orthoDataProduced = false;
    private boolean processingStarted = false;
    private boolean isPolsar = false;
    private String mission = null;
    private boolean nearRangeOnLeft = true;
    private int maxIterations = 20;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected();
            this.maskBand = this.sourceProduct.getBand("layover_shadow_mask");
            this.checkUserInput();
            this.getSourceImageDimension();
            this.getMetadata();
            this.getTiePointGrid();
            if (this.useAvgSceneHeight) {
                this.saveSigmaNought = false;
                this.saveGammaNought = false;
                this.saveBetaNought = false;
                this.saveDEM = false;
                this.saveLocalIncidenceAngle = false;
                this.saveProjectedLocalIncidenceAngle = false;
            }
            this.imgResampling = ResamplingFactory.createResampling((String)this.imgResamplingMethod);
            this.createTargetProduct();
            if (!this.useAvgSceneHeight) {
                this.getElevationModel();
            }
            this.processedSlaveBand = this.absRoot.getAttributeString("processed_slave");
            this.computeSensorPositionsAndVelocities();
            if (this.saveSigmaNought) {
                this.calibrator = CalibrationFactory.createCalibrator((Product)this.sourceProduct);
                this.calibrator.setAuxFileFlag(this.auxFile);
                this.calibrator.setExternalAuxFile(this.externalAuxFile);
                this.calibrator.initialize((Operator)this, this.sourceProduct, this.targetProduct, true, true);
                this.calibrator.setIncidenceAngleForSigma0(this.incidenceAngleForSigma0);
            }
            this.updateTargetProductMetadata();
            DEMFactory.validateDEM((String)this.demName, (Product)this.sourceProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.dem != null) {
            this.dem.dispose();
            this.dem = null;
        }
        if (!this.orthoDataProduced && this.processingStarted) {
            String errMsg = this.getId() + " error: no valid output was produced. Please verify the DEM";
            System.out.println(errMsg);
            if (VisatApp.getApp() != null) {
                VisatApp.getApp().setStatusBarMessage(errMsg);
            }
        }
    }

    private void checkUserInput() {
        if (!this.saveSelectedSourceBand && !this.applyRadiometricNormalization) {
            throw new OperatorException("Please selecte output band for terrain corrected image");
        }
        if (!this.applyRadiometricNormalization) {
            this.saveSigmaNought = false;
            this.saveGammaNought = false;
            this.saveBetaNought = false;
        }
        if (this.saveBetaNought || this.saveGammaNought || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use incidence angle from Ellipsoid")) {
            this.saveSigmaNought = true;
            this.saveProjectedLocalIncidenceAngle = true;
        }
        if (this.saveGammaNought && this.incidenceAngleForGamma0.contains("Use incidence angle from Ellipsoid") || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use incidence angle from Ellipsoid")) {
            this.saveIncidenceAngleFromEllipsoid = true;
        }
        if (this.saveGammaNought && this.incidenceAngleForGamma0.contains("Use local incidence angle from DEM") || this.saveSigmaNought && this.incidenceAngleForSigma0.contains("Use local incidence angle from DEM")) {
            this.saveLocalIncidenceAngle = true;
        }
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
    }

    private void getMetadata() throws Exception {
        this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        this.mission = RangeDopplerGeocodingOp.getMissionType(this.absRoot);
        if (this.mission.contains("CSKS") || this.mission.contains("TSX") || this.mission.equals("RS2") || this.mission.contains("SENTINEL")) {
            this.skipBistaticCorrection = true;
        }
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"srgr_flag");
        this.wavelength = SARUtils.getRadarFrequency((MetadataElement)this.absRoot);
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
        this.firstLineUTC = this.absRoot.getAttributeUTC("first_line_time").getMJD();
        this.lastLineUTC = this.absRoot.getAttributeUTC("last_line_time").getMJD();
        this.lineTimeInterval = this.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)this.absRoot);
        if (this.srgrFlag) {
            this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)this.absRoot);
        } else {
            this.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"slant_range_to_first_pixel");
        }
        this.avgSceneHeight = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"avg_scene_height");
        MetadataAttribute attribute = this.absRoot.getAttribute("retro-calibration performed flag");
        if (attribute != null) {
            this.usePreCalibrationOp = true;
            if (!this.applyRadiometricNormalization) {
                throw new OperatorException("Apply radiometric normalization must be selected.");
            }
        } else if (this.applyRadiometricNormalization && this.mission.equals("ERS")) {
            throw new OperatorException("For radiometric normalization of ERS product, please use one of the following\n user graphs: 'RemoveAntPat_SARSim_GCPSelection' or 'RemoveAntPat_Multilook_SARSim_GCPSelection',\n then apply 'SARSim Terrain Correction' operator to the output in the Graph Builder.");
        }
        this.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft((TiePointGrid)this.incidenceAngle, (int)this.sourceImageWidth);
        this.isPolsar = this.absRoot.getAttributeInt("polsar_data", 0) == 1;
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        this.demName = this.absRoot.getAttributeString("DEM");
        this.demResamplingMethod = this.absRoot.getAttributeString("DEM resampling method");
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(this.demName);
        if (demDescriptor == null) {
            File externalDemFile = new File(this.demName);
            this.dem = new FileElevationModel(externalDemFile, this.demResamplingMethod, Float.valueOf(this.demNoDataValue));
            this.demName = externalDemFile.getName();
            this.demNoDataValue = (float)this.absRoot.getAttributeDouble("external DEM no data value");
        } else {
            this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
            this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
        }
        if (this.elevationBand != null) {
            this.elevationBand.setNoDataValue((double)this.demNoDataValue);
            this.elevationBand.setNoDataValueUsed(true);
        }
        this.isElevationModelAvailable = true;
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void getTiePointGrid() {
        this.latitude = OperatorUtils.getLatitude((Product)this.sourceProduct);
        if (this.latitude == null) {
            throw new OperatorException("Product without latitude tie point grid");
        }
        this.longitude = OperatorUtils.getLongitude((Product)this.sourceProduct);
        if (this.longitude == null) {
            throw new OperatorException("Product without longitude tie point grid");
        }
    }

    private void createTargetProduct() throws Exception {
        block3: {
            if (this.pixelSpacingInMeter <= 0.0) {
                this.pixelSpacingInMeter = Math.max(SARGeocoding.getAzimuthPixelSpacing((Product)this.sourceProduct), SARGeocoding.getRangePixelSpacing((Product)this.sourceProduct));
                this.pixelSpacingInDegree = SARGeocoding.getPixelSpacingInDegree((double)this.pixelSpacingInMeter);
            }
            this.delLat = this.pixelSpacingInDegree;
            this.delLon = this.pixelSpacingInDegree;
            CRSGeoCodingHandler crsHandler = new CRSGeoCodingHandler(this.sourceProduct, this.mapProjection, this.pixelSpacingInDegree, this.pixelSpacingInMeter);
            this.targetCRS = crsHandler.getTargetCRS();
            this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), crsHandler.getTargetWidth(), crsHandler.getTargetHeight());
            this.targetProduct.setGeoCoding((GeoCoding)crsHandler.getCrsGeoCoding());
            this.targetImageWidth = this.targetProduct.getSceneRasterWidth();
            this.targetImageHeight = this.targetProduct.getSceneRasterHeight();
            this.addSelectedBands();
            ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
            this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
            this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
            this.targetProduct.setDescription(this.sourceProduct.getDescription());
            try {
                ProductUtils.copyIndexCodings((Product)this.sourceProduct, (Product)this.targetProduct);
            }
            catch (Exception e) {
                if (this.imgResampling.equals(Resampling.NEAREST_NEIGHBOUR)) break block3;
                throw new OperatorException("Use Nearest Neighbour with Classifications: " + e.getMessage());
            }
        }
        SARSimTerrainCorrectionOp.addLayoverShadowBitmasks(this.targetProduct);
    }

    private void computeSensorPositionsAndVelocities() {
        this.orbit = new SARGeocoding.Orbit(this.orbitStateVectors, this.polyDegree, this.firstLineUTC, this.lineTimeInterval, this.sourceImageHeight);
    }

    private static void addLayoverShadowBitmasks(Product product) {
        Band layoverShadowBand = product.getBand("layover_shadow_mask");
        if (layoverShadowBand != null) {
            String maskName = layoverShadowBand.getName();
            BitmaskDef layover = new BitmaskDef("Layover", "", maskName + " == 1", Color.GREEN, 0.5f);
            BitmaskDef shadow = new BitmaskDef("Shadow", "", maskName + " == 2", Color.BLUE, 0.5f);
            BitmaskDef layoverShadow = new BitmaskDef("Layover_and_Shadow", "", maskName + " == 3", Color.YELLOW, 0.5f);
            product.addBitmaskDef(layover);
            product.addBitmaskDef(shadow);
            product.addBitmaskDef(layoverShadow);
        }
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands = this.sourceProduct.getBands();
        if (sourceBands.length == 1) {
            throw new OperatorException("Source product should include a simulated intensity band. Only " + sourceBands[0].getName() + " found");
        }
        for (int i = 1; i < sourceBands.length; ++i) {
            String targetBandName;
            Band srcBand = sourceBands[i];
            String bandName = srcBand.getName();
            if (bandName.contains("layover_shadow_mask")) {
                this.saveLayoverShadowMask = true;
                continue;
            }
            String[] srcBandNames = new String[]{bandName};
            if (this.saveSigmaNought && RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, targetBandName = bandName.contains("HH") ? "Sigma0_HH" : (bandName.contains("VV") ? "Sigma0_VV" : (bandName.contains("HV") ? "Sigma0_HV" : (bandName.contains("VH") ? "Sigma0_VH" : "Sigma0"))), "intensity", srcBand, 30) != null) {
                this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                this.targetBandapplyRadiometricNormalizationFlag.put(targetBandName, true);
                if (this.usePreCalibrationOp) {
                    this.targetBandApplyRetroCalibrationFlag.put(targetBandName, false);
                } else {
                    this.targetBandApplyRetroCalibrationFlag.put(targetBandName, true);
                }
            }
            if (!this.saveSelectedSourceBand) continue;
            targetBandName = bandName;
            int dataType = 30;
            if (this.imgResampling.equals(Resampling.NEAREST_NEIGHBOUR)) {
                dataType = srcBand.getDataType();
            }
            if (RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, targetBandName, srcBand.getUnit(), srcBand, dataType) == null) continue;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            this.targetBandapplyRadiometricNormalizationFlag.put(targetBandName, false);
            this.targetBandApplyRetroCalibrationFlag.put(targetBandName, false);
        }
        if (this.saveDEM) {
            this.elevationBand = RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, "elevation", "meters", null, 30);
        }
        if (this.saveLatLon) {
            RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, "latitude", "deg", null, 30);
            RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, "longitude", "deg", null, 30);
        }
        if (this.saveLocalIncidenceAngle) {
            RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, "localIncidenceAngle", "deg", null, 30);
        }
        if (this.saveProjectedLocalIncidenceAngle) {
            RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, "projectedLocalIncidenceAngle", "deg", null, 30);
        }
        if (this.saveLayoverShadowMask) {
            Band layoverShadowingMasksBand = new Band("layover_shadow_mask", 10, this.targetImageWidth, this.targetImageHeight);
            layoverShadowingMasksBand.setUnit("amplitude");
            this.targetProduct.addBand(layoverShadowingMasksBand);
        }
        if (this.saveIncidenceAngleFromEllipsoid) {
            RangeDopplerGeocodingOp.addTargetBand(this.targetProduct, this.targetImageWidth, this.targetImageHeight, "incidenceAngleFromEllipsoid", "deg", null, 30);
        }
        if (this.saveSigmaNought && !this.incidenceAngleForSigma0.contains("Use projected local incidence angle from DEM")) {
            CalibrationFactory.createSigmaNoughtVirtualBand((Product)this.targetProduct, (String)this.incidenceAngleForSigma0);
        }
        if (this.saveGammaNought) {
            CalibrationFactory.createGammaNoughtVirtualBand((Product)this.targetProduct, (String)this.incidenceAngleForGamma0);
        }
        if (this.saveBetaNought) {
            CalibrationFactory.createBetaNoughtVirtualBand((Product)this.targetProduct);
        }
    }

    private void updateTargetProductMetadata() throws OperatorException {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"srgr_flag", (int)1);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetImageHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetImageWidth);
        GeoCoding targetGeoCoding = this.targetProduct.getGeoCoding();
        GeoPos geoPosFirstNear = targetGeoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
        GeoPos geoPosFirstFar = targetGeoCoding.getGeoPos(new PixelPos((float)(this.targetImageWidth - 1), 0.0f), null);
        GeoPos geoPosLastNear = targetGeoCoding.getGeoPos(new PixelPos(0.0f, (float)(this.targetImageHeight - 1)), null);
        GeoPos geoPosLastFar = targetGeoCoding.getGeoPos(new PixelPos((float)(this.targetImageWidth - 1), (float)(this.targetImageHeight - 1)), null);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_lat", (double)geoPosFirstNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_lat", (double)geoPosFirstFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_lat", (double)geoPosLastNear.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_lat", (double)geoPosLastFar.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_long", (double)geoPosFirstNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_long", (double)geoPosFirstFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_long", (double)geoPosLastNear.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_long", (double)geoPosLastFar.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"total_size", (int)ReaderUtils.getTotalSize((Product)this.targetProduct));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"map_projection", (String)this.targetCRS.getName().getCode());
        if (!this.useAvgSceneHeight) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"is_terrain_corrected", (int)1);
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.demName);
        }
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"geo_ref_system", (String)"WGS84");
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"lat_pixel_res", (double)this.delLat);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"lon_pixel_res", (double)this.delLon);
        if (this.pixelSpacingInMeter > 0.0) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"range_spacing", (double)this.pixelSpacingInMeter);
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"azimuth_spacing", (double)this.pixelSpacingInMeter);
        }
        MetadataElement lookDirectionListElem = new MetadataElement("Look_Direction_List");
        int numOfDirections = 5;
        for (int i = 1; i <= 5; ++i) {
            SARGeocoding.addLookDirection((String)"look_direction", (MetadataElement)lookDirectionListElem, (int)i, (int)5, (int)this.sourceImageWidth, (int)this.sourceImageHeight, (double)this.firstLineUTC, (double)this.lineTimeInterval, (boolean)this.nearRangeOnLeft, (TiePointGrid)this.latitude, (TiePointGrid)this.longitude);
        }
        absTgt.addElement(lookDirectionListElem);
    }

    private synchronized void getWarpData(Set<Band> keySet, Rectangle targetRectangle) {
        if (this.warpDataAvailable) {
            return;
        }
        for (Band targetBand : keySet) {
            String[] srcBandNames;
            Band srcBand;
            if (!targetBand.getName().equals(this.processedSlaveBand) && !targetBand.getName().contains("Sigma0") || (srcBand = this.sourceProduct.getBand((srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName()))[0])) == null) continue;
            Tile sourceRaster = this.getSourceTile((RasterDataNode)srcBand, targetRectangle);
            break;
        }
        Band masterBand = this.sourceProduct.getBandAt(0);
        this.masterGCPGroup = GCPManager.instance().getGcpGroup(masterBand);
        int numSrcBands = this.sourceProduct.getNumBands();
        boolean appendFlag = false;
        for (int i = 1; i < numSrcBands; ++i) {
            Band srcBand = this.sourceProduct.getBandAt(i);
            String unit = srcBand.getUnit();
            if (unit != null && unit.contains("bit")) continue;
            ProductNodeGroup slaveGCPGroup = GCPManager.instance().getGcpGroup(srcBand);
            if (slaveGCPGroup.getNodeCount() < 3) {
                for (Band band : this.sourceProduct.getBands()) {
                    if (band != srcBand && band != masterBand && (slaveGCPGroup = GCPManager.instance().getGcpGroup(band)).getNodeCount() >= 3) break;
                }
            }
            WarpOp.WarpData warpData = new WarpOp.WarpData(slaveGCPGroup);
            this.warpDataMap.put(srcBand, warpData);
            WarpOp.computeWARPPolynomialFromGCPs((Product)this.sourceProduct, (Band)srcBand, (int)this.warpPolynomialOrder, this.masterGCPGroup, (int)this.maxIterations, (float)this.rmsThreshold, (boolean)appendFlag, (WarpOp.WarpData)warpData);
            if (appendFlag) continue;
            appendFlag = true;
        }
        this.announceGCPWarning();
        this.warpDataAvailable = true;
    }

    private void announceGCPWarning() {
        String msg = "";
        for (Band srcBand : this.sourceProduct.getBands()) {
            WarpOp.WarpData warpData = this.warpDataMap.get(srcBand);
            if (warpData == null || !warpData.notEnoughGCPs) continue;
            msg = msg + srcBand.getName() + " does not have enough valid GCPs for the warp\n";
            this.openResidualsFile = true;
        }
        if (!msg.isEmpty()) {
            System.out.println(msg);
            if (VisatApp.getApp() != null) {
                AutoCloseOptionPane.showWarningDialog((String)"Some bands did not coregister", (String)msg);
            }
        }
    }

    private synchronized void outputResidualAndShiftFiles() {
        if (this.fileOutput) {
            return;
        }
        if (this.openShiftsFile) {
            File shiftsFile = SARSimTerrainCorrectionOp.getFile(this.sourceProduct, "_shift.txt");
            if (Desktop.isDesktopSupported() && shiftsFile.exists()) {
                try {
                    Desktop.getDesktop().open(shiftsFile);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        if (this.openResidualsFile) {
            File residualsFile = SARSimTerrainCorrectionOp.getFile(this.sourceProduct, "_residual.txt");
            if (Desktop.isDesktopSupported() && residualsFile.exists()) {
                try {
                    Desktop.getDesktop().open(residualsFile);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        this.fileOutput = true;
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        this.processingStarted = true;
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int ymax = y0 + h;
        int xmax = x0 + w;
        GeoPos geoPos = new GeoPos();
        double[] earthPoint = new double[3];
        double[] sensorPos = new double[3];
        int srcMaxRange = this.sourceImageWidth - 1;
        int srcMaxAzimuth = this.sourceImageHeight - 1;
        ProductData demBuffer = null;
        ProductData latBuffer = null;
        ProductData lonBuffer = null;
        ProductData localIncidenceAngleBuffer = null;
        ProductData projectedLocalIncidenceAngleBuffer = null;
        ProductData layoverShadowingMasksBuffer = null;
        ProductData incidenceAngleFromEllipsoidBuffer = null;
        Set<Band> keySet = targetTiles.keySet();
        if (!this.warpDataAvailable) {
            this.getWarpData(keySet, targetRectangle);
            this.outputResidualAndShiftFiles();
        }
        ArrayList<RangeDopplerGeocodingOp.TileData> trgTileList = new ArrayList<RangeDopplerGeocodingOp.TileData>();
        for (Band targetBand : keySet) {
            if (targetBand.getName().equals("elevation")) {
                demBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            if (targetBand.getName().equals("latitude")) {
                latBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            if (targetBand.getName().equals("longitude")) {
                lonBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            if (targetBand.getName().equals("localIncidenceAngle")) {
                localIncidenceAngleBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            if (targetBand.getName().equals("projectedLocalIncidenceAngle")) {
                projectedLocalIncidenceAngleBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            if (targetBand.getName().equals("layover_shadow_mask")) {
                layoverShadowingMasksBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            if (targetBand.getName().equals("incidenceAngleFromEllipsoid")) {
                incidenceAngleFromEllipsoidBuffer = targetTiles.get(targetBand).getDataBuffer();
                continue;
            }
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
            Band[] srcBands = new Band[]{this.sourceProduct.getBand(srcBandNames[0]), srcBandNames.length > 1 ? this.sourceProduct.getBand(srcBandNames[1]) : null};
            RangeDopplerGeocodingOp.TileData td = new RangeDopplerGeocodingOp.TileData(targetTiles.get(targetBand), srcBands, this.isPolsar, targetBand.getName(), this.getBandUnit(targetBand.getName()), this.absRoot, this.calibrator, this.imgResampling);
            td.applyRadiometricNormalization = this.targetBandapplyRadiometricNormalizationFlag.get(targetBand.getName());
            td.applyRetroCalibration = this.targetBandApplyRetroCalibrationFlag.get(targetBand.getName());
            trgTileList.add(td);
        }
        RangeDopplerGeocodingOp.TileData[] trgTiles = trgTileList.toArray(new RangeDopplerGeocodingOp.TileData[trgTileList.size()]);
        TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0 - 1, y0 - 1, w + 2, h + 2);
        try {
            double[][] localDEM = new double[h + 2][w + 2];
            if (this.useAvgSceneHeight) {
                DEMFactory.fillDEM((double[][])localDEM, (float)((float)this.avgSceneHeight));
            } else {
                boolean valid = DEMFactory.getLocalDEM((ElevationModel)this.dem, (float)this.demNoDataValue, (String)this.demResamplingMethod, (TileGeoreferencing)tileGeoRef, (int)x0, (int)y0, (int)w, (int)h, (Product)this.sourceProduct, (boolean)true, (double[][])localDEM);
                if (!valid) {
                    return;
                }
            }
            for (int y = y0; y < ymax; ++y) {
                int yy = y - y0 + 1;
                for (int x = x0; x < xmax; ++x) {
                    int index = trgTiles[0].targetTile.getDataBufferIndex(x, y);
                    double alt = localDEM[yy][x - x0 + 1];
                    if (this.saveDEM) {
                        demBuffer.setElemDoubleAt(index, alt);
                    }
                    if (!this.useAvgSceneHeight && alt == (double)this.demNoDataValue) continue;
                    tileGeoRef.getGeoPos(x, y, geoPos);
                    if (!geoPos.isValid()) continue;
                    double lat = geoPos.lat;
                    double lon = geoPos.lon;
                    if (lon >= 180.0) {
                        lon -= 360.0;
                    }
                    if (this.saveLatLon) {
                        latBuffer.setElemDoubleAt(index, lat);
                        lonBuffer.setElemDoubleAt(index, lon);
                    }
                    GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)alt, (double[])earthPoint);
                    double zeroDopplerTime = this.getEarthPointZeroDopplerTime(earthPoint);
                    if (Double.compare(zeroDopplerTime, -99999.0) == 0) continue;
                    double slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos);
                    double zeroDoppler = zeroDopplerTime;
                    if (!this.skipBistaticCorrection) {
                        zeroDoppler = zeroDopplerTime + slantRange / 2.59020683712E13;
                        slantRange = SARGeocoding.computeSlantRange((double)zeroDoppler, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos);
                    }
                    double azimuthIndex = (zeroDoppler - this.firstLineUTC) / this.lineTimeInterval;
                    double rangeIndex = SARGeocoding.computeRangeIndex((boolean)this.srgrFlag, (int)this.sourceImageWidth, (double)this.firstLineUTC, (double)this.lastLineUTC, (double)this.rangeSpacing, (double)zeroDoppler, (double)slantRange, (double)this.nearEdgeSlantRange, (AbstractMetadata.SRGRCoefficientList[])this.srgrConvParams);
                    if (!this.nearRangeOnLeft) {
                        rangeIndex = (double)srcMaxRange - rangeIndex;
                    }
                    if (!SARGeocoding.isValidCell((double)rangeIndex, (double)azimuthIndex, (double)lat, (double)lon, (TileGeoreferencing)tileGeoRef, (int)srcMaxRange, (int)srcMaxAzimuth, (double[])sensorPos)) continue;
                    double[] localIncidenceAngles = new double[]{-99999.0, -99999.0};
                    if (this.saveLocalIncidenceAngle || this.saveProjectedLocalIncidenceAngle || this.saveSigmaNought) {
                        LocalGeometry localGeometry = new LocalGeometry(x, y, tileGeoRef, earthPoint, sensorPos);
                        SARGeocoding.computeLocalIncidenceAngle((LocalGeometry)localGeometry, (float)this.demNoDataValue, (boolean)this.saveLocalIncidenceAngle, (boolean)this.saveProjectedLocalIncidenceAngle, (boolean)this.saveSigmaNought, (int)x0, (int)y0, (int)x, (int)y, (double[][])localDEM, (double[])localIncidenceAngles);
                        if (this.saveLocalIncidenceAngle && localIncidenceAngles[0] != -99999.0) {
                            localIncidenceAngleBuffer.setElemDoubleAt(index, localIncidenceAngles[0]);
                        }
                        if (this.saveProjectedLocalIncidenceAngle && localIncidenceAngles[1] != -99999.0) {
                            projectedLocalIncidenceAngleBuffer.setElemDoubleAt(index, localIncidenceAngles[1]);
                        }
                    }
                    if (this.saveLayoverShadowMask) {
                        Rectangle srcRect = new Rectangle((int)(rangeIndex + 0.5), (int)(azimuthIndex + 0.5), 1, 1);
                        Tile sourceTile = this.getSourceTile((RasterDataNode)this.maskBand, srcRect);
                        int m = sourceTile.getDataBuffer().getElemIntAt(sourceTile.getDataBufferIndex((int)(rangeIndex + 0.5), (int)(azimuthIndex + 0.5)));
                        layoverShadowingMasksBuffer.setElemIntAt(index, m);
                    }
                    if (this.saveIncidenceAngleFromEllipsoid) {
                        incidenceAngleFromEllipsoidBuffer.setElemDoubleAt(index, (double)this.incidenceAngle.getPixelFloat((float)rangeIndex, (float)azimuthIndex));
                    }
                    for (RangeDopplerGeocodingOp.TileData tileData : trgTiles) {
                        Unit.UnitType bandUnit = this.getBandUnit(tileData.bandName);
                        String[] srcBandName = this.targetBandNameToSourceBandName.get(tileData.bandName);
                        Band srcBand = this.sourceProduct.getBand(srcBandName[0]);
                        PixelPos pixelPos = new PixelPos();
                        WarpOp.WarpData warpData = this.warpDataMap.get(srcBand);
                        if (warpData.notEnoughGCPs) continue;
                        WarpOp.getWarpedCoords((WarpOp.WarpData)warpData, (int)this.warpPolynomialOrder, (double)rangeIndex, (double)azimuthIndex, (PixelPos)pixelPos);
                        if ((double)pixelPos.x < 0.0 || pixelPos.x >= (float)srcMaxRange || (double)pixelPos.y < 0.0 || pixelPos.y >= (float)srcMaxAzimuth) {
                            tileData.tileDataBuffer.setElemDoubleAt(index, tileData.noDataValue);
                            continue;
                        }
                        int[] subSwathIndex = new int[]{-1};
                        double v = this.getPixelValue(pixelPos.y, pixelPos.x, tileData, subSwathIndex);
                        if (v != tileData.noDataValue && tileData.applyRadiometricNormalization) {
                            if (localIncidenceAngles[1] != -99999.0) {
                                double satelliteHeight = Math.sqrt(sensorPos[0] * sensorPos[0] + sensorPos[1] * sensorPos[1] + sensorPos[2] * sensorPos[2]);
                                double sceneToEarthCentre = Math.sqrt(earthPoint[0] * earthPoint[0] + earthPoint[1] * earthPoint[1] + earthPoint[2] * earthPoint[2]);
                                v = this.calibrator.applyCalibration(v, rangeIndex, azimuthIndex, slantRange, satelliteHeight, sceneToEarthCentre, localIncidenceAngles[1], tileData.bandPolar, bandUnit, subSwathIndex);
                            } else {
                                v = tileData.noDataValue;
                            }
                        }
                        tileData.tileDataBuffer.setElemDoubleAt(index, v);
                    }
                    this.orthoDataProduced = true;
                }
            }
        }
        catch (Throwable e) {
            this.orthoDataProduced = true;
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void saveNoDataValueToTarget(int index, RangeDopplerGeocodingOp.TileData[] trgTiles) {
        for (RangeDopplerGeocodingOp.TileData tileData : trgTiles) {
            tileData.tileDataBuffer.setElemDoubleAt(index, tileData.noDataValue);
        }
    }

    private double getEarthPointZeroDopplerTime(double[] earthPoint) throws OperatorException {
        int lowerBound = 0;
        int upperBound = this.orbit.sensorPosition.length - 1;
        double lowerBoundFreq = this.getDopplerFrequency(lowerBound, earthPoint);
        double upperBoundFreq = this.getDopplerFrequency(upperBound, earthPoint);
        if (Double.compare(lowerBoundFreq, 0.0) == 0) {
            return this.firstLineUTC + (double)lowerBound * this.lineTimeInterval;
        }
        if (Double.compare(upperBoundFreq, 0.0) == 0) {
            return this.firstLineUTC + (double)upperBound * this.lineTimeInterval;
        }
        if (lowerBoundFreq * upperBoundFreq > 0.0) {
            return -99999.0;
        }
        while (upperBound - lowerBound > 1) {
            int mid = (int)((double)(lowerBound + upperBound) / 2.0);
            double midFreq = this.getDopplerFrequency(mid, earthPoint);
            if (Double.compare(midFreq, 0.0) == 0) {
                return this.firstLineUTC + (double)mid * this.lineTimeInterval;
            }
            if (midFreq * lowerBoundFreq > 0.0) {
                lowerBound = mid;
                lowerBoundFreq = midFreq;
                continue;
            }
            if (!(midFreq * upperBoundFreq > 0.0)) continue;
            upperBound = mid;
            upperBoundFreq = midFreq;
        }
        double y0 = (double)lowerBound - lowerBoundFreq * (double)(upperBound - lowerBound) / (upperBoundFreq - lowerBoundFreq);
        return this.firstLineUTC + y0 * this.lineTimeInterval;
    }

    private double getDopplerFrequency(int y, double[] earthPoint) {
        if (y < 0 || y > this.sourceImageHeight - 1) {
            throw new OperatorException("Invalid range line index: " + y);
        }
        double xVel = this.orbit.sensorVelocity[y][0];
        double yVel = this.orbit.sensorVelocity[y][1];
        double zVel = this.orbit.sensorVelocity[y][2];
        double xDiff = earthPoint[0] - this.orbit.sensorPosition[y][0];
        double yDiff = earthPoint[1] - this.orbit.sensorPosition[y][1];
        double zDiff = earthPoint[2] - this.orbit.sensorPosition[y][2];
        double distance = Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
        return 2.0 * (xVel * xDiff + yVel * yDiff + zVel * zDiff) / (distance * this.wavelength);
    }

    private Unit.UnitType getBandUnit(String bandName) {
        String[] srcBandNames = this.targetBandNameToSourceBandName.get(bandName);
        return Unit.getUnitType((Band)this.sourceProduct.getBand(srcBandNames[0]));
    }

    private double getPixelValue(double azimuthIndex, double rangeIndex, RangeDopplerGeocodingOp.TileData tileData, int[] subSwathIndex) {
        try {
            int x0 = (int)(rangeIndex + 0.5);
            int y0 = (int)(azimuthIndex + 0.5);
            Rectangle srcRect = null;
            Tile sourceTileQ = null;
            if (this.imgResampling == Resampling.NEAREST_NEIGHBOUR) {
                srcRect = new Rectangle(x0, y0, 1, 1);
            } else if (this.imgResampling == Resampling.BILINEAR_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 1), Math.max(0, y0 - 1), 3, 3);
            } else if (this.imgResampling == Resampling.CUBIC_CONVOLUTION) {
                srcRect = new Rectangle(Math.max(0, x0 - 2), Math.max(0, y0 - 2), 5, 5);
            } else if (this.imgResampling == Resampling.BISINC_5_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 3), Math.max(0, y0 - 3), 6, 6);
            } else if (this.imgResampling == Resampling.BISINC_11_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 6), Math.max(0, y0 - 6), 12, 12);
            } else if (this.imgResampling == Resampling.BISINC_21_POINT_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 11), Math.max(0, y0 - 11), 22, 22);
            } else if (this.imgResampling == Resampling.BICUBIC_INTERPOLATION) {
                srcRect = new Rectangle(Math.max(0, x0 - 2), Math.max(0, y0 - 2), 5, 5);
            } else {
                throw new OperatorException("Unhandled interpolation method");
            }
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(tileData.bandName);
            Tile sourceTileI = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(srcBandNames[0]), srcRect);
            if (srcBandNames.length > 1) {
                sourceTileQ = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(srcBandNames[1]), srcRect);
            }
            tileData.imgResamplingRaster.set(rangeIndex, azimuthIndex, sourceTileI, sourceTileQ);
            this.imgResampling.computeIndex(rangeIndex + 0.5, azimuthIndex + 0.5, this.sourceImageWidth, this.sourceImageHeight, tileData.imgResamplingIndex);
            double v = this.imgResampling.resample((Resampling.Raster)tileData.imgResamplingRaster, tileData.imgResamplingIndex);
            subSwathIndex[0] = tileData.imgResamplingRaster.getSubSwathIndex();
            return v;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            return 0.0;
        }
    }

    private void outputGCPShifts(WarpOp.WarpData warpData, String bandName, boolean appendFlag) throws OperatorException {
        File shiftsFile = SARSimTerrainCorrectionOp.getFile(this.sourceProduct, "_shift.txt");
        try (PrintStream p = null;){
            FileOutputStream out = new FileOutputStream(shiftsFile.getAbsolutePath(), appendFlag);
            p = new PrintStream(out);
            p.println();
            p.println("Band: " + bandName);
            p.println();
            p.print("Range and Azimuth Shifts for Valid GCPs:");
            p.println();
            p.println();
            p.println("No. | Range Shift (m) | Azimuth Shift (m) |");
            p.println("-------------------------------------------");
            double meanRangeShift = 0.0;
            double meanAzimuthShift = 0.0;
            for (int i = 0; i < warpData.numValidGCPs; ++i) {
                Placemark sPin = (Placemark)warpData.slaveGCPList.get(i);
                PixelPos sGCPPos = sPin.getPixelPos();
                Placemark mPin = (Placemark)this.masterGCPGroup.get(sPin.getName());
                PixelPos mGCPPos = mPin.getPixelPos();
                double rangeShift = (double)Math.abs(sGCPPos.x - mGCPPos.x) * this.rangeSpacing;
                double azimuthShift = (double)Math.abs(sGCPPos.y - mGCPPos.y) * this.azimuthSpacing;
                meanRangeShift += rangeShift;
                meanAzimuthShift += azimuthShift;
                p.format("%2d  |%16.3f |%18.3f |", i, rangeShift, azimuthShift);
                p.println();
            }
            if (warpData.numValidGCPs > 0) {
                meanRangeShift /= (double)warpData.numValidGCPs;
                meanAzimuthShift /= (double)warpData.numValidGCPs;
            } else {
                p.println("No valid GCP is available.");
            }
            p.println();
            p.format("Mean Range Shift = %8.3f", meanRangeShift);
            p.println();
            p.format("Mean Azimuth Shift = %8.3f", meanAzimuthShift);
            p.println();
        }
    }

    private static File getFile(Product sourceProduct, String name) {
        String fileName = sourceProduct.getName() + name;
        File appUserDir = new File(ResourceUtils.getApplicationUserDir((boolean)true).getAbsolutePath() + File.separator + "log");
        if (!appUserDir.exists()) {
            appUserDir.mkdirs();
        }
        return new File(appUserDir.toString(), fileName);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SARSimTerrainCorrectionOp.class);
        }
    }
}

