/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.FileElevationModel;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.nest.gpf.geometric.SARUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.eo.LocalGeometry;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.jlinda.core.Ellipsoid;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;

@OperatorMetadata(alias="SAR-Simulation", category="SAR Processing/Geometric/Terrain Correction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Rigorous SAR Simulation")
public final class SARSimulationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"ACE", "GETASSE30", "SRTM 3Sec", "ASTER 1sec GDEM"}, description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BICUBIC_INTERPOLATION", "BISINC_5_POINT_INTERPOLATION"}, defaultValue="BICUBIC_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BICUBIC_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    boolean isSARSimTC = true;
    boolean reGridMethod = false;
    boolean orbitMethod = false;
    private boolean saveDEM = false;
    private boolean saveZeroHeightSimulation = false;
    private boolean saveLocalIncidenceAngle = false;
    @Parameter(defaultValue="false", label="Save Layover-Shadow Mask")
    private boolean saveLayoverShadowMask = false;
    public static final String demBandName = "elevation";
    public static final String zeroHeightSimulationBandName = "ZeroHeightSimulation";
    public static final String simulatedLocalIncidenceAngleBandName = "Simulated_LocalIncidenceAngle";
    public static final String layoverShadowMaskBandName = "layover_shadow_mask";
    private MetadataElement absRoot = null;
    private ElevationModel dem = null;
    private GeoCoding targetGeoCoding = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean srgrFlag = false;
    private boolean isElevationModelAvailable = false;
    private double rangeSpacing = 0.0;
    private double firstLineUTC = 0.0;
    private double lastLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private double nearEdgeSlantRange = 0.0;
    private double wavelength = 0.0;
    private float demNoDataValue = 0.0f;
    private SARGeocoding.Orbit orbit = null;
    private int polyDegree = 2;
    private int tileSize = 400;
    private OrbitStateVector[] orbitStateVectors = null;
    private AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;
    private static String SIMULATED_BAND_NAME = "Simulated_Intensity";
    private boolean nearRangeOnLeft = true;
    private boolean isPolsar = false;
    private double delLat = 0.0;
    private double delLon = 0.0;
    private SLCImage meta = null;
    private Orbit jOrbit = null;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfTOPSARBurstProduct(false);
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getSourceImageDimension();
            this.getMetadata();
            this.computeSensorPositionsAndVelocities();
            this.createTargetProduct();
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.sourceProduct);
            this.computeDEMTraversalSampleInterval();
            if (this.orbitMethod) {
                this.meta = new SLCImage(this.absRoot);
                this.jOrbit = new Orbit(this.absRoot, 3);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.dem != null) {
            this.dem.dispose();
            this.dem = null;
        }
    }

    private void getMetadata() throws Exception {
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"srgr_flag");
        this.wavelength = SARUtils.getRadarFrequency((MetadataElement)this.absRoot);
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.firstLineUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("first_line_time")).getMJD();
        this.lastLineUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("last_line_time")).getMJD();
        this.lineTimeInterval = this.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)this.absRoot);
        if (this.srgrFlag) {
            this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)this.absRoot);
        } else {
            this.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"slant_range_to_first_pixel");
        }
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        this.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft((TiePointGrid)incidenceAngle, (int)this.sourceImageWidth);
        this.isPolsar = this.absRoot.getAttributeInt("polsar_data", 0) == 1;
    }

    private void computeSensorPositionsAndVelocities() {
        this.orbit = new SARGeocoding.Orbit(this.orbitStateVectors, this.polyDegree, this.firstLineUTC, this.lineTimeInterval, this.sourceImageHeight);
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        try {
            if (this.externalDEMFile != null) {
                this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Float.valueOf((float)this.externalDEMNoDataValue));
                this.demNoDataValue = (float)this.externalDEMNoDataValue;
                this.demName = this.externalDEMFile.getPath();
            } else {
                this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
                this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.isElevationModelAvailable = true;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.externalDEMFile != null) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.externalDEMFile.getPath());
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.demName);
        }
        absTgt.setAttributeString("DEM resampling method", this.demResamplingMethod);
        if (this.externalDEMFile != null) {
            absTgt.setAttributeDouble("external DEM no data value", this.externalDEMNoDataValue);
        }
        this.targetGeoCoding = this.targetProduct.getGeoCoding();
        this.targetProduct.setPreferredTileSize(this.targetProduct.getSceneRasterWidth(), this.tileSize);
    }

    private void addSelectedBands() {
        Band targetBand = new Band(SIMULATED_BAND_NAME, 30, this.sourceImageWidth, this.sourceImageHeight);
        targetBand.setUnit("intensity");
        this.targetProduct.addBand(targetBand);
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                String unit = band.getUnit();
                if (unit != null && !unit.contains("intensity")) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        Band[] sourceBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String sourceBandName = this.sourceBandNames[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            sourceBands[i] = sourceBand;
        }
        for (Band srcBand : sourceBands) {
            targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(srcBand.getSourceImage());
        }
        if (this.saveDEM) {
            targetBand = new Band(demBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
            targetBand.setUnit("meters");
            this.targetProduct.addBand(targetBand);
        }
        if (this.saveZeroHeightSimulation) {
            targetBand = new Band(zeroHeightSimulationBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
            targetBand.setUnit("intensity");
            this.targetProduct.addBand(targetBand);
        }
        if (this.saveLocalIncidenceAngle) {
            targetBand = new Band(simulatedLocalIncidenceAngleBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
            targetBand.setUnit("deg");
            this.targetProduct.addBand(targetBand);
        }
        if (this.saveLayoverShadowMask) {
            targetBand = new Band(layoverShadowMaskBandName, 10, this.sourceImageWidth, this.sourceImageHeight);
            targetBand.setUnit("bit");
            this.targetProduct.addBand(targetBand);
        }
    }

    private void computeTileOverlapPercentage(int x0, int y0, int w, int h, double[] overlapPercentages) throws Exception {
        PixelPos pixPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        double[] earthPoint = new double[3];
        double[] sensorPos = new double[3];
        double tileOverlapPercentageMax = -1.7976931348623157E308;
        double tileOverlapPercentageMin = Double.MAX_VALUE;
        for (int y = y0; y < y0 + h; y += 20) {
            for (int x = x0; x < x0 + w; x += 20) {
                pixPos.setLocation((float)x, (float)y);
                this.targetGeoCoding.getGeoPos(pixPos, geoPos);
                double alt = this.dem.getElevation(geoPos);
                GeoUtils.geo2xyzWGS84((double)geoPos.getLat(), (double)geoPos.getLon(), (double)alt, (double[])earthPoint);
                double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTime((double)this.firstLineUTC, (double)this.lineTimeInterval, (double)this.wavelength, (double[])earthPoint, (double[][])this.orbit.sensorPosition, (double[][])this.orbit.sensorVelocity);
                if (zeroDopplerTime == -99999.0) continue;
                double slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos);
                double zeroDopplerTimeWithoutBias = zeroDopplerTime + slantRange / 2.59020683712E13;
                int azimuthIndex = (int)((zeroDopplerTimeWithoutBias - this.firstLineUTC) / this.lineTimeInterval + 0.5);
                double tileOverlapPercentage = (float)(azimuthIndex - y) / (float)this.tileSize;
                if (tileOverlapPercentage > tileOverlapPercentageMax) {
                    tileOverlapPercentageMax = tileOverlapPercentage;
                }
                if (!(tileOverlapPercentage < tileOverlapPercentageMin)) continue;
                tileOverlapPercentageMin = tileOverlapPercentage;
            }
        }
        overlapPercentages[0] = tileOverlapPercentageMin != Double.MAX_VALUE && tileOverlapPercentageMin < 0.0 ? tileOverlapPercentageMin - 1.0 : 0.0;
        overlapPercentages[1] = tileOverlapPercentageMax != -1.7976931348623157E308 && tileOverlapPercentageMax > 0.0 ? tileOverlapPercentageMax + 1.0 : 0.0;
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        double[] tileOverlapPercentage = new double[]{0.0, 0.0};
        try {
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            this.computeTileOverlapPercentage(x0, y0, w, h, tileOverlapPercentage);
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
        Tile targetTile = targetTiles.get(this.targetProduct.getBand(SIMULATED_BAND_NAME));
        ProductData masterBuffer = targetTile.getDataBuffer();
        ProductData demBandBuffer = null;
        ProductData zeroHeightBandBuffer = null;
        ProductData localIncidenceAngleBandBuffer = null;
        ProductData layoverShadowMaskBuffer = null;
        if (this.saveDEM) {
            demBandBuffer = targetTiles.get(this.targetProduct.getBand(demBandName)).getDataBuffer();
        }
        if (this.saveZeroHeightSimulation) {
            zeroHeightBandBuffer = targetTiles.get(this.targetProduct.getBand(zeroHeightSimulationBandName)).getDataBuffer();
        }
        if (this.saveLocalIncidenceAngle) {
            localIncidenceAngleBandBuffer = targetTiles.get(this.targetProduct.getBand(simulatedLocalIncidenceAngleBandName)).getDataBuffer();
        }
        if (this.saveLayoverShadowMask) {
            layoverShadowMaskBuffer = targetTiles.get(this.targetProduct.getBand(layoverShadowMaskBandName)).getDataBuffer();
        }
        int ymin = Math.max(y0 - (int)((double)this.tileSize * tileOverlapPercentage[1]), 0);
        int ymax = y0 + h + (int)((double)this.tileSize * Math.abs(tileOverlapPercentage[0]));
        int xmax = x0 + w;
        PositionData posData = new PositionData();
        GeoPos geoPos = new GeoPos();
        double[] slrs = null;
        double[] elev = null;
        int[] index = null;
        boolean[] savePixel = new boolean[w];
        if (this.saveLayoverShadowMask) {
            slrs = new double[w];
            elev = new double[w];
            index = new int[w];
        }
        try {
            if (this.reGridMethod) {
                double[] latLonMinMax = new double[4];
                this.computeImageGeoBoundary(x0, xmax, ymin, ymax, latLonMinMax);
                double latMin = latLonMinMax[0];
                double latMax = latLonMinMax[1];
                double lonMin = latLonMinMax[2];
                double lonMax = latLonMinMax[3];
                int nLat = (int)((latMax - latMin) / this.delLat) + 1;
                int nLon = (int)((lonMax - lonMin) / this.delLon) + 1;
                double[][] tileDEM = new double[nLat + 1][nLon + 1];
                double[][] neighbourDEM = new double[3][3];
                for (int i = 0; i < nLat; ++i) {
                    double lat = latMin + (double)i * this.delLat;
                    for (int j = 0; j < nLon; ++j) {
                        double alt;
                        double lon = lonMin + (double)j * this.delLon;
                        if (lon >= 180.0) {
                            lon -= 360.0;
                        }
                        if (this.saveZeroHeightSimulation) {
                            alt = 1.0;
                        } else {
                            geoPos.setLocation((float)lat, (float)lon);
                            alt = this.dem.getElevation(geoPos);
                            if (alt == (double)this.demNoDataValue) continue;
                        }
                        tileDEM[i][j] = alt;
                        if (!this.getPosition(lat, lon, alt, x0, y0, w, h, posData)) continue;
                        LocalGeometry localGeometry = new LocalGeometry(lat, lon, this.delLat, this.delLon, posData.earthPoint, posData.sensorPos);
                        double[] localIncidenceAngles = new double[]{-99999.0, -99999.0};
                        int r = 0;
                        for (int ii = Math.max(0, i - 1); ii <= i + 1; ++ii) {
                            ii = Math.min(nLat, ii);
                            int c = 0;
                            float neighbourLat = (float)(latMin + (double)ii * this.delLat);
                            for (int jj = Math.max(0, j - 1); jj <= j + 1; ++jj) {
                                jj = Math.min(nLon, jj);
                                neighbourDEM[r][c] = tileDEM[ii][jj];
                                if (neighbourDEM[r][c] == 0.0) {
                                    if (this.saveZeroHeightSimulation) {
                                        neighbourDEM[r][c] = 1.0;
                                    } else {
                                        geoPos.setLocation(neighbourLat, (float)(lonMin + (double)jj * this.delLon));
                                        neighbourDEM[r][c] = this.dem.getElevation(geoPos);
                                    }
                                    tileDEM[ii][jj] = neighbourDEM[r][c];
                                }
                                ++c;
                            }
                            ++r;
                        }
                        SARGeocoding.computeLocalIncidenceAngle((LocalGeometry)localGeometry, (float)this.demNoDataValue, (boolean)false, (boolean)true, (boolean)false, (int)0, (int)0, (int)0, (int)0, (double[][])neighbourDEM, (double[])localIncidenceAngles);
                        if (localIncidenceAngles[1] == -99999.0) continue;
                        double v = SARSimulationOp.computeBackscatteredPower(localIncidenceAngles[1]);
                        SARSimulationOp.saveSimulatedData(posData.azimuthIndex, posData.rangeIndex, v, x0, y0, w, h, targetTile, masterBuffer);
                        int idx = 0;
                        if (this.saveDEM || this.saveLocalIncidenceAngle) {
                            idx = targetTile.getDataBufferIndex((int)posData.rangeIndex, (int)posData.azimuthIndex);
                        }
                        if (this.saveDEM && idx >= 0) {
                            demBandBuffer.setElemDoubleAt(idx, alt);
                        }
                        if (this.saveZeroHeightSimulation) {
                            SARSimulationOp.saveSimulatedData(posData.azimuthIndex, posData.rangeIndex, 1.0, x0, y0, w, h, targetTile, zeroHeightBandBuffer);
                        }
                        if (this.saveLocalIncidenceAngle && idx >= 0) {
                            localIncidenceAngleBandBuffer.setElemDoubleAt(idx, localIncidenceAngles[1]);
                        }
                        if (!this.saveLayoverShadowMask) continue;
                        int rIndex = (int)posData.rangeIndex;
                        int aIndex = (int)posData.azimuthIndex;
                        index[rIndex] = targetTile.getDataBufferIndex(rIndex, aIndex);
                        if (index[rIndex] < 0) {
                            savePixel[rIndex] = false;
                            continue;
                        }
                        slrs[rIndex] = posData.slantRange;
                        elev[rIndex] = SARSimulationOp.computeElevationAngle(posData.slantRange, posData.earthPoint, posData.sensorPos);
                        savePixel[rIndex] = true;
                    }
                    if (!this.saveLayoverShadowMask) continue;
                    this.computeLayoverShadow(savePixel, slrs, index, elev, layoverShadowMaskBuffer);
                }
            } else {
                double[][] localDEM = new double[ymax - ymin + 2][w + 2];
                TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0, ymin, w, ymax - ymin);
                if (this.saveZeroHeightSimulation) {
                    for (double[] aLocalDEM : localDEM) {
                        Arrays.fill(aLocalDEM, 1.0);
                    }
                } else {
                    boolean valid = DEMFactory.getLocalDEM((ElevationModel)this.dem, (float)this.demNoDataValue, (String)this.demResamplingMethod, (TileGeoreferencing)tileGeoRef, (int)x0, (int)ymin, (int)w, (int)(ymax - ymin), (Product)this.sourceProduct, (boolean)true, (double[][])localDEM);
                    if (!valid) {
                        return;
                    }
                }
                for (int y = ymin; y < ymax; ++y) {
                    int yy = y - ymin;
                    for (int x = x0; x < xmax; ++x) {
                        int xx = x - x0;
                        double alt = localDEM[yy + 1][xx + 1];
                        if (alt == (double)this.demNoDataValue) continue;
                        tileGeoRef.getGeoPos(x, y, geoPos);
                        if (!geoPos.isValid()) continue;
                        double lat = geoPos.lat;
                        double lon = geoPos.lon;
                        if (lon >= 180.0) {
                            lon -= 360.0;
                        }
                        if (this.orbitMethod) {
                            double[] latlon = this.jOrbit.lp2ell(new Point((double)x + 0.5, (double)y + 0.5), this.meta);
                            lat = latlon[0] * 57.29577951308232;
                            lon = latlon[1] * 57.29577951308232;
                            alt = this.dem.getElevation(new GeoPos((float)lat, (float)lon));
                        }
                        if (!this.getPosition(lat, lon, alt, x0, y0, w, h, posData)) continue;
                        LocalGeometry localGeometry = new LocalGeometry(x, y, tileGeoRef, posData.earthPoint, posData.sensorPos);
                        double[] localIncidenceAngles = new double[]{-99999.0, -99999.0};
                        SARGeocoding.computeLocalIncidenceAngle((LocalGeometry)localGeometry, (float)this.demNoDataValue, (boolean)false, (boolean)true, (boolean)false, (int)x0, (int)ymin, (int)x, (int)y, (double[][])localDEM, (double[])localIncidenceAngles);
                        if (localIncidenceAngles[1] == -99999.0) continue;
                        double v = SARSimulationOp.computeBackscatteredPower(localIncidenceAngles[1]);
                        SARSimulationOp.saveSimulatedData(posData.azimuthIndex, posData.rangeIndex, v, x0, y0, w, h, targetTile, masterBuffer);
                        int idx = 0;
                        if (this.saveDEM || this.saveLocalIncidenceAngle) {
                            idx = targetTile.getDataBufferIndex((int)posData.rangeIndex, (int)posData.azimuthIndex);
                        }
                        if (this.saveDEM && idx >= 0) {
                            demBandBuffer.setElemDoubleAt(idx, alt);
                        }
                        if (this.saveZeroHeightSimulation) {
                            SARSimulationOp.saveSimulatedData(posData.azimuthIndex, posData.rangeIndex, 1.0, x0, y0, w, h, targetTile, zeroHeightBandBuffer);
                        }
                        if (this.saveLocalIncidenceAngle && idx >= 0) {
                            localIncidenceAngleBandBuffer.setElemDoubleAt(idx, localIncidenceAngles[1]);
                        }
                        if (!this.saveLayoverShadowMask) continue;
                        int rIndex = (int)posData.rangeIndex;
                        int aIndex = (int)posData.azimuthIndex;
                        index[xx] = targetTile.getDataBufferIndex(rIndex, aIndex);
                        if (index[xx] < 0) {
                            savePixel[xx] = false;
                            continue;
                        }
                        slrs[xx] = posData.slantRange;
                        elev[xx] = SARSimulationOp.computeElevationAngle(posData.slantRange, posData.earthPoint, posData.sensorPos);
                        savePixel[xx] = true;
                    }
                    if (!this.saveLayoverShadowMask) continue;
                    this.computeLayoverShadow(savePixel, slrs, index, elev, layoverShadowMaskBuffer);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private boolean getPositionFromOrbit(double lat, double lon, double alt, int x0, int y0, int w, int h, PositionData data) {
        double[] phi_lam_height = new double[]{lat * (Math.PI / 180), lon * (Math.PI / 180), alt};
        Point pointOnDem = Ellipsoid.ell2xyz((double[])phi_lam_height);
        Point linePixel = this.jOrbit.xyz2lp(pointOnDem, this.meta);
        data.azimuthIndex = linePixel.y;
        data.rangeIndex = linePixel.x;
        if (!(data.azimuthIndex > (double)(y0 - 1)) || !(data.azimuthIndex < (double)(y0 + h))) {
            return false;
        }
        if (data.rangeIndex <= 0.0) {
            return false;
        }
        if (!this.nearRangeOnLeft) {
            data.rangeIndex = (double)(this.sourceImageWidth - 1) - data.rangeIndex;
        }
        return data.rangeIndex >= (double)x0 && data.rangeIndex < (double)(x0 + w);
    }

    private boolean getPosition(double lat, double lon, double alt, int x0, int y0, int w, int h, PositionData data) {
        GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)alt, (double[])data.earthPoint);
        double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTimeNewton((double)this.firstLineUTC, (double)this.lineTimeInterval, (double)this.wavelength, (double[])data.earthPoint, (double[][])this.orbit.sensorPosition, (double[][])this.orbit.sensorVelocity);
        if (zeroDopplerTime == -99999.0) {
            return false;
        }
        data.slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])data.earthPoint, (double[])data.sensorPos);
        double zeroDopplerTimeWithoutBias = zeroDopplerTime + data.slantRange / 2.59020683712E13;
        data.azimuthIndex = (zeroDopplerTimeWithoutBias - this.firstLineUTC) / this.lineTimeInterval;
        if (!(data.azimuthIndex > (double)(y0 - 1)) || !(data.azimuthIndex <= (double)(y0 + h))) {
            return false;
        }
        data.slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTimeWithoutBias, (SARGeocoding.Orbit)this.orbit, (double[])data.earthPoint, (double[])data.sensorPos);
        data.rangeIndex = !this.srgrFlag ? (data.slantRange - this.nearEdgeSlantRange) / this.rangeSpacing : SARGeocoding.computeRangeIndex((boolean)this.srgrFlag, (int)this.sourceImageWidth, (double)this.firstLineUTC, (double)this.lastLineUTC, (double)this.rangeSpacing, (double)zeroDopplerTimeWithoutBias, (double)data.slantRange, (double)this.nearEdgeSlantRange, (AbstractMetadata.SRGRCoefficientList[])this.srgrConvParams);
        if (data.rangeIndex <= 0.0) {
            return false;
        }
        if (!this.nearRangeOnLeft) {
            data.rangeIndex = (double)(this.sourceImageWidth - 1) - data.rangeIndex;
        }
        return data.rangeIndex >= (double)x0 && data.rangeIndex < (double)(x0 + w);
    }

    private static void saveSimulatedData(double azimuthIndex, double rangeIndex, double v, int x0, int y0, int w, int h, Tile targetTile, ProductData masterBuffer) {
        int ia0 = (int)azimuthIndex;
        int ia1 = ia0 + 1;
        int ir0 = (int)rangeIndex;
        int ir1 = ir0 + 1;
        double wr = rangeIndex - (double)ir0;
        double wa = azimuthIndex - (double)ia0;
        double wac = 1.0 - wa;
        if (ir0 >= x0) {
            double wrc = 1.0 - wr;
            if (ia0 >= y0) {
                int idx00 = targetTile.getDataBufferIndex(ir0, ia0);
                masterBuffer.setElemDoubleAt(idx00, wrc * wac * v + masterBuffer.getElemDoubleAt(idx00));
            }
            if (ia1 < y0 + h) {
                int idx10 = targetTile.getDataBufferIndex(ir0, ia1);
                masterBuffer.setElemDoubleAt(idx10, wrc * wa * v + masterBuffer.getElemDoubleAt(idx10));
            }
        }
        if (ir1 < x0 + w) {
            if (ia0 >= y0) {
                int idx01 = targetTile.getDataBufferIndex(ir1, ia0);
                masterBuffer.setElemDoubleAt(idx01, wr * wac * v + masterBuffer.getElemDoubleAt(idx01));
            }
            if (ia1 < y0 + h) {
                int idx11 = targetTile.getDataBufferIndex(ir1, ia1);
                masterBuffer.setElemDoubleAt(idx11, wr * wa * v + masterBuffer.getElemDoubleAt(idx11));
            }
        }
    }

    private void computeLayoverShadow(boolean[] savePixel, double[] slrs, int[] index, double[] elev, ProductData layoverShadowMaskBuffer) {
        int length = savePixel.length;
        try {
            if (this.nearRangeOnLeft) {
                double maxSlantRange = 0.0;
                for (int i = 0; i < length; ++i) {
                    if (!savePixel[i]) continue;
                    if (slrs[i] > maxSlantRange) {
                        maxSlantRange = slrs[i];
                        continue;
                    }
                    layoverShadowMaskBuffer.setElemIntAt(index[i], 1);
                }
                double minSlantRange = maxSlantRange;
                for (int i = length - 1; i >= 0; --i) {
                    if (!savePixel[i]) continue;
                    if (slrs[i] < minSlantRange) {
                        minSlantRange = slrs[i];
                        continue;
                    }
                    layoverShadowMaskBuffer.setElemIntAt(index[i], 1);
                }
                double maxElevAngle = 0.0;
                for (int i = 0; i < length; ++i) {
                    if (!savePixel[i]) continue;
                    if (elev[i] > maxElevAngle) {
                        maxElevAngle = elev[i];
                        continue;
                    }
                    layoverShadowMaskBuffer.setElemIntAt(index[i], 2 + layoverShadowMaskBuffer.getElemIntAt(index[i]));
                }
            } else {
                double maxSlantRange = 0.0;
                for (int i = length - 1; i >= 0; --i) {
                    if (!savePixel[i]) continue;
                    if (slrs[i] > maxSlantRange) {
                        maxSlantRange = slrs[i];
                        continue;
                    }
                    layoverShadowMaskBuffer.setElemIntAt(index[i], 1);
                }
                double minSlantRange = maxSlantRange;
                for (int i = 0; i < length; ++i) {
                    if (!savePixel[i]) continue;
                    if (slrs[i] < minSlantRange) {
                        minSlantRange = slrs[i];
                        continue;
                    }
                    layoverShadowMaskBuffer.setElemIntAt(index[i], 1);
                }
                double maxElevAngle = 0.0;
                for (int i = length - 1; i >= 0; --i) {
                    if (!savePixel[i]) continue;
                    if (elev[i] > maxElevAngle) {
                        maxElevAngle = elev[i];
                        continue;
                    }
                    layoverShadowMaskBuffer.setElemIntAt(index[i], 2 + layoverShadowMaskBuffer.getElemIntAt(index[i]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static double computeBackscatteredPower(double localIncidenceAngle) {
        double alpha = localIncidenceAngle * (Math.PI / 180);
        double cosAlpha = FastMath.cos((double)alpha);
        return 0.0118 * cosAlpha / Math.pow(FastMath.sin((double)alpha) + 0.111 * cosAlpha, 3.0);
    }

    private static double computeElevationAngle(double slantRange, double[] earthPoint, double[] sensorPos) {
        double H2 = sensorPos[0] * sensorPos[0] + sensorPos[1] * sensorPos[1] + sensorPos[2] * sensorPos[2];
        double R2 = earthPoint[0] * earthPoint[0] + earthPoint[1] * earthPoint[1] + earthPoint[2] * earthPoint[2];
        return FastMath.acos((double)((slantRange * slantRange + H2 - R2) / (2.0 * slantRange * Math.sqrt(H2)))) * 57.29577951308232;
    }

    private void computeImageGeoBoundary(int xmin, int xmax, int ymin, int ymax, double[] latLonMinMax) throws Exception {
        GeoCoding geoCoding = this.sourceProduct.getGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("Product does not contain a geocoding");
        }
        GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos((float)xmin, (float)ymin), null);
        GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((float)xmax, (float)ymin), null);
        GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos((float)xmin, (float)ymax), null);
        GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((float)xmax, (float)ymax), null);
        double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
        double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
        double latMin = 90.0;
        double latMax = -90.0;
        for (double lat : lats) {
            if (lat < latMin) {
                latMin = lat;
            }
            if (!(lat > latMax)) continue;
            latMax = lat;
        }
        double lonMin = 180.0;
        double lonMax = -180.0;
        for (double lon : lons) {
            if (lon < lonMin) {
                lonMin = lon;
            }
            if (!(lon > lonMax)) continue;
            lonMax = lon;
        }
        latLonMinMax[0] = latMin;
        latLonMinMax[1] = latMax;
        latLonMinMax[2] = lonMin;
        latLonMinMax[3] = lonMax;
    }

    private void computeDEMTraversalSampleInterval() throws Exception {
        double[] latLonMinMax = new double[4];
        this.computeImageGeoBoundary(0, this.sourceProduct.getSceneRasterWidth() - 1, 0, this.sourceProduct.getSceneRasterHeight() - 1, latLonMinMax);
        double groundRangeSpacing = SARGeocoding.getRangePixelSpacing((Product)this.sourceProduct);
        double azimuthPixelSpacing = SARGeocoding.getAzimuthPixelSpacing((Product)this.sourceProduct);
        double spacing = Math.min(groundRangeSpacing, azimuthPixelSpacing);
        double latMin = latLonMinMax[0];
        double latMax = latLonMinMax[1];
        double minAbsLat = latMin * latMax > 0.0 ? Math.min(Math.abs(latMin), Math.abs(latMax)) * (Math.PI / 180) : 0.0;
        this.delLat = spacing / 6371008.7714 * 57.29577951308232;
        this.delLon = spacing / (6371008.7714 * Math.cos(minAbsLat)) * 57.29577951308232;
        this.delLon = this.delLat = Math.min(this.delLat, this.delLon);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SARSimulationOp.class);
        }
    }

    private static class PositionData {
        final double[] earthPoint = new double[3];
        final double[] sensorPos = new double[3];
        double azimuthIndex;
        double rangeIndex;
        double slantRange;

        private PositionData() {
        }
    }
}

