/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.snap.gpf.OperatorUIUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class SARSimulationOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox<String> demName = new JComboBox<String>(DEMFactory.getDEMNameList());
    private static final String externalDEMStr = "External DEM";
    private final JComboBox demResamplingMethod = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JTextField externalDEMFile = new JTextField("");
    private final JTextField externalDEMNoDataValue = new JTextField("");
    private final JButton externalDEMBrowseButton = new JButton("...");
    private final JLabel externalDEMFileLabel = new JLabel("External DEM:");
    private final JLabel externalDEMNoDataValueLabel = new JLabel("DEM No Data Value:");
    private final JCheckBox reGridMethodCheckBox = new JCheckBox("Re-grid method (slower)");
    private final JCheckBox orbitMethodCheckBox = new JCheckBox("Orbit method");
    private final JCheckBox saveDEMCheckBox = new JCheckBox("Save DEM band");
    private final JCheckBox saveZeroHeightSimulationCheckBox = new JCheckBox("Save Zero Height Simulation");
    private final JCheckBox saveLocalIncidenceAngleCheckBox = new JCheckBox("Save Simulated Local Incidence Angle");
    private final JCheckBox saveLayoverShadowMaskCheckBox = new JCheckBox("Save Layover-Shadow Mask");
    private Boolean isSARSimTC = false;
    private Boolean reGridMethod = false;
    private Boolean orbitMethod = false;
    private Boolean saveDEM = false;
    private Boolean saveZeroHeightSimulation = false;
    private Boolean saveLocalIncidenceAngle = false;
    private Boolean saveLayoverShadowMask = false;
    private Double extNoDataValue = 0.0;
    private final DialogUtils.TextAreaKeyListener textAreaKeyListener = new DialogUtils.TextAreaKeyListener();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.demName.addItem(externalDEMStr);
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.demName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (((String)SARSimulationOpUI.this.demName.getSelectedItem()).startsWith(SARSimulationOpUI.externalDEMStr)) {
                    SARSimulationOpUI.this.enableExternalDEM(true);
                } else {
                    SARSimulationOpUI.this.externalDEMFile.setText("");
                    SARSimulationOpUI.this.enableExternalDEM(false);
                }
            }
        });
        this.externalDEMFile.setColumns(30);
        this.enableExternalDEM(((String)this.demName.getSelectedItem()).startsWith(externalDEMStr));
        this.externalDEMBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = VisatApp.getApp().showFileOpenDialog("External DEM File", false, null);
                SARSimulationOpUI.this.externalDEMFile.setText(file.getAbsolutePath());
                SARSimulationOpUI.this.extNoDataValue = OperatorUIUtils.getNoDataValue((File)file);
                SARSimulationOpUI.this.externalDEMNoDataValue.setText(String.valueOf(SARSimulationOpUI.this.extNoDataValue));
            }
        });
        this.externalDEMNoDataValue.addKeyListener((KeyListener)this.textAreaKeyListener);
        this.reGridMethodCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimulationOpUI.this.reGridMethod = e.getStateChange() == 1;
            }
        });
        this.orbitMethodCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimulationOpUI.this.orbitMethod = e.getStateChange() == 1;
            }
        });
        this.saveDEMCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimulationOpUI.this.saveDEM = e.getStateChange() == 1;
            }
        });
        this.saveZeroHeightSimulationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimulationOpUI.this.saveZeroHeightSimulation = e.getStateChange() == 1;
            }
        });
        this.saveLocalIncidenceAngleCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimulationOpUI.this.saveLocalIncidenceAngle = e.getStateChange() == 1;
            }
        });
        this.saveLayoverShadowMaskCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimulationOpUI.this.saveLayoverShadowMask = e.getStateChange() == 1;
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            this.demName.setSelectedItem(DEMFactory.appendAutoDEM((String)demNameParam));
        }
        this.demResamplingMethod.setSelectedItem(this.paramMap.get("demResamplingMethod"));
        File extFile = (File)this.paramMap.get("externalDEMFile");
        if (extFile != null) {
            this.externalDEMFile.setText(extFile.getAbsolutePath());
            this.extNoDataValue = (Double)this.paramMap.get("externalDEMNoDataValue");
            if (this.extNoDataValue != null && !this.textAreaKeyListener.isChangedByUser()) {
                this.externalDEMNoDataValue.setText(String.valueOf(this.extNoDataValue));
            }
        }
        this.isSARSimTC = (Boolean)this.paramMap.get("isSARSimTC");
        if (this.isSARSimTC == null) {
            this.isSARSimTC = true;
        }
        if (!this.isSARSimTC.booleanValue()) {
            this.reGridMethod = (Boolean)this.paramMap.get("reGridMethod");
            this.reGridMethodCheckBox.setSelected(this.reGridMethod);
            this.orbitMethod = (Boolean)this.paramMap.get("orbitMethod");
            this.orbitMethodCheckBox.setSelected(this.orbitMethod);
            this.saveDEM = (Boolean)this.paramMap.get("saveDEM");
            this.saveDEMCheckBox.setSelected(this.saveDEM);
            this.saveZeroHeightSimulation = (Boolean)this.paramMap.get("saveZeroHeightSimulation");
            this.saveZeroHeightSimulationCheckBox.setSelected(this.saveZeroHeightSimulation);
            this.saveLocalIncidenceAngle = (Boolean)this.paramMap.get("saveLocalIncidenceAngle");
            this.saveLocalIncidenceAngleCheckBox.setSelected(this.saveLocalIncidenceAngle);
        }
        this.saveLayoverShadowMask = (Boolean)this.paramMap.get("saveLayoverShadowMask");
        if (this.saveLayoverShadowMask != null) {
            this.saveLayoverShadowMaskCheckBox.setSelected(this.saveLayoverShadowMask);
        }
        this.enableExtraOptions(this.isSARSimTC == false);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("demName", DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem())));
        this.paramMap.put("demResamplingMethod", this.demResamplingMethod.getSelectedItem());
        String extFileStr = this.externalDEMFile.getText();
        if (!extFileStr.isEmpty()) {
            this.paramMap.put("externalDEMFile", new File(extFileStr));
            this.paramMap.put("externalDEMNoDataValue", Double.parseDouble(this.externalDEMNoDataValue.getText()));
        }
        if (!this.isSARSimTC.booleanValue()) {
            this.paramMap.put("reGridMethod", this.reGridMethod);
            this.paramMap.put("orbitMethod", this.orbitMethod);
            this.paramMap.put("saveDEM", this.saveDEM);
            this.paramMap.put("saveZeroHeightSimulation", this.saveZeroHeightSimulation);
            this.paramMap.put("saveLocalIncidenceAngle", this.saveLocalIncidenceAngle);
        }
        this.paramMap.put("saveLayoverShadowMask", this.saveLayoverShadowMask);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMFileLabel, (JComponent)this.externalDEMFile);
        gbc.gridx = 2;
        contentPane.add((Component)this.externalDEMBrowseButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"DEM Resampling Method:", (JComponent)this.demResamplingMethod);
        gbc.gridx = 0;
        if (!this.isSARSimTC.booleanValue()) {
            ++gbc.gridy;
            contentPane.add((Component)this.reGridMethodCheckBox, gbc);
            ++gbc.gridy;
            contentPane.add((Component)this.orbitMethodCheckBox, gbc);
            ++gbc.gridy;
            contentPane.add((Component)this.saveDEMCheckBox, gbc);
            ++gbc.gridy;
            contentPane.add((Component)this.saveZeroHeightSimulationCheckBox, gbc);
            ++gbc.gridy;
            contentPane.add((Component)this.saveLocalIncidenceAngleCheckBox, gbc);
        }
        ++gbc.gridy;
        contentPane.add((Component)this.saveLayoverShadowMaskCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableExtraOptions(boolean flag) {
        this.reGridMethodCheckBox.setVisible(flag);
        this.orbitMethodCheckBox.setVisible(flag);
        this.saveDEMCheckBox.setVisible(flag);
        this.saveZeroHeightSimulationCheckBox.setVisible(flag);
        this.saveLocalIncidenceAngleCheckBox.setVisible(flag);
    }

    private void enableExternalDEM(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue, (boolean)flag);
        this.externalDEMBrowseButton.setVisible(flag);
    }
}

