/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import Jama.Matrix;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.Unit;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.util.Maths;

@OperatorMetadata(alias="SRGR", category="SAR Processing/Geometric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Converts Slant Range to Ground Range")
public class SRGROp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(description="The order of WARP polynomial function", interval="[1, *)", defaultValue="4", label="Warp Polynomial Order")
    private int warpPolynomialOrder = 4;
    private int numRangePoints = 100;
    @Parameter(valueSet={"Nearest-neighbor interpolation", "Linear interpolation", "Cubic interpolation", "Cubic2 interpolation", "Sinc interpolation"}, defaultValue="Linear interpolation", label="Interpolation Method")
    private String interpolationMethod = "Linear interpolation";
    private MetadataElement absRoot = null;
    private GeoCoding geoCoding = null;
    private boolean imageFlipped = false;
    private double slantRangeSpacing;
    private double groundRangeSpacing;
    private double nearRangeIncidenceAngle;
    private double[] slantRangeDistanceArray;
    private double[] groundRangeDistanceArray;
    private double[] warpPolynomialCoef;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private int targetImageWidth;
    private int targetImageHeight;
    private Interpolation interpMethod = Interpolation.LINEAR;
    private static final String nearestNeighbourStr = "Nearest-neighbor interpolation";
    private static final String linearStr = "Linear interpolation";
    private static final String cubicStr = "Cubic interpolation";
    private static final String cubic2Str = "Cubic2 interpolation";
    private static final String sincStr = "Sinc interpolation";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected();
            validator.checkIfTOPSARBurstProduct(false);
            if (this.numRangePoints < this.warpPolynomialOrder + 2) {
                throw new OperatorException("numRangePoints must be greater than warpPolynomialOrder");
            }
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getSRGRFlag();
            this.getSlantRangePixelSpacing();
            this.getSourceImageDimension();
            this.geoCoding = this.sourceProduct.getGeoCoding();
            if (this.geoCoding == null) {
                throw new OperatorException("GeoCoding is null");
            }
            this.computeSlantRangeDistanceArray();
            this.getNearRangeIncidenceAngle();
            this.computeGroundRangeSpacing();
            this.computeWarpPolynomial();
            this.createTargetProduct();
            if (this.interpolationMethod.equals(nearestNeighbourStr)) {
                this.interpMethod = Interpolation.NEAREST_NEIGHBOR;
            } else if (this.interpolationMethod.equals(linearStr)) {
                this.interpMethod = Interpolation.LINEAR;
            } else if (this.interpolationMethod.equals(cubicStr)) {
                this.interpMethod = Interpolation.CUBIC;
            } else if (this.interpolationMethod.equals(cubic2Str)) {
                this.interpMethod = Interpolation.CUBIC2;
            } else if (this.interpolationMethod.equals(sincStr)) {
                this.interpMethod = Interpolation.SINC;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getSRGRFlag() throws Exception {
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"srgr_flag");
        if (srgrFlag) {
            throw new OperatorException("Slant range to ground range conversion has already been applied");
        }
    }

    private void getSlantRangePixelSpacing() throws Exception {
        this.slantRangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand);
            Rectangle sourceTileRectangle = this.getSourceRectangle(tx0, ty0, tw, th);
            Tile sourceRaster = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData trgData = targetTile.getDataBuffer();
            ProductData srcData = sourceRaster.getDataBuffer();
            int p0 = 0;
            int p1 = 0;
            int p2 = 0;
            int p3 = 0;
            int p4 = 0;
            double v0 = 0.0;
            double v1 = 0.0;
            double v2 = 0.0;
            double v3 = 0.0;
            double v4 = 0.0;
            double v = 0.0;
            double mu = 0.0;
            for (int x = tx0; x < tx0 + tw; ++x) {
                double p = this.getSlantRangePixelPosition(x);
                if (this.interpMethod.equals((Object)Interpolation.NEAREST_NEIGHBOR)) {
                    p0 = Math.min((int)(p + 0.5), this.sourceImageWidth - 1);
                } else if (this.interpMethod.equals((Object)Interpolation.LINEAR)) {
                    p0 = Math.min((int)p, this.sourceImageWidth - 2);
                    p1 = p0 + 1;
                    mu = p - (double)p0;
                } else if (this.interpMethod.equals((Object)Interpolation.CUBIC) || this.interpMethod.equals((Object)Interpolation.CUBIC2)) {
                    p1 = Math.min((int)p, this.sourceImageWidth - 1);
                    p0 = Math.max(p1 - 1, 0);
                    p2 = Math.min(p1 + 1, this.sourceImageWidth - 1);
                    p3 = Math.min(p1 + 2, this.sourceImageWidth - 1);
                    mu = Math.min(p - (double)p1, 1.0);
                } else if (this.interpMethod.equals((Object)Interpolation.SINC)) {
                    p2 = Math.min((int)(p + 0.5), this.sourceImageWidth - 1);
                    p0 = Math.max(p2 - 2, 0);
                    p1 = Math.max(p2 - 1, 0);
                    p3 = Math.min(p2 + 1, this.sourceImageWidth - 1);
                    p4 = Math.min(p2 + 2, this.sourceImageWidth - 1);
                    mu = p - (double)p2;
                }
                for (int y = ty0; y < ty0 + th; ++y) {
                    if (this.interpMethod.equals((Object)Interpolation.NEAREST_NEIGHBOR)) {
                        v = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p0, y));
                    } else if (this.interpMethod.equals((Object)Interpolation.LINEAR)) {
                        v0 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p0, y));
                        v1 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p1, y));
                        v = Maths.interpolationLinear((double)v0, (double)v1, (double)mu);
                    } else if (this.interpMethod.equals((Object)Interpolation.CUBIC)) {
                        v0 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p0, y));
                        v1 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p1, y));
                        v2 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p2, y));
                        v3 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p3, y));
                        v = Maths.interpolationCubic((double)v0, (double)v1, (double)v2, (double)v3, (double)mu);
                    } else if (this.interpMethod.equals((Object)Interpolation.CUBIC2)) {
                        v0 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p0, y));
                        v1 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p1, y));
                        v2 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p2, y));
                        v3 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p3, y));
                        v = Maths.interpolationCubic2((double)v0, (double)v1, (double)v2, (double)v3, (double)mu);
                    } else if (this.interpMethod.equals((Object)Interpolation.SINC)) {
                        v0 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p0, y));
                        v1 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p1, y));
                        v2 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p2, y));
                        v3 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p3, y));
                        v4 = srcData.getElemDoubleAt(sourceRaster.getDataBufferIndex(p4, y));
                        v = Maths.interpolationSinc((double)v0, (double)v1, (double)v2, (double)v3, (double)v4, (double)mu);
                    }
                    if (bandUnit == Unit.UnitType.INTENSITY) {
                        v = Math.max(v, 0.0);
                    }
                    trgData.setElemDoubleAt(targetTile.getDataBufferIndex(x, y), v);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int xMin = (int)this.getSlantRangePixelPosition(Math.max(tx0 - 2, 0));
        int xMax = (int)this.getSlantRangePixelPosition((double)tx0 + (double)tw + 2.0);
        int sw = Math.min(xMax - xMin + 1, this.sourceImageWidth);
        return new Rectangle(xMin, ty0, sw, th);
    }

    private double getSlantRangePixelPosition(double x) {
        if (Double.compare(x, 0.0) == 0) {
            return 0.0;
        }
        double dg = this.groundRangeSpacing * x;
        double ds = 0.0;
        for (int j = 0; j < this.warpPolynomialOrder + 1; ++j) {
            ds += Math.pow(dg, j) * this.warpPolynomialCoef[j];
        }
        return ds / this.slantRangeSpacing;
    }

    private void computeSlantRangeDistanceArray() {
        this.slantRangeDistanceArray = new double[this.numRangePoints - 1];
        int pixelsBetweenPoints = this.sourceImageWidth / this.numRangePoints;
        double slantDistanceBetweenPoints = this.slantRangeSpacing * (double)pixelsBetweenPoints;
        for (int i = 0; i < this.numRangePoints - 1; ++i) {
            this.slantRangeDistanceArray[i] = slantDistanceBetweenPoints * (double)(i + 1);
        }
    }

    private void getNearRangeIncidenceAngle() {
        double alphaLast;
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        double alphaFirst = incidenceAngle.getPixelFloat(0.5f, 0.5f);
        if (alphaFirst <= (alphaLast = (double)incidenceAngle.getPixelFloat((float)this.sourceImageWidth - 0.5f, 0.5f))) {
            this.imageFlipped = false;
            this.nearRangeIncidenceAngle = alphaFirst;
        } else {
            this.imageFlipped = true;
            this.nearRangeIncidenceAngle = alphaLast;
        }
    }

    private void computeGroundRangeSpacing() {
        this.groundRangeSpacing = this.slantRangeSpacing / Math.sin(this.nearRangeIncidenceAngle * Math.PI / 180.0);
    }

    private void createTargetProduct() throws Exception {
        this.computeTargetImageDimension();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.targetImageWidth, this.targetImageHeight);
        this.addSelectedBands();
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        this.addGeoCoding();
        this.updateTargetProductMetadata();
    }

    private void computeTargetImageDimension() {
        double[] xyz = new double[3];
        GeoPos geoPos = this.geoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
        GeoUtils.geo2xyz((GeoPos)geoPos, (double[])xyz);
        double xP0 = xyz[0];
        double yP0 = xyz[1];
        double zP0 = xyz[2];
        double totalDistance = 0.0;
        for (int i = 1; i < this.sourceImageWidth; ++i) {
            geoPos = this.geoCoding.getGeoPos(new PixelPos((float)i, 0.0f), null);
            GeoUtils.geo2xyz((GeoPos)geoPos, (double[])xyz);
            totalDistance += Math.sqrt(Math.pow(xP0 - xyz[0], 2.0) + Math.pow(yP0 - xyz[1], 2.0) + Math.pow(zP0 - xyz[2], 2.0));
            xP0 = xyz[0];
            yP0 = xyz[1];
            zP0 = xyz[2];
        }
        this.targetImageWidth = (int)(totalDistance / this.groundRangeSpacing);
        this.targetImageHeight = this.sourceImageHeight;
    }

    private void updateTargetProductMetadata() throws Exception {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"srgr_flag", (int)1);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"range_spacing", (double)this.groundRangeSpacing);
        this.addSRGRCoefficients(absTgt);
    }

    private void addSRGRCoefficients(MetadataElement absTgt) throws Exception {
        MetadataElement srgrCoefficientsElem = new MetadataElement("SRGR_Coefficients");
        MetadataElement srgrListElem = new MetadataElement("srgr_coef_list");
        srgrCoefficientsElem.addElement(srgrListElem);
        ProductData.UTC utcTime = absTgt.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
        srgrListElem.setAttributeUTC("zero_doppler_time", utcTime);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (int)31, (String)"m", (String)"Ground Range Origin");
        AbstractMetadata.setAttribute((MetadataElement)srgrListElem, (String)"ground_range_origin", (double)0.0);
        double r0 = AbstractMetadata.getAttributeDouble((MetadataElement)absTgt, (String)"slant_range_to_first_pixel");
        for (int i = 0; i < this.warpPolynomialCoef.length; ++i) {
            if (i == 0) {
                SRGROp.addSRGRCoef(srgrListElem, this.warpPolynomialCoef[i] + r0, i + 1);
                continue;
            }
            SRGROp.addSRGRCoef(srgrListElem, this.warpPolynomialCoef[i], i + 1);
        }
        MetadataElement srgrElem = absTgt.getElement("SRGR_Coefficients");
        if (srgrElem != null) {
            absTgt.removeElement(srgrElem);
        }
        absTgt.addElement(srgrCoefficientsElem);
    }

    private static void addSRGRCoef(MetadataElement srgrListElem, double srgrCoefficient, int cnt) {
        MetadataElement coefElem = new MetadataElement("coefficient." + cnt);
        srgrListElem.addElement(coefElem);
        AbstractMetadata.addAbstractedAttribute((MetadataElement)coefElem, (String)"srgr_coef", (int)31, (String)"", (String)"SRGR Coefficient");
        AbstractMetadata.setAttribute((MetadataElement)coefElem, (String)"srgr_coef", (double)srgrCoefficient);
    }

    private void addSelectedBands() {
        Band[] sourceBands;
        for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames)) {
            if (srcBand.getUnit() != null && srcBand.getUnit().contains("phase")) continue;
            Band targetBand = new Band(srcBand.getName(), 30, this.targetImageWidth, this.targetImageHeight);
            targetBand.setUnit(srcBand.getUnit());
            targetBand.setDescription(srcBand.getDescription());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
            this.targetProduct.addBand(targetBand);
        }
    }

    private void addGeoCoding() {
        TiePointGrid lat = OperatorUtils.getLatitude((Product)this.sourceProduct);
        TiePointGrid lon = OperatorUtils.getLongitude((Product)this.sourceProduct);
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        TiePointGrid slantRgTime = OperatorUtils.getSlantRangeTime((Product)this.sourceProduct);
        if (lat == null || lon == null || incidenceAngle == null || slantRgTime == null) {
            ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
            return;
        }
        int gridWidth = 11;
        int gridHeight = 11;
        float subSamplingX = (float)this.targetImageWidth / 10.0f;
        float subSamplingY = (float)this.targetImageHeight / 10.0f;
        PixelPos[] newTiePointPos = new PixelPos[121];
        int k = 0;
        for (int j = 0; j < 11; ++j) {
            float y = Math.min((float)j * subSamplingY, (float)(this.targetImageHeight - 1));
            for (int i = 0; i < 11; ++i) {
                float tx = Math.min((float)i * subSamplingX, (float)(this.targetImageWidth - 1));
                float x = (float)this.getSlantRangePixelPosition(tx);
                newTiePointPos[k] = new PixelPos(x, y);
                ++k;
            }
        }
        OperatorUtils.createNewTiePointGridsAndGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct, (int)11, (int)11, (float)subSamplingX, (float)subSamplingY, (PixelPos[])newTiePointPos);
    }

    private void computeWarpPolynomial() {
        int y = this.sourceImageHeight / 2;
        this.computeGroundRangeDistanceArray(y);
        Matrix A = Maths.createVandermondeMatrix((double[])this.groundRangeDistanceArray, (int)this.warpPolynomialOrder);
        Matrix b = new Matrix(this.slantRangeDistanceArray, this.numRangePoints - 1);
        Matrix x = A.solve(b);
        this.warpPolynomialCoef = x.getColumnPackedCopy();
    }

    private void computeGroundRangeDistanceArray(int y) {
        this.groundRangeDistanceArray = new double[this.numRangePoints - 1];
        double[] xyz = new double[3];
        int pixelsBetweenPoints = this.sourceImageWidth / this.numRangePoints;
        GeoPos geoPos = this.imageFlipped ? this.geoCoding.getGeoPos(new PixelPos((float)(this.sourceImageWidth - 1), (float)y), null) : this.geoCoding.getGeoPos(new PixelPos(0.0f, (float)y), null);
        GeoUtils.geo2xyz((GeoPos)geoPos, (double[])xyz);
        double xPos0 = xyz[0];
        double yPos0 = xyz[1];
        double zPos0 = xyz[2];
        for (int i = 0; i < this.numRangePoints - 1; ++i) {
            geoPos = this.imageFlipped ? this.geoCoding.getGeoPos(new PixelPos((float)(this.sourceImageWidth - 1 - pixelsBetweenPoints * (i + 1)), (float)y), null) : this.geoCoding.getGeoPos(new PixelPos((float)(pixelsBetweenPoints * (i + 1)), (float)y), null);
            GeoUtils.geo2xyz((GeoPos)geoPos, (double[])xyz);
            double pointToPointDistance = Math.sqrt((xPos0 - xyz[0]) * (xPos0 - xyz[0]) + (yPos0 - xyz[1]) * (yPos0 - xyz[1]) + (zPos0 - xyz[2]) * (zPos0 - xyz[2]));
            this.groundRangeDistanceArray[i] = i == 0 ? pointToPointDistance : this.groundRangeDistanceArray[i - 1] + pointToPointDistance;
            xPos0 = xyz[0];
            yPos0 = xyz[1];
            zPos0 = xyz[2];
        }
    }

    public void setNumOfRangePoints(int numPoints) {
        this.numRangePoints = numPoints;
    }

    public void setSourceBandName(String name) {
        this.sourceBandNames = new String[1];
        this.sourceBandNames[0] = name;
    }

    public double[] getWarpPolynomialCoef() {
        return this.warpPolynomialCoef;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SRGROp.class);
        }
    }

    private static enum Interpolation {
        NEAREST_NEIGHBOR,
        LINEAR,
        CUBIC,
        CUBIC2,
        SINC;

    }
}

