/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelGeoCoding;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.FileElevationModel;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.nest.gpf.geometric.SARUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.esa.snap.gpf.TileIndex;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;

@OperatorMetadata(alias="Update-Geo-Reference", category="SAR Processing/Geometric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Update Geo Reference")
public final class UpdateGeoRefOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"ACE", "GETASSE30", "SRTM 3Sec", "ASTER 1sec GDEM"}, description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BICUBIC_INTERPOLATION", "BISINC_5_POINT_INTERPOLATION"}, defaultValue="BICUBIC_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BICUBIC_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(defaultValue="false", label="Re-grid method (slower)")
    boolean reGridMethod = false;
    boolean orbitMethod = false;
    private MetadataElement absRoot = null;
    private ElevationModel dem = null;
    private GeoCoding sourceGeoCoding = null;
    private SLCImage meta = null;
    private Orbit jOrbit = null;
    private int tileSize = 400;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean srgrFlag = false;
    private boolean isElevationModelAvailable = false;
    private boolean nearRangeOnLeft = true;
    private float demNoDataValue = 0.0f;
    private double rangeSpacing = 0.0;
    private double firstLineUTC = 0.0;
    private double lastLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private double nearEdgeSlantRange = 0.0;
    private double wavelength = 0.0;
    private double delLat = 0.0;
    private double delLon = 0.0;
    private SARGeocoding.Orbit orbit = null;
    private int polyDegree = 2;
    private OrbitStateVector[] orbitStateVectors = null;
    private AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;
    private static double noDataValue = -999.0;
    public static String LATITUDE_BAND_NAME = "lat_band";
    public static String LONGITUDE_BAND_NAME = "lon_band";

    public void initialize() throws OperatorException {
        try {
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getSourceImageDimension();
            this.getMetadata();
            this.computeSensorPositionsAndVelocities();
            this.createTargetProduct();
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.sourceProduct);
            if (this.reGridMethod) {
                this.computeDEMTraversalSampleInterval();
            } else if (this.orbitMethod) {
                this.meta = new SLCImage(this.absRoot);
                this.jOrbit = new Orbit(this.absRoot, 3);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.dem != null) {
            this.dem.dispose();
            this.dem = null;
        }
    }

    private void getMetadata() throws Exception {
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"srgr_flag");
        this.wavelength = SARUtils.getRadarFrequency((MetadataElement)this.absRoot);
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.firstLineUTC = this.absRoot.getAttributeUTC("first_line_time").getMJD();
        this.lastLineUTC = this.absRoot.getAttributeUTC("last_line_time").getMJD();
        this.lineTimeInterval = this.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)this.absRoot);
        if (this.srgrFlag) {
            this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)this.absRoot);
        } else {
            this.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"slant_range_to_first_pixel");
        }
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        this.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft((TiePointGrid)incidenceAngle, (int)this.sourceImageWidth);
    }

    private void computeSensorPositionsAndVelocities() {
        this.orbit = new SARGeocoding.Orbit(this.orbitStateVectors, this.polyDegree, this.firstLineUTC, this.lineTimeInterval, this.sourceImageHeight);
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        try {
            if (this.externalDEMFile != null) {
                this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Float.valueOf((float)this.externalDEMNoDataValue));
                this.demNoDataValue = (float)this.externalDEMNoDataValue;
                this.demName = this.externalDEMFile.getPath();
            } else {
                this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
                this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.isElevationModelAvailable = true;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.externalDEMFile != null) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.externalDEMFile.getPath());
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.demName);
        }
        absTgt.setAttributeString("DEM resampling method", this.demResamplingMethod);
        if (this.externalDEMFile != null) {
            absTgt.setAttributeDouble("external DEM no data value", this.externalDEMNoDataValue);
        }
        this.sourceGeoCoding = this.sourceProduct.getGeoCoding();
        this.targetProduct.setPreferredTileSize(this.targetProduct.getSceneRasterWidth(), this.tileSize);
    }

    private void addSelectedBands() {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                String unit = band.getUnit();
                if (unit != null && !unit.contains("intensity")) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        Band[] sourceBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String sourceBandName = this.sourceBandNames[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            sourceBands[i] = sourceBand;
        }
        for (Band srcBand : sourceBands) {
            Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(srcBand.getSourceImage());
        }
        Band latBand = new Band(LATITUDE_BAND_NAME, 30, this.sourceImageWidth, this.sourceImageHeight);
        Band lonBand = new Band(LONGITUDE_BAND_NAME, 30, this.sourceImageWidth, this.sourceImageHeight);
        this.targetProduct.addBand(latBand);
        this.targetProduct.addBand(lonBand);
        this.targetProduct.setGeoCoding((GeoCoding)new PixelGeoCoding(latBand, lonBand, null, 6));
    }

    private void computeTileOverlapPercentage(int x0, int y0, int w, int h, double[] overlapPercentages) throws Exception {
        PixelPos pixPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        double[] earthPoint = new double[3];
        double[] sensorPos = new double[3];
        double tileOverlapPercentageMax = -1.7976931348623157E308;
        double tileOverlapPercentageMin = Double.MAX_VALUE;
        for (int y = y0; y < y0 + h; y += 20) {
            for (int x = x0; x < x0 + w; x += 20) {
                pixPos.setLocation((float)x, (float)y);
                this.sourceGeoCoding.getGeoPos(pixPos, geoPos);
                double alt = this.dem.getElevation(geoPos);
                GeoUtils.geo2xyzWGS84((double)geoPos.getLat(), (double)geoPos.getLon(), (double)alt, (double[])earthPoint);
                double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTime((double)this.firstLineUTC, (double)this.lineTimeInterval, (double)this.wavelength, (double[])earthPoint, (double[][])this.orbit.sensorPosition, (double[][])this.orbit.sensorVelocity);
                if (zeroDopplerTime == -99999.0) continue;
                double slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])earthPoint, (double[])sensorPos);
                double zeroDopplerTimeWithoutBias = zeroDopplerTime + slantRange / 2.59020683712E13;
                int azimuthIndex = (int)((zeroDopplerTimeWithoutBias - this.firstLineUTC) / this.lineTimeInterval + 0.5);
                double tileOverlapPercentage = (float)(azimuthIndex - y) / (float)this.tileSize;
                if (tileOverlapPercentage > tileOverlapPercentageMax) {
                    tileOverlapPercentageMax = tileOverlapPercentage;
                }
                if (!(tileOverlapPercentage < tileOverlapPercentageMin)) continue;
                tileOverlapPercentageMin = tileOverlapPercentage;
            }
        }
        overlapPercentages[0] = tileOverlapPercentageMin != Double.MAX_VALUE && tileOverlapPercentageMin < 0.0 ? tileOverlapPercentageMin - 1.0 : 0.0;
        overlapPercentages[1] = tileOverlapPercentageMax != -1.7976931348623157E308 && tileOverlapPercentageMax > 0.0 ? tileOverlapPercentageMax + 1.0 : 0.0;
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        double[] tileOverlapPercentage = new double[]{0.0, 0.0};
        try {
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            this.computeTileOverlapPercentage(x0, y0, w, h, tileOverlapPercentage);
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
        Tile latTile = targetTiles.get(this.targetProduct.getBand(LATITUDE_BAND_NAME));
        Tile lonTile = targetTiles.get(this.targetProduct.getBand(LONGITUDE_BAND_NAME));
        ProductData latData = latTile.getDataBuffer();
        ProductData lonData = lonTile.getDataBuffer();
        double[][] latArray = new double[h][w];
        double[][] lonArray = new double[h][w];
        for (int r = 0; r < h; ++r) {
            Arrays.fill(latArray[r], noDataValue);
            Arrays.fill(lonArray[r], noDataValue);
        }
        int ymin = Math.max(y0 - (int)((double)this.tileSize * tileOverlapPercentage[1]), 0);
        int ymax = y0 + h + (int)((double)this.tileSize * Math.abs(tileOverlapPercentage[0]));
        int xmax = x0 + w;
        PositionData posData = new PositionData();
        GeoPos geoPos = new GeoPos();
        try {
            if (this.reGridMethod) {
                double[] latLonMinMax = new double[4];
                this.computeImageGeoBoundary(x0, xmax, ymin, ymax, latLonMinMax);
                double latMin = latLonMinMax[0];
                double latMax = latLonMinMax[1];
                double lonMin = latLonMinMax[2];
                double lonMax = latLonMinMax[3];
                int nLat = (int)((latMax - latMin) / this.delLat) + 1;
                int nLon = (int)((lonMax - lonMin) / this.delLon) + 1;
                double[][] tileDEM = new double[nLat + 1][nLon + 1];
                for (int i = 0; i < nLat; ++i) {
                    double lat = latMin + (double)i * this.delLat;
                    for (int j = 0; j < nLon; ++j) {
                        double lon = lonMin + (double)j * this.delLon;
                        if (lon >= 180.0) {
                            lon -= 360.0;
                        }
                        geoPos.setLocation((float)lat, (float)lon);
                        double alt = this.dem.getElevation(geoPos);
                        if (alt == (double)this.demNoDataValue) continue;
                        tileDEM[i][j] = alt;
                        if (!this.getPosition(lat, lon, alt, x0, y0, w, h, posData)) continue;
                        int ri = (int)Math.round(posData.rangeIndex);
                        int ai = (int)Math.round(posData.azimuthIndex);
                        if (ri < x0 || ri >= x0 + w || ai < y0 || ai >= y0 + h) continue;
                        latArray[ai - y0][ri - x0] = lat;
                        lonArray[ai - y0][ri - x0] = lon;
                    }
                }
            } else {
                TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.sourceProduct, x0, ymin, w, ymax - ymin);
                double[][] localDEM = new double[ymax - ymin + 2][w + 2];
                boolean valid = DEMFactory.getLocalDEM((ElevationModel)this.dem, (float)this.demNoDataValue, (String)this.demResamplingMethod, (TileGeoreferencing)tileGeoRef, (int)x0, (int)ymin, (int)w, (int)(ymax - ymin), (Product)this.sourceProduct, (boolean)true, (double[][])localDEM);
                if (!valid) {
                    return;
                }
                for (int y = ymin; y < ymax; ++y) {
                    int yy = y - ymin;
                    for (int x = x0; x < xmax; ++x) {
                        int xx = x - x0;
                        double alt = localDEM[yy + 1][xx + 1];
                        if (alt == (double)this.demNoDataValue) continue;
                        tileGeoRef.getGeoPos(x, y, geoPos);
                        if (!geoPos.isValid()) continue;
                        double lat = geoPos.lat;
                        double lon = geoPos.lon;
                        if (lon >= 180.0) {
                            lon -= 360.0;
                        }
                        if (this.orbitMethod) {
                            double[] latlon = this.jOrbit.lp2ell(new Point((double)x + 0.5, (double)y + 0.5), this.meta);
                            lat = latlon[0] * 57.29577951308232;
                            lon = latlon[1] * 57.29577951308232;
                            alt = this.dem.getElevation(new GeoPos((float)lat, (float)lon));
                        }
                        if (!this.getPosition(lat, lon, alt, x0, y0, w, h, posData)) continue;
                        int ri = (int)Math.round(posData.rangeIndex);
                        int ai = (int)Math.round(posData.azimuthIndex);
                        if (ri < x0 || ri >= x0 + w || ai < y0 || ai >= y0 + h) continue;
                        latArray[ai - y0][ri - x0] = lat;
                        lonArray[ai - y0][ri - x0] = lon;
                    }
                }
            }
            TileIndex trgIndex = new TileIndex(latTile);
            for (int y = y0; y < y0 + h; ++y) {
                int yy = y - y0;
                trgIndex.calculateStride(y);
                for (int x = x0; x < x0 + w; ++x) {
                    int xx = x - x0;
                    int index = trgIndex.getIndex(x);
                    if (latArray[yy][xx] == noDataValue) {
                        latData.setElemFloatAt(index, (float)this.fillHole(xx, yy, latArray));
                    } else {
                        latData.setElemFloatAt(index, (float)latArray[yy][xx]);
                    }
                    if (lonArray[yy][xx] == noDataValue) {
                        lonData.setElemFloatAt(index, (float)this.fillHole(xx, yy, lonArray));
                        continue;
                    }
                    lonData.setElemFloatAt(index, (float)lonArray[yy][xx]);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private double fillHole(int xx, int yy, double[][] srcArray) throws Exception {
        try {
            int x;
            int y;
            int h = srcArray.length;
            int w = srcArray[0].length;
            double vU = noDataValue;
            double vD = noDataValue;
            double vL = noDataValue;
            double vR = noDataValue;
            int yU = -1;
            int yD = -1;
            int xL = -1;
            int xR = -1;
            for (y = yy; y >= 0; --y) {
                if (srcArray[y][xx] == noDataValue) continue;
                vU = srcArray[y][xx];
                yU = y;
                break;
            }
            for (y = yy; y < h; ++y) {
                if (srcArray[y][xx] == noDataValue) continue;
                if (vU != noDataValue) {
                    vD = srcArray[y][xx];
                    yD = y;
                    break;
                }
                vU = srcArray[y][xx];
                yU = y;
            }
            for (x = xx; x >= 0; --x) {
                if (srcArray[yy][x] == noDataValue) continue;
                vL = srcArray[yy][x];
                xL = x;
                break;
            }
            for (x = xx; x < w; ++x) {
                if (srcArray[yy][x] == noDataValue) continue;
                if (vL != noDataValue) {
                    vR = srcArray[yy][x];
                    xR = x;
                    break;
                }
                vL = srcArray[yy][x];
                xL = x;
            }
            if (vU != noDataValue && vD != noDataValue && vL != noDataValue && vR != noDataValue) {
                double vY = vU + (vD - vU) * (double)(yy - yU) / (double)(yD - yU);
                double vX = vL + (vR - vL) * (double)(xx - xL) / (double)(xR - xL);
                return 0.5 * (vY + vX);
            }
            if (vU != noDataValue && vD != noDataValue) {
                return vU + (vD - vU) * (double)(yy - yU) / (double)(yD - yU);
            }
            if (vL != noDataValue && vR != noDataValue) {
                return vL + (vR - vL) * (double)(xx - xL) / (double)(xR - xL);
            }
            if (vL != noDataValue) {
                return vL;
            }
            if (vR != noDataValue) {
                return vR;
            }
            if (vU != noDataValue) {
                return vU;
            }
            if (vD != noDataValue) {
                return vD;
            }
        }
        catch (Exception e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        return 0.0;
    }

    private boolean getPosition(double lat, double lon, double alt, int x0, int y0, int w, int h, PositionData data) {
        GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)alt, (double[])data.earthPoint);
        double zeroDopplerTime = SARGeocoding.getEarthPointZeroDopplerTimeNewton((double)this.firstLineUTC, (double)this.lineTimeInterval, (double)this.wavelength, (double[])data.earthPoint, (double[][])this.orbit.sensorPosition, (double[][])this.orbit.sensorVelocity);
        if (zeroDopplerTime == -99999.0) {
            return false;
        }
        data.slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTime, (SARGeocoding.Orbit)this.orbit, (double[])data.earthPoint, (double[])data.sensorPos);
        double zeroDopplerTimeWithoutBias = zeroDopplerTime + data.slantRange / 2.59020683712E13;
        data.azimuthIndex = (zeroDopplerTimeWithoutBias - this.firstLineUTC) / this.lineTimeInterval;
        if (!(data.azimuthIndex > (double)(y0 - 1)) || !(data.azimuthIndex <= (double)(y0 + h))) {
            return false;
        }
        data.slantRange = SARGeocoding.computeSlantRange((double)zeroDopplerTimeWithoutBias, (SARGeocoding.Orbit)this.orbit, (double[])data.earthPoint, (double[])data.sensorPos);
        data.rangeIndex = !this.srgrFlag ? (data.slantRange - this.nearEdgeSlantRange) / this.rangeSpacing : SARGeocoding.computeRangeIndex((boolean)this.srgrFlag, (int)this.sourceImageWidth, (double)this.firstLineUTC, (double)this.lastLineUTC, (double)this.rangeSpacing, (double)zeroDopplerTimeWithoutBias, (double)data.slantRange, (double)this.nearEdgeSlantRange, (AbstractMetadata.SRGRCoefficientList[])this.srgrConvParams);
        if (data.rangeIndex <= 0.0) {
            return false;
        }
        if (!this.nearRangeOnLeft) {
            data.rangeIndex = (double)(this.sourceImageWidth - 1) - data.rangeIndex;
        }
        return data.rangeIndex >= (double)x0 && data.rangeIndex < (double)(x0 + w);
    }

    private void computeImageGeoBoundary(int xmin, int xmax, int ymin, int ymax, double[] latLonMinMax) throws Exception {
        GeoCoding geoCoding = this.sourceProduct.getGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("Product does not contain a geocoding");
        }
        GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos((float)xmin, (float)ymin), null);
        GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((float)xmax, (float)ymin), null);
        GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos((float)xmin, (float)ymax), null);
        GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((float)xmax, (float)ymax), null);
        double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
        double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
        double latMin = 90.0;
        double latMax = -90.0;
        for (double lat : lats) {
            if (lat < latMin) {
                latMin = lat;
            }
            if (!(lat > latMax)) continue;
            latMax = lat;
        }
        double lonMin = 180.0;
        double lonMax = -180.0;
        for (double lon : lons) {
            if (lon < lonMin) {
                lonMin = lon;
            }
            if (!(lon > lonMax)) continue;
            lonMax = lon;
        }
        latLonMinMax[0] = latMin;
        latLonMinMax[1] = latMax;
        latLonMinMax[2] = lonMin;
        latLonMinMax[3] = lonMax;
    }

    private void computeDEMTraversalSampleInterval() throws Exception {
        double[] latLonMinMax = new double[4];
        this.computeImageGeoBoundary(0, this.sourceImageWidth - 1, 0, this.sourceImageHeight - 1, latLonMinMax);
        double groundRangeSpacing = SARGeocoding.getRangePixelSpacing((Product)this.sourceProduct);
        double azimuthPixelSpacing = SARGeocoding.getAzimuthPixelSpacing((Product)this.sourceProduct);
        double spacing = Math.min(groundRangeSpacing, azimuthPixelSpacing);
        double latMin = latLonMinMax[0];
        double latMax = latLonMinMax[1];
        double minAbsLat = latMin * latMax > 0.0 ? Math.min(Math.abs(latMin), Math.abs(latMax)) * (Math.PI / 180) : 0.0;
        this.delLat = spacing / 6371008.7714 * 57.29577951308232;
        this.delLon = spacing / (6371008.7714 * Math.cos(minAbsLat)) * 57.29577951308232;
        this.delLon = this.delLat = Math.min(this.delLat, this.delLon);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(UpdateGeoRefOp.class);
        }
    }

    private static class PositionData {
        final double[] earthPoint = new double[3];
        final double[] sensorPos = new double[3];
        double azimuthIndex;
        double rangeIndex;
        double slantRange;

        private PositionData() {
        }
    }
}

