/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.esa.beam.util.io.FileUtils;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.util.FileIOUtils;

public class ProductFileHandler {
    private static final String[] singleFileExt = new String[]{"n1", "e1", "e2", "tif", "tiff", "zip"};
    private static final String[] folderExt = new String[]{"safe"};
    private static final String[] folderMissions = new String[]{"RS2", "TSX", "TDX", "CSKS1", "CSKS2", "CSKS3", "CSKS4", "ALOS", "JERS1", "RS1"};

    public static boolean canMove(ProductEntry entry) {
        return ProductFileHandler.isDimap(entry) || ProductFileHandler.isFolderProduct(entry) || ProductFileHandler.isSingleFile(entry) || ProductFileHandler.isSMOS(entry);
    }

    public static void copyTo(ProductEntry entry, File targetFolder) throws Exception {
        if (ProductFileHandler.isSingleFile(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.copy(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (ProductFileHandler.isDimap(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.copy(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            String dataFolderName = entry.getFile().getName().replace(".dim", ".data");
            File oldDataFolder = new File(entry.getFile().getParentFile(), dataFolderName);
            File newDataFolder = new File(targetFolder, dataFolderName);
            FileIOUtils.copyFolder((Path)oldDataFolder.toPath(), (Path)newDataFolder.toPath());
        } else if (ProductFileHandler.isSMOS(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.copy(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File hdrFile = FileUtils.exchangeExtension((File)entry.getFile(), (String)".HDR");
            File newHdrFile = new File(targetFolder, hdrFile.getName());
            Files.copy(hdrFile.toPath(), newHdrFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (ProductFileHandler.isFolderProduct(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getParentFile().getName());
            FileIOUtils.copyFolder((Path)entry.getFile().getParentFile().toPath(), (Path)newFile.toPath());
        }
    }

    public static void moveTo(ProductEntry entry, File targetFolder) throws Exception {
        if (ProductFileHandler.isSingleFile(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.move(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        } else if (ProductFileHandler.isDimap(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.move(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            String dataFolderName = entry.getFile().getName().replace(".dim", ".data");
            File oldDataFolder = new File(entry.getFile().getParentFile(), dataFolderName);
            File newDataFolder = new File(targetFolder, dataFolderName);
            FileIOUtils.moveFolder((Path)oldDataFolder.toPath(), (Path)newDataFolder.toPath());
        } else if (ProductFileHandler.isSMOS(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.move(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            File hdrFile = FileUtils.exchangeExtension((File)entry.getFile(), (String)".HDR");
            File newHdrFile = new File(targetFolder, hdrFile.getName());
            Files.move(hdrFile.toPath(), newHdrFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        } else if (ProductFileHandler.isFolderProduct(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getParentFile().getName());
            FileIOUtils.moveFolder((Path)entry.getFile().getParentFile().toPath(), (Path)newFile.toPath());
        }
    }

    public static void delete(ProductEntry entry) throws Exception {
        if (ProductFileHandler.isDimap(entry)) {
            Files.delete(entry.getFile().toPath());
            String dataFolderName = entry.getFile().getName().replace(".dim", ".data");
            File dataFolder = new File(entry.getFile().getParentFile(), dataFolderName);
            FileIOUtils.deleteFolder((Path)dataFolder.toPath());
        } else if (ProductFileHandler.isSMOS(entry)) {
            Files.delete(entry.getFile().toPath());
            File hdrFile = FileUtils.exchangeExtension((File)entry.getFile(), (String)".HDR");
            Files.delete(hdrFile.toPath());
        } else if (ProductFileHandler.isFolderProduct(entry)) {
            FileIOUtils.deleteFolder((Path)entry.getFile().getParentFile().toPath());
        } else if (ProductFileHandler.isSingleFile(entry)) {
            Files.delete(entry.getFile().toPath());
        }
    }

    private static boolean isDimap(ProductEntry entry) {
        return entry.getFile().getName().endsWith(".dim");
    }

    private static boolean isSMOS(ProductEntry entry) {
        return entry.getFile().getName().toUpperCase().endsWith("DBL");
    }

    private static boolean isSingleFile(ProductEntry entry) {
        String fileName = entry.getFile().getName().toLowerCase();
        for (String ext : singleFileExt) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFolderProduct(ProductEntry entry) {
        String mission = entry.getMission();
        for (String folderMission : folderMissions) {
            if (!mission.equals(folderMission)) continue;
            return true;
        }
        String fileName = entry.getFile().getName().toLowerCase();
        for (String ext : folderExt) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return (mission.equals("ERS1") || mission.equals("ERS2")) && !ProductFileHandler.isSingleFile(entry);
    }
}

