/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.toolviews.productlibrary.ProductFileHandler;
import org.esa.nest.dat.toolviews.productlibrary.ProductLibraryToolView;
import org.esa.nest.dat.toolviews.productlibrary.model.SortingDecorator;
import org.esa.nest.dat.utils.ProductOpener;
import org.esa.snap.dat.dialogs.BatchGraphDialog;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.util.ClipboardUtils;
import org.esa.snap.util.DialogUtils;
import org.esa.snap.util.ResourceUtils;
import org.jlinda.nest.dat.dialogs.InSARMasterDialog;

public class ProductLibraryActions {
    private static final ImageIcon selectAllIcon = UIUtils.loadImageIcon((String)"/org/esa/nest/icons/select-all24.png", ProductLibraryToolView.class);
    private static final ImageIcon openIcon = UIUtils.loadImageIcon((String)"/org/esa/nest/icons/open24.png", ProductLibraryToolView.class);
    private static final ImageIcon copyIcon = UIUtils.loadImageIcon((String)"/org/esa/nest/icons/copy24.png", ProductLibraryToolView.class);
    private static final ImageIcon batchIcon = UIUtils.loadImageIcon((String)"/org/esa/nest/icons/batch24.png", ProductLibraryToolView.class);
    private static final ImageIcon stackIcon = UIUtils.loadImageIcon((String)"/org/esa/nest/icons/stack24.png", ProductLibraryToolView.class);
    private final JTable productEntryTable;
    private final ProductOpener openHandler;
    private JButton selectAllButton;
    private JButton openAllSelectedButton;
    private JButton copySelectedButton;
    private JButton batchProcessButton;
    private JButton stackButton;
    private JMenuItem copyToItem;
    private JMenuItem moveToItem;
    private JMenuItem deleteItem;
    private File currentDirectory;
    private final List<ProductLibraryActionListener> listenerList = new ArrayList<ProductLibraryActionListener>(1);

    public ProductLibraryActions(JTable productEntryTable) {
        this.productEntryTable = productEntryTable;
        this.openHandler = new ProductOpener(VisatApp.getApp());
    }

    public JPanel createCommandPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.selectAllButton = DialogUtils.createButton((String)"selectAllButton", (String)"Select all", (ImageIcon)selectAllIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performSelectAllAction();
            }
        });
        this.openAllSelectedButton = DialogUtils.createButton((String)"openAllSelectedButton", (String)"Open selected", (ImageIcon)openIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.openAllSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performOpenAction();
            }
        });
        this.copySelectedButton = DialogUtils.createButton((String)"copySelectedButton", (String)"Copy to clipboard", (ImageIcon)copyIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.copySelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performCopyAction();
            }
        });
        this.batchProcessButton = DialogUtils.createButton((String)"batchProcessButton", (String)"Batch", (ImageIcon)batchIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.batchProcessButton.setToolTipText("Right click to select a graph");
        this.batchProcessButton.setComponentPopupMenu(this.createGraphPopup());
        this.batchProcessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.batchProcess(ProductLibraryActions.this.getSelectedProductEntries(), null);
            }
        });
        this.stackButton = DialogUtils.createButton((String)"stackButton", (String)"Stack overview", (ImageIcon)stackIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.stackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performStackOverviewAction();
            }
        });
        panel.add(this.selectAllButton);
        panel.add(this.openAllSelectedButton);
        panel.add(this.copySelectedButton);
        panel.add(this.batchProcessButton);
        panel.add(this.stackButton);
        return panel;
    }

    private static void batchProcess(ProductEntry[] productEntryList, File graphFile) {
        BatchGraphDialog batchDlg = new BatchGraphDialog((AppContext)VisatApp.getApp(), "Batch Processing", "batchProcessing", false);
        batchDlg.setInputFiles(productEntryList);
        if (graphFile != null) {
            batchDlg.LoadGraphFile(graphFile);
        }
        batchDlg.show();
    }

    private void performStackOverviewAction() {
        InSARMasterDialog dialog = new InSARMasterDialog();
        dialog.setInputProductList(this.getSelectedProductEntries());
        dialog.show();
    }

    public void selectionEnabled(boolean enable) {
        this.openAllSelectedButton.setEnabled(enable);
        this.copySelectedButton.setEnabled(enable);
        this.batchProcessButton.setEnabled(enable);
        this.stackButton.setEnabled(enable && this.getNumberOfSelections() > 1);
    }

    private int getNumberOfSelections() {
        return this.productEntryTable.getSelectedRowCount();
    }

    public ProductEntry[] getSelectedProductEntries() {
        int[] selectedRows = this.productEntryTable.getSelectedRows();
        ProductEntry[] selectedEntries = new ProductEntry[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Object entry = this.productEntryTable.getValueAt(selectedRows[i], 0);
            if (!(entry instanceof ProductEntry)) continue;
            selectedEntries[i] = (ProductEntry)entry;
        }
        return selectedEntries;
    }

    public File[] getSelectedFiles() {
        int[] selectedRows = this.productEntryTable.getSelectedRows();
        File[] selectedFiles = new File[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Object entry = this.productEntryTable.getValueAt(selectedRows[i], 0);
            if (!(entry instanceof ProductEntry)) continue;
            selectedFiles[i] = ((ProductEntry)entry).getFile();
        }
        return selectedFiles;
    }

    private void performSelectAllAction() {
        this.productEntryTable.selectAll();
        this.notifySelectionChanged();
    }

    private void performCopyAction() {
        File[] fileList = this.getSelectedFiles();
        if (fileList.length != 0) {
            ClipboardUtils.copyToClipboard((File[])fileList);
        }
    }

    private void performCopyToAction() {
        ProductEntry[] entries;
        File targetFolder = this.promptForRepositoryBaseDir();
        if (targetFolder == null) {
            return;
        }
        for (ProductEntry entry : entries = this.getSelectedProductEntries()) {
            try {
                ProductFileHandler.copyTo(entry, targetFolder);
            }
            catch (Exception e) {
                VisatApp.getApp().showErrorDialog("Unable to copy file " + entry.getFile().getAbsolutePath() + '\n' + e.getMessage());
            }
        }
    }

    private void performMoveToAction() {
        ProductEntry[] entries;
        File targetFolder = this.promptForRepositoryBaseDir();
        if (targetFolder == null) {
            return;
        }
        for (ProductEntry entry : entries = this.getSelectedProductEntries()) {
            try {
                ProductFileHandler.moveTo(entry, targetFolder);
            }
            catch (Exception e) {
                VisatApp.getApp().showErrorDialog("Unable to move file " + entry.getFile().getAbsolutePath() + '\n' + e.getMessage());
            }
        }
        this.notifyDirectoryChanged();
    }

    private void performDeleteAction() {
        ProductEntry[] entries;
        for (ProductEntry entry : entries = this.getSelectedProductEntries()) {
            try {
                ProductFileHandler.delete(entry);
            }
            catch (Exception e) {
                VisatApp.getApp().showErrorDialog("Unable to delete file " + entry.getFile().getAbsolutePath() + '\n' + e.getMessage());
            }
        }
        this.notifyDirectoryChanged();
    }

    public void performOpenAction() {
        if (this.openHandler != null) {
            this.openHandler.openProducts(this.getSelectedFiles());
        }
    }

    public File promptForRepositoryBaseDir() {
        JFileChooser fileChooser = ProductLibraryActions.createDirectoryChooser();
        fileChooser.setCurrentDirectory(this.currentDirectory);
        int response = fileChooser.showOpenDialog((Component)VisatApp.getApp().getMainFrame());
        this.currentDirectory = fileChooser.getCurrentDirectory();
        File selectedDir = fileChooser.getSelectedFile();
        if (selectedDir != null && selectedDir.isFile()) {
            selectedDir = selectedDir.getParentFile();
        }
        if (response == 0) {
            return selectedDir;
        }
        return null;
    }

    private static JFileChooser createDirectoryChooser() {
        BeamFileChooser fileChooser = new BeamFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories";
            }
        });
        fileChooser.setDialogTitle("Select Directory");
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText("Select");
        fileChooser.setApproveButtonMnemonic('S');
        return fileChooser;
    }

    public JPopupMenu createEntryTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem selectAllItem = new JMenuItem("Select All");
        selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performSelectAllAction();
            }
        });
        popup.add(selectAllItem);
        JMenuItem openSelectedItem = new JMenuItem("Open Selected");
        openSelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performOpenAction();
            }
        });
        popup.add(openSelectedItem);
        JMenuItem copySelectedItem = new JMenuItem("Copy Selected");
        copySelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performCopyAction();
            }
        });
        popup.add(copySelectedItem);
        popup.addSeparator();
        this.copyToItem = new JMenuItem("Copy Selected Files To...");
        this.copyToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performCopyToAction();
            }
        });
        popup.add(this.copyToItem);
        this.moveToItem = new JMenuItem("Move Selected Files To...");
        this.moveToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performMoveToAction();
            }
        });
        popup.add(this.moveToItem);
        this.deleteItem = new JMenuItem("Delete Selected Files");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int status = VisatApp.getApp().showQuestionDialog("Are you sure you want to delete these products", "");
                if (status == 0) {
                    ProductLibraryActions.this.performDeleteAction();
                }
            }
        });
        popup.add(this.deleteItem);
        JMenuItem exploreItem = new JMenuItem("Browse Folder");
        exploreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object entry;
                Point pos = ProductLibraryActions.this.productEntryTable.getMousePosition();
                int row = 0;
                if (pos != null) {
                    row = ProductLibraryActions.this.productEntryTable.rowAtPoint(pos);
                }
                if ((entry = ProductLibraryActions.this.productEntryTable.getValueAt(row, 0)) != null && entry instanceof ProductEntry) {
                    ProductEntry prodEntry = (ProductEntry)entry;
                    try {
                        Desktop.getDesktop().open(prodEntry.getFile().getParentFile());
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                }
            }
        });
        popup.add(exploreItem);
        popup.addSeparator();
        JMenu sortMenu = new JMenu("Sort By");
        popup.add(sortMenu);
        sortMenu.add(this.createSortItem("Product Name", SortingDecorator.SORT_BY.NAME));
        sortMenu.add(this.createSortItem("Product Type", SortingDecorator.SORT_BY.TYPE));
        sortMenu.add(this.createSortItem("Acquisition Date", SortingDecorator.SORT_BY.DATE));
        sortMenu.add(this.createSortItem("Mission", SortingDecorator.SORT_BY.MISSON));
        sortMenu.add(this.createSortItem("File Size", SortingDecorator.SORT_BY.FILESIZE));
        return popup;
    }

    private JMenuItem createSortItem(String name, final SortingDecorator.SORT_BY sortBy) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableModel model = ProductLibraryActions.this.productEntryTable.getModel();
                if (model instanceof SortingDecorator) {
                    SortingDecorator sortedModel = (SortingDecorator)model;
                    sortedModel.sortBy(sortBy);
                }
            }
        });
        return item;
    }

    public JPopupMenu createGraphPopup() {
        File graphPath = ResourceUtils.getGraphFolder((String)"");
        JPopupMenu popup = new JPopupMenu();
        if (graphPath.exists()) {
            this.createGraphMenu(popup, graphPath);
        }
        return popup;
    }

    private void createGraphMenu(JPopupMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            menu.add(item);
        }
    }

    private void createGraphMenu(JMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            menu.add(item);
        }
    }

    public void updateContextMenu(ProductEntry[] selections) {
        boolean allValid = true;
        for (ProductEntry entry : selections) {
            if (ProductFileHandler.canMove(entry)) continue;
            allValid = false;
            break;
        }
        this.copyToItem.setEnabled(allValid);
        this.moveToItem.setEnabled(allValid);
        this.deleteItem.setEnabled(allValid);
    }

    public void addListener(ProductLibraryActionListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void notifyDirectoryChanged() {
        for (ProductLibraryActionListener listener : this.listenerList) {
            listener.notifyDirectoryChanged();
        }
    }

    private void notifySelectionChanged() {
        for (ProductLibraryActionListener listener : this.listenerList) {
            listener.notifySelectionChanged();
        }
    }

    public static interface ProductLibraryActionListener {
        public void notifyDirectoryChanged();

        public void notifySelectionChanged();
    }
}

