/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.CheckListDialog;
import org.esa.nest.dat.toolviews.productlibrary.DatabasePane;
import org.esa.nest.dat.toolviews.productlibrary.LabelBarProgressMonitor;
import org.esa.nest.dat.toolviews.productlibrary.ProductLibraryActions;
import org.esa.nest.dat.toolviews.productlibrary.WorldMapUI;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseQueryListener;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseStatistics;
import org.esa.nest.dat.toolviews.productlibrary.model.ProductEntryTableModel;
import org.esa.nest.dat.toolviews.productlibrary.model.ProductLibraryConfig;
import org.esa.nest.dat.toolviews.productlibrary.model.SortingDecorator;
import org.esa.nest.dat.toolviews.productlibrary.timeline.TimelinePanel;
import org.esa.nest.dat.utils.FileFolderUtils;
import org.esa.snap.db.DBScanner;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.util.DialogUtils;

public class ProductLibraryToolView
extends AbstractToolView
implements LabelBarProgressMonitor.ProgressBarListener,
DatabaseQueryListener,
ProductLibraryActions.ProductLibraryActionListener {
    private static final ImageIcon updateIcon = UIUtils.loadImageIcon((String)"/org/esa/nest/icons/refresh24.png", ProductLibraryToolView.class);
    private static final ImageIcon updateRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)updateIcon);
    private static final ImageIcon stopIcon = UIUtils.loadImageIcon((String)"icons/Stop24.gif");
    private static final ImageIcon stopRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)stopIcon);
    private static final ImageIcon addButtonIcon = UIUtils.loadImageIcon((String)"icons/Plus24.gif");
    private static final ImageIcon removeButtonIcon = UIUtils.loadImageIcon((String)"icons/Minus24.gif");
    private static final ImageIcon helpButtonIcon = UIUtils.loadImageIcon((String)"icons/Help24.gif");
    private JPanel mainPanel;
    private JComboBox repositoryListCombo;
    private JTable productEntryTable = new JTable();
    private JLabel statusLabel;
    private JPanel progressPanel;
    private JButton addToProjectButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton updateButton;
    private LabelBarProgressMonitor progMon;
    private JProgressBar progressBar;
    private ProductLibraryConfig libConfig;
    private static final String helpId = "productLibrary";
    private WorldMapUI worldMapUI = null;
    private DatabasePane dbPane;
    private ProductLibraryActions productLibraryActions;

    public void componentOpened() {
        this.dbPane.getDB();
    }

    public JComponent createControl() {
        this.libConfig = new ProductLibraryConfig(VisatApp.getApp().getPreferences());
        this.dbPane = new DatabasePane();
        this.dbPane.addListener(this);
        this.productLibraryActions = new ProductLibraryActions(this.productEntryTable);
        this.productLibraryActions.addListener(this);
        this.initUI();
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ProductLibraryToolView.this.progMon != null) {
                    ProductLibraryToolView.this.progMon.setCanceled(true);
                }
            }
        });
        this.applyConfig(this.libConfig);
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ProductLibraryToolView.this.libConfig.setWindowBounds(e.getComponent().getBounds());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ProductLibraryToolView.this.libConfig.setWindowBounds(e.getComponent().getBounds());
            }
        });
        this.setUIComponentsEnabled(this.repositoryListCombo.getItemCount() > 1);
        return this.mainPanel;
    }

    private void initUI() {
        JPanel northPanel = this.createHeaderPanel();
        JPanel centrePanel = this.createCentrePanel();
        JPanel southPanel = this.createStatusPanel();
        DatabaseStatistics stats = new DatabaseStatistics(this.dbPane);
        TimelinePanel timeLinePanel = new TimelinePanel(stats);
        this.dbPane.addListener(timeLinePanel);
        JSplitPane splitPane = new JSplitPane(0, centrePanel, (Component)((Object)timeLinePanel));
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.99);
        this.mainPanel = new JPanel(new BorderLayout(4, 4));
        this.mainPanel.add((Component)northPanel, "North");
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.add((Component)southPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }

    private JPanel createHeaderPanel() {
        JPanel headerBar = new JPanel();
        headerBar.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        this.updateButton = DialogUtils.createButton((String)"updateButton", (String)"Rescan folder", (ImageIcon)updateIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.updateButton.setActionCommand("update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("stop")) {
                    ProductLibraryToolView.this.updateButton.setEnabled(false);
                    ProductLibraryToolView.this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                    ProductLibraryToolView.this.progMon.setCanceled(true);
                } else {
                    ProductLibraryToolView.this.rescanFolder();
                }
            }
        });
        headerBar.add((Component)this.updateButton, gbc);
        headerBar.add(new JLabel("Folder:"));
        gbc.weightx = 99.0;
        this.repositoryListCombo = new JComboBox();
        this.repositoryListCombo.setName(this.getClass().getName() + "repositoryListCombo");
        this.repositoryListCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Object selectedItem = ProductLibraryToolView.this.repositoryListCombo.getSelectedItem();
                    if (selectedItem instanceof File) {
                        ProductLibraryToolView.this.dbPane.setBaseDir((File)selectedItem);
                    } else {
                        ProductLibraryToolView.this.dbPane.setBaseDir(null);
                    }
                }
            }
        });
        headerBar.add((Component)this.repositoryListCombo, gbc);
        gbc.weightx = 0.0;
        this.addButton = DialogUtils.createButton((String)"addButton", (String)"Add folder", (ImageIcon)addButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.addRepository();
            }
        });
        headerBar.add((Component)this.addButton, gbc);
        this.removeButton = DialogUtils.createButton((String)"removeButton", (String)"Remove folder", (ImageIcon)removeButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.removeRepository();
            }
        });
        headerBar.add((Component)this.removeButton, gbc);
        JButton helpButton = DialogUtils.createButton((String)"helpButton", (String)"Help", (ImageIcon)helpButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        HelpSys.enableHelpOnButton((Component)helpButton, (String)helpId);
        headerBar.add((Component)helpButton, gbc);
        return headerBar;
    }

    private JPanel createStatusPanel() {
        JPanel southPanel = new JPanel(new BorderLayout(4, 4));
        this.statusLabel = new JLabel("");
        this.statusLabel.setMinimumSize(new Dimension(100, 10));
        southPanel.add((Component)this.statusLabel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.progressPanel.setVisible(false);
        southPanel.add((Component)this.progressPanel, "East");
        return southPanel;
    }

    private JPanel createCentrePanel() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setMinimumSize(new Dimension(200, 577));
        leftPanel.add((Component)this.dbPane, "North");
        this.productEntryTable.setAutoResizeMode(3);
        this.productEntryTable.setSelectionMode(2);
        this.productEntryTable.setComponentPopupMenu(this.productLibraryActions.createEntryTablePopup());
        this.productEntryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    ProductLibraryToolView.this.productLibraryActions.performOpenAction();
                } else if (clickCount == 1) {
                    ProductLibraryToolView.this.notifySelectionChanged();
                }
            }
        });
        JPanel commandPanel = this.productLibraryActions.createCommandPanel();
        JScrollPane tablePane = new JScrollPane(this.productEntryTable);
        tablePane.setMinimumSize(new Dimension(400, 400));
        this.worldMapUI = new WorldMapUI();
        this.worldMapUI.addListener(this);
        JSplitPane splitPaneV = new JSplitPane(0, tablePane, (Component)this.worldMapUI.getWorlMapPane());
        splitPaneV.setOneTouchExpandable(true);
        splitPaneV.setResizeWeight(0.8);
        JPanel centrePanel = new JPanel(new BorderLayout());
        centrePanel.add((Component)leftPanel, "West");
        centrePanel.add((Component)splitPaneV, "Center");
        centrePanel.add((Component)commandPanel, "East");
        return centrePanel;
    }

    private void applyConfig(ProductLibraryConfig config) {
        File[] baseDirList = config.getBaseDirs();
        this.repositoryListCombo.insertItemAt("All_Folders", 0);
        for (File f : baseDirList) {
            this.repositoryListCombo.insertItemAt(f, this.repositoryListCombo.getItemCount());
        }
        if (baseDirList.length > 0) {
            this.repositoryListCombo.setSelectedIndex(0);
        }
    }

    private void addRepository() {
        File baseDir = this.productLibraryActions.promptForRepositoryBaseDir();
        if (baseDir == null) {
            return;
        }
        HashMap<String, Boolean> checkBoxMap = new HashMap<String, Boolean>(3);
        checkBoxMap.put("Generate quicklooks?", false);
        checkBoxMap.put("Search folder recursively?", true);
        CheckListDialog dlg = new CheckListDialog("Scan Folder Options", checkBoxMap);
        dlg.show();
        boolean doRecursive = (Boolean)checkBoxMap.get("Search folder recursively?");
        boolean doQuicklooks = (Boolean)checkBoxMap.get("Generate quicklooks?");
        this.libConfig.addBaseDir(baseDir);
        int index = this.repositoryListCombo.getItemCount();
        this.repositoryListCombo.insertItemAt(baseDir, index);
        this.setUIComponentsEnabled(this.repositoryListCombo.getItemCount() > 1);
        this.updateRepostitory(baseDir, doRecursive, doQuicklooks);
    }

    private void updateRepostitory(File baseDir, boolean doRecursive, boolean doQuicklooks) {
        if (baseDir == null) {
            return;
        }
        this.progMon = new LabelBarProgressMonitor(this.progressBar, this.statusLabel);
        this.progMon.addListener(this);
        DBScanner scanner = new DBScanner(this.dbPane.getDB(), baseDir, doRecursive, doQuicklooks, (ProgressMonitor)this.progMon);
        scanner.addListener((DBScanner.DBScannerListener)new MyDatabaseScannerListener());
        scanner.execute();
    }

    private void removeRepository() {
        Object selectedItem = this.repositoryListCombo.getSelectedItem();
        int index = this.repositoryListCombo.getSelectedIndex();
        if (index == 0) {
            int status = VisatApp.getApp().showQuestionDialog("This will remove all folders and products from the database.\nAre you sure you wish to continue?", null);
            if (status == 1) {
                return;
            }
            while (this.repositoryListCombo.getItemCount() > 1) {
                File baseDir = (File)this.repositoryListCombo.getItemAt(1);
                this.libConfig.removeBaseDir(baseDir);
                this.repositoryListCombo.removeItemAt(1);
                this.dbPane.removeProducts(baseDir);
            }
            try {
                this.dbPane.getDB().removeAllProducts();
            }
            catch (Exception e) {
                System.out.println("Failed to remove all products");
            }
        } else if (selectedItem instanceof File) {
            File baseDir = (File)selectedItem;
            int status = VisatApp.getApp().showQuestionDialog("This will remove all products within " + baseDir.getAbsolutePath() + " from the database\n" + "Are you sure you wish to continue?", null);
            if (status == 1) {
                return;
            }
            this.libConfig.removeBaseDir(baseDir);
            this.repositoryListCombo.removeItemAt(index);
            this.dbPane.removeProducts(baseDir);
        }
        this.setUIComponentsEnabled(this.repositoryListCombo.getItemCount() > 1);
        this.UpdateUI();
    }

    private void setUIComponentsEnabled(boolean enable) {
        this.removeButton.setEnabled(enable);
        this.updateButton.setEnabled(enable);
        this.repositoryListCombo.setEnabled(enable);
    }

    private void toggleUpdateButton(String command) {
        if (command.equals("stop")) {
            this.updateButton.setIcon(stopIcon);
            this.updateButton.setRolloverIcon(stopRolloverIcon);
            this.updateButton.setActionCommand("stop");
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.updateButton.setIcon(updateIcon);
            this.updateButton.setRolloverIcon(updateRolloverIcon);
            this.updateButton.setActionCommand("update");
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    public void UpdateUI() {
        this.dbPane.refresh();
        this.productEntryTable.updateUI();
    }

    private void rescanFolder() {
        if (this.repositoryListCombo.getSelectedIndex() != 0) {
            this.updateRepostitory((File)this.repositoryListCombo.getSelectedItem(), true, true);
        } else {
            File[] baseDirList;
            for (File f : baseDirList = this.libConfig.getBaseDirs()) {
                this.updateRepostitory(f, true, true);
            }
        }
    }

    private void updateStatusLabel() {
        String selectedText = "";
        int selecteRows = this.productEntryTable.getSelectedRowCount();
        this.productLibraryActions.selectionEnabled(selecteRows > 0);
        if (selecteRows > 0) {
            selectedText = ", " + selecteRows + " Selected";
        } else {
            this.dbPane.updateProductSelectionText(null);
        }
        this.statusLabel.setText(this.productEntryTable.getRowCount() + " Products" + selectedText);
    }

    public void ShowRepository(ProductEntry[] productEntryList) {
        ProductEntryTableModel tableModel = new ProductEntryTableModel(productEntryList);
        this.productEntryTable.setModel(new SortingDecorator(tableModel, this.productEntryTable.getTableHeader()));
        this.productEntryTable.setColumnModel(tableModel.getColumnModel());
        this.updateStatusLabel();
        this.worldMapUI.setProductEntryList(productEntryList);
        this.worldMapUI.setSelectedProductEntryList(null);
    }

    private static void handleErrorList(List<DBScanner.ErrorFile> errorList) {
        StringBuilder str = new StringBuilder();
        int cnt = 1;
        for (DBScanner.ErrorFile err : errorList) {
            str.append(err.message);
            str.append("   ");
            str.append(err.file.getAbsolutePath());
            str.append('\n');
            if (cnt >= 20) {
                str.append("plus " + (errorList.size() - 20) + " other errors...\n");
                break;
            }
            ++cnt;
        }
        String question = "\nWould you like to save the list to a text file?";
        if (VisatApp.getApp().showQuestionDialog("Product Errors", "The follow files have errors:\n" + str.toString() + "\nWould you like to save the list to a text file?", null) == 0) {
            File file = FileFolderUtils.GetSaveFilePath((String)"Save as...", (String)"Text", (String)"txt", (String)"ProductErrorList", (String)"Products with errors");
            try {
                ProductLibraryToolView.writeErrors(errorList, file);
            }
            catch (Exception e) {
                VisatApp.getApp().showErrorDialog("Unable to save to " + file.getAbsolutePath());
                file = FileFolderUtils.GetSaveFilePath((String)"Save as...", (String)"Text", (String)"txt", (String)"ProductErrorList", (String)"Products with errors");
                try {
                    ProductLibraryToolView.writeErrors(errorList, file);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (Desktop.isDesktopSupported() && file.exists()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeErrors(List<DBScanner.ErrorFile> errorList, File file) throws Exception {
        if (file == null) {
            return;
        }
        try (PrintStream p = null;){
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
            p = new PrintStream(out);
            for (DBScanner.ErrorFile err : errorList) {
                p.println(err.message + "   " + err.file.getAbsolutePath());
            }
        }
    }

    @Override
    public void notifyStart() {
        this.progressPanel.setVisible(true);
        this.toggleUpdateButton("stop");
    }

    @Override
    public void notifyDone() {
        this.progressPanel.setVisible(false);
        this.toggleUpdateButton("update");
        this.updateButton.setEnabled(true);
        this.mainPanel.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void notifyNewEntryListAvailable() {
        this.ShowRepository(this.dbPane.getProductEntryList());
    }

    @Override
    public void notifyNewMapSelectionAvailable() {
        this.dbPane.setSelectionRect(this.worldMapUI.getSelectionBox());
    }

    @Override
    public void notifyDirectoryChanged() {
        this.rescanFolder();
        this.UpdateUI();
    }

    @Override
    public void notifySelectionChanged() {
        this.updateStatusLabel();
        ProductEntry[] selections = this.productLibraryActions.getSelectedProductEntries();
        this.productLibraryActions.selectionEnabled(selections.length > 0);
        this.productLibraryActions.updateContextMenu(selections);
        this.dbPane.updateProductSelectionText(selections);
        this.worldMapUI.setSelectedProductEntryList(selections);
    }

    private class MyDatabaseScannerListener
    implements DBScanner.DBScannerListener {
        private MyDatabaseScannerListener() {
        }

        public void notifyMSG(DBScanner dbScanner, DBScanner.DBScannerListener.MSG msg) {
            List errorList;
            if (msg.equals((Object)DBScanner.DBScannerListener.MSG.DONE) && !(errorList = dbScanner.getErrorList()).isEmpty()) {
                ProductLibraryToolView.handleErrorList(errorList);
            }
            ProductLibraryToolView.this.UpdateUI();
        }
    }
}

