/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.MouseInputAdapter;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseQueryListener;
import org.esa.snap.db.GeoPosList;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.gpf.ui.worldmap.NestWorldMapPane;
import org.esa.snap.gpf.ui.worldmap.NestWorldMapPaneDataModel;

public class WorldMapUI {
    private final NestWorldMapPaneDataModel worldMapDataModel;
    private final NestWorldMapPane worlMapPane;
    private final List<DatabaseQueryListener> listenerList = new ArrayList<DatabaseQueryListener>(1);

    public WorldMapUI() {
        this.worldMapDataModel = new NestWorldMapPaneDataModel();
        this.worlMapPane = new NestWorldMapPane(this.worldMapDataModel);
        this.worlMapPane.getLayerCanvas().addMouseListener((MouseListener)new MouseHandler());
    }

    public void addListener(DatabaseQueryListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public GeoPos[] getSelectionBox() {
        return this.worldMapDataModel.getSelectionBox();
    }

    public void setSelectionStart(float lat, float lon) {
        this.worldMapDataModel.setSelectionBoxStart(lat, lon);
    }

    public void setSelectionEnd(float lat, float lon) {
        this.worldMapDataModel.setSelectionBoxEnd(lat, lon);
    }

    public void removeListener(DatabaseQueryListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyQuery() {
        for (DatabaseQueryListener listener : this.listenerList) {
            listener.notifyNewMapSelectionAvailable();
        }
    }

    public NestWorldMapPane getWorlMapPane() {
        return this.worlMapPane;
    }

    public void setAOIList(GeoPosList[] aoiList) {
        GeoPos[][] geoBoundaries = new GeoPos[aoiList.length][4];
        int i = 0;
        for (GeoPosList aoi : aoiList) {
            geoBoundaries[i++] = aoi.getPoints();
        }
        this.worldMapDataModel.setAdditionalGeoBoundaries(geoBoundaries);
    }

    public void setSelectedAOIList(GeoPosList[] selectedAOIList) {
        GeoPos[][] geoBoundaries = new GeoPos[selectedAOIList.length][4];
        int i = 0;
        for (GeoPosList aoi : selectedAOIList) {
            geoBoundaries[i++] = aoi.getPoints();
        }
        this.worldMapDataModel.setSelectedGeoBoundaries(geoBoundaries);
    }

    public void setProductEntryList(ProductEntry[] productEntryList) {
        if (productEntryList == null) {
            return;
        }
        GeoPos[][] geoBoundaries = new GeoPos[productEntryList.length][4];
        int i = 0;
        for (ProductEntry entry : productEntryList) {
            geoBoundaries[i++] = entry.getGeoBoundary();
        }
        this.worldMapDataModel.setAdditionalGeoBoundaries(geoBoundaries);
    }

    public void setSelectedProductEntryList(ProductEntry[] selectedProductEntryList) {
        if (selectedProductEntryList == null) {
            this.worldMapDataModel.setSelectedGeoBoundaries((GeoPos[][])null);
            return;
        }
        GeoPos[][] geoBoundaries = new GeoPos[selectedProductEntryList.length][4];
        int i = 0;
        for (ProductEntry entry : selectedProductEntryList) {
            geoBoundaries[i++] = entry.getGeoBoundary();
        }
        this.worldMapDataModel.setSelectedGeoBoundaries(geoBoundaries);
    }

    public NestWorldMapPaneDataModel getModel() {
        return this.worldMapDataModel;
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                WorldMapUI.this.notifyQuery();
            }
        }
    }
}

