/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.nest.dat.toolviews.productlibrary.DatabasePane;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseQueryListener;
import org.esa.snap.db.ProductEntry;

public class DatabaseStatistics
implements DatabaseQueryListener {
    private final DatabasePane dbPane;
    private final Map<Integer, YearData> yearDataMap = new HashMap<Integer, YearData>(30);
    private Integer overallMaxYearCnt = 0;
    private Integer overallMaxDayCnt = 0;
    private MonthData monthData;

    public DatabaseStatistics(DatabasePane dbPane) {
        this.dbPane = dbPane;
        dbPane.addListener(this);
    }

    @Override
    public void notifyNewEntryListAvailable() {
        this.updateStats(this.dbPane.getProductEntryList());
    }

    @Override
    public void notifyNewMapSelectionAvailable() {
    }

    private void updateStats(ProductEntry[] entryList) {
        if (entryList == null) {
            return;
        }
        this.yearDataMap.clear();
        this.monthData = new MonthData();
        for (ProductEntry entry : entryList) {
            ProductData.UTC utc = entry.getFirstLineTime();
            int year = utc.getAsCalendar().get(1);
            YearData yData = this.yearDataMap.get(year);
            if (yData == null) {
                yData = new YearData(year);
                this.yearDataMap.put(year, yData);
            }
            int dayOfYear = utc.getAsCalendar().get(6);
            yData.addDayOfYear(dayOfYear);
            int month = utc.getAsCalendar().get(2);
            this.monthData.add(month);
        }
        this.overallMaxYearCnt = 0;
        this.overallMaxDayCnt = 0;
        for (Integer year : this.yearDataMap.keySet()) {
            YearData yData = this.yearDataMap.get(year);
            int cnt = yData.yearCnt;
            int dayCnt = yData.maxDayCnt;
            if (cnt > this.overallMaxYearCnt) {
                this.overallMaxYearCnt = cnt;
            }
            if (dayCnt <= this.overallMaxDayCnt) continue;
            this.overallMaxDayCnt = dayCnt;
        }
    }

    public Map<Integer, YearData> getYearDataMap() {
        return this.yearDataMap;
    }

    public MonthData getMonthData() {
        return this.monthData;
    }

    public int getOverallMaxYearCnt() {
        return this.overallMaxYearCnt;
    }

    public int getOverallMaxDayCnt() {
        return this.overallMaxDayCnt;
    }

    private void showStats() {
        TreeSet<Integer> years = new TreeSet<Integer>(this.yearDataMap.keySet());
        System.out.print("Year: ");
        for (Integer y : years) {
            System.out.print(y + "= " + this.yearDataMap.get((Object)y).yearCnt + "  ");
        }
        System.out.println();
        Set<Integer> months = this.monthData.getMonthSet();
        System.out.print("Month: ");
        for (Integer m : months) {
            System.out.print(m + "= " + this.monthData.get(m) + "  ");
        }
        System.out.println();
        for (Integer y : years) {
            Map<Integer, Integer> dayOfYear = this.yearDataMap.get((Object)y).dayOfYearMap;
            Set<Integer> days = dayOfYear.keySet();
            System.out.print(y + ": ");
            for (Integer d : days) {
                Integer dayCnt = dayOfYear.get(d);
                if (dayCnt == 0) continue;
                System.out.print(d + "=" + dayCnt + " ");
            }
            System.out.println();
        }
    }

    public class MonthData {
        private int maxMonthCnt = 0;
        private final Map<Integer, Integer> monthMap = new HashMap<Integer, Integer>(12);

        MonthData() {
            for (int m = 0; m < 12; ++m) {
                this.monthMap.put(m, 0);
            }
        }

        public void add(Integer month) {
            Integer monthCnt = this.monthMap.get(month);
            if (monthCnt != null) {
                if ((monthCnt = Integer.valueOf(monthCnt + 1)) > this.maxMonthCnt) {
                    this.maxMonthCnt = monthCnt;
                }
                this.monthMap.put(month, monthCnt);
            }
        }

        public Set<Integer> getMonthSet() {
            return this.monthMap.keySet();
        }

        public Integer get(Integer m) {
            return this.monthMap.get(m);
        }

        public int getMaxMonthCnt() {
            return this.maxMonthCnt;
        }

        public void setSelected(int m, boolean selected) {
            DatabaseStatistics.this.dbPane.getDBQuery().setMonthSelected(m, selected);
            DatabaseStatistics.this.dbPane.queryDatabase();
        }

        public boolean isSelected(int m) {
            return DatabaseStatistics.this.dbPane.getDBQuery().isMonthSelected(m);
        }
    }

    public static class YearData {
        public final int year;
        public int yearCnt = 0;
        public int maxDayCnt = 0;
        public final Map<Integer, Integer> dayOfYearMap = new HashMap<Integer, Integer>(365);
        private boolean isSelected = true;

        YearData(int year) {
            this.year = year;
            for (int d = 1; d < 366; ++d) {
                this.dayOfYearMap.put(d, 0);
            }
        }

        void addDayOfYear(int dayOfYear) {
            Integer dayOfYearCnt = this.dayOfYearMap.get(dayOfYear);
            dayOfYearCnt = dayOfYearCnt == null ? Integer.valueOf(1) : Integer.valueOf(dayOfYearCnt + 1);
            this.dayOfYearMap.put(dayOfYear, dayOfYearCnt);
            if (dayOfYearCnt > this.maxDayCnt) {
                this.maxDayCnt = dayOfYearCnt;
            }
            ++this.yearCnt;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }
    }
}

