/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary.model;

import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.visat.VisatApp;

public class ProductLibraryConfig {
    private static final String WINDOW_LOCATION_X_KEY = "productLibrary.window.locationX";
    private static final String WINDOW_LOCATION_Y_KEY = "productLibrary.window.locationY";
    private static final String WINDOW_WIDTH_KEY = "productLibrary.window.width";
    private static final String WINDOW_HEIGHT_KEY = "productLibrary.window.height";
    private static final String BASE_DIR = "BaseDir_";
    private final PropertyMap properties;

    public ProductLibraryConfig(PropertyMap configuration) {
        Guardian.assertNotNull((String)"configuration", (Object)configuration);
        this.properties = configuration;
    }

    public void addBaseDir(File baseDir) {
        this.properties.setPropertyString(BASE_DIR + baseDir.getAbsolutePath(), baseDir.getAbsolutePath());
        VisatApp.getApp().savePreferences();
    }

    public void removeBaseDir(File baseDir) {
        this.properties.setPropertyString(BASE_DIR + baseDir.getAbsolutePath(), null);
        VisatApp.getApp().savePreferences();
    }

    public File[] getBaseDirs() {
        ArrayList<File> dirList = new ArrayList<File>();
        Set<Object> keys = this.properties.getProperties().keySet();
        for (Object o : keys) {
            File file;
            String path;
            String key;
            if (!(o instanceof String) || !(key = (String)o).startsWith(BASE_DIR) || (path = this.properties.getPropertyString(key)) == null || !(file = new File(path)).exists()) continue;
            dirList.add(file);
        }
        return dirList.toArray(new File[dirList.size()]);
    }

    public void setWindowBounds(Rectangle windowBounds) {
        this.properties.setPropertyInt(WINDOW_LOCATION_X_KEY, windowBounds.x);
        this.properties.setPropertyInt(WINDOW_LOCATION_Y_KEY, windowBounds.y);
        this.properties.setPropertyInt(WINDOW_WIDTH_KEY, windowBounds.width);
        this.properties.setPropertyInt(WINDOW_HEIGHT_KEY, windowBounds.height);
    }

    public Rectangle getWindowBounds() {
        int x = this.properties.getPropertyInt(WINDOW_LOCATION_X_KEY, 50);
        int y = this.properties.getPropertyInt(WINDOW_LOCATION_Y_KEY, 50);
        int width = this.properties.getPropertyInt(WINDOW_WIDTH_KEY, 700);
        int height = this.properties.getPropertyInt(WINDOW_HEIGHT_KEY, 450);
        return new Rectangle(x, y, width, height);
    }
}

