/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary.model.dataprovider;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.esa.nest.dat.toolviews.productlibrary.model.dataprovider.DataProvider;
import org.esa.snap.db.ProductEntry;

public class IDProvider
implements DataProvider {
    private final Comparator comparator = new IntComparator();
    private TableColumn column;

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public TableColumn getTableColumn() {
        if (this.column == null) {
            try {
                this.column = new TableColumn();
                this.column.setHeaderValue("ID");
                this.column.setPreferredWidth(34);
                this.column.setResizable(true);
                this.column.setCellRenderer(new IDCellRenderer());
            }
            catch (Throwable e) {
                System.out.println("IDProvider: " + e.getMessage());
            }
        }
        return this.column;
    }

    private static class IntComparator
    implements Comparator {
        private IntComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ProductEntry s1 = (ProductEntry)o1;
            ProductEntry s2 = (ProductEntry)o2;
            if (s1.getId() < s2.getId()) {
                return -1;
            }
            return 1;
        }
    }

    private static class IDCellRenderer
    extends DefaultTableCellRenderer {
        private IDCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                ProductEntry entry = (ProductEntry)value;
                if (entry != null) {
                    String text = String.valueOf(entry.getId());
                    JLabel jlabel = (JLabel)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                    jlabel.setFont(jlabel.getFont());
                    jlabel.setToolTipText(entry.getFile().getAbsolutePath());
                    return jlabel;
                }
            }
            catch (Throwable e) {
                System.out.println("IDCellRenderer: " + e.getMessage());
            }
            return null;
        }
    }
}

