/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary.timeline;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Set;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseStatistics;
import org.esa.nest.dat.toolviews.productlibrary.timeline.TimelinePlot;

class MonthsPlot
extends TimelinePlot {
    private final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    MonthsPlot(DatabaseStatistics stats) {
        super(stats);
    }

    @Override
    protected void paintPlot(Graphics2D g2d) {
        DatabaseStatistics.MonthData monthData = this.stats.getMonthData();
        Set<Integer> months = monthData.getMonthSet();
        int numMonths = months.size();
        int maxMonthCnt = monthData.getMaxMonthCnt();
        int w = this.getWidth();
        int h = this.getHeight() - 15;
        this.interval = (float)w / (float)numMonths;
        float halfInterval = this.interval / 2.0f;
        float barWidth = halfInterval / 2.0f;
        int y = this.getHeight() - 2;
        float x = halfInterval;
        for (Integer month : months) {
            MonthsPlot.drawButton(g2d, this.monthNames[month], (int)x - 10, y, monthData.isSelected(month));
            float newH = (float)monthData.get(month).intValue() / (float)maxMonthCnt * (float)h;
            MonthsPlot.drawBar(g2d, (int)(x - barWidth), h - (int)newH, (int)halfInterval, (int)newH, h);
            x += this.interval;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DatabaseStatistics.MonthData monthData;
        int x = (int)((float)e.getX() / this.interval);
        monthData.setSelected(x, !(monthData = this.stats.getMonthData()).isSelected(x));
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int x = (int)((float)event.getX() / this.interval);
        Set<Integer> monthSet = this.stats.getMonthData().getMonthSet();
        Integer[] months = monthSet.toArray(new Integer[monthSet.size()]);
        int value = this.stats.getMonthData().get(x);
        if (value == 0) {
            return "";
        }
        return this.monthNames[months[x]] + ": " + value;
    }
}

