/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.productlibrary.timeline;

import com.alee.laf.panel.WebPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseQueryListener;
import org.esa.nest.dat.toolviews.productlibrary.model.DatabaseStatistics;
import org.esa.nest.dat.toolviews.productlibrary.timeline.MonthsPlot;
import org.esa.nest.dat.toolviews.productlibrary.timeline.TimelinePlot;
import org.esa.nest.dat.toolviews.productlibrary.timeline.YearsPlot;
import org.esa.snap.util.DialogUtils;

public class TimelinePanel
extends WebPanel
implements DatabaseQueryListener {
    private final DatabaseStatistics stats;
    private JPanel currentPanel = null;
    private JPanel timelinePanel;
    private JPanel yearsPanel;
    private JPanel monthsPanel;

    public TimelinePanel(DatabaseStatistics stats) {
        this.stats = stats;
        this.createPanel();
        this.setMaximumSize(new Dimension(500, 30));
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        this.setUndecorated(false);
        JPanel centrePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.fill = 1;
        this.timelinePanel = new TimelinePlot(this.stats);
        this.yearsPanel = new YearsPlot(this.stats);
        this.monthsPanel = new MonthsPlot(this.stats);
        gbc.weightx = 10.0;
        gbc.weighty = 10.0;
        centrePanel.add((Component)this.timelinePanel, gbc);
        centrePanel.add((Component)this.monthsPanel, gbc);
        this.hideShowPanels(this.timelinePanel);
        this.add(centrePanel, "Center");
        this.add(this.createControlPanel(), "West");
    }

    private JPanel createControlPanel() {
        WebPanel controlPanel = new WebPanel();
        controlPanel.setLayout((LayoutManager)new BoxLayout((Container)controlPanel, 3));
        JRadioButton timelineButton = new JRadioButton("Timeline", true);
        JRadioButton yearsButton = new JRadioButton("Years", false);
        JRadioButton monthsButton = new JRadioButton("Months", false);
        ButtonGroup group = new ButtonGroup();
        group.add(timelineButton);
        group.add(yearsButton);
        group.add(monthsButton);
        timelineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimelinePanel.this.hideShowPanels(TimelinePanel.this.timelinePanel);
            }
        });
        yearsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimelinePanel.this.hideShowPanels(TimelinePanel.this.yearsPanel);
            }
        });
        monthsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimelinePanel.this.hideShowPanels(TimelinePanel.this.monthsPanel);
            }
        });
        controlPanel.add((Component)timelineButton);
        controlPanel.add((Component)monthsButton);
        return controlPanel;
    }

    private void hideShowPanels(JPanel selectedPanel) {
        this.currentPanel = selectedPanel;
        this.timelinePanel.setVisible(this.currentPanel.equals(this.timelinePanel));
        this.yearsPanel.setVisible(this.currentPanel.equals(this.yearsPanel));
        this.monthsPanel.setVisible(this.currentPanel.equals(this.monthsPanel));
    }

    @Override
    public void notifyNewEntryListAvailable() {
        this.currentPanel.updateUI();
    }

    @Override
    public void notifyNewMapSelectionAvailable() {
    }
}

