/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.event.DockableBarListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.OperatorSpiRegistry;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.BasicApp;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.application.ApplicationDescriptor;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.util.ResourceInstaller;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.DatAboutBox;
import org.esa.nest.dat.actions.LoadTabbedLayoutAction;
import org.esa.nest.dat.views.polarview.PolarView;
import org.esa.snap.dat.graphbuilder.GraphBuilderDialog;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.db.ProductDB;
import org.esa.snap.util.MemUtils;
import org.esa.snap.util.ResourceUtils;
import org.esa.snap.util.Settings;

public class DatApp
extends VisatApp {
    public static final String PROCESSORS_TOOL_BAR_ID = "processorsToolBar";
    public static final String LABELS_TOOL_BAR_ID = "labelsToolBar";

    public DatApp(ApplicationDescriptor applicationDescriptor) {
        super(applicationDescriptor);
        System.setProperty("sun.java2d.opengl", "true");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
    }

    protected ModalDialog createAboutBox() {
        return new DatAboutBox();
    }

    protected void initClientUI(ProgressMonitor pm) {
        super.initClientUI(pm);
        CommandBar processorToolBar = this.createProcessorToolBar();
        processorToolBar.getContext().setInitSide(1);
        processorToolBar.getContext().setInitIndex(3);
        this.getMainFrame().getDockableBarManager().addDockableBar((DockableBar)processorToolBar);
        CommandBar labelToolBar = this.createLabelToolBar();
        labelToolBar.getContext().setInitSide(4);
        labelToolBar.getContext().setInitIndex(4);
        this.getMainFrame().getDockableBarManager().addDockableBar((DockableBar)labelToolBar);
        this.updateGraphMenu();
        this.postInit();
    }

    protected void configureJaiTileCache() {
        MemUtils.createTileCache();
        super.configureJaiTileCache();
    }

    protected void loadLayout() {
        String getStarted = VisatApp.getApp().getPreferences().getPropertyString("visat.showGettingStarted", "true");
        this.getMainFrame().setMinimumSize(new Dimension(1200, 800));
        if (getStarted == null || getStarted.equals("true")) {
            LoadTabbedLayoutAction.loadTabbedLayout();
            HelpSys.showTheme((String)"top");
            VisatApp.getApp().getPreferences().setPropertyString("visat.showGettingStarted", "false");
            this.getMainFrame().setExtendedState(6);
        } else {
            this.getMainFrame().getLayoutPersistence().loadLayoutData();
        }
    }

    protected void postInit() {
        try {
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            this.disableOperatorPlugins();
            this.disableIOPlugins();
            DatApp.validateAuxDataFolder();
            UIManager.put("List.lockToPositionOnScroll", Boolean.FALSE);
            this.installDefaultColorPalettes();
            DatApp.backgroundInitTasks();
        }
        catch (Throwable t) {
            VisatApp.getApp().showErrorDialog("PostInit failed. " + t.toString());
        }
    }

    private void installDefaultColorPalettes() {
        URL codeSourceUrl = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        File auxdataDir = new File(SystemUtils.getApplicationDataDir(), "beam-ui/auxdata/color-palettes");
        final ResourceInstaller resourceInstaller = new ResourceInstaller(codeSourceUrl, "auxdata/color_palettes/", auxdataDir);
        ProgressMonitorSwingWorker swingWorker = new ProgressMonitorSwingWorker((Component)this.getMainFrame(), "Installing Auxdata..."){

            protected Object doInBackground(ProgressMonitor progressMonitor) throws Exception {
                resourceInstaller.install(".*.cpd", progressMonitor);
                return Boolean.TRUE;
            }

            protected void done() {
                try {
                    this.get();
                }
                catch (Exception e) {
                    DatApp.this.getLogger().log(Level.SEVERE, "Could not install auxdata", e);
                }
            }
        };
        swingWorker.executeWithBlocking();
    }

    protected void disableOperatorPlugins() {
        this.removeOperator("org.esa.beam.gpf.operators.standard.MergeOp$Spi");
        this.removeOperator("org.esa.beam.pixex.PixExOp$Spi");
        this.removeOperator("org.esa.beam.statistics.StatisticsOp$Spi");
        this.removeOperator("org.esa.beam.gpf.operators.meris.N1PatcherOp$Spi");
    }

    protected void disableIOPlugins() {
        this.removeReaderPlugIn("org.esa.beam.dataio.geotiff.GeoTiffProductReaderPlugIn");
    }

    protected void removeOperator(String spi) {
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi op = registry.getOperatorSpi(spi);
        if (op != null) {
            registry.removeOperatorSpi(op);
        }
    }

    protected void removeReaderPlugIn(String name) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
    }

    private static void validateAuxDataFolder() throws IOException {
        File auxDataFolder;
        File NestData = new File("~\\NestData");
        if (Settings.isWindowsOS()) {
            NestData = new File("c:\\NestData");
        }
        if (!(auxDataFolder = Settings.getAuxDataFolder()).exists() && NestData.exists()) {
            NestData.renameTo(auxDataFolder);
        }
    }

    private static void backgroundInitTasks() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(new BackgroundInitRunnable());
    }

    public synchronized void closeAllProducts() {
        Product[] products = this.getProductManager().getProducts();
        for (int i = products.length - 1; i >= 0; --i) {
            Product product = products[i];
            this.closeProduct(product);
        }
        MemUtils.freeAllMemory();
    }

    public synchronized void shutDown() {
        DatApp.cleanTempFolder();
        super.shutDown();
    }

    private static void cleanTempFolder() {
        File tempFolder = ResourceUtils.getApplicationUserTempDataDir();
        File[] fileList = tempFolder.listFiles();
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            if (!file.getName().startsWith("tmp_")) continue;
            ResourceUtils.deleteFile((File)file);
        }
        long freeSpace = tempFolder.getFreeSpace() / 1024L / 1024L / 1024L;
        int cutoff = 20;
        if (freeSpace > 30L) {
            cutoff = 60;
        }
        if ((fileList = tempFolder.listFiles()) != null && fileList.length > cutoff) {
            long[] dates = new long[fileList.length];
            int i = 0;
            for (File file : fileList) {
                dates[i++] = file.lastModified();
            }
            Arrays.sort(dates);
            long cutoffDate = dates[dates.length - cutoff];
            for (File file : fileList) {
                if (file.lastModified() >= cutoffDate) continue;
                file.delete();
            }
        }
    }

    protected String getCSName(RasterDataNode raster) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)raster.getProduct());
        if (!AbstractMetadata.isNoData((MetadataElement)absRoot, (String)"map_projection")) {
            return absRoot.getAttributeString("map_projection", "-");
        }
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding instanceof MapGeoCoding || geoCoding instanceof CrsGeoCoding) {
            return geoCoding.getMapCRS().getName().toString();
        }
        return "Satellite coordinates";
    }

    protected HashSet<String> getExcludedToolbars() {
        HashSet excludedIds = super.getExcludedToolbars();
        excludedIds.add("org.esa.beam.visat.toolviews.spectrum.SpectrumToolView");
        excludedIds.add("org.esa.beam.visat.toolviews.placemark.pin.PinManagerToolView");
        excludedIds.add("org.esa.beam.visat.toolviews.placemark.gcp.GcpManagerToolView");
        excludedIds.add("org.esa.nest.dat.toolviews.worldmap.NestWorldMapToolView");
        excludedIds.add("org.csa.rstb.dat.toolviews.HaAlphaPlotToolView");
        return excludedIds;
    }

    protected void addDefaultToolViewCommands(List<String> commandIds) {
        commandIds.add("org.esa.nest.dat.toolviews.Projects.ProjectsToolView.showCmd");
        commandIds.add("org.esa.beam.visat.ProductsToolView.showCmd");
        commandIds.add("org.esa.beam.visat.toolviews.pixelinfo.PixelInfoToolView.showCmd");
        commandIds.add(null);
        commandIds.add("org.esa.beam.visat.toolviews.nav.NavigationToolView.showCmd");
        commandIds.add("org.esa.beam.visat.toolviews.imageinfo.ColorManipulationToolView.showCmd");
        commandIds.add("org.esa.beam.visat.toolviews.layermanager.LayerManagerToolView.showCmd");
        commandIds.add(null);
    }

    protected CommandBar createMainToolBar() {
        CommandBar toolBar = this.createToolBar("mainToolBar", "Standard");
        this.addCommandsToToolBar(toolBar, new String[]{"newProject", "loadProject", null, "open", "save"});
        return toolBar;
    }

    protected CommandBar createMainMenuBar() {
        CommandMenuBar menuBar = new CommandMenuBar("Main Menu");
        menuBar.setHidable(true);
        menuBar.setStretch(true);
        boolean incImageProcessing = false;
        CommandManager cmdMan = this.getCommandManager();
        for (int i = 0; i < cmdMan.getNumCommands(); ++i) {
            String parent = cmdMan.getCommandAt(i).getParent();
            if (parent == null || !parent.equals("image-processing")) continue;
            incImageProcessing = true;
        }
        menuBar.add(this.createJMenu("file", "File", 'F', new String[0]));
        menuBar.add(this.createJMenu("edit", "Edit", 'E', new String[0]));
        menuBar.add(this.createJMenu("view", "View", 'V', new String[0]));
        menuBar.add(this.createAnalysisMenu());
        menuBar.add(this.createJMenu("tools", "Utilities", 'U', new String[0]));
        menuBar.add(this.createJMenu("processing", "Optical Processing", 'O', new String[0]));
        menuBar.add(this.createJMenu("Sar Processing", "SAR Processing", 'S', new String[0]));
        if (incImageProcessing) {
            menuBar.add(this.createJMenu("image-processing", "Image Processing", 'M', new String[0]));
        }
        menuBar.add(this.createJMenu("processing.imageAnalysis", "Image Analysis", 'I', new String[0]));
        menuBar.add(this.createJMenu("Graphs", "Graphs", 'G', new String[0]));
        menuBar.add(this.createJMenu("window", "Window", 'W', new String[0]));
        menuBar.add(this.createJMenu("help", "Help", 'H', new String[0]));
        return menuBar;
    }

    private void updateGraphMenu() {
        JMenu menu = this.findMenu("Graphs");
        if (menu == null) {
            return;
        }
        File graphPath = ResourceUtils.getGraphFolder((String)"");
        if (!graphPath.exists()) {
            return;
        }
        menu.add(new JSeparator());
        DatApp.createGraphMenu(menu, graphPath);
    }

    private static void createGraphMenu(JMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (final File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                DatApp.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphBuilderDialog dialog = new GraphBuilderDialog((AppContext)VisatApp.getApp(), "Graph Builder", "graph_builder");
                    dialog.show();
                    dialog.LoadGraph(file);
                }
            });
            menu.add(item);
        }
    }

    protected JMenu createAnalysisMenu() {
        JMenu menu = super.createAnalysisMenu();
        this.addCommandToMenu(menu, "org.csa.rstb.dat.toolviews.HaAlphaPlotToolView.showCmd");
        return menu;
    }

    protected void addCommandToMenu(JMenu menu, String cmdID) {
        Command command = this.getCommandManager().getCommand(cmdID);
        if (command != null) {
            menu.getPopupMenu().add(command.createMenuItem());
        }
    }

    protected CommandBar createAnalysisToolBar() {
        CommandBar toolBar = super.createAnalysisToolBar();
        this.addCommandsToToolBar(toolBar, new String[]{"org.csa.rstb.dat.toolviews.HaAlphaPlotToolView.showCmd"});
        return toolBar;
    }

    protected CommandBar createProcessorToolBar() {
        CommandBar toolBar = new CommandBar(PROCESSORS_TOOL_BAR_ID, "Processors");
        toolBar.addDockableBarListener((DockableBarListener)new BasicApp.ToolBarListener((BasicApp)this));
        this.addCommandsToToolBar(toolBar, new String[]{"openGraphBuilderDialog", "batchProcessing"});
        return toolBar;
    }

    protected CommandBar createLabelToolBar() {
        CommandBar toolBar = this.createToolBar(LABELS_TOOL_BAR_ID, "Labels and GeoTags");
        LinkedList<String> cmdList = new LinkedList<String>();
        HashMap<String, String> placeAfterMap = new HashMap<String, String>();
        cmdList.add("pinTool");
        cmdList.add("gcpTool");
        CommandManager cmdMan = this.getCommandManager();
        int numCmds = cmdMan.getNumCommands();
        for (int i = 0; i < numCmds; ++i) {
            Command cmd = cmdMan.getCommandAt(i);
            String parent = cmd.getParent();
            if (parent == null || !parent.equals("labels")) continue;
            placeAfterMap.put(cmd.getCommandID(), cmd.getPlaceAfter());
            cmdList.add(cmd.getCommandID());
        }
        Set placeAfterSet = placeAfterMap.keySet();
        for (String id : placeAfterSet) {
            String placeAfter = (String)placeAfterMap.get(id);
            int index = cmdList.indexOf(placeAfter);
            if (index == -1) continue;
            cmdList.remove(id);
            index = cmdList.indexOf(placeAfter);
            cmdList.add(index + 1, id);
        }
        this.addCommandsToToolBar(toolBar, cmdList.toArray(new String[cmdList.size()]));
        return toolBar;
    }

    protected CommandBar createInteractionsToolBar() {
        CommandBar toolBar = this.createToolBar("toolsToolBar", "Interactions");
        this.addCommandsToToolBar(toolBar, new String[]{"selectLayerTool", "rangeFinder", "zoomTool", "pannerTool", null, "magicWandTool", "drawLineTool", "drawPolylineTool", "drawRectangleTool", "drawEllipseTool", "drawPolygonTool", "createVectorDataNode"});
        return toolBar;
    }

    public synchronized void closeAllAssociatedFrames(Product product) {
        boolean frameFound;
        super.closeAllAssociatedFrames(product);
        block0: do {
            frameFound = false;
            JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
            if (frames == null) break;
            for (JInternalFrame frame : frames) {
                Container cont = frame.getContentPane();
                Product frameProduct = null;
                if (cont instanceof PolarView) {
                    PolarView view = (PolarView)((Object)cont);
                    frameProduct = view.getProduct();
                }
                if (frameProduct == null || frameProduct != product) continue;
                this.getDesktopPane().closeFrame(frame);
                frameFound = true;
                continue block0;
            }
        } while (frameFound);
    }

    private static class BackgroundInitRunnable
    implements Runnable {
        private BackgroundInitRunnable() {
        }

        @Override
        public void run() {
            try {
                ProductDB.instance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

