/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ImageLegend;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.StringSelectorDialog;
import org.esa.snap.dat.graphbuilder.GraphBuilderDialog;
import org.esa.snap.gpf.GPFProcessor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class ExportKmzProductAction
extends ExecCommand {
    private static final String OVERLAY_KML = "overlay.kml";
    private static final String OVERLAY_TIF = "overlay.tif";
    private static final String IMAGE_TYPE = "TIF";
    private static final String LEGEND_PNG = "legend.png";
    private static final String[] KMZ_FORMAT_DESCRIPTION = new String[]{"KMZ", "kmz", "KMZ - Google Earth File Format"};
    private static final String IMAGE_EXPORT_DIR_PREFERENCES_KEY = "user.image.export.dir";
    private final BeamFileFilter kmzFileFilter;

    public ExportKmzProductAction() {
        String formatName = KMZ_FORMAT_DESCRIPTION[0];
        String formatExt = KMZ_FORMAT_DESCRIPTION[1];
        String formatDescr = KMZ_FORMAT_DESCRIPTION[2];
        this.kmzFileFilter = new BeamFileFilter(formatName, formatExt, formatDescr);
    }

    public void actionPerformed(CommandEvent event) {
        Product product = VisatApp.getApp().getSelectedProduct();
        GeoCoding geoCoding = product.getGeoCoding();
        boolean isGeographic = false;
        if (geoCoding instanceof MapGeoCoding) {
            MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
            MapTransformDescriptor transformDescriptor = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform().getDescriptor();
            String typeID = transformDescriptor.getTypeID();
            if (typeID.equals("Identity")) {
                isGeographic = true;
            }
        } else if (geoCoding instanceof CrsGeoCoding) {
            isGeographic = CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
        }
        if (isGeographic) {
            StringSelectorDialog dlg = new StringSelectorDialog("Select band", ExportKmzProductAction.getValidBandNames(product));
            dlg.show();
            if (dlg.IsOK()) {
                this.exportImage(product, dlg.getSelectedItem());
            }
        } else {
            String message = "Product must be Orthorectified and in ''Geographic Lat/Lon'' projection.";
            VisatApp.getApp().showInfoDialog("Product must be Orthorectified and in ''Geographic Lat/Lon'' projection.", null);
        }
    }

    public void updateState(CommandEvent event) {
        Product product = VisatApp.getApp().getSelectedProduct();
        this.setEnabled(product != null);
    }

    private static String[] getValidBandNames(Product product) {
        ArrayList<String> bandNames = new ArrayList<String>(4);
        for (Band band : product.getBands()) {
            bandNames.add(band.getName());
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private void exportImage(Product product, String selectedBandName) {
        VisatApp visatApp = VisatApp.getApp();
        String lastDir = visatApp.getPreferences().getPropertyString(IMAGE_EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        HelpSys.enableHelpKey((Component)fileChooser, (String)this.getHelpId());
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.addChoosableFileFilter((FileFilter)this.kmzFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(visatApp.getAppName() + " - " + "Export KMZ");
        fileChooser.setCurrentFilename(product.getName());
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        int result = fileChooser.showSaveDialog((Component)visatApp.getMainFrame());
        File file = fileChooser.getSelectedFile();
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            visatApp.getPreferences().setPropertyString(IMAGE_EXPORT_DIR_PREFERENCES_KEY, currentDirectory.getPath());
        }
        if (result != 0) {
            return;
        }
        if (file == null || file.getName().isEmpty()) {
            return;
        }
        if (!visatApp.promptForOverwrite(file)) {
            return;
        }
        SaveKMLSwingWorker worker = new SaveKMLSwingWorker(visatApp, "Save KMZ", product, selectedBandName, file);
        worker.executeWithBlocking();
    }

    private static RenderedImage createImageLegend(RasterDataNode raster) {
        ImageLegend imageLegend = ExportKmzProductAction.initImageLegend(raster);
        return imageLegend.createImage();
    }

    private static String formatKML(Product product, String imageName) {
        Placemark[] pins;
        GeoCoding geoCoding = product.getGeoCoding();
        PixelPos upperLeftPP = new PixelPos(0.5f, 0.5f);
        PixelPos lowerRightPP = new PixelPos((float)product.getSceneRasterWidth() - 0.5f, (float)product.getSceneRasterHeight() - 0.5f);
        GeoPos upperLeftGP = geoCoding.getGeoPos(upperLeftPP, null);
        GeoPos lowerRightGP = geoCoding.getGeoPos(lowerRightPP, null);
        float eastLon = lowerRightGP.getLon();
        if (geoCoding.isCrossingMeridianAt180()) {
            eastLon += 360.0f;
        }
        String pinKml = "";
        PlacemarkGroup pinGroup = product.getPinGroup();
        for (Placemark placemark : pins = (Placemark[])pinGroup.toArray((ProductNode[])new Placemark[pinGroup.getNodeCount()])) {
            GeoPos geoPos = placemark.getGeoPos();
            if (geoPos == null || !product.containsPixel(placemark.getPixelPos())) continue;
            pinKml = pinKml + String.format("<Placemark>\n  <name>%s</name>\n  <Point>\n    <coordinates>%f,%f,0</coordinates>\n  </Point>\n</Placemark>\n", placemark.getLabel(), Float.valueOf(geoPos.lon), Float.valueOf(geoPos.lat));
        }
        String name = product.getName();
        String description = product.getDescription() + '\n' + product.getName();
        String legendKml = "  <ScreenOverlay>\n    <name>Legend</name>\n    <Icon>\n      <href>legend.png</href>\n    </Icon>\n    <overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\" />\n    <screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\" />\n  </ScreenOverlay>\n";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.0\">\n<Document>\n  <name>" + name + "</name>\n" + "  <description>" + description + "</description>\n" + "  <GroundOverlay>\n" + "    <name>Raster data</name>\n" + "    <LatLonBox>\n" + "      <north>" + upperLeftGP.getLat() + "</north>\n" + "      <south>" + lowerRightGP.getLat() + "</south>\n" + "      <east>" + eastLon + "</east>\n" + "      <west>" + upperLeftGP.getLon() + "</west>\n" + "    </LatLonBox>\n" + "    <Icon>\n" + "      <href>" + imageName + "</href>\n" + "    </Icon>\n" + "  </GroundOverlay>\n" + "  <ScreenOverlay>\n    <name>Legend</name>\n    <Icon>\n      <href>legend.png</href>\n    </Icon>\n    <overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\" />\n    <screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\" />\n  </ScreenOverlay>\n" + pinKml + "</Document>\n" + "</kml>\n";
    }

    private static ImageLegend initImageLegend(RasterDataNode raster) {
        ImageLegend imageLegend = new ImageLegend(raster.getImageInfo(), raster);
        imageLegend.setHeaderText(ExportKmzProductAction.getLegendHeaderText(raster));
        imageLegend.setOrientation(1);
        imageLegend.setBackgroundTransparency(0.0f);
        imageLegend.setBackgroundTransparencyEnabled(true);
        imageLegend.setAntialiasing(true);
        return imageLegend;
    }

    private static String getLegendHeaderText(RasterDataNode raster) {
        String unit = raster.getUnit() != null ? raster.getUnit() : "-";
        unit = unit.replace('*', ' ');
        return '(' + unit + ')';
    }

    private static class SaveKMLSwingWorker
    extends ProgressMonitorSwingWorker {
        private final VisatApp visatApp;
        private final Product product;
        private final String selectedBandName;
        private final File file;

        SaveKMLSwingWorker(VisatApp visatApp, String message, Product product, String selectedBandName, File file) {
            super((Component)visatApp.getMainFrame(), message);
            this.visatApp = visatApp;
            this.product = product;
            this.selectedBandName = selectedBandName;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            try {
                Product subsetProduct = SaveKMLSwingWorker.createSubsetProduct(this.product, this.selectedBandName);
                String message = String.format("Saving image as %s...", this.file.getPath());
                pm.beginTask(message, 4);
                this.visatApp.setStatusBarMessage(message);
                this.visatApp.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                try (ZipOutputStream outStream = new ZipOutputStream(new FileOutputStream(this.file));){
                    outStream.putNextEntry(new ZipEntry(ExportKmzProductAction.OVERLAY_KML));
                    String kmlContent = ExportKmzProductAction.formatKML(subsetProduct, ExportKmzProductAction.OVERLAY_TIF);
                    outStream.write(kmlContent.getBytes());
                    pm.worked(1);
                    File imgFile = new File(this.file.getParent(), this.product.getName() + ".tif");
                    File graphFile = new File(GraphBuilderDialog.getInternalGraphFolder(), "DataConvertGraph.xml");
                    GPFProcessor proc = new GPFProcessor(graphFile);
                    proc.setIO(this.product.getFileLocation(), imgFile, "GeoTIFF");
                    proc.executeGraph(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    pm.worked(1);
                    try (FileInputStream fin = new FileInputStream(imgFile);){
                        int n;
                        outStream.putNextEntry(new ZipEntry(ExportKmzProductAction.OVERLAY_TIF));
                        int size = 8192;
                        byte[] buf = new byte[8192];
                        while ((n = fin.read(buf, 0, 8192)) > -1) {
                            outStream.write(buf, 0, n);
                        }
                    }
                    pm.worked(1);
                    imgFile.delete();
                    pm.worked(1);
                }
            }
            catch (OutOfMemoryError ignored) {
                this.visatApp.showOutOfMemoryErrorDialog("The image could not be exported.");
            }
            catch (Throwable e) {
                this.visatApp.handleUnknownException(e);
            }
            finally {
                this.visatApp.getMainFrame().setCursor(Cursor.getDefaultCursor());
                this.visatApp.clearStatusBarMessage();
                pm.done();
            }
            return null;
        }

        private static Product createSubsetProduct(Product product, String selectedBandName) throws IOException {
            ProductSubsetDef productSubsetDef = new ProductSubsetDef("subset");
            Band srcBand = product.getBand(selectedBandName);
            if (!(srcBand instanceof VirtualBand)) {
                productSubsetDef.setNodeNames(new String[]{selectedBandName});
            }
            return product.createSubset(productSubsetDef, null, null);
        }
    }
}

