/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import java.io.File;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.product.ProductMetadataTable;
import org.esa.beam.framework.ui.product.ProductMetadataView;
import org.esa.beam.framework.ui.product.ProductNodeView;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.utils.FileFolderUtils;
import org.esa.snap.datamodel.metadata.AbstractMetadataIO;

public class ExportMetadataXMLAction
extends ExecCommand {
    public void actionPerformed(CommandEvent event) {
        try {
            ProductNodeView view = VisatApp.getApp().getSelectedProductNodeView();
            if (!(view instanceof ProductMetadataView)) {
                return;
            }
            ProductMetadataView productMetadataView = (ProductMetadataView)view;
            ProductMetadataTable metadataTable = productMetadataView.getMetadataTable();
            MetadataElement root = metadataTable.getMetadataElement();
            Product srcProduct = productMetadataView.getProduct();
            String fileName = srcProduct.getName() + "_metadata.xml";
            File file = FileFolderUtils.GetFilePath("Save Metadata", "XML", "xml", fileName, "Metadata XML File", true);
            if (file == null) {
                return;
            }
            AbstractMetadataIO.Save((Product)srcProduct, (MetadataElement)root, (File)file);
        }
        catch (Exception e) {
            VisatApp.getApp().showErrorDialog("Unable to save metadata\n" + e.getMessage());
        }
    }

    public void updateState(CommandEvent event) {
        ProductNodeView view = VisatApp.getApp().getSelectedProductNodeView();
        this.setEnabled(view instanceof ProductMetadataView);
    }
}

