/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.utils.FileFolderUtils;
import org.esa.snap.util.ResourceUtils;

public class LaunchPolsarProAction
extends ExecCommand {
    private static final String PolsarProPathStr = "external.polsarpro.path";
    private static final String TCLPathStr = "external.TCL.path";

    public void actionPerformed(CommandEvent event) {
        File polsarProFile;
        PropertyMap pref = VisatApp.getApp().getPreferences();
        File tclFile = new File(pref.getPropertyString(TCLPathStr));
        if (!tclFile.exists() && (tclFile = LaunchPolsarProAction.findTCLWish()).exists()) {
            pref.setPropertyString(TCLPathStr, tclFile.getAbsolutePath());
        }
        if (!(polsarProFile = new File(pref.getPropertyString(PolsarProPathStr))).exists()) {
            polsarProFile = LaunchPolsarProAction.findPolsarPro();
        }
        if (!polsarProFile.exists()) {
            polsarProFile = FileFolderUtils.GetFilePath("PolSARPro Location", "tcl", "tcl", null, "PolSARPro File", false);
        }
        if (polsarProFile.exists()) {
            LaunchPolsarProAction.externalExecute(polsarProFile, tclFile);
            pref.setPropertyString(PolsarProPathStr, polsarProFile.getAbsolutePath());
            VisatApp.getApp().savePreferences();
        }
    }

    private static void externalExecute(final File prog, final File tclWishFile) {
        File homeFolder = ResourceUtils.findHomeFolder();
        final File program = new File(homeFolder, "bin" + File.separator + "exec.bat");
        String wish = "wish";
        final String args = '\"' + prog.getParent() + "\" " + wish + ' ' + prog.getName();
        System.out.println("Launching PolSARPro " + args);
        Thread worker = new Thread(){

            @Override
            public void run() {
                try {
                    Process proc = Runtime.getRuntime().exec(program.getAbsolutePath() + ' ' + args);
                    LaunchPolsarProAction.outputTextBuffers(new BufferedReader(new InputStreamReader(proc.getInputStream())));
                    boolean hasErrors = LaunchPolsarProAction.outputTextBuffers(new BufferedReader(new InputStreamReader(proc.getErrorStream())));
                    if (hasErrors && tclWishFile.exists()) {
                        String wish = '\"' + tclWishFile.getAbsolutePath() + '\"';
                        String args2 = '\"' + prog.getParent() + "\" " + wish + ' ' + prog.getName();
                        System.out.println("Launching PolSARPro 2nd attempt " + args2);
                        Process proc2 = Runtime.getRuntime().exec(program.getAbsolutePath() + ' ' + args2);
                        LaunchPolsarProAction.outputTextBuffers(new BufferedReader(new InputStreamReader(proc2.getInputStream())));
                        LaunchPolsarProAction.outputTextBuffers(new BufferedReader(new InputStreamReader(proc2.getErrorStream())));
                    }
                }
                catch (Exception e) {
                    VisatApp.getApp().showErrorDialog(e.getMessage());
                }
            }
        };
        worker.start();
    }

    private static File findTCLWish() {
        File progFiles = new File("C:\\Program Files (x86)\\TCL\\bin");
        if (!progFiles.exists()) {
            progFiles = new File("C:\\Program Files\\TCL\\bin");
        }
        if (!progFiles.exists()) {
            progFiles = new File("C:\\TCL\\bin");
        }
        if (progFiles.exists()) {
            File[] files;
            for (File file : files = progFiles.listFiles()) {
                String name = file.getName().toLowerCase();
                if (!name.equals("wish.exe")) continue;
                return file;
            }
        }
        return new File("");
    }

    private static File findPolsarPro() {
        File progFiles = new File("C:\\Program Files (x86)");
        if (!progFiles.exists()) {
            progFiles = new File("C:\\Program Files");
        }
        if (progFiles.exists()) {
            File[] progs;
            for (File prog : progs = progFiles.listFiles(new PolsarFileFilter())) {
                File[] fileList;
                for (File file : fileList = prog.listFiles(new PolsarFileFilter())) {
                    if (!file.getName().toLowerCase().endsWith("tcl")) continue;
                    return file;
                }
            }
        }
        return new File("");
    }

    private static boolean outputTextBuffers(BufferedReader in) throws IOException {
        char c;
        boolean hasData = false;
        while ((c = (char)in.read()) != '\uffffffff' && c != '\uffff') {
            System.out.print(c);
            hasData = true;
        }
        return hasData;
    }

    private static class PolsarFileFilter
    implements FilenameFilter {
        private PolsarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith("polsar");
        }
    }
}

