/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.actions.EditMetadataAction;
import org.esa.snap.dat.dialogs.PromptDialog;

public class SearchMetadataAction
extends ExecCommand {
    public void actionPerformed(CommandEvent event) {
        PromptDialog dlg = new PromptDialog("Search Metadata", "Item Name", "", false);
        dlg.show();
        if (dlg.IsOK()) {
            String tag = dlg.getValue().toUpperCase();
            MetadataElement resultElem = new MetadataElement("Search result (" + dlg.getValue() + ')');
            Product product = VisatApp.getApp().getSelectedProduct();
            boolean isModified = product.isModified();
            MetadataElement root = product.getMetadataRoot();
            resultElem.setOwner((ProductNode)product);
            SearchMetadataAction.searchMetadata(resultElem, root, tag);
            product.setModified(isModified);
            if (resultElem.getNumElements() > 0 || resultElem.getNumAttributes() > 0) {
                EditMetadataAction.createProductMetadataView(resultElem);
            } else {
                VisatApp.getApp().showErrorDialog("Search Metadata", dlg.getValue() + " not found in the Metadata");
            }
        }
    }

    public void updateState(CommandEvent event) {
        int n = VisatApp.getApp().getProductManager().getProductCount();
        this.setEnabled(n > 0);
    }

    private static void searchMetadata(MetadataElement resultElem, MetadataElement elem, String tag) {
        MetadataAttribute[] attribList;
        MetadataElement[] elemList;
        for (MetadataElement e : elemList = elem.getElements()) {
            SearchMetadataAction.searchMetadata(resultElem, e, tag);
        }
        for (MetadataAttribute attrib : attribList = elem.getAttributes()) {
            if (!attrib.getName().toUpperCase().contains(tag)) continue;
            MetadataAttribute newAttrib = attrib.createDeepClone();
            newAttrib.setDescription(SearchMetadataAction.getAttributePath(attrib));
            resultElem.addAttribute(newAttrib);
        }
    }

    static String getAttributePath(MetadataAttribute attrib) {
        MetadataElement parentElem = attrib.getParentElement();
        String path = parentElem.getName();
        while (parentElem != null && !parentElem.getName().equals("metadata")) {
            if ((parentElem = parentElem.getParentElement()) == null) continue;
            path = parentElem.getName() + "/" + path;
        }
        return path;
    }
}

