/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.actions.EditMetadataAction;
import org.esa.nest.dat.actions.SearchMetadataAction;
import org.esa.snap.dat.dialogs.PromptDialog;

public class SearchMetadataValueAction
extends ExecCommand {
    public void actionPerformed(CommandEvent event) {
        PromptDialog dlg = new PromptDialog("Search Metadata", "Value", "", false);
        dlg.show();
        if (dlg.IsOK()) {
            String value = dlg.getValue().toUpperCase();
            MetadataElement resultElem = new MetadataElement("Search result (" + dlg.getValue() + ')');
            Product product = VisatApp.getApp().getSelectedProduct();
            boolean isModified = product.isModified();
            MetadataElement root = product.getMetadataRoot();
            resultElem.setOwner((ProductNode)product);
            SearchMetadataValueAction.searchMetadataValue(resultElem, root, value);
            product.setModified(isModified);
            if (resultElem.getNumElements() > 0 || resultElem.getNumAttributes() > 0) {
                EditMetadataAction.createProductMetadataView(resultElem);
            } else {
                VisatApp.getApp().showErrorDialog("Search Metadata", dlg.getValue() + " not found in the Metadata");
            }
        }
    }

    public void updateState(CommandEvent event) {
        int n = VisatApp.getApp().getProductManager().getProductCount();
        this.setEnabled(n > 0);
    }

    private static void searchMetadataValue(MetadataElement resultElem, MetadataElement elem, String value) {
        MetadataAttribute[] attribList;
        MetadataElement[] elemList;
        for (MetadataElement e : elemList = elem.getElements()) {
            SearchMetadataValueAction.searchMetadataValue(resultElem, e, value);
        }
        for (MetadataAttribute attrib : attribList = elem.getAttributes()) {
            if (!attrib.getData().getElemString().toUpperCase().contains(value)) continue;
            MetadataAttribute newAttrib = attrib.createDeepClone();
            newAttrib.setDescription(SearchMetadataAction.getAttributePath(attrib));
            resultElem.addAttribute(newAttrib);
        }
    }
}

