/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.product.ProductSceneImage;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.util.Debug;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.views.polarview.PolarView;

public class ShowCrossSpectraViewAction
extends ExecCommand {
    public static String ID = "showPolarWaveView";

    public void actionPerformed(CommandEvent event) {
        VisatApp visatApp = VisatApp.getApp();
        this.openProductSceneView((RasterDataNode)visatApp.getSelectedProductNode());
    }

    void openProductSceneView(final RasterDataNode selectedProductNode) {
        final VisatApp visatApp = VisatApp.getApp();
        visatApp.setStatusBarMessage("Creating polar view...");
        UIUtils.setRootFrameWaitCursor((Component)visatApp.getMainFrame());
        final Product product = VisatApp.getApp().getSelectedProduct();
        ProgressMonitorSwingWorker<ProductSceneImage, Object> worker = new ProgressMonitorSwingWorker<ProductSceneImage, Object>((Component)visatApp.getMainFrame(), visatApp.getAppName() + " - Creating image for '" + selectedProductNode.getName() + "'"){

            protected ProductSceneImage doInBackground(ProgressMonitor pm) throws Exception {
                try {
                    ProductSceneImage productSceneImage = ShowCrossSpectraViewAction.createProductSceneImage(selectedProductNode, pm);
                    return productSceneImage;
                }
                finally {
                    if (pm.isCanceled()) {
                        selectedProductNode.unloadRasterData();
                    }
                }
            }

            public void done() {
                ProductSceneImage productSceneImage;
                UIUtils.setRootFrameDefaultCursor((Component)visatApp.getMainFrame());
                visatApp.clearStatusBarMessage();
                try {
                    productSceneImage = (ProductSceneImage)this.get();
                }
                catch (OutOfMemoryError e) {
                    visatApp.showOutOfMemoryErrorDialog("The polar view could not be created.");
                    return;
                }
                catch (Exception e) {
                    visatApp.handleUnknownException((Throwable)e);
                    return;
                }
                PolarView view = new PolarView(product, productSceneImage);
                view.setCommandUIFactory(visatApp.getCommandUIFactory());
                String title = ShowCrossSpectraViewAction.createInternalFrameTitle(selectedProductNode);
                ImageIcon icon = UIUtils.loadImageIcon((String)"icons/RsBandAsSwath16.gif");
                final JInternalFrame internalFrame = visatApp.createInternalFrame(title, (Icon)icon, (JComponent)((Object)view), ShowCrossSpectraViewAction.this.getHelpId());
                final ProductNodeListenerAdapter pnl = new ProductNodeListenerAdapter(){

                    public void nodeChanged(ProductNodeEvent event1) {
                        if (event1.getSourceNode() == selectedProductNode && event1.getPropertyName().equalsIgnoreCase("name")) {
                            internalFrame.setTitle(ShowCrossSpectraViewAction.createInternalFrameTitle(selectedProductNode));
                        }
                    }
                };
                final Product product2 = selectedProductNode.getProduct();
                internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameOpened(InternalFrameEvent event1) {
                        product2.addProductNodeListener((ProductNodeListener)pnl);
                    }

                    @Override
                    public void internalFrameClosed(InternalFrameEvent event11) {
                        product2.removeProductNodeListener((ProductNodeListener)pnl);
                    }
                });
                visatApp.updateState();
            }
        };
        visatApp.getExecutorService().submit((Runnable)worker);
    }

    private static String createInternalFrameTitle(RasterDataNode raster) {
        return UIUtils.getUniqueFrameTitle((JInternalFrame[])VisatApp.getApp().getAllInternalFrames(), (String)raster.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProductSceneImage createProductSceneImage(RasterDataNode raster, ProgressMonitor pm) {
        Debug.assertNotNull((Object)raster);
        Debug.assertNotNull((Object)pm);
        VisatApp app = VisatApp.getApp();
        ProductSceneImage sceneImage = null;
        try {
            pm.beginTask("Creating polar view...", 1);
            JInternalFrame[] frames = app.findInternalFrames(raster, 1);
            if (frames.length > 0) {
                ProductSceneView view = (ProductSceneView)frames[0].getContentPane();
                sceneImage = new ProductSceneImage(raster, view);
            } else {
                sceneImage = new ProductSceneImage(raster, app.getPreferences(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            }
        }
        finally {
            pm.done();
        }
        return sceneImage;
    }

    public void updateState(CommandEvent event) {
        Product product = VisatApp.getApp().getSelectedProduct();
        if (product != null) {
            String productType = VisatApp.getApp().getSelectedProduct().getProductType();
            this.setEnabled(productType.startsWith("ASA_WV") && VisatApp.getApp().getSelectedProductNode() instanceof RasterDataNode);
        } else {
            this.setEnabled(false);
        }
    }
}

