/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.product.ProductSceneImage;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.util.PropertyMapChangeListener;
import org.esa.beam.util.StringUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.beam.visat.actions.ShowImageViewRGBAction;
import org.esa.nest.dat.dialogs.HSVImageProfilePane;

public class ShowImageViewHSVAction
extends ExecCommand {
    public static String ID = "showImageViewHSV";
    private static final String r = "min(round( (floor((6*(h))%6)==0?(v): (floor((6*(h))%6)==1?((1-((s)*((6*(h))%6)-floor((6*(h))%6)))*(v)): (floor((6*(h))%6)==2?((1-(s))*(v)): (floor((6*(h))%6)==3?((1-(s))*(v)): (floor((6*(h))%6)==4?((1-((s)*(1-((6*(h))%6)-floor((6*(h))%6))))*(v)): (floor((6*(h))%6)==5?(v):0)))))) *256), 255)";
    private static final String g = "min(round( (floor((6*(h))%6)==0?((1-((s)*(1-((6*(h))%6)-floor((6*(h))%6))))*(v)): (floor((6*(h))%6)==1?(v): (floor((6*(h))%6)==2?(v): (floor((6*(h))%6)==3?((1-((s)*((6*(h))%6)-floor((6*(h))%6)))*(v)): (floor((6*(h))%6)==4?((1-(s))*(v)): (floor((6*(h))%6)==5?((1-(s))*(v)):0)))))) *256), 255)";
    private static final String b = "min(round( (floor((6*(h))%6)==0?((1-(s))*(v)): (floor((6*(h))%6)==1?((1-(s))*(v)): (floor((6*(h))%6)==2?((1-((s)*(1-((6*(h))%6)-floor((6*(h))%6))))*(v)): (floor((6*(h))%6)==3?(v): (floor((6*(h))%6)==4?(v): (floor((6*(h))%6)==5?((1-((s)*((6*(h))%6)-floor((6*(h))%6)))*(v)):0)))))) *256), 255)";

    public void actionPerformed(CommandEvent event) {
        Product product = VisatApp.getApp().getSelectedProduct();
        if (product != null) {
            this.openProductSceneViewHSV(product, this.getHelpId());
        }
    }

    public void updateState(CommandEvent event) {
        this.setEnabled(VisatApp.getApp().getSelectedProduct() != null);
    }

    public void openProductSceneViewHSV(Product product, String helpId) {
        VisatApp visatApp = VisatApp.getApp();
        Product[] openedProducts = visatApp.getProductManager().getProducts();
        int[] defaultBandIndices = ShowImageViewRGBAction.getDefaultBandIndices((Product)product);
        HSVImageProfilePane profilePane = new HSVImageProfilePane(visatApp.getPreferences(), product, openedProducts, defaultBandIndices);
        String title = "Select HSV-Image Channels";
        boolean ok = profilePane.showDialog((Window)visatApp.getMainFrame(), "Select HSV-Image Channels", helpId);
        if (!ok) {
            return;
        }
        String[] hsvExpressions = profilePane.getRgbaExpressions();
        ShowImageViewHSVAction.nomalizeHSVExpressions(product, hsvExpressions);
        if (profilePane.getStoreProfileInProduct()) {
            RGBImageProfile.storeRgbaExpressions((Product)product, (String[])hsvExpressions, (String[])HSVImageProfilePane.HSV_COMP_NAMES);
        }
        String sceneName = ShowImageViewHSVAction.createSceneName(product, profilePane.getSelectedProfile());
        this.openProductSceneViewHSV(sceneName, product, hsvExpressions);
    }

    public void openProductSceneViewHSV(final String name, final Product product, final String[] hsvExpressions) {
        final VisatApp visatApp = VisatApp.getApp();
        ProgressMonitorSwingWorker<ProductSceneImage, Object> worker = new ProgressMonitorSwingWorker<ProductSceneImage, Object>((Component)visatApp.getMainFrame(), visatApp.getAppName() + " - Creating image for '" + name + '\''){

            protected ProductSceneImage doInBackground(ProgressMonitor pm) throws Exception {
                return ShowImageViewHSVAction.createProductSceneImageHSV(name, product, hsvExpressions, pm);
            }

            protected void done() {
                visatApp.getMainFrame().setCursor(Cursor.getDefaultCursor());
                try {
                    ProductSceneView productSceneView = new ProductSceneView((ProductSceneImage)this.get());
                    productSceneView.setLayerProperties(visatApp.getPreferences());
                    ShowImageViewHSVAction.this.openInternalFrame(productSceneView, true);
                }
                catch (OutOfMemoryError e) {
                    visatApp.showOutOfMemoryErrorDialog("The HSV image view could not be created.");
                    return;
                }
                catch (Exception e) {
                    visatApp.handleUnknownException((Throwable)e);
                    return;
                }
                visatApp.clearStatusBarMessage();
            }
        };
        visatApp.setStatusBarMessage("Creating HSV image view...");
        visatApp.getExecutorService().submit((Runnable)worker);
    }

    public JInternalFrame openInternalFrame(ProductSceneView view, boolean configureByPreferences) {
        VisatApp visatApp = VisatApp.getApp();
        view.setCommandUIFactory(visatApp.getCommandUIFactory());
        if (configureByPreferences) {
            view.setLayerProperties(visatApp.getPreferences());
        }
        String title = ShowImageViewRGBAction.createUniqueInternalFrameTitle((String)view.getSceneName());
        ImageIcon icon = UIUtils.loadImageIcon((String)"icons/RsBandAsSwath16.gif");
        JInternalFrame internalFrame = visatApp.createInternalFrame(title, (Icon)icon, (JComponent)view, this.getHelpId());
        visatApp.addPropertyMapChangeListener((PropertyMapChangeListener)view);
        this.updateState();
        return internalFrame;
    }

    private static ProductSceneImage createProductSceneImageHSV(String name, Product product, String[] hsvExpressions, ProgressMonitor pm) throws Exception {
        VisatApp visatApp = VisatApp.getApp();
        UIUtils.setRootFrameWaitCursor((Component)visatApp.getMainFrame());
        ShowImageViewRGBAction.RGBBand[] rgbBands = null;
        boolean errorOccured = false;
        ProductSceneImage productSceneImage = null;
        try {
            pm.beginTask("Creating HSV image...", 2);
            String[] rgbaExpressions = ShowImageViewHSVAction.convertHSVToRGBExpressions(hsvExpressions);
            rgbBands = ShowImageViewRGBAction.allocateRgbBands((Product)product, (String[])rgbaExpressions);
            productSceneImage = new ProductSceneImage(name, (RasterDataNode)rgbBands[0].band, (RasterDataNode)rgbBands[1].band, (RasterDataNode)rgbBands[2].band, visatApp.getPreferences(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            productSceneImage.initVectorDataCollectionLayer();
            productSceneImage.initMaskCollectionLayer();
        }
        catch (Exception e) {
            try {
                errorOccured = true;
                throw e;
            }
            catch (Throwable throwable) {
                pm.done();
                if (rgbBands != null) {
                    ShowImageViewRGBAction.releaseRgbBands(rgbBands, (boolean)errorOccured);
                }
                throw throwable;
            }
        }
        pm.done();
        if (rgbBands != null) {
            ShowImageViewRGBAction.releaseRgbBands((ShowImageViewRGBAction.RGBBand[])rgbBands, (boolean)errorOccured);
        }
        return productSceneImage;
    }

    private static void nomalizeHSVExpressions(Product product, String[] hsvExpressions) {
        boolean modified = product.isModified();
        int i = 0;
        for (String exp : hsvExpressions) {
            if (exp.isEmpty()) continue;
            String checkForNoDataValue = "";
            Band virtBand = ShowImageViewHSVAction.createVirtualBand(product, exp, "tmpVirtBand" + i);
            Stx stx = virtBand.getStx(false, ProgressMonitor.NULL);
            if (stx != null) {
                double min = stx.getMinimum();
                double range = stx.getMaximum() - min;
                hsvExpressions[i] = "min(max((((" + exp + ")- " + min + ")/" + range + "), 0), 1)";
            }
            product.removeBand(virtBand);
            ++i;
        }
        product.setModified(modified);
    }

    private static String getCheckForNoDataExpression(Product product, String exp) {
        String[] bandNames = product.getBandNames();
        StringBuilder checkForNoData = new StringBuilder("(" + exp + " == NaN");
        if (StringUtils.contains((String[])bandNames, (String)exp)) {
            double nodatavalue = product.getBand(exp).getNoDataValue();
            checkForNoData.append(" or " + exp + " == " + nodatavalue);
        }
        checkForNoData.append(") ? NaN : ");
        return checkForNoData.toString();
    }

    public static Band createVirtualBand(Product product, String expression, String name) {
        VirtualBand virtBand = new VirtualBand(name, 31, product.getSceneRasterWidth(), product.getSceneRasterHeight(), expression);
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
        return virtBand;
    }

    private static String[] convertHSVToRGBExpressions(String[] hsvExpressions) {
        String h = hsvExpressions[0].isEmpty() ? "0" : hsvExpressions[0];
        String s = hsvExpressions[1].isEmpty() ? "0" : hsvExpressions[1];
        String v = hsvExpressions[2].isEmpty() ? "0" : hsvExpressions[2];
        String[] rgbExpressions = new String[]{r.replace("(h)", '(' + h + ')').replace("(s)", '(' + s + ')').replace("(v)", '(' + v + ')'), g.replace("(h)", '(' + h + ')').replace("(s)", '(' + s + ')').replace("(v)", '(' + v + ')'), b.replace("(h)", '(' + h + ')').replace("(s)", '(' + s + ')').replace("(v)", '(' + v + ')')};
        return rgbExpressions;
    }

    private static String createSceneName(Product product, RGBImageProfile rgbImageProfile) {
        StringBuilder nameBuilder = new StringBuilder(80);
        String productRef = product.getProductRefString();
        if (productRef != null) {
            nameBuilder.append(productRef);
            nameBuilder.append(' ');
        }
        if (rgbImageProfile != null) {
            nameBuilder.append(rgbImageProfile.getName().replace("_", " "));
            nameBuilder.append(' ');
        }
        nameBuilder.append("HSV");
        return nameBuilder.toString();
    }
}

