/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.visat.VisatApp;
import org.esa.snap.util.Settings;
import org.esa.snap.util.ftpUtils;

public class TestConnectivityAction
extends ExecCommand {
    public void actionPerformed(CommandEvent event) {
        boolean result;
        String remoteFTPSRTM = Settings.instance().get("DEM.srtm3GeoTiffDEM_FTP");
        String remotePathSRTM = ftpUtils.getPathFromSettings((String)"DEM.srtm3GeoTiffDEM_remotePath");
        String delftFTP = Settings.instance().get("OrbitFiles.delftFTP");
        String delftFTPPath = Settings.instance().get("OrbitFiles.delftFTP_ERS2_precise_remotePath");
        boolean failed = false;
        Exception exception1 = null;
        Exception exception2 = null;
        String msg1 = "Connection to FTP " + remoteFTPSRTM + remotePathSRTM;
        try {
            result = ftpUtils.testFTP((String)remoteFTPSRTM, (String)remotePathSRTM);
        }
        catch (Exception e) {
            result = false;
            exception1 = e;
        }
        if (result) {
            msg1 = msg1 + " PASSED";
        } else {
            msg1 = msg1 + " FAILED";
            failed = true;
        }
        String msg2 = "Connection to FTP " + delftFTP + delftFTPPath;
        try {
            result = ftpUtils.testFTP((String)delftFTP, (String)delftFTPPath);
        }
        catch (Exception e) {
            result = false;
            exception2 = e;
        }
        if (result) {
            msg2 = msg2 + " PASSED";
        } else {
            msg2 = msg2 + " FAILED";
            failed = true;
        }
        String msg = msg1 + "\n" + msg2;
        if (failed) {
            msg = msg + "\n\nPlease verify that all paths are correct in your $SNAP_HOME/config/settings.xml";
            msg = msg + "\nAlso verify that FTP is not blocked by your firewall.";
            if (exception1 != null) {
                msg = msg + "\n\n" + exception1.getMessage();
            }
            if (exception2 != null) {
                msg = msg + "\n\n" + exception2.getMessage();
            }
        }
        VisatApp.getApp().showInfoDialog(msg, null);
    }
}

