/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.graphics;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import org.esa.nest.dat.layers.ScreenPixelConverter;

public class GraphicShape {
    public static void drawArrow(Graphics2D g, ScreenPixelConverter screenPixel, int x, int y, int x2, int y2) {
        double[] ipts = new double[8];
        double[] vpts = new double[8];
        int headSize = Math.max(5, (int)((double)(x2 - x) * 0.1));
        GraphicShape.createArrow(x, y, x2, y2, headSize, ipts);
        screenPixel.pixelToScreen(ipts, vpts);
        g.draw(new Line2D.Double(vpts[4], vpts[5], vpts[2], vpts[3]));
        g.draw(new Line2D.Double(vpts[6], vpts[7], vpts[2], vpts[3]));
        Polygon head = new Polygon();
        head.addPoint((int)vpts[4], (int)vpts[5]);
        head.addPoint((int)vpts[2], (int)vpts[3]);
        head.addPoint((int)vpts[6], (int)vpts[7]);
        head.addPoint((int)vpts[4], (int)vpts[5]);
        g.fill(head);
        g.draw(new Line2D.Double(vpts[0], vpts[1], vpts[2], vpts[3]));
    }

    private static void createArrow(int x, int y, int xx, int yy, int i1, double[] ipts) {
        ipts[0] = x;
        ipts[1] = y;
        ipts[2] = xx;
        ipts[3] = yy;
        double d = xx - x;
        double d1 = -(yy - y);
        double d2 = Math.sqrt(d * d + d1 * d1);
        double size = 2.0;
        double d3 = d2 > 3.0 * (double)i1 ? (double)i1 : d2 / 3.0;
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        if (d2 >= 1.0) {
            double d4 = d3 * d / d2;
            double d5 = -(d3 * d1 / d2);
            double d6 = (double)xx - 2.0 * d4;
            double d7 = (double)yy - 2.0 * d5;
            ipts[4] = (int)(d6 - d5);
            ipts[5] = (int)(d7 + d4);
            ipts[6] = (int)(d6 + d5);
            ipts[7] = (int)(d7 - d4);
        }
    }
}

