/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class GraphicText {
    public static void setHighQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public static void shadowText(Graphics2D g, Color col, String text, int x, int y) {
        g.setColor(Color.black);
        g.drawString(text, x + 2, y + 2);
        g.setColor(col);
        g.drawString(text, x, y);
    }

    public static void outlineText(Graphics2D g, Color col, String text, int x, int y) {
        g.setColor(Color.black);
        g.drawString(text, x - 1, y - 1);
        g.drawString(text, x - 1, y + 1);
        g.drawString(text, x + 1, y - 1);
        g.drawString(text, x + 1, y + 1);
        g.setColor(col);
        g.drawString(text, x, y);
    }

    public static void highlightText(Graphics2D g, Color col, String text, int x, int y, Color highlightColor) {
        g.setColor(highlightColor);
        g.drawString(text, x - 1, y - 1);
        g.drawString(text, x - 1, y + 1);
        g.drawString(text, x + 1, y - 1);
        g.drawString(text, x + 1, y + 1);
        g.setColor(col);
        g.drawString(text, x, y);
    }

    public static String padString(String text, int width) {
        if (text.length() >= width || text.equalsIgnoreCase("NaN")) {
            return text;
        }
        StringBuilder newText = new StringBuilder(width);
        int firstPos = width - text.length();
        for (int i = 0; i <= firstPos; ++i) {
            newText.append(' ');
        }
        newText.append(text);
        return newText.toString();
    }
}

