/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.graphics;

import java.awt.Color;

public class Palette {
    public static final Palette[] STANDARD_MAPS = new Palette[]{new Palette("Rainbow", new Color[]{Color.blue, Color.cyan, Color.green, Color.yellow, Color.orange, Color.red}), new Palette("Cool", new Color[]{Color.green, Color.blue, new Color(255, 0, 255)}), new Palette("Warm", new Color[]{Color.red, Color.orange, Color.yellow}), new Palette("Thermal", new Color[]{Color.black, Color.red, Color.orange, Color.yellow, Color.green, Color.blue, new Color(255, 0, 255), Color.white})};
    private Color[] colors;
    private final String name;

    public Palette(String name, Color[] colors) {
        this.colors = colors;
        this.name = name;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public String getName() {
        return this.name;
    }

    public Color lookupColor(float percent) {
        int length = this.colors.length - 1;
        if (percent < 0.0f) {
            return this.colors[0];
        }
        if (percent >= 1.0f) {
            return this.colors[length];
        }
        int pos = (int)(percent * (float)length);
        Color s = this.colors[pos];
        Color e = this.colors[pos + 1];
        float rem = percent * (float)length - (float)pos;
        return new Color(s.getRed() + (int)(rem * (float)(e.getRed() - s.getRed())), s.getGreen() + (int)(rem * (float)(e.getGreen() - s.getGreen())), s.getBlue() + (int)(rem * (float)(e.getBlue() - s.getBlue())));
    }
}

