/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import org.esa.nest.dat.graphics.GraphicText;
import org.esa.nest.dat.layers.ScreenPixelConverter;

public class ArrowOverlay {
    private final double[] ipts = new double[10];
    private final double[] vpts = new double[10];
    private Point headPoint;
    private Point tailPoint;
    private Point textPoint;
    private String text = null;
    private static final Color outlineColour = Color.BLACK;
    private static final Color bodyColour = Color.YELLOW;
    private static final BasicStroke thickStroke = new BasicStroke(6.0f);
    private static final BasicStroke thinStroke = new BasicStroke(2.0f);

    public ArrowOverlay(int x, int y, int x2, int y2) {
        this.createArrow(x, y, x2, y2);
    }

    public void setText(String text) {
        this.text = text;
    }

    private void createArrow(int x, int y, int xx, int yy) {
        this.ipts[0] = x;
        this.ipts[1] = y;
        this.ipts[2] = xx;
        this.ipts[3] = yy;
        double d = xx - x;
        double d1 = -(yy - y);
        double d2 = Math.sqrt(d * d + d1 * d1);
        double size = 2.0;
        int headSize = Math.max(3, 2);
        double d3 = d2 > 3.0 * (double)headSize ? (double)headSize : d2 / 3.0;
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        double d4 = d3 * d / d2;
        double d5 = -(d3 * d1 / d2);
        double d6 = (double)xx - 2.0 * d4;
        double d7 = (double)yy - 2.0 * d5;
        this.ipts[4] = (int)(d6 - d5);
        this.ipts[5] = (int)(d7 + d4);
        this.ipts[6] = (int)(d6 + d5);
        this.ipts[7] = (int)(d7 - d4);
        this.ipts[8] = (double)xx + d / 10.0;
        this.ipts[9] = (double)yy - d1 / 10.0;
    }

    public void drawArrow(Graphics2D g, ScreenPixelConverter screenPixel) {
        screenPixel.pixelToScreen(this.ipts, this.vpts);
        this.headPoint = new Point((int)this.vpts[0], (int)this.vpts[1]);
        this.tailPoint = new Point((int)this.vpts[2], (int)this.vpts[3]);
        this.textPoint = new Point((int)this.vpts[8], (int)this.vpts[9]);
        g.setColor(outlineColour);
        g.setStroke(thickStroke);
        this.paintTriangleArrowHead(g);
        this.paintStraightBody(g);
        g.setColor(bodyColour);
        g.setStroke(thinStroke);
        this.paintTriangleArrowHead(g);
        this.paintStraightBody(g);
        if (this.text != null) {
            this.paintText(g);
        }
    }

    private void paintTriangleArrowHead(Graphics2D g) {
        g.draw(new Line2D.Double(this.vpts[4], this.vpts[5], this.vpts[2], this.vpts[3]));
        g.draw(new Line2D.Double(this.vpts[6], this.vpts[7], this.vpts[2], this.vpts[3]));
        Polygon head = new Polygon();
        head.addPoint((int)this.vpts[4], (int)this.vpts[5]);
        head.addPoint((int)this.vpts[2], (int)this.vpts[3]);
        head.addPoint((int)this.vpts[6], (int)this.vpts[7]);
        head.addPoint((int)this.vpts[4], (int)this.vpts[5]);
        g.fill(head);
    }

    private void paintStraightBody(Graphics2D g) {
        g.draw(new Line2D.Double(this.vpts[0], this.vpts[1], this.vpts[2], this.vpts[3]));
    }

    private void paintText(Graphics2D g) {
        GraphicText.outlineText(g, bodyColour, this.text, this.textPoint.x, this.textPoint.y);
    }

    public Point getHead() {
        return this.headPoint;
    }

    public Point getTail() {
        return this.tailPoint;
    }
}

