/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.grender.Viewport;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.RasterDataNode;

public class ScreenPixelConverter {
    private final double[] ipts = new double[2];
    private final double[] mpts = new double[2];
    private static final int level = 0;
    private final AffineTransform m2v;
    private final AffineTransform i2m;
    private final Shape ibounds;
    private final MultiLevelImage mli;
    private final double zoomFactor;
    private final Viewport vp;
    private final RasterDataNode raster;

    public ScreenPixelConverter(Viewport vp, RasterDataNode raster) {
        this.vp = vp;
        this.raster = raster;
        this.mli = raster.getGeophysicalImage();
        this.zoomFactor = vp.getZoomFactor();
        AffineTransform m2i = this.mli.getModel().getModelToImageTransform(0);
        this.i2m = this.mli.getModel().getImageToModelTransform(0);
        Rectangle vbounds = vp.getViewBounds();
        Shape mbounds = vp.getViewToModelTransform().createTransformedShape(vbounds);
        this.ibounds = m2i.createTransformedShape(mbounds);
        this.m2v = vp.getModelToViewTransform();
    }

    public AffineTransform getImageTransform(AffineTransform transformSave) {
        AffineTransform transform = new AffineTransform();
        transform.concatenate(transformSave);
        transform.concatenate(this.vp.getModelToViewTransform());
        transform.concatenate(this.raster.getSourceImage().getModel().getImageToModelTransform(0));
        return transform;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public boolean withInBounds() {
        RenderedImage ri = this.mli.getImage(0);
        Rectangle irect = this.ibounds.getBounds().intersection(new Rectangle(0, 0, ri.getWidth(), ri.getHeight()));
        return !irect.isEmpty();
    }

    public void pixelToScreen(Point pnt, double[] vpts) {
        this.ipts[0] = pnt.x;
        this.ipts[1] = pnt.y;
        this.i2m.transform(this.ipts, 0, this.mpts, 0, 1);
        this.m2v.transform(this.mpts, 0, vpts, 0, 1);
    }

    public void pixelToScreen(double x, double y, double[] vpts) {
        this.ipts[0] = x;
        this.ipts[1] = y;
        this.i2m.transform(this.ipts, 0, this.mpts, 0, 1);
        this.m2v.transform(this.mpts, 0, vpts, 0, 1);
    }

    public void pixelToScreen(double[] inpts, double[] vpts) {
        double[] tmppts = new double[inpts.length];
        this.i2m.transform(inpts, 0, tmppts, 0, inpts.length / 2);
        this.m2v.transform(tmppts, 0, vpts, 0, inpts.length / 2);
    }

    public static Point[] arrayToPoints(double[] vpts) {
        int j = 0;
        Point[] pt = new Point[vpts.length];
        for (int i = 0; i < vpts.length; i += 2) {
            pt[j++] = new Point((int)vpts[i], (int)vpts[i + 1]);
        }
        return pt;
    }

    public static PixelPos computeLevelZeroPixelPos(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel) {
        if (currentLevel != 0) {
            AffineTransform i2mTransform = imageLayer.getImageToModelTransform(currentLevel);
            Point2D modelP = i2mTransform.transform(new Point2D.Double(pixelX, pixelY), null);
            AffineTransform m2iTransform = imageLayer.getModelToImageTransform();
            Point2D imageP = m2iTransform.transform(modelP, null);
            return new PixelPos(new Float(imageP.getX()).floatValue(), new Float(imageP.getY()).floatValue());
        }
        return new PixelPos((float)pixelX + 0.5f, (float)pixelY + 0.5f);
    }
}

