/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.swing.figure.interactions.SelectionInteractor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.layers.LayerSelection;

public class SelectLayerInteractor
extends SelectionInteractor {
    protected boolean isMouseOverSelection(MouseEvent event) {
        boolean figureSelected = super.isMouseOverSelection(event);
        boolean layerSelected = false;
        return figureSelected;
    }

    public SelectionInteractor.SelectRectangleTool createSelectRectangleTool() {
        return new SelectLayerRectangleTool();
    }

    public SelectionInteractor.SelectPointTool createSelectPointTool() {
        return new SelectLayerPointTool();
    }

    private static List<Layer> findLayerSelections(ProductSceneView view) {
        return LayerUtils.getChildLayers((Layer)view.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (LayerFilter)new LayerFilter(){

            public boolean accept(Layer layer) {
                return layer instanceof LayerSelection;
            }
        });
    }

    private class SelectLayerRectangleTool
    extends SelectionInteractor.SelectRectangleTool {
        private SelectLayerRectangleTool() {
            super((SelectionInteractor)SelectLayerInteractor.this);
        }

        public void drag(MouseEvent event) {
            super.drag(event);
            int width = event.getX() - ((SelectLayerInteractor)SelectLayerInteractor.this).referencePoint.x;
            int height = event.getY() - ((SelectLayerInteractor)SelectLayerInteractor.this).referencePoint.y;
            int x = ((SelectLayerInteractor)SelectLayerInteractor.this).referencePoint.x;
            int y = ((SelectLayerInteractor)SelectLayerInteractor.this).referencePoint.y;
            if (width < 0) {
                x -= (width *= -1);
            }
            if (height < 0) {
                y -= (height *= -1);
            }
            ProductSceneView view = VisatApp.getApp().getSelectedProductSceneView();
            List layers = SelectLayerInteractor.findLayerSelections(view);
            for (Layer layer : layers) {
                LayerSelection laySel = (LayerSelection)layer;
                laySel.selectRectangle(new Rectangle(x, y, width, height));
            }
        }

        public void end(MouseEvent event) {
            super.end(event);
            ProductSceneView view = VisatApp.getApp().getSelectedProductSceneView();
            view.repaint();
        }
    }

    private class SelectLayerPointTool
    extends SelectionInteractor.SelectPointTool {
        private SelectLayerPointTool() {
            super((SelectionInteractor)SelectLayerInteractor.this);
        }

        public void end(MouseEvent event) {
            super.end(event);
            ProductSceneView view = VisatApp.getApp().getSelectedProductSceneView();
            List layers = SelectLayerInteractor.findLayerSelections(view);
            for (Layer layer : layers) {
                LayerSelection laySel = (LayerSelection)layer;
                laySel.selectPoint(event.getX(), event.getY());
            }
            view.repaint();
        }
    }
}

