/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.layers.LayerSelection;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.MapToolsLayerType;
import org.esa.nest.dat.layers.maptools.MapToolsOptions;
import org.esa.nest.dat.layers.maptools.components.InfoComponent;
import org.esa.nest.dat.layers.maptools.components.LatLonGridComponent;
import org.esa.nest.dat.layers.maptools.components.LogoComponent;
import org.esa.nest.dat.layers.maptools.components.LookDirectionComponent;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.nest.dat.layers.maptools.components.NorthArrowComponent;
import org.esa.nest.dat.layers.maptools.components.ScaleComponent;

public class MapToolsLayer
extends Layer
implements LayerSelection {
    private final Product product;
    private final RasterDataNode raster;
    private final MapToolsOptions options;
    private final ArrayList<MapToolsComponent> components = new ArrayList(5);

    public MapToolsLayer(LayerType layerType, PropertySet configuration) {
        super(layerType, configuration);
        this.setName("Mapping Tools");
        this.raster = (RasterDataNode)configuration.getValue("raster");
        this.options = (MapToolsOptions)configuration.getValue("options");
        this.options.setLayer(this);
        this.product = this.raster.getProduct();
        this.regenerate();
    }

    public void regenerate() {
        this.components.clear();
        if (this.options.showNorthArrow()) {
            this.components.add(new NorthArrowComponent(this.raster));
        }
        if (this.options.showLatLonGrid()) {
            this.components.add(new LatLonGridComponent(this.raster));
        }
        if (this.options.showLookDirection()) {
            this.components.add(new LookDirectionComponent(this.raster));
        }
        if (this.options.showMapOverview()) {
            // empty if block
        }
        if (this.options.showInfo()) {
            this.components.add(new InfoComponent(this.raster));
        }
        if (this.options.showScale()) {
            this.components.add(new ScaleComponent(this.raster));
        }
        if (this.options.showNestLogo()) {
            this.components.add(new LogoComponent(this.raster));
        }
    }

    protected void renderLayer(Rendering rendering) {
        RasterDataNode raster;
        GeoCoding geoCoding = this.product.getGeoCoding();
        if (geoCoding == null) {
            return;
        }
        Viewport vp = rendering.getViewport();
        ScreenPixelConverter screenPixel = new ScreenPixelConverter(vp, raster = this.product.getRasterDataNode(this.product.getBandAt(0).getName()));
        if (!screenPixel.withInBounds()) {
            return;
        }
        Graphics2D graphics = rendering.getGraphics();
        for (MapToolsComponent component : this.components) {
            component.render(graphics, screenPixel);
        }
    }

    @Override
    public void selectRectangle(Rectangle rect) {
    }

    @Override
    public void selectPoint(int x, int y) {
    }

    public static Layer findMapToolsLayer(Layer rootLayer) {
        return LayerUtils.getChildLayer((Layer)rootLayer, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (LayerFilter)new LayerFilter(){

            public boolean accept(Layer layer) {
                return layer.getLayerType() instanceof MapToolsLayerType;
            }
        });
    }

    public MapToolsOptions getMapToolsOptions() {
        return this.options;
    }
}

